/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter0Decimals;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter1Decimals;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter2Decimals;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete_;
import java.sql.Date;
import java.util.Comparator;
import java.util.Iterator;

public class FormulaConverterForBase
implements Converter<Object, String> {
    @Override
    public String convert(Object o, Node<Object> currentNode, Object ... param) {
        Node<Object> n = currentNode;
        String retString = "";
        double amount = 1.0;
        int currentNumber = -1;
        Date validityDate = null;
        if (param != null && param.length >= 1 && param[0] instanceof Date) {
            validityDate = (Date)param[0];
        }
        if (validityDate == null) {
            validityDate = new Date(System.currentTimeMillis());
        }
        FormattedDoubleConverter0Decimals conv0 = ConverterRegistry.getConverter(FormattedDoubleConverter0Decimals.class);
        FormattedDoubleConverter1Decimals conv1 = ConverterRegistry.getConverter(FormattedDoubleConverter1Decimals.class);
        FormattedDoubleConverter2Decimals conv2 = ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
        Iterator<Node<?>> it = n.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node packingNode;
            Node<?> packingBase = it.next();
            PeriodComplete period = ((PackagingQuantityBaseComplete)packingBase.getValue()).getPeriod();
            if (period.getStartDate().getTime() > validityDate.getTime() || period.getEndDate().getTime() < validityDate.getTime() || (packingNode = packingBase.getChildNamed(PackagingQuantityBaseComplete_.packingQuantities)) == null) continue;
            packingNode.sortChilds(new Comparator<Node<?>>(){

                @Override
                public int compare(Node<?> o1, Node<?> o2) {
                    PackagingQuantityComplete q1 = (PackagingQuantityComplete)o1.getValue();
                    PackagingQuantityComplete q2 = (PackagingQuantityComplete)o2.getValue();
                    return q1.compareTo(q2);
                }
            });
            Iterator<Node<?>> it2 = packingNode.getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node<?> qt = it2.next();
                int dd = (Integer)qt.getChildNamed(PackagingQuantityComplete_.amount).getValue();
                currentNumber = this.getMaxNumbers("" + dd, currentNumber);
                Converter<Number, String> con = null;
                con = currentNumber == -1 || currentNumber == 0 ? conv0 : (currentNumber == 1 ? conv1 : (currentNumber >= 2 ? conv2 : conv0));
                double d = (amount *= (double)dd) % 1.0;
                String fr = con.convert(amount, null, new Object[0]);
                retString = retString + fr + " " + ((UnitComplete)qt.getChildNamed(PackagingQuantityComplete_.unit).getValue()).getShortName() + " = ";
            }
        }
        if (retString.length() > 3) {
            retString = retString.substring(0, retString.length() - 3);
        }
        return retString;
    }

    @Override
    public Class<?> getParameterClass() {
        return null;
    }

    private int getMaxNumbers(String value, int currentNumber) {
        int i = value.indexOf(".");
        if (i != -1) {
            int ci = value.length() - i - 1;
            String t = value.substring(i + 1, value.length());
            try {
                int a = Integer.valueOf(t);
                if (a == 0) {
                    ci -= t.length();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (currentNumber < ci) {
                return ci;
            }
        }
        return currentNumber;
    }
}

