/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.handlingcost.AbsolutePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.ArticleDeliverablePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.LinearPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.PriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import java.util.List;

public class HandlingCostPriceConverter
implements Converter<HandlingCostComplete, String> {
    @Override
    public String convert(HandlingCostComplete o, Node<HandlingCostComplete> currentNode, Object ... param) {
        switch (o.getCurrentVariant().getType()) {
            case ARTICLE: {
                if (!(o.getCurrentVariant().getDeliverable() instanceof HandlingCostArticleDeliverableComplete)) break;
                HandlingCostArticleDeliverableComplete del = (HandlingCostArticleDeliverableComplete)o.getCurrentVariant().getDeliverable();
                PriceComplete best = null;
                for (ArticleDeliverablePriceCalculationComplete object : del.getArticles()) {
                    PriceComplete actPrice = this.calculatePrice(object.getPriceCalculation());
                    if (best != null && best.compareTo(actPrice) >= 0) continue;
                    best = actPrice;
                }
                if (best == null) break;
                return new PriceConverter1().convert(best, (Node<PriceComplete>)null, new Object[0]);
            }
            case FLIGHT: 
            case PAX: 
            case PRODUCT: {
                PriceComplete actPrice = this.calculatePrice(o.getCurrentVariant().getQuantity());
                return new PriceConverter1().convert(actPrice, (Node<PriceComplete>)null, new Object[0]);
            }
        }
        return null;
    }

    private PriceComplete calculatePrice(PriceCalculationComplete pcc) {
        if (pcc instanceof AbsolutePriceCalculationComplete) {
            return new PriceComplete(((AbsolutePriceCalculationComplete)pcc).getCurrency(), ((AbsolutePriceCalculationComplete)pcc).getPrice());
        }
        if (pcc instanceof LinearPriceCalculationComplete) {
            return new PriceComplete(((LinearPriceCalculationComplete)pcc).getPrice());
        }
        if (pcc instanceof StepPriceCalculationComplete) {
            List steps = ((StepPriceCalculationComplete)pcc).getSteps();
            if (steps.isEmpty()) {
                return new PriceComplete();
            }
            return ((StepPriceFunctionComplete)steps.get(0)).getPrice();
        }
        return new PriceComplete();
    }

    @Override
    public Class<? extends HandlingCostComplete> getParameterClass() {
        return HandlingCostComplete.class;
    }
}

