/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.node.impls;

import ch.icit.pegasus.client.node.impls.HumanNodeOperation;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.server.core.dtos.ADTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NodeToolkit {
    static List<Node<?>> affixes = new ArrayList();
    public static List<Node<?>> treeOfLife = new ArrayList();
    public static HumanNodeOperation currentOperation;

    public static void addAffix(Node<?> n) {
        NodeToolkit.addAffix(n, true);
    }

    public static void addAffix(Node<?> n, boolean dontUpdate) {
        n.setPermanent(true);
        Iterator<Node<?>> it = NodeToolkit.getAffixes();
        while (it.hasNext()) {
            Node<?> node = it.next();
            if (!node.getName().equals(n.getName())) continue;
            it.remove();
        }
        affixes.add(n);
        it = n.getChilds();
        if (it != null) {
            while (it.hasNext()) {
                Node<?> i = it.next();
                i.setPermanent(true);
            }
        }
    }

    public static void removeAffix(Node<?> n) {
        affixes.remove(n);
    }

    public static void removeAffixNamed(String name) {
        for (Node<?> n : affixes) {
            if (!n.getName().equals(name)) continue;
            affixes.remove(n);
            return;
        }
    }

    public static <V> Node<List<V>> getAffixList(Class<V> clazz) {
        return NodeToolkit.getAffixNamed(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(clazz));
    }

    public static <V extends ADTO> Node<V> getAffixClass(Class<V> clazz) {
        return NodeToolkit.getAffixNamed(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(clazz));
    }

    public static Node<?> getAffixNamed(String name) {
        for (Node<?> n : affixes) {
            if (!name.equals(n.getName())) continue;
            return n;
        }
        return null;
    }

    public static int getAffixesCount() {
        return affixes.size();
    }

    public static Iterator<Node<?>> getAffixes() {
        return affixes.iterator();
    }

    public static void clearAll() {
        NodeToolkit.clearAffixes();
        NodeToolkit.clearValues();
    }

    public static void clearAffixes() {
        affixes.clear();
    }

    public static void clearValues() {
        treeOfLife.clear();
    }

    public static void clearNonPermanentValues() {
        Iterator<Node<?>> it = treeOfLife.iterator();
        while (it.hasNext()) {
            Node<?> n = it.next();
            if (n != null && n.isPermanent()) continue;
            it.remove();
        }
    }

    public static Node ensureChild(Node parent, String name) {
        Node<Object> startStock = parent.getChildNamed(name);
        if (startStock == null) {
            startStock = new Node();
            startStock.setName(name);
            parent.addChild(startStock, 0L);
        }
        return startStock;
    }
}

