/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.node.impls;

import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ProxyNode<T>
extends Node<T> {
    protected Node<T> refNode;
    private T source;

    public ProxyNode() {
        this.source = null;
    }

    public ProxyNode(T source) {
        this.source = source;
    }

    public ProxyNode(Node<T> ref) {
        this.setSource(ref.getValue());
        this.setRefNode(ref);
    }

    @Override
    public void kill() {
        super.kill();
        this.refNode = null;
        this.source = null;
    }

    protected void ensureRefNode() {
        if (this.source != null) {
            boolean updateNeeded = false;
            if (this.refNode == null) {
                updateNeeded = true;
            } else if (this.refNode.getValue() != null && !this.refNode.getValue().equals(this.source)) {
                updateNeeded = true;
            }
            if (updateNeeded) {
                this.setRefNode(INodeCreator.getDefaultImpl().getNode4DTO(this.source, false, false, false));
            }
        } else if (this.refNode != null) {
            this.setRefNode(null);
        }
    }

    public T getSource() {
        return this.source;
    }

    public void setSource(T source) {
        this.source = source;
    }

    public Node<T> getRefNode() {
        this.ensureRefNode();
        return this.refNode;
    }

    public void setRefNodeSilent(Node<T> ref, boolean all, NodeListener ... l) {
        this.refNode = ref;
        if (!all) {
            this.fireDataChangedEvent(all, l);
        }
    }

    public void setRefNode(Node<T> ref) {
        this.refNode = ref;
        this.fireDataChangedEvent(true, new NodeListener[0]);
    }

    @Override
    public void addChild(Node<?> child, long id) {
        this.ensureRefNode();
        if (this.refNode != null) {
            this.refNode.addChild(child, id);
        }
    }

    @Override
    public void addChildSilent(Node<?> child, NodeListener l, boolean all, long id) {
        this.ensureRefNode();
        if (this.refNode != null) {
            this.refNode.addChildSilent(child, l, all, id);
        }
    }

    @Override
    public void getAllChildAddEventsFor(NodeListener listener, String ... childs) {
        this.ensureRefNode();
        if (this.refNode != null) {
            this.refNode.getAllChildAddEventsFor(listener, childs);
        }
    }

    @Override
    public boolean contains(Node<?> node) {
        this.ensureRefNode();
        if (this.refNode != null) {
            return this.refNode.contains(node);
        }
        return false;
    }

    @Override
    public Iterator<Node<?>> getAllChildsNamed(String name) {
        this.ensureRefNode();
        if (this.refNode != null) {
            return this.refNode.getAllChildsNamed(name);
        }
        return null;
    }

    @Override
    public Node<?> getChildAt(int i) {
        this.ensureRefNode();
        if (this.refNode != null) {
            return this.refNode.getChildAt(i);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        this.ensureRefNode();
        if (this.refNode != null) {
            return this.refNode.getChildCount();
        }
        return 0;
    }

    @Override
    public int getChildIndex(Node<?> child) {
        this.ensureRefNode();
        if (this.refNode != null) {
            return this.refNode.getChildIndex(child);
        }
        return -1;
    }

    @Override
    public Node<?> getChildNamed(String ... name) {
        this.ensureRefNode();
        if (this.refNode != null) {
            return this.refNode.getChildNamed(name);
        }
        return null;
    }

    @Override
    public Iterator<Node<?>> getChilds() {
        this.ensureRefNode();
        if (this.refNode != null) {
            return this.refNode.getChilds();
        }
        return null;
    }

    @Override
    public List<T> getData() {
        this.ensureRefNode();
        return this.refNode != null ? this.refNode.getData() : null;
    }

    @Override
    public Iterator<Node<?>> getFailSafeChildIterator() {
        this.ensureRefNode();
        if (this.refNode != null) {
            return this.refNode.getFailSafeChildIterator();
        }
        return null;
    }

    @Override
    public T getValue() {
        this.ensureRefNode();
        return this.refNode != null ? (T)this.refNode.getValue() : null;
    }

    @Override
    public <V> V getValue(Class<V> searchedType) {
        this.ensureRefNode();
        V r = this.refNode != null ? (V)this.refNode.getValue(searchedType) : null;
        return r;
    }

    @Override
    public void removeChild(Node<?> child, long id) {
        this.ensureRefNode();
        if (this.refNode != null) {
            this.refNode.removeChild(child, id);
        }
    }

    @Override
    public boolean setValue(T val, long id) {
        this.setSource(val);
        this.ensureRefNode();
        Object oldValue = null;
        if (this.refNode != null) {
            oldValue = this.refNode.getValue();
        }
        T newValue = val;
        if (oldValue != null && newValue != null && !val.getClass().equals(oldValue) && oldValue.getClass().isAssignableFrom(val.getClass())) {
            this.refNode.setValue(val, 0L);
        }
        this.fireDataChangedEvent(false, new NodeListener[0]);
        return true;
    }

    @Override
    public Object getValueForNamed(String vName) {
        this.ensureRefNode();
        if (this.refNode != null) {
            return this.refNode.getValueForNamed(vName);
        }
        return null;
    }

    @Override
    public boolean setValueSilent(T val, boolean allSilent, long id, NodeListener ... l) {
        this.setSource(val);
        Node<T> n = INodeCreator.getDefaultImpl().getNode4DTO(val, false, false);
        if (n != null) {
            this.setRefNodeSilent(n, allSilent, l);
            return true;
        }
        return false;
    }

    @Override
    public void propagateCommit(Object value, List<Node<?>> list, boolean b, Map<Class<?>, Class<?>> classMapping) {
        this.ensureRefNode();
        if (this.refNode != null) {
            this.refNode.propagateCommit(value, list, b, classMapping);
        }
    }

    @Override
    public void updateNode(List<Node<?>> registry) {
    }
}

