/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.invoice;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.invoice.InvoiceService;

public class InvoiceServiceManagerImpl
implements InvoiceServiceManager {
    @Override
    public OptionalWrapper<PegasusFileComplete> getLatestReport(InvoiceReference invoiceReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceService.class).getLatestReport(invoiceReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<InvoiceLight> getAllInvoices(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceService.class).getAllInvoices(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Double calculateProductServiceCount(ServiceProductComplete serviceProduct, CustomerLight customer, PeriodComplete period, InvoiceReference invoice) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceService.class).calculateProductServiceCount(serviceProduct, customer, period, invoice);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void sendInvoice(InvoiceReference invoiceReference, FlightReference flightReference) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(InvoiceService.class).sendInvoice(invoiceReference, new FlightReference(flightReference.getId()));
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InvoiceLight> getInvoiceForFlight(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceService.class).getInvoiceForFlight(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InvoiceComplete> getInvoice(InvoiceReference invoice) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceService.class).getInvoice(invoice);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InvoiceComplete> createInvoice(InvoiceComplete invoice) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceService.class).createInvoice(invoice);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InvoiceComplete> updateInvoice(InvoiceComplete invoice) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceService.class).updateInvoice(invoice);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void delete(InvoiceReference invoice) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(InvoiceService.class).delete(invoice);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InvoiceComplete> createCreditNote(InvoiceReference originInvoice, DateWrapper date) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceService.class).createCreditNote(originInvoice, date);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public Boolean getHasFlightInvoice(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceService.class).getHasFlightInvoice(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void setTaxRateInfoEmbeddableToEntity() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(InvoiceService.class).setTaxRateInfoEmbeddableToEntity();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

