/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.FlightNoConverter;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCheckinComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPreparationComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.CirculationStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.CirculationStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckoutCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockIrregularityCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockIrregularityMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockOutCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockOutMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockReturnCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockReturnMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockWasteCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockWasteMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckoutCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockConsumptionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;

public class ChargeTransactionConverter
implements Converter<StockTransactionComplete, String> {
    @Override
    public String convert(StockTransactionComplete o, Node<StockTransactionComplete> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        StorePositionShortNameConverter storeC = ConverterRegistry.getConverter(StorePositionShortNameConverter.class);
        FlightNoConverter flightC = ConverterRegistry.getConverter(FlightNoConverter.class);
        if (o instanceof FlightStockCheckoutComplete) {
            FlightStockCheckoutComplete p = (FlightStockCheckoutComplete)o;
            return Phrase.getPhrase((String)Phrase.SOLD_FROM_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof FlightStockCheckoutCorrectionComplete) {
            FlightStockCheckoutCorrectionComplete p = (FlightStockCheckoutCorrectionComplete)o;
            return Phrase.getPhrase((String)Phrase.SOLD_CORRECTION_FOR_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof FlightStockIrregularityCorrectionComplete) {
            FlightStockIrregularityCorrectionComplete p = (FlightStockIrregularityCorrectionComplete)o;
            return Phrase.getPhrase((String)Phrase.IRREGULARITY_CORRECTION_FOR_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof FlightStockIrregularityMovementComplete) {
            FlightStockIrregularityMovementComplete p = (FlightStockIrregularityMovementComplete)o;
            return Phrase.getPhrase((String)Phrase.IRREGULARITY_FOR_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof FlightStockOutCorrectionComplete) {
            FlightStockOutCorrectionComplete p = (FlightStockOutCorrectionComplete)o;
            return Phrase.getPhrase((String)Phrase.CHECKOUT_CORRECTION_FOR_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof FlightStockOutMovementComplete) {
            FlightStockOutMovementComplete p = (FlightStockOutMovementComplete)o;
            return Phrase.getPhrase((String)Phrase.CHECKOUT_FOR_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof FlightStockReturnCorrectionComplete) {
            FlightStockReturnCorrectionComplete p = (FlightStockReturnCorrectionComplete)o;
            return Phrase.getPhrase((String)Phrase.RETURN_CORRECTION_FOR_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof FlightStockReturnMovementComplete) {
            FlightStockReturnMovementComplete p = (FlightStockReturnMovementComplete)o;
            return Phrase.getPhrase((String)Phrase.RETURN_FOR_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof FlightStockWasteCorrectionComplete) {
            FlightStockWasteCorrectionComplete p = (FlightStockWasteCorrectionComplete)o;
            return Phrase.getPhrase((String)Phrase.WASTE_CORRECTION_FOR_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof FlightStockWasteMovementComplete) {
            FlightStockWasteMovementComplete p = (FlightStockWasteMovementComplete)o;
            return Phrase.getPhrase((String)Phrase.WASTE_FOR_FLIGHT, (Object[])new Object[]{flightC.convert(p.getFlight(), (Node<FlightLight>)null, new Object[0])});
        }
        if (o instanceof StockCheckinComplete) {
            StockCheckinComplete p = (StockCheckinComplete)o;
            if (o instanceof CirculationStockCheckinComplete) {
                return Phrase.getPhrase((String)Phrase.CIRCULATION_CHECKIN_TO, (Object[])new Object[]{storeC.convert(p.getStorePosition(), (Node<StorePositionLight>)null, new Object[0])});
            }
            if (o instanceof InventoryCheckinComplete) {
                return Phrase.getPhrase((String)Phrase.INVENTORY_CHECKIN_TO, (Object[])new Object[]{storeC.convert(p.getStorePosition(), (Node<StorePositionLight>)null, new Object[0])});
            }
            if (o instanceof ManualStockCheckinComplete) {
                return Phrase.getPhrase((String)Phrase.MANUAL_CHECKIN_TO, (Object[])new Object[]{storeC.convert(p.getStorePosition(), (Node<StorePositionLight>)null, new Object[0])});
            }
        } else if (o instanceof StockCheckoutComplete) {
            StockCheckoutComplete p = (StockCheckoutComplete)o;
            if (o instanceof CirculationStockCheckoutComplete) {
                return Phrase.getPhrase((String)Phrase.CIRCULATION_CHECKOUT_FROM, (Object[])new Object[]{storeC.convert(p.getStorePosition(), (Node<StorePositionLight>)null, new Object[0])});
            }
            if (o instanceof ManualStockCheckoutComplete) {
                return Phrase.getPhrase((String)Phrase.MANUAL_CHECKOUT_FROM, (Object[])new Object[]{storeC.convert(p.getStorePosition(), (Node<StorePositionLight>)null, new Object[0])});
            }
            if (o instanceof StockConsumptionComplete) {
                return Phrase.getPhrase((String)Phrase.STOCK_CONSUMPTION_FROM, (Object[])new Object[]{storeC.convert(p.getStorePosition(), (Node<StorePositionLight>)null, new Object[0])});
            }
        } else {
            if (o instanceof StockInventoryComplete) {
                StockInventoryComplete p = (StockInventoryComplete)o;
                boolean corrected = true;
                if (p instanceof InventoryCorrectionComplete) {
                    corrected = ((InventoryCorrectionComplete)p).getCorrectStock();
                }
                String ct = Words.CORRECT_CHARGE;
                if (!corrected) {
                    ct = Words.CORRECT_INVENTORY;
                }
                if (p.getCharge() != null) {
                    return Phrase.getPhrase((String)Phrase.CORRECT_CHARGE_IN_STORE, (Object[])new Object[]{ct, p.getCharge().getNumber(), storeC.convert(p.getStorePosition(), (Node<StorePositionLight>)null, new Object[0])});
                }
                return Phrase.getPhrase((String)Phrase.CORRECT_CHARGE_IN_STORE, (Object[])new Object[]{ct, "", storeC.convert(p.getStorePosition(), (Node<StorePositionLight>)null, new Object[0])});
            }
            if (o instanceof StockMovementComplete) {
                StockMovementComplete p = (StockMovementComplete)o;
                return Phrase.getPhrase((String)Phrase.MOVE_CHARGE_FROM_TO, (Object[])new Object[]{p.getCharge().getNumber(), storeC.convert(p.getOriginPosition(), (Node<StorePositionLight>)null, new Object[0]), storeC.convert(p.getDestinationPosition(), (Node<StorePositionLight>)null, new Object[0])});
            }
            if (o instanceof RequisitionOrderPreparationComplete) {
                RequisitionOrderPreparationComplete p = (RequisitionOrderPreparationComplete)o;
                if (p.getOriginCharge() == null) {
                    if (p.getOrderPosition() != null) {
                        return Phrase.getPhrase((String)Phrase.REQUISITION_DELIVERY, (Object[])new Object[]{p.getOrderPosition().getOrder().getNumber()});
                    }
                    return Words.REQUISITION_DELIVERY_ONLY;
                }
                if (p.getOrderPosition() != null) {
                    return Phrase.getPhrase((String)Phrase.REQUISITION_DELIVERY_CHARGE, (Object[])new Object[]{p.getOrderPosition().getOrder().getNumber(), p.getOriginCharge().getNumber()});
                }
                return Words.REQUISITION_DELIVERY_ONLY;
            }
            if (o instanceof RequisitionOrderAcceptationComplete) {
                RequisitionOrderAcceptationComplete p = (RequisitionOrderAcceptationComplete)o;
                if (p.getBatch() == null) {
                    if (p.getOrderPosition() != null) {
                        return Phrase.getPhrase((String)Phrase.REQUISITION_RECEIVED, (Object[])new Object[]{p.getOrderPosition().getOrder().getNumber()});
                    }
                    return Words.REQUISITION_RECEIVED_ONLY;
                }
                if (p.getOrderPosition() != null) {
                    return Phrase.getPhrase((String)Phrase.REQUISITION_RECEIVED_CHARGE, (Object[])new Object[]{p.getOrderPosition().getOrder().getNumber(), p.getBatch().getCharge().getNumber()});
                }
                return Words.REQUISITION_RECEIVED_ONLY;
            }
            if (o instanceof PurchaseOrderAcceptationComplete) {
                PurchaseOrderAcceptationComplete p = (PurchaseOrderAcceptationComplete)o;
                if (p.getCharge() == null) {
                    if (p.getOrderPosition() != null) {
                        return Phrase.getPhrase((String)Phrase.PURCHASE_RECEIVED, (Object[])new Object[]{p.getOrderPosition().getOrder().getNumber()});
                    }
                    return Words.PURCHASE_RECEIVED_ONLY;
                }
                if (p.getOrderPosition() != null) {
                    return Phrase.getPhrase((String)Phrase.PURCHASE_RECEIVED_CHARGE, (Object[])new Object[]{p.getOrderPosition().getOrder().getNumber(), p.getCharge().getNumber()});
                }
                return Words.PURCHASE_RECEIVED_ONLY;
            }
            if (o instanceof ManualStockMovementCorrectionComplete) {
                return "Correction to";
            }
            if (o instanceof ManualStockCheckoutCorrectionComplete) {
                return "Correction to";
            }
            if (o instanceof ManualStockCheckinCorrectionComplete) {
                return "Correction to";
            }
        }
        return NULL_RETURN;
    }

    @Override
    public Class<? extends StockTransactionComplete> getParameterClass() {
        return StockTransactionComplete.class;
    }
}

