/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import java.sql.Timestamp;

public class PurchaseOrderReviewPositionSumConverter
implements Converter<PurchaseOrderPositionComplete, String> {
    @Override
    public String convert(PurchaseOrderPositionComplete o, Node<PurchaseOrderPositionComplete> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        UnitComplete pu = o.getPriceUnit();
        PriceComplete price = o.getSupplierPrice();
        Node<BasicArticleLight> n = INodeCreator.getDefaultImpl().getNodeDirectly(o.getArticle());
        BasicArticleComplete artC = null;
        if (n.getValue(BasicArticleComplete.class) != null) {
            artC = n.getValue(BasicArticleComplete.class);
        }
        if (!o.getTransactions().isEmpty()) {
            PriceComplete np = null;
            for (PurchaseOrderTransactionComplete transaction : o.getTransactions()) {
                if (!(transaction instanceof PurchaseOrderAcceptationComplete)) continue;
                PurchaseOrderAcceptationComplete acc = (PurchaseOrderAcceptationComplete)transaction;
                price = acc.getCharge().getPrice();
                pu = acc.getCharge().getPriceUnit();
                double ca = UnitConversionToolkit.convertUnit((UnitComplete)transaction.getAmount().getUnit(), (UnitComplete)pu, (double)transaction.getAmount().getAmount().longValue(), (BasicArticleLight)artC, (Timestamp)new Timestamp(o.getOrder().getOrderDate().getTime()));
                PriceComplete np1 = new PriceComplete(price.getCurrency(), Double.valueOf(price.getPrice() * ca));
                if (np == null) {
                    np = new PriceComplete(np1);
                    continue;
                }
                np.setPrice(Double.valueOf(np.getPrice() + np1.getPrice()));
            }
            return ConverterRegistry.getConverter(PriceConverter3.class).convert((Object)np, (Node)null, new Object[0]);
        }
        StoreQuantityComplete da = o.getDeliveredAmount();
        double ca = UnitConversionToolkit.convertUnit((UnitComplete)da.getUnit(), (UnitComplete)pu, (double)da.getAmount().longValue(), (BasicArticleLight)artC, (Timestamp)new Timestamp(o.getOrder().getOrderDate().getTime()));
        PriceComplete np = new PriceComplete(price.getCurrency(), Double.valueOf(price.getPrice() * ca));
        return ConverterRegistry.getConverter(PriceConverter3.class).convert((Object)np, (Node)null, new Object[0]);
    }

    @Override
    public Class<? extends PurchaseOrderPositionComplete> getParameterClass() {
        return PurchaseOrderPositionComplete.class;
    }
}

