/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.search;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreContentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StorePositionContentComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.services.search.SearchService;
import ch.icit.pegasus.server.dtos.IDTO;
import java.util.ArrayList;

public class SearchServiceManagerImpl
implements SearchServiceManager {
    @Override
    public SearchResult<StorePositionContentComplete> searchStoreContents(StoreContentSearchConfiguration config) throws ClientServerCallException {
        try {
            SearchResult result = EjbContextFactory.getInstance().getService(SearchService.class).searchStoreContents(config);
            if (result.getResults() == null) {
                result.setResults(new ArrayList());
            }
            return result;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public <D extends IDTO, C extends ADtoSearchConfiguration<D, ?>> SearchResult<D> search(C config) throws ClientServerCallException {
        try {
            SearchResult search = EjbContextFactory.getInstance().getService(SearchService.class).search(config);
            if (search.getResults() == null) {
                search.setResults(new ArrayList());
            }
            return search;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

