/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissSettingsComplete;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissDataImportComplete;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissDataImportLight;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissDataImportReference;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.EdelweissService;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdelweissServiceManagerImpl
implements EdelweissServiceManager {
    private static Logger log = LoggerFactory.getLogger(EdelweissServiceManagerImpl.class);

    @Override
    public OptionalWrapper<PegasusFileComplete> sendCommissionTrackingFile() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(EdelweissService.class).sendCommissionTrackingFile();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public Node<EdelweissSettingsComplete> getSettingsCached() throws ClientServerCallException {
        Node<EdelweissSettingsComplete> settings = NodeToolkit.getAffixClass(EdelweissSettingsComplete.class);
        if (settings != null) {
            INodeCreator.getDefaultImpl().addToAllNodes(settings);
        } else {
            EdelweissSettingsComplete dto = (EdelweissSettingsComplete)this.getSettings().getValue();
            settings = INodeCreator.getDefaultImpl().getNode4DTO(dto, false, false);
            settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(EdelweissSettingsComplete.class));
            NodeToolkit.addAffix(settings);
        }
        return settings;
    }

    @Override
    public void readLimeFlightData(ServiceTypesForTimerService type) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(EdelweissService.class).readLimeFlightData(type);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void deleteEdelweissData(EdelweissDataImportReference data) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(EdelweissService.class).deleteEdelweissData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<EdelweissDataImportComplete> create(EdelweissDataImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(EdelweissService.class).create(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void resolveImport(ListWrapper<EdelweissDataImportReference> data) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(EdelweissService.class).resolveImport(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<EdelweissDataImportComplete> get(EdelweissDataImportLight data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(EdelweissService.class).get(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<EdelweissDataImportComplete> update(EdelweissDataImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(EdelweissService.class).update(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<EdelweissSettingsComplete> getSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(EdelweissService.class).getSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createOverviewReport(ListWrapper<EdelweissDataImportReference> references) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(EdelweissService.class).createOverviewReport(references);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDetailReport(ListWrapper<EdelweissDataImportReference> references) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(EdelweissService.class).createDetailReport(references);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createChangeLogReport(EdelweissDataImportReference edw, ReportingOutputFormatE format) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(EdelweissService.class).createChangeLogReport(edw, format);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void updateQuadData(ServiceTypesForTimerService service) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(EdelweissService.class).updateQuadData(service);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public String getUpdateList() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(EdelweissService.class).getUpdateList();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

