/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.product.details;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.ProductViewConverter;
import ch.icit.pegasus.client.converter.QuantityConverter0Decimal;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductProduceTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductProduceTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductGroupCheckInAccess;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ComponentDetailsPanel
extends TableDetailsPanel<ProductStockCheckinGroupLight> {
    private static final long serialVersionUID = 1L;

    public ComponentDetailsPanel(RowEditor<ProductStockCheckinGroupLight> editor, RDProvider provider) {
        super(editor, provider, editor.getModel().isAddRow());
        this.setTitleText(Words.PRODUCTS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.PRODUCT, null, null, null, "", 40));
        columns.add(new TableColumnInfo(Words.CHECKIN_AMOUNT, null, null, null, "", 2 * this.getTable().getCellPadding() + InputComboBox2.getPreferredWidth(this, 7)));
        columns.add(new TableColumnInfo(Words.EXPIRY_DATE, null, null, null, "", 2 * this.getTable().getCellPadding() + DateChooser.getPreferredWidth(this, false)));
        columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 30));
        columns.add(new TableColumnInfo("", null, null, null, "", 2 * this.getTable().getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL)));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        ProductProduceTransactionComplete c = new ProductProduceTransactionComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setQuantity(new StoreQuantityComplete(Long.valueOf(0L), ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit()));
        c.setExpiryDate(new Date(System.currentTimeMillis() + 86400000L * (long)((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getDefaultProductExpiryDate().intValue()));
        if (this.table.getModel().getNode().getChildCount() > 0) {
            DefaultTable2RowPanel ra = (DefaultTable2RowPanel)this.table.getRowAt(this.table.getRowCount() - 1);
            StorePositionLight sp = (StorePositionLight)ra.getModel().getNode().getChildNamed(ProductProduceTransactionComplete_.targetStore).getValue();
            c.setTargetStore(sp);
        }
        this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false), 0L);
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(model);
        boolean add = this.editor.getModel().isAddRow();
        boolean correctable = this.provider.isWritable(ProductGroupCheckInAccess.CORRECT);
        if (add) {
            row.addLayoutComponent(SearchTextField2Factory.getProductSearchField(true, model.getNode().getChildNamed(ProductProduceTransactionComplete_.product)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        } else {
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(ProductProduceTransactionComplete_.product), ConverterRegistry.getConverter(ProductViewConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        }
        if (add || correctable) {
            row.addLayoutComponent(new InputComboBox2(model.getNode().getChildNamed(new DtoField[]{ProductProduceTransactionComplete_.quantity, StoreQuantityComplete_.amount}), model.getNode().getChildNamed(new DtoField[]{ProductProduceTransactionComplete_.quantity, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_LONG), DefaultTable2RowPanelLayout.LayoutType.FIX);
        } else {
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(ProductProduceTransactionComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter0Decimal.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        }
        if (add) {
            row.addLayoutComponent(new DateChooser(model.getNode().getChildNamed(ProductProduceTransactionComplete_.expiryDate)), DefaultTable2RowPanelLayout.LayoutType.FIX);
            row.addLayoutComponent(new StorePositionSearchBox((Node<StorePositionLight>)model.getNode().getChildNamed(ProductProduceTransactionComplete_.targetStore)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new DeleteButton((source, x, y) -> model.getNode().getParent().removeChild(model.getNode(), 0L)), DefaultTable2RowPanelLayout.LayoutType.FIX);
        } else {
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(ProductProduceTransactionComplete_.expiryDate), ConverterRegistry.getConverter(DateConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(ProductProduceTransactionComplete_.targetStore), ConverterRegistry.getConverter(StorePositionShortNameConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        }
        if (add) {
            row.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        } else {
            row.setUseControlSkin(Table2RowPanel.TableControlsType.NONE);
        }
        return row;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(ProductStockCheckinGroupComplete_.stockCheckins));
    }
}

