/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customsdocument;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.List;

public class CustomsDocumentModuleDataHandler
extends DefaultDataHandler<CustomsDocumentComplete, CustomsDocumentComplete> {
    public CustomsDocumentModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<CustomsDocumentComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(CustomsDocumentComplete.class);
                CustomsDocumentComplete dto = (CustomsDocumentComplete)node.getValue(CustomsDocumentComplete.class);
                CustomsDocumentComplete nDto = (CustomsDocumentComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updateCustomsDocument(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<CustomsDocumentComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(CustomsDocumentComplete.class);
                CustomsDocumentComplete dto = (CustomsDocumentComplete)node.getValue();
                CustomsDocumentComplete nDto = (CustomsDocumentComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).createCustomsDocument(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CustomsDocumentModuleDataHandler.this.setCurrentLoadMaximum(1);
                CustomsDocumentModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return CustomsDocumentModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<CustomsDocumentComplete> resetData(Node<CustomsDocumentComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public boolean reloadDataAfterClosing(Node<?> node, RemoteLoader listener, ProgressListener progressListener) {
        return false;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CustomsDocumentComplete cust = (CustomsDocumentComplete)node.getValue(CustomsDocumentComplete.class);
                CustomsDocumentComplete ncust = (CustomsDocumentComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getCustomsDocument(cust).getValue();
                List creationFlight = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getCreationFlight(ncust).getList();
                List creationTransaction = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getCreationTransaction(ncust).getList();
                for (StockTransactionComplete transaction : creationTransaction) {
                    ManualStockMovementComplete movement;
                    StockCheckinGroupComplete group;
                    if (transaction instanceof ManualStockCheckinComplete) {
                        ManualStockCheckinComplete checkin = (ManualStockCheckinComplete)transaction;
                        if (checkin.getContainingGroup() == null) continue;
                        group = (StockCheckinGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockCheckinGroup(checkin.getContainingGroup()).getValue();
                        checkin.setContainingGroup((StockCheckinGroupReference)group);
                        continue;
                    }
                    if (!(transaction instanceof ManualStockMovementComplete) || (movement = (ManualStockMovementComplete)transaction).getContainingMovement() == null) continue;
                    group = (StockMovementGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockMovementGroup(movement.getContainingMovement()).getValue();
                    movement.setContainingMovement((StockMovementGroupReference)group);
                }
                Node cfNode = INodeCreator.getDefaultImpl().createNodes(creationFlight, false);
                Node ctNode = INodeCreator.getDefaultImpl().createNodes(creationTransaction, false);
                cfNode.setName(DtoFieldConstants.CREATION_FLIGHT);
                ctNode.setName(DtoFieldConstants.TRANSACTIONS);
                NodeToolkit.removeAffixNamed((String)DtoFieldConstants.CREATION_FLIGHT.getFieldName());
                NodeToolkit.removeAffixNamed((String)DtoFieldConstants.TRANSACTIONS.getFieldName());
                NodeToolkit.addAffix((Node)cfNode);
                NodeToolkit.addAffix((Node)ctNode);
                List creationCheckinGroup = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getCreationCheckinGroup(ncust).getList();
                List creationCheckoutGroup = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getCreationCheckoutGroup(cust).getList();
                List creationMovementGroup = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getCreationMovementGroup(cust).getList();
                Node checkinNode = INodeCreator.getDefaultImpl().createNodes(creationCheckinGroup, false);
                checkinNode.setName(DtoFieldConstants.CHECKIN_GROUP);
                Node checkoutNode = INodeCreator.getDefaultImpl().createNodes(creationCheckoutGroup, false);
                checkoutNode.setName(DtoFieldConstants.CHECKOUT_GROUP);
                Node movementNode = INodeCreator.getDefaultImpl().createNodes(creationMovementGroup, false);
                movementNode.setName(DtoFieldConstants.MOVEMENT_GROUP);
                NodeToolkit.removeAffixNamed((String)DtoFieldConstants.CHECKIN_GROUP.getFieldName());
                NodeToolkit.removeAffixNamed((String)DtoFieldConstants.CHECKOUT_GROUP.getFieldName());
                NodeToolkit.removeAffixNamed((String)DtoFieldConstants.MOVEMENT_GROUP.getFieldName());
                NodeToolkit.addAffix((Node)checkinNode);
                NodeToolkit.addAffix((Node)checkoutNode);
                NodeToolkit.addAffix((Node)movementNode);
                node.removeExistingValues();
                node.setValue((Object)ncust, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<CustomsDocumentComplete> createEmptyNode() {
        return null;
    }

    @Override
    public Class<CustomsDocumentComplete> getCommittingClass() {
        return CustomsDocumentComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<CustomsDocumentComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

