/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customsdocument.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TransactionDetailsPanel
extends DefaultDetailsPanel<CustomsDocumentComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> associatedCharges;
    private TitledItem<TextLabel> associatedFlights;
    private TitledItem<TextLabel> associatedCheckIn;
    private TitledItem<TextLabel> associatedCheckout;
    private TitledItem<TextLabel> associatedMovements;
    private TitledItem<TextLabel> associatedPurchase;

    public TransactionDetailsPanel(RowEditor<CustomsDocumentComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.TRANSACTIONS);
        this.associatedCharges = new TitledItem<TextLabel>(new TextLabel(), Words.ASSOCIATED_CHARGES, TitledItem.TitledItemOrientation.NORTH);
        this.associatedFlights = new TitledItem<TextLabel>(new TextLabel(), Words.ASSOCIATED_FLIGHTS, TitledItem.TitledItemOrientation.NORTH);
        this.associatedCheckIn = new TitledItem<TextLabel>(new TextLabel(), Words.ASSOCIATED_CHECKIN, TitledItem.TitledItemOrientation.NORTH);
        this.associatedCheckout = new TitledItem<TextLabel>(new TextLabel(), Words.ASSOCIATED_CHECKOUT, TitledItem.TitledItemOrientation.NORTH);
        this.associatedMovements = new TitledItem<TextLabel>(new TextLabel(), Words.ASSOCIATED_MOVEMENTS, TitledItem.TitledItemOrientation.NORTH);
        this.associatedPurchase = new TitledItem<TextLabel>(new TextLabel(), Words.ASSOCIATED_PURCHASE, TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.associatedCharges);
        this.addToView(this.associatedFlights);
        this.addToView(this.associatedCheckIn);
        this.addToView(this.associatedCheckout);
        this.addToView(this.associatedMovements);
        this.addToView(this.associatedPurchase);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<Component> getFocusComponents() {
        return new ArrayList<Component>();
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        CustomsDocumentComplete currentDoc = (CustomsDocumentComplete)node.getValue();
        List usedFlights = (List)NodeToolkit.getAffixNamed((String)DtoFieldConstants.CREATION_FLIGHT.getFieldName()).getValue();
        List usedTransactions = (List)NodeToolkit.getAffixNamed((String)DtoFieldConstants.TRANSACTIONS.getFieldName()).getValue();
        List originCheckIn = (List)NodeToolkit.getAffixNamed((String)DtoFieldConstants.CHECKIN_GROUP.getFieldName()).getValue();
        List originCheckout = (List)NodeToolkit.getAffixNamed((String)DtoFieldConstants.CHECKOUT_GROUP.getFieldName()).getValue();
        List movement = (List)NodeToolkit.getAffixNamed((String)DtoFieldConstants.MOVEMENT_GROUP.getFieldName()).getValue();
        this.associatedCharges.getElement().setText(this.createChargeText(usedTransactions, currentDoc));
        this.associatedCheckIn.getElement().setText(this.createCheckInText(originCheckIn));
        this.associatedCheckout.getElement().setText(this.createCheckoutText(originCheckout));
        this.associatedFlights.getElement().setText(this.createFlightText(usedFlights));
        this.associatedMovements.getElement().setText(this.createMovementText(movement));
        this.associatedPurchase.getElement().setText(this.createPurchaseText(usedTransactions, currentDoc));
    }

    private String createPurchaseText(List<StockTransactionComplete> usedTransactions, CustomsDocumentComplete currentDoc) {
        String text = "";
        HashSet<PurchaseOrderComplete> orders = new HashSet<PurchaseOrderComplete>();
        for (StockTransactionComplete transaction : usedTransactions) {
            PurchaseOrderAcceptationComplete acceptation;
            if (!(transaction instanceof PurchaseOrderAcceptationComplete) || !(acceptation = (PurchaseOrderAcceptationComplete)transaction).getCustomsDocs().contains(currentDoc)) continue;
            orders.add(acceptation.getOrderPosition().getOrder());
        }
        ArrayList<PurchaseOrderComplete> sortedOrders = new ArrayList<PurchaseOrderComplete>();
        sortedOrders.addAll(orders);
        Collections.sort(sortedOrders);
        for (PurchaseOrderComplete o : sortedOrders) {
            text = text + o.getNumber() + ", ";
        }
        text = this.cutText(text);
        return text;
    }

    private String createFlightText(List<FlightLight> usedFlights) {
        String text = "";
        DateTimeConverter dateTimeConverter = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
        if (usedFlights != null && !usedFlights.isEmpty()) {
            for (FlightLight f : usedFlights) {
                text = text + f.getOutboundCode() + " " + dateTimeConverter.convert((Object)f.getStd(), null, new Object[0]) + ", ";
            }
        }
        text = this.cutText(text);
        return text;
    }

    private String cutText(String text) {
        if (!text.isEmpty()) {
            text = text.substring(0, text.length() - 2);
        }
        return text;
    }

    private String createMovementText(List<StockMovementGroupComplete> movement) {
        String text = "";
        HashSet<StockMovementGroupComplete> groups = new HashSet<StockMovementGroupComplete>();
        groups.addAll(movement);
        ArrayList<StockMovementGroupComplete> sortedGroups = new ArrayList<StockMovementGroupComplete>();
        sortedGroups.addAll(groups);
        Collections.sort(sortedGroups);
        for (StockMovementGroupComplete stockMovementGroupComplete : sortedGroups) {
            text = text + stockMovementGroupComplete.getNumber() + ", ";
        }
        text = this.cutText(text);
        return text;
    }

    private String createCheckoutText(List<StockCheckoutGroupComplete> originCheckout) {
        String text = "";
        HashSet<StockCheckoutGroupComplete> groups = new HashSet<StockCheckoutGroupComplete>();
        groups.addAll(originCheckout);
        ArrayList<StockCheckoutGroupComplete> sortedGroups = new ArrayList<StockCheckoutGroupComplete>();
        sortedGroups.addAll(groups);
        Collections.sort(sortedGroups);
        for (StockCheckoutGroupComplete stockMovementGroupComplete : sortedGroups) {
            text = text + stockMovementGroupComplete.getNumber() + ", ";
        }
        text = this.cutText(text);
        return text;
    }

    private String createCheckInText(List<StockCheckinGroupComplete> originCheckin) {
        String text = "";
        HashSet<StockCheckinGroupComplete> groups = new HashSet<StockCheckinGroupComplete>();
        groups.addAll(originCheckin);
        ArrayList<StockCheckinGroupComplete> sortedGroups = new ArrayList<StockCheckinGroupComplete>();
        sortedGroups.addAll(groups);
        Collections.sort(sortedGroups);
        for (StockCheckinGroupComplete stockMovementGroupComplete : sortedGroups) {
            text = text + stockMovementGroupComplete.getNumber() + ", ";
        }
        text = this.cutText(text);
        return text;
    }

    private String createChargeText(List<StockTransactionComplete> usedTransactions, CustomsDocumentComplete currentDoc) {
        String text = "";
        HashSet<Object> charges = new HashSet<Object>();
        for (StockTransactionComplete transaction : usedTransactions) {
            ManualStockMovementComplete manualStockMovementComplete;
            if (transaction instanceof ManualStockCheckinComplete) {
                ManualStockCheckinComplete manualStockCheckinComplete = (ManualStockCheckinComplete)transaction;
                if (!manualStockCheckinComplete.getCustomsDocs().contains(currentDoc)) continue;
                charges.add(manualStockCheckinComplete.getCharge());
                continue;
            }
            if (transaction instanceof PurchaseOrderAcceptationComplete) {
                PurchaseOrderAcceptationComplete purchaseOrderAcceptationComplete = (PurchaseOrderAcceptationComplete)transaction;
                if (!purchaseOrderAcceptationComplete.getCustomsDocs().contains(currentDoc)) continue;
                charges.add(purchaseOrderAcceptationComplete.getCharge());
                continue;
            }
            if (!(transaction instanceof ManualStockMovementComplete) || !(manualStockMovementComplete = (ManualStockMovementComplete)transaction).getCustomsDocs().contains(currentDoc)) continue;
            charges.add(manualStockMovementComplete.getCharge());
        }
        ArrayList<Object> sortedGroups = new ArrayList<Object>();
        sortedGroups.addAll(charges);
        Collections.sort(sortedGroups);
        for (ArticleChargeLight articleChargeLight : sortedGroups) {
            text = text + articleChargeLight.getNumber() + ", ";
        }
        text = this.cutText(text);
        return text;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            TransactionDetailsPanel.this.associatedFlights.setLocation(TransactionDetailsPanel.this.horizontalBorder, TransactionDetailsPanel.this.verticalBorder);
            TransactionDetailsPanel.this.associatedFlights.setSize(parent.getWidth() - 2 * TransactionDetailsPanel.this.horizontalBorder, (int)TransactionDetailsPanel.this.associatedFlights.getPreferredSize().getHeight());
            int currentY = TransactionDetailsPanel.this.associatedFlights.getY() + TransactionDetailsPanel.this.associatedFlights.getHeight() + TransactionDetailsPanel.this.verticalBorder;
            TransactionDetailsPanel.this.associatedPurchase.setLocation(TransactionDetailsPanel.this.horizontalBorder, currentY);
            TransactionDetailsPanel.this.associatedPurchase.setSize(parent.getWidth() - 2 * TransactionDetailsPanel.this.horizontalBorder, (int)TransactionDetailsPanel.this.associatedPurchase.getPreferredSize().getHeight());
            currentY = TransactionDetailsPanel.this.associatedPurchase.getY() + TransactionDetailsPanel.this.associatedPurchase.getHeight() + TransactionDetailsPanel.this.verticalBorder;
            TransactionDetailsPanel.this.associatedCheckIn.setLocation(TransactionDetailsPanel.this.horizontalBorder, currentY);
            TransactionDetailsPanel.this.associatedCheckIn.setSize(parent.getWidth() - 2 * TransactionDetailsPanel.this.horizontalBorder, (int)TransactionDetailsPanel.this.associatedCheckIn.getPreferredSize().getHeight());
            currentY = TransactionDetailsPanel.this.associatedCheckIn.getY() + TransactionDetailsPanel.this.associatedCheckIn.getHeight() + TransactionDetailsPanel.this.verticalBorder;
            TransactionDetailsPanel.this.associatedCheckout.setLocation(TransactionDetailsPanel.this.horizontalBorder, currentY);
            TransactionDetailsPanel.this.associatedCheckout.setSize(parent.getWidth() - 2 * TransactionDetailsPanel.this.horizontalBorder, (int)TransactionDetailsPanel.this.associatedCheckout.getPreferredSize().getHeight());
            currentY = TransactionDetailsPanel.this.associatedCheckout.getY() + TransactionDetailsPanel.this.associatedCheckout.getHeight() + TransactionDetailsPanel.this.verticalBorder;
            TransactionDetailsPanel.this.associatedMovements.setLocation(TransactionDetailsPanel.this.horizontalBorder, currentY);
            TransactionDetailsPanel.this.associatedMovements.setSize(parent.getWidth() - 2 * TransactionDetailsPanel.this.horizontalBorder, (int)TransactionDetailsPanel.this.associatedMovements.getPreferredSize().getHeight());
            currentY = TransactionDetailsPanel.this.associatedMovements.getY() + TransactionDetailsPanel.this.associatedMovements.getHeight() + TransactionDetailsPanel.this.verticalBorder;
            TransactionDetailsPanel.this.associatedCharges.setLocation(TransactionDetailsPanel.this.horizontalBorder, currentY);
            TransactionDetailsPanel.this.associatedCharges.setSize(parent.getWidth() - 2 * TransactionDetailsPanel.this.horizontalBorder, (int)TransactionDetailsPanel.this.associatedCharges.getPreferredSize().getHeight());
            currentY = TransactionDetailsPanel.this.associatedCharges.getY() + TransactionDetailsPanel.this.associatedCharges.getHeight() + TransactionDetailsPanel.this.verticalBorder;
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h = TransactionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + TransactionDetailsPanel.this.associatedFlights.getPreferredSize().getHeight());
            h += TransactionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + TransactionDetailsPanel.this.associatedPurchase.getPreferredSize().getHeight());
            h += TransactionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + TransactionDetailsPanel.this.associatedCheckIn.getPreferredSize().getHeight());
            h += TransactionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + TransactionDetailsPanel.this.associatedCheckout.getPreferredSize().getHeight());
            h += TransactionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + TransactionDetailsPanel.this.associatedMovements.getPreferredSize().getHeight());
            h += TransactionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + TransactionDetailsPanel.this.associatedCharges.getPreferredSize().getHeight());
            return new Dimension(0, h += TransactionDetailsPanel.this.verticalBorder);
        }
    }
}

