/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dailyopskitchen;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionComplete_;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionEntryComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionEntryComplete_;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KitchenDailyOpsModuleDataHandler
extends DefaultDataHandler<FlightReference, FlightComplete> {
    static Logger log = LoggerFactory.getLogger(KitchenDailyOpsModuleDataHandler.class);
    private boolean latestApproveState;

    public KitchenDailyOpsModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataAfterClosing(final Node<?> node, final RemoteLoader listener, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightLight f = (FlightLight)node.getValue();
                FlightSearchConfiguration s = new FlightSearchConfiguration();
                s.setFlightNumber(f.getOutboundCode());
                s.setDayPeriod(new PeriodComplete(new Date(f.getStd().getTime()), new Date(f.getStd().getTime())));
                Node flightNode = node;
                SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)s);
                for (FlightLight fl : r.getResults()) {
                    if (fl.getId() == null || f.getId() == null) continue;
                    if (fl.getId().equals(f.getId())) {
                        flightNode.removeExistingValues();
                        flightNode.setValue((Object)fl, 0L);
                        flightNode.updateNode();
                        continue;
                    }
                    if (f.getClientOId() == null || fl.getClientOId() == null || !f.getClientOId().equals(fl.getClientOId())) continue;
                    flightNode.removeExistingValues();
                    flightNode.setValue((Object)fl, 0L);
                    flightNode.updateNode();
                }
                if (r.getResults().size() == 1) {
                    flightNode.removeExistingValues();
                    flightNode.setValue(r.getSingleResult(), 0L);
                    flightNode.updateNode();
                }
                return flightNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<FlightReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightLight flight = (FlightLight)node.getValue(FlightLight.class);
                boolean newApproveState = flight.getSubstitutionsApproved();
                Node sc = node.getChildNamed(DtoFieldConstants.SUBSTITUTIONS);
                sc.commitThis(ItemSubstitutionComplete.class);
                ItemSubstitutionComplete s = (ItemSubstitutionComplete)sc.getValue(ItemSubstitutionComplete.class);
                if (!s.getSubstitutions().isEmpty()) {
                    for (ItemSubstitutionEntryComplete e : s.getSubstitutions()) {
                        e.setFlight(s.getAssociatedFlight());
                    }
                    s = s.getId() == null ? (ItemSubstitutionComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createItemSubstitution(s).getValue() : (ItemSubstitutionComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateItemSubstitution(s).getValue();
                    sc.removeExistingValues();
                    sc.setValue((Object)s, 0L);
                    sc.updateNode();
                } else if (s.getId() != null) {
                    s = (ItemSubstitutionComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateItemSubstitution(s).getValue();
                    sc.removeExistingValues();
                    sc.setValue((Object)s, 0L);
                    sc.updateNode();
                }
                if (!KitchenDailyOpsModuleDataHandler.this.latestApproveState && newApproveState) {
                    flight = (FlightLight)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).approveFlightSubstitutions(new FlightReference(flight.getId())).getValue();
                    node.removeExistingValues();
                    node.setValue((Object)flight, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(Node<FlightComplete> node, RemoteLoader model, boolean sameNode, ProgressListener l) {
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                KitchenDailyOpsModuleDataHandler.this.setCurrentLoadMaximum(7);
                KitchenDailyOpsModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                KitchenDailyOpsModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                KitchenDailyOpsModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                KitchenDailyOpsModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                KitchenDailyOpsModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                KitchenDailyOpsModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                KitchenDailyOpsModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllItemSubstitutionTypes();
                KitchenDailyOpsModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return KitchenDailyOpsModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<FlightComplete> resetData(Node<FlightComplete> node) {
        return null;
    }

    @Override
    public Node<FlightComplete> createEmptyNode() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n;
                FlightLight flight = (FlightLight)node.getValue(FlightLight.class);
                KitchenDailyOpsModuleDataHandler.this.latestApproveState = flight.getSubstitutionsApproved();
                ItemSubstitutionComplete sc = (ItemSubstitutionComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getItemSubstitutionForFlight((FlightReference)node.getValue()).getValue();
                if (sc == null || sc.getId() == null) {
                    sc = new ItemSubstitutionComplete();
                    sc.setClientOId(Long.valueOf(ADTO.getNextId()));
                    sc.setAssociatedFlight(flight);
                    sc.setDate(new Date(flight.getStd().getTime()));
                    sc.setName(Phrase.getPhrase((String)Phrase.SUBSTITUTION_FOR_FLIGHT, (Object[])new Object[]{flight.getOutboundCode()}));
                }
                if ((n = node.getChildNamed(DtoFieldConstants.SUBSTITUTIONS)) == null) {
                    n = INodeCreator.getDefaultImpl().getNode4DTO((Object)sc, false, false);
                    n.setName(DtoFieldConstants.SUBSTITUTIONS);
                    node.addChild(n, 0L);
                }
                n.removeExistingValues();
                n.setValue((Object)sc, 0L);
                n.updateNode();
                Iterator it = n.getChildNamed(ItemSubstitutionComplete_.substitutions).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node sub = (Node)it.next();
                    this.ensureArticle((Node<BasicArticleLight>)sub.getChildNamed(ItemSubstitutionEntryComplete_.originArticle));
                    this.ensureArticle((Node<BasicArticleLight>)sub.getChildNamed(ItemSubstitutionEntryComplete_.newArticle));
                }
                Node au = node.getChildNamed(FlightLight_.substitutionsApprovedUser);
                if (au.getValue() != null && au.getValue(UserLight.class) == null) {
                    UserLight nu = (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getUserLight((UserReference)au.getValue()).getValue();
                    au.removeExistingValues();
                    au.setValue((Object)nu, 0L);
                }
                return node;
            }

            private void ensureArticle(Node<BasicArticleLight> articleNode) throws ClientServerCallException {
                if (articleNode == null) {
                    return;
                }
                if (articleNode.getValue() == null) {
                    return;
                }
                BasicArticleComplete artC = (BasicArticleComplete)articleNode.getValue(BasicArticleComplete.class);
                if (artC == null) {
                    BasicArticleLight artL = (BasicArticleLight)articleNode.getValue();
                    artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                    articleNode.removeExistingValues();
                    articleNode.setValue((Object)artC, 0L);
                }
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Class<FlightComplete> getCommittingClass() {
        return FlightComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<FlightReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

