/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.TemporaryFileRemoveServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.TemporaryFileRemoveSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TemporaryFileRemoveSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.report.TemporaryFileRemoveExportConfig;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class TemporaryFileRemoveInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> useTemporaryFileRemoveSync;
    private TitledItem<CheckBox> autoDeleteActive;
    private RadioButtonBox deleteParameter;
    private TitledItem<RadioButton> removeAll;
    private TitledItem<RadioButton> removeOlderThan30Days;
    private TextLabel removeDirectory;
    private TablePanelAddSaveButton deleteButton;
    private TablePanelAddSaveButton saveButton;
    private final Node<TemporaryFileRemoveExportConfig> node;
    private final DataExchangeModule module;
    protected Node<TemporaryFileRemoveSettingsComplete> settings;
    protected TemporaryFileRemoveSettingsComplete tfrsc;

    public TemporaryFileRemoveInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
        TemporaryFileRemoveExportConfig e = new TemporaryFileRemoveExportConfig();
        this.node = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, false, false);
    }

    @Override
    public void insertElements() {
        this.useTemporaryFileRemoveSync = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(TemporaryFileRemoveSettingsComplete_.useTemporaryFileRemoveInterface)), Words.ENABLE_RETAIL_IN_MOTION, TitledItem.TitledItemOrientation.EAST);
        this.useTemporaryFileRemoveSync.getElement().addButtonListener(this);
        this.autoDeleteActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(TemporaryFileRemoveSettingsComplete_.autoDeleteData)), Words.AUTO_RECEIVE, TitledItem.TitledItemOrientation.EAST);
        this.removeDirectory = new TextLabel("Deletedirectory: " + Words.TEMPORARY);
        this.removeAll = new TitledItem<RadioButton>(new RadioButton(), "delete all.", TitledItem.TitledItemOrientation.EAST);
        this.removeOlderThan30Days = new TitledItem<RadioButton>(new RadioButton(), "delete older than 30 days.", TitledItem.TitledItemOrientation.EAST);
        this.removeOlderThan30Days.getElement().setChecked(true);
        this.deleteParameter = new RadioButtonBox();
        this.deleteParameter.setBorder(0);
        this.deleteParameter.addBox(this.removeAll, this.removeAll.getElement());
        this.deleteParameter.addBox(this.removeOlderThan30Days, this.removeOlderThan30Days.getElement());
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText("Save");
        this.saveButton.addButtonListener(this);
        this.deleteButton = new TablePanelAddSaveButton();
        this.deleteButton.setText("Delete");
        this.deleteButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.useTemporaryFileRemoveSync);
        this.add(this.autoDeleteActive);
        this.add(this.removeDirectory);
        this.add(this.deleteButton);
        this.add(this.saveButton);
        this.add(this.deleteParameter);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                TemporaryFileRemoveInsert.this.tfrsc = (TemporaryFileRemoveSettingsComplete)((TemporaryFileRemoveServiceManager)ServiceManagerRegistry.getService(TemporaryFileRemoveServiceManager.class)).getTemporaryFileRemoveSettings().getValue();
                if (TemporaryFileRemoveInsert.this.tfrsc == null) {
                    TemporaryFileRemoveSettingsComplete s = new TemporaryFileRemoveSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    TemporaryFileRemoveInsert.this.tfrsc = s;
                }
                TemporaryFileRemoveInsert.this.tfrsc.setTimerServiceSettings(TemporaryFileRemoveInsert.this.createDailyTimerService());
                TemporaryFileRemoveInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)TemporaryFileRemoveInsert.this.tfrsc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return TemporaryFileRemoveInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(4), Integer.valueOf(0), Integer.valueOf(0)));
        return s;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useTemporaryFileRemoveSync.setEnabled(isEnabled);
            this.autoDeleteActive.setEnabled(isEnabled);
            this.removeDirectory.setEnabled(isEnabled);
            this.deleteButton.setEnabled(isEnabled);
            this.deleteParameter.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.useTemporaryFileRemoveSync.kill();
            this.autoDeleteActive.kill();
            this.removeDirectory.kill();
            this.deleteButton.kill();
            this.deleteParameter.kill();
            this.saveButton.kill();
        }
        this.useTemporaryFileRemoveSync = null;
        this.autoDeleteActive = null;
        this.removeDirectory = null;
        this.deleteButton = null;
        this.deleteParameter = null;
        this.removeAll = null;
        this.removeOlderThan30Days = null;
        this.saveButton = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Remove Temporary Files";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.deleteButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.deleteButton) {
                this.deleteFiles();
            } else if (source == this.saveButton) {
                this.saveConfig();
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private void deleteFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){
            Integer intervall;
            {
                this.intervall = 30;
            }

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                if (((RadioButton)TemporaryFileRemoveInsert.this.removeAll.getElement()).isChecked()) {
                    this.intervall = 0;
                } else if (((RadioButton)TemporaryFileRemoveInsert.this.removeOlderThan30Days.getElement()).isChecked()) {
                    this.intervall = 30;
                }
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).deleteOldFiles();
                n.setValue((Object)true, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        TemporaryFileRemoveInsert.this.module.ended();
                        TemporaryFileRemoveInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, TemporaryFileRemoveInsert.this.deleteButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_RETAIL_IN_MOTION_IMPORT, (Component)TemporaryFileRemoveInsert.this.deleteButton);
                        TemporaryFileRemoveInsert.this.setEnabled(true);
                        TemporaryFileRemoveInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                TemporaryFileRemoveSettingsComplete tfrsc = (TemporaryFileRemoveSettingsComplete)((TemporaryFileRemoveServiceManager)ServiceManagerRegistry.getService(TemporaryFileRemoveServiceManager.class)).getTemporaryFileRemoveSettings().getValue();
                boolean b = ((CheckBox)TemporaryFileRemoveInsert.this.useTemporaryFileRemoveSync.getElement()).isChecked();
                boolean c = ((CheckBox)TemporaryFileRemoveInsert.this.autoDeleteActive.getElement()).isChecked();
                if (Boolean.TRUE.equals(((CheckBox)TemporaryFileRemoveInsert.this.useTemporaryFileRemoveSync.getElement()).isChecked()) && Boolean.TRUE.equals(((CheckBox)TemporaryFileRemoveInsert.this.autoDeleteActive.getElement()).isChecked())) {
                    tfrsc.setUseTemporaryFileRemoveInterface(Boolean.valueOf(true));
                    tfrsc.setAutoDeleteData(Boolean.valueOf(true));
                    if (((RadioButton)TemporaryFileRemoveInsert.this.removeAll.getElement()).isChecked()) {
                        tfrsc.setIntervall(Integer.valueOf(0));
                    } else if (((RadioButton)TemporaryFileRemoveInsert.this.removeOlderThan30Days.getElement()).isChecked()) {
                        tfrsc.setIntervall(Integer.valueOf(30));
                    }
                    TemporaryFileRemoveSettingsComplete deleteFiles = tfrsc = (TemporaryFileRemoveSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)tfrsc).getValue();
                    deleteFiles.setTimerServiceSettings(TemporaryFileRemoveInsert.this.createDailyTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(deleteFiles.getTimerServiceSettings()).getValue();
                    deleteFiles.setTimerServiceSettings(ts);
                    deleteFiles = (TemporaryFileRemoveSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)deleteFiles).getValue();
                    TimerServiceConfigComplete tc = ts.getTimerServiceConfig();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.TEMPORARY_FILE_REMOVE, deleteFiles.getAutoDeleteData().booleanValue(), ts, -1L);
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)tfrsc, false, false);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.TEMPORARY_FILE_REMOVE);
                    tfrsc = (TemporaryFileRemoveSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)tfrsc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)tfrsc, false, false);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        TemporaryFileRemoveInsert.this.module.ended();
                        TemporaryFileRemoveInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)TemporaryFileRemoveInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (TemporaryFileRemoveInsert.this.isInserted) {
                TemporaryFileRemoveInsert.this.useTemporaryFileRemoveSync.setLocation(border, border);
                TemporaryFileRemoveInsert.this.useTemporaryFileRemoveSync.setSize(TemporaryFileRemoveInsert.this.useTemporaryFileRemoveSync.getPreferredSize());
                TemporaryFileRemoveInsert.this.autoDeleteActive.setLocation(border, TemporaryFileRemoveInsert.this.useTemporaryFileRemoveSync.getY() + TemporaryFileRemoveInsert.this.useTemporaryFileRemoveSync.getHeight());
                TemporaryFileRemoveInsert.this.autoDeleteActive.setSize(TemporaryFileRemoveInsert.this.autoDeleteActive.getPreferredSize());
                TemporaryFileRemoveInsert.this.removeDirectory.setLocation(border, TemporaryFileRemoveInsert.this.autoDeleteActive.getY() + TemporaryFileRemoveInsert.this.autoDeleteActive.getHeight());
                TemporaryFileRemoveInsert.this.removeDirectory.setSize(parent.getWidth() / 2 - 2 * border, (int)TemporaryFileRemoveInsert.this.removeDirectory.getPreferredSize().getHeight());
                TemporaryFileRemoveInsert.this.deleteParameter.setLocation(TemporaryFileRemoveInsert.this.removeDirectory.getX(), TemporaryFileRemoveInsert.this.removeDirectory.getY() + TemporaryFileRemoveInsert.this.removeDirectory.getHeight() + border);
                TemporaryFileRemoveInsert.this.deleteParameter.setSize(parent.getWidth() / 2 - 2 * border, (int)TemporaryFileRemoveInsert.this.deleteParameter.getPreferredSize().getHeight());
                TemporaryFileRemoveInsert.this.saveButton.setLocation((int)(((double)parent.getWidth() - TemporaryFileRemoveInsert.this.saveButton.getPreferredSize().getWidth()) / 2.0) - 100, (int)((double)parent.getHeight() - ((double)border + TemporaryFileRemoveInsert.this.saveButton.getPreferredSize().getHeight())));
                TemporaryFileRemoveInsert.this.saveButton.setSize(TemporaryFileRemoveInsert.this.saveButton.getPreferredSize());
                TemporaryFileRemoveInsert.this.deleteButton.setLocation((int)((double)parent.getWidth() - ((double)border + TemporaryFileRemoveInsert.this.deleteButton.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - ((double)border + TemporaryFileRemoveInsert.this.deleteButton.getPreferredSize().getHeight())));
                TemporaryFileRemoveInsert.this.deleteButton.setSize(TemporaryFileRemoveInsert.this.deleteButton.getPreferredSize());
            }
        }
    }
}

