/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.documentscan.detail;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete_;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanLight;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<DocumentScanLight>
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private ViewButton openFile;
    private TitledItem<TextField> description;
    private TitledItem<MultiLineTextLabel> contentAsText;

    public SpecificationDetailsPanel(RowEditor<DocumentScanLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CONFIGURATION);
        this.setCustomLayouter(new Layout());
        this.openFile = new ViewButton();
        this.openFile.addButtonListener(this);
        this.description = new TitledItem<TextField>(new TextField(), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        this.contentAsText = new TitledItem<MultiLineTextLabel>(new MultiLineTextLabel(), Words.CONTENT, TitledItem.TitledItemOrientation.NORTH);
        this.addToView(this.openFile);
        this.addToView(this.description);
        this.addToView(this.contentAsText);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.openFile);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        this.description.getElement().setNode(node.getChildNamed(DocumentScanComplete_.description));
        this.contentAsText.getElement().setText((String)node.getChildNamed(DocumentScanComplete_.contentAsText).getValue());
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        PegasusFileComplete gr = (PegasusFileComplete)this.editor.getModel().getNode().getChildNamed(DocumentScanComplete_.fileData).getValue();
        if (gr != null && gr.getLocalFile() != null) {
            FileCommitter c = new FileCommitter(gr.getLocalFile(), FileCategoryE.IMPORT);
            c.setWriteBackAlgorithm(reference -> {
                this.editor.getModel().getNode().getChildNamed(DocumentScanComplete_.fileData).setValue((Object)reference, 0L);
                ((DocumentScanComplete)this.editor.getModel().getNode().getValue()).setFileData(reference);
            });
            a.add(c);
        }
        return a;
    }

    @Override
    public void buttonPressed(final Button source, int x, int y) {
        if (source == this.openFile) {
            try {
                PegasusFileComplete value = ((DocumentScanComplete)this.editor.getModel().getNode().getValue()).getFileData();
                if (value == null) {
                    InnerPopupFactory.showErrorDialog("No Document Uploaded", (Component)this);
                    return;
                }
                File file = FileTransferUtil.download((PegasusFileComplete)value, (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                    public void statusChanged(File file, FileTransferState state) {
                    }

                    public void exceptionOccurred(Exception exception) {
                        InnerPopupFactory.showErrorDialog(exception, (Component)source);
                    }
                }});
                if (file == null) {
                    InnerPopupFactory.showErrorDialog("No template ready. Please contact support.", (Component)this);
                }
                Desktop.getDesktop().open(file);
            }
            catch (IOException e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
            catch (Exception e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.openFile.kill();
        this.openFile = null;
        this.description.kill();
        this.description = null;
        this.contentAsText.kill();
        this.contentAsText = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.openFile.setEnabled(isEnabled);
        this.description.setEnabled(isEnabled);
        this.contentAsText.setEnabled(isEnabled);
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.openFile.setLocation(SpecificationDetailsPanel.this.horizontalBorder, (int)((double)SpecificationDetailsPanel.this.verticalBorder + SpecificationDetailsPanel.this.description.getPreferredSize().getHeight() - SpecificationDetailsPanel.this.openFile.getPreferredSize().getHeight()) - 2);
            SpecificationDetailsPanel.this.openFile.setSize(SpecificationDetailsPanel.this.openFile.getPreferredSize());
            SpecificationDetailsPanel.this.description.setLocation(SpecificationDetailsPanel.this.openFile.getX() + SpecificationDetailsPanel.this.openFile.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.description.setSize(SpecificationDetailsPanel.this.description.getPreferredSize());
            SpecificationDetailsPanel.this.contentAsText.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.description.getY() + SpecificationDetailsPanel.this.description.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.contentAsText.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.contentAsText.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int lh = SpecificationDetailsPanel.this.verticalBorder;
            lh = (int)((double)lh + SpecificationDetailsPanel.this.description.getPreferredSize().getHeight());
            lh += SpecificationDetailsPanel.this.inner_verticalBorder;
            lh = (int)((double)lh + SpecificationDetailsPanel.this.contentAsText.getPreferredSize().getHeight());
            return new Dimension(0, lh += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

