/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DiscountTypeConfig
extends MasterDataInsert<DiscountTypeComplete> {
    private static final long serialVersionUID = 1L;

    public DiscountTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new DiscountTyoeConfigPanel();
    }

    @Override
    public DiscountTypeComplete getNewObject() {
        DiscountTypeComplete a = new DiscountTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<DiscountTypeComplete> getMasterDataClass() {
        return DiscountTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.DISCOUNT_TYPES;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(DiscountTypeComplete_.name).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(DiscountTypeComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(DiscountTypeComplete_.name).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(DiscountTypeComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        return a;
    }

    private class DiscountTyoeConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<TextField> rate;
        private TitledItem<TextField> description;

        public DiscountTyoeConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.rate = new TitledItem<TextField>(new TextField(null, TextFieldType.DOUBLE), Words.RATE_PERCENT, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.rate);
            this.add(this.description);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.name.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.rate.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.rate.kill();
            this.description.kill();
            this.name = null;
            this.rate.kill();
            this.description = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.rate.setEnabled(b);
            this.description.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(DiscountTypeComplete_.name));
            this.rate.getElement().setNode(node.getChildNamed(DiscountTypeComplete_.rate));
            this.description.getElement().setNode(node.getChildNamed(DiscountTypeComplete_.decription));
            this.setEnabled(true);
            DiscountTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return DiscountTypeComplete_.name;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                DiscountTyoeConfigPanel.this.name.setLocation(DiscountTypeConfig.this.masterDataTable.getCellPadding(), DiscountTypeConfig.this.masterDataTable.getCellPadding());
                DiscountTyoeConfigPanel.this.name.setSize(200, (int)DiscountTyoeConfigPanel.this.name.getPreferredSize().getHeight());
                DiscountTyoeConfigPanel.this.rate.setLocation(DiscountTypeConfig.this.masterDataTable.getCellPadding(), DiscountTyoeConfigPanel.this.name.getY() + DiscountTyoeConfigPanel.this.name.getHeight() + DiscountTypeConfig.this.masterDataTable.getCellPadding());
                DiscountTyoeConfigPanel.this.rate.setSize(200, (int)DiscountTyoeConfigPanel.this.rate.getPreferredSize().getHeight());
                DiscountTyoeConfigPanel.this.description.setLocation(DiscountTypeConfig.this.masterDataTable.getCellPadding(), DiscountTyoeConfigPanel.this.rate.getY() + DiscountTyoeConfigPanel.this.rate.getHeight() + DiscountTypeConfig.this.masterDataTable.getCellPadding());
                DiscountTyoeConfigPanel.this.description.setSize(200, (int)DiscountTyoeConfigPanel.this.description.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

