/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class HaulTypeConfig
extends MasterDataInsert<HaulTypeComplete> {
    private static final long serialVersionUID = 1L;

    public HaulTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public HaulTypeComplete getNewObject() {
        HaulTypeComplete c = new HaulTypeComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        return c;
    }

    @Override
    public Class<HaulTypeComplete> getMasterDataClass() {
        return HaulTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Haul Types";
    }

    @Override
    public DetailsPanel getDetails() {
        return new HaulTypeDetailsPanel();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean descriptionSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(HaulTypeComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(HaulTypeComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(HaulTypeComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(HaulTypeComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(HaulTypeComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Desciptions are set"));
        }
        return a;
    }

    private class HaulTypeDetailsPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> invoiceCode;
        private TitledItem<TextField> description;
        private TitledItem<TextField> internalDescription;

        public HaulTypeDetailsPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(), WordsToolkit.toCapitalLetter((String)Words.CODE), TitledItem.TitledItemOrientation.NORTH);
            this.invoiceCode = new TitledItem<TextField>(new TextField(), Words.INVOICE_CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(), WordsToolkit.toCapitalLetter((String)Words.DESCRIPTION), TitledItem.TitledItemOrientation.NORTH);
            this.internalDescription = new TitledItem<TextField>(new TextField(), WordsToolkit.toCapitalLetter((String)Words.INTERNAL_DESCRIPTION), TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.invoiceCode);
            this.add(this.description);
            this.add(this.internalDescription);
        }

        @Override
        public void setNode(Node<?> n) {
            super.setNode(n);
            this.code.getElement().setNode(n.getChildNamed(HaulTypeComplete_.code));
            this.invoiceCode.getElement().setNode(n.getChildNamed(HaulTypeComplete_.invoiceCode));
            this.description.getElement().setNode(n.getChildNamed(HaulTypeComplete_.description));
            this.internalDescription.getElement().setNode(n.getChildNamed(HaulTypeComplete_.internalDescription));
            this.setEnabled(true);
            HaulTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return HaulTypeComplete_.code;
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            CheckedListAdder.addToList(a, this.invoiceCode);
            a.addAll(this.description.getFocusComponents());
            CheckedListAdder.addToList(a, this.internalDescription);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.invoiceCode.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.internalDescription.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.internalDescription.kill();
            this.invoiceCode.kill();
            this.code = null;
            this.description = null;
            this.internalDescription = null;
            this.invoiceCode = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.internalDescription.setEnabled(b);
            this.invoiceCode.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                HaulTypeDetailsPanel.this.code.setLocation(HaulTypeConfig.this.masterDataTable.getCellPadding(), HaulTypeConfig.this.masterDataTable.getCellPadding());
                HaulTypeDetailsPanel.this.code.setSize(200, (int)HaulTypeDetailsPanel.this.code.getPreferredSize().getHeight());
                HaulTypeDetailsPanel.this.invoiceCode.setLocation(HaulTypeConfig.this.masterDataTable.getCellPadding(), HaulTypeDetailsPanel.this.code.getY() + HaulTypeDetailsPanel.this.code.getHeight() + HaulTypeConfig.this.masterDataTable.getCellPadding());
                HaulTypeDetailsPanel.this.invoiceCode.setSize(200, (int)HaulTypeDetailsPanel.this.invoiceCode.getPreferredSize().getHeight());
                HaulTypeDetailsPanel.this.description.setLocation(HaulTypeConfig.this.masterDataTable.getCellPadding(), HaulTypeDetailsPanel.this.invoiceCode.getY() + HaulTypeDetailsPanel.this.invoiceCode.getHeight() + HaulTypeConfig.this.masterDataTable.getCellPadding());
                HaulTypeDetailsPanel.this.description.setSize(200, (int)HaulTypeDetailsPanel.this.description.getPreferredSize().getHeight());
                HaulTypeDetailsPanel.this.internalDescription.setLocation(HaulTypeConfig.this.masterDataTable.getCellPadding(), HaulTypeDetailsPanel.this.description.getY() + HaulTypeDetailsPanel.this.description.getHeight() + HaulTypeConfig.this.masterDataTable.getCellPadding());
                HaulTypeDetailsPanel.this.internalDescription.setSize(200, (int)HaulTypeDetailsPanel.this.internalDescription.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

