/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispo.utils;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.matdispo.MatDispoOldModule;
import ch.icit.pegasus.client.gui.modules.matdispo.details.ArticleDetailsPanel;
import ch.icit.pegasus.client.gui.modules.matdispo.details.FlightDetailsPanel;
import ch.icit.pegasus.client.gui.modules.matdispo.details.ProductDetailsPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.ExcelExportPopupInsert;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.matdispo.MatDispoDataExportComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.StyledWorkbook;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class MatDispoExportPopup
extends ExcelExportPopupInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private ArticleDetailsPanel adp;
    private ProductDetailsPanel pdp;
    private FlightDetailsPanel fdp;
    private MatDispoOldModule module;
    private TitledItem<ComboBox> filterBonded;
    private TitledItem<ComboBox> source;
    private TitledItem<CheckBox> includeMatCost;
    private TitledItem<CheckBox> includeCurrentStock;
    private boolean showMaterialCost;

    public MatDispoExportPopup(MatDispoOldModule module, ArticleDetailsPanel adp, ProductDetailsPanel pdp, FlightDetailsPanel fdp, boolean showMaterialCosts) {
        super(true);
        this.adp = adp;
        this.pdp = pdp;
        this.fdp = fdp;
        this.module = module;
        this.showMaterialCost = showMaterialCosts;
        this.createComponents();
    }

    @Override
    protected void createComponents() {
        this.source = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(BondedStateEConverter.class)), Words.SOURCE, TitledItem.TitledItemOrientation.NORTH);
        this.source.getElement().addItem(SourceType.ARTICLES);
        this.source.getElement().addItem(SourceType.PRODUCTS);
        this.source.getElement().addItem(SourceType.RECIPES);
        this.filterBonded = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.includeMatCost = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MAT_COSTS, TitledItem.TitledItemOrientation.EAST);
        this.includeCurrentStock = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STOCK, TitledItem.TitledItemOrientation.EAST);
        this.add(this.source);
        this.add(this.filterBonded);
        this.add(this.includeMatCost);
        this.add(this.includeCurrentStock);
        this.setLayout(new Layout());
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public String getTitleString() {
        return null;
    }

    @Override
    public String getTitleValue() {
        return null;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.filterBonded);
        CheckedListAdder.addToList(a, this.source);
        CheckedListAdder.addToList(a, this.includeMatCost);
        CheckedListAdder.addToList(a, this.includeCurrentStock);
        return a;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.filterBonded.setVisible(false);
        this.source.setVisible(false);
        this.includeMatCost.setVisible(false);
        this.includeCurrentStock.setVisible(false);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.filterBonded.setEnabled(isEnabled);
        this.source.setEnabled(isEnabled);
        this.includeMatCost.setEnabled(isEnabled && this.showMaterialCost);
        this.includeCurrentStock.setEnabled(isEnabled);
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                List<ExcelRow> rows = null;
                String exports = "";
                switch ((SourceType)((Object)((ComboBox)MatDispoExportPopup.this.source.getElement()).getSelectedItem())) {
                    case ARTICLES: {
                        exports = "Articles";
                        rows = MatDispoExportPopup.this.adp.getExcelRows((BondedStateE)((Node)((ComboBox)MatDispoExportPopup.this.filterBonded.getElement()).getSelectedItem()).getValue(), ((CheckBox)MatDispoExportPopup.this.includeCurrentStock.getElement()).isChecked(), MatDispoExportPopup.this.fdp, MatDispoExportPopup.this.animation);
                        break;
                    }
                    case PRODUCTS: {
                        exports = "Products";
                        rows = MatDispoExportPopup.this.pdp.getProductExcelRows((BondedStateE)((Node)((ComboBox)MatDispoExportPopup.this.filterBonded.getElement()).getSelectedItem()).getValue(), MatDispoExportPopup.this.fdp, MatDispoExportPopup.this.animation, ((CheckBox)MatDispoExportPopup.this.includeMatCost.getElement()).isChecked() && MatDispoExportPopup.this.showMaterialCost);
                        break;
                    }
                    case RECIPES: {
                        exports = "Recipes";
                        rows = MatDispoExportPopup.this.pdp.getRecipeExcelRows((BondedStateE)((Node)((ComboBox)MatDispoExportPopup.this.filterBonded.getElement()).getSelectedItem()).getValue(), MatDispoExportPopup.this.fdp, MatDispoExportPopup.this.animation);
                        break;
                    }
                }
                StyledWorkbook wb = ExcelToolkit.createFastWorkbook();
                wb.setUseIntegerStyleWithoutSeperator(true);
                ExcelToolkit.addRows((StyledWorkbook)wb, rows, (String)"Mat Dispo");
                ExcelToolkit.addRows((StyledWorkbook)wb, MatDispoExportPopup.this.fdp.getFlightRows(), (String)"Flight");
                ExcelToolkit.addRows((StyledWorkbook)wb, MatDispoExportPopup.this.pdp.getProductsRow(), (String)"Products");
                ExcelToolkit.addRows((StyledWorkbook)wb, MatDispoExportPopup.this.module.getArticleByProductRows(), (String)"Article by Product");
                try {
                    ExcelToolkit.addRows((StyledWorkbook)wb, MatDispoExportPopup.this.getSummaryRows(), (String)"Creation data");
                    ArrayList<ExcelRow> warnings = new ArrayList<ExcelRow>();
                    warnings.addAll(MatDispoExportPopup.this.adp.getWarnings());
                    warnings.add(new ExcelRow());
                    warnings.addAll(MatDispoExportPopup.this.pdp.getWarnings());
                    ExcelToolkit.addRows((StyledWorkbook)wb, warnings, (String)"Calculation Warnings");
                }
                catch (Exception warnings) {
                    // empty catch block
                }
                File file = ExcelToolkit.writeWorkBook((File)MatDispoExportPopup.this.getSelectedFile().getAbsoluteFile(), (StyledWorkbook)wb);
                MatDispoDataExportComplete data = new MatDispoDataExportComplete();
                data.setRemark(exports);
                ReportFileComplete p = new ReportFileComplete();
                p.setLocalFile(file);
                p.setCategory(FileCategoryE.REPORT);
                p.setReportType(ReportTypeE.MAT_DISPO);
                p = (ReportFileComplete)FileTransferUtil.upload((PegasusFileComplete)p, (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                    public void statusChanged(File file, FileTransferState state) {
                    }

                    public void exceptionOccurred(Exception exception) {
                    }
                }});
                data.setSheet(p);
                data = (MatDispoDataExportComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createMatDispoExport(data).getValue();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return MatDispoExportPopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    protected List<ExcelRow> getSummaryRows() {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        rows.add(this.getRowWithField("Created at", new Timestamp(System.currentTimeMillis())));
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        rows.add(this.getRowWithField("Create by", ((UserConverter)ConverterRegistry.getConverter(UserConverter.class)).convert((UserReference)user, null, new Object[0])));
        return rows;
    }

    private ExcelRow getRowWithField(Object ... fields) {
        ExcelRow r = new ExcelRow();
        for (Object f : fields) {
            r.addCell(f, new String[0]);
        }
        return r;
    }

    @Override
    protected String getFinishedText() {
        if (this.isError) {
            return "<html>" + this.errorMSG + "</html>";
        }
        return "Material Diposition successfully exported";
    }

    @Override
    protected String getProgressText() {
        return "Exporting Material Diposition";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int y = MatDispoExportPopup.this.getInheritedComponentsHeight();
            y += MatDispoExportPopup.this.border;
            y = (int)((double)y + MatDispoExportPopup.this.filterBonded.getPreferredSize().getHeight());
            y += MatDispoExportPopup.this.border / 2;
            y = (int)((double)y + MatDispoExportPopup.this.source.getPreferredSize().getHeight());
            y += MatDispoExportPopup.this.border / 2;
            y = (int)((double)y + MatDispoExportPopup.this.includeMatCost.getPreferredSize().getHeight());
            y += MatDispoExportPopup.this.border / 2;
            y = (int)((double)y + MatDispoExportPopup.this.includeCurrentStock.getPreferredSize().getHeight());
            return new Dimension(280, y += MatDispoExportPopup.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = MatDispoExportPopup.this.layoutInheritedComponents(parent);
            MatDispoExportPopup.this.source.setLocation(MatDispoExportPopup.this.border, y += MatDispoExportPopup.this.border);
            MatDispoExportPopup.this.source.setSize(parent.getWidth() - 2 * MatDispoExportPopup.this.border, (int)MatDispoExportPopup.this.source.getPreferredSize().getHeight());
            MatDispoExportPopup.this.filterBonded.setLocation(MatDispoExportPopup.this.border, ((MatDispoExportPopup)MatDispoExportPopup.this).source.getLocation().y + MatDispoExportPopup.this.source.getHeight() + MatDispoExportPopup.this.border / 2);
            MatDispoExportPopup.this.filterBonded.setSize(parent.getWidth() - 2 * MatDispoExportPopup.this.border, (int)MatDispoExportPopup.this.filterBonded.getPreferredSize().getHeight());
            MatDispoExportPopup.this.includeMatCost.setLocation(MatDispoExportPopup.this.border, ((MatDispoExportPopup)MatDispoExportPopup.this).filterBonded.getLocation().y + MatDispoExportPopup.this.filterBonded.getHeight() + MatDispoExportPopup.this.border / 2);
            MatDispoExportPopup.this.includeMatCost.setSize(parent.getWidth() - 2 * MatDispoExportPopup.this.border, (int)MatDispoExportPopup.this.includeMatCost.getPreferredSize().getHeight());
            MatDispoExportPopup.this.includeCurrentStock.setLocation(MatDispoExportPopup.this.border, ((MatDispoExportPopup)MatDispoExportPopup.this).includeMatCost.getLocation().y + MatDispoExportPopup.this.includeMatCost.getHeight() + MatDispoExportPopup.this.border / 2);
            MatDispoExportPopup.this.includeCurrentStock.setSize(parent.getWidth() - 2 * MatDispoExportPopup.this.border, (int)MatDispoExportPopup.this.includeCurrentStock.getPreferredSize().getHeight());
        }
    }

    private static enum SourceType {
        ARTICLES{

            public String toString() {
                return "Articles";
            }
        }
        ,
        PRODUCTS{

            public String toString() {
                return "Products";
            }
        }
        ,
        RECIPES{

            public String toString() {
                return "Recipes";
            }
        };

    }
}

