/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispo2;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.MatDispoSupplierAndStoreTemplateConverter;
import ch.icit.pegasus.client.converter.PaxFigureStringConverter;
import ch.icit.pegasus.client.converter.PaxFigureTypeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.SubModuleProvider;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.matdispo2.MatDispoModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.matdispo2.details.MatDispoDepartmentFilter;
import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.StoreSearchTable;
import ch.icit.pegasus.client.gui.utils.tables.SupplierTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.GenericReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.MatDispoSupplierAndStoreTemplateComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.MatDispoConfiguration;
import ch.icit.pegasus.server.core.dtos.report.MatDispoParameters;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.MatDispo2Access;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;

public class MatDispoModule<T extends IDTO>
extends TitledScreenInsert<T>
implements Module,
SubModuleProvider,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private static boolean isNoPro;
    private TitledItem<SearchTextField> numberSearch;
    private TitledItem<SearchComboBox> customerSearch;
    private TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>> haulPanel;
    private MultiHaulTypeSelectionComboBox haulCombo;
    private TitledDateTimePeriodChooser periodEditor;
    private TextButton search;
    private TextButton clearAll;
    private TitledItem<CheckBox> excludeCancelledFlights;
    protected TablePanelAddSaveButton export;
    protected LoadingAnimation animation;
    private MatDispoModuleDataHandler handler = new MatDispoModuleDataHandler();
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> groupByCustomer;
    private TitledItem<CheckBox> includeActualStock;
    private TitledItem<CheckBox> includeMaterialCosts;
    private TitledItem<ComboBox> matDispoType;
    private TitledItem<ComboBox> filterBonded;
    private TitledItem<CheckBox> includeForecastSheet;
    private TitledItem<CheckBox> excludePurchaseWaste;
    private TitledItem<CheckBox> generateArticleBarcodes;
    private SupplierTable supplierTable;
    private StoreSearchTable storeSearchTable;
    private TitledItem<ComboBox> templateCombo;
    private TitledItem<CheckBox> includeSPMLMeals;
    private TitledItem<CheckBox> includeRegularMeals;
    private TitledItem<CheckBox> includeReserve;
    private MatDispoDepartmentFilter departmentFilter;
    private boolean showMaterialCosts = false;
    private boolean accessReserve = false;
    private Table2 table;

    public MatDispoModule() {
        this.handler.loadMasterData(0L, null, null);
        RDProvider rdp = new RDProvider(HUDToolkit.getCurrentAccessRight(MatDispo2Access.MODULE_MATERIAL_DISPOSITION2, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false);
        this.showMaterialCosts = rdp.isWritable("printMaterialCosts");
        this.accessReserve = rdp.isWritable(MatDispo2Access.INCLUDE_RESERVE);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)settings);
        this.numberSearch = new TitledItem<SearchTextField>(new SearchTextField(), "Flight NO", TitledItem.TitledItemOrientation.NORTH);
        this.customerSearch = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCustomerSearchField(true), "Customer", TitledItem.TitledItemOrientation.NORTH);
        if (!isNoPro) {
            this.haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
            this.haulPanel = new TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>>(new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(this.haulCombo), Words.HAUL_TYPE, TitledItem.TitledItemOrientation.NORTH);
            this.haulCombo.setEnabled(false);
        }
        long aMonth = 2592000000L;
        Timestamp refDate = new Timestamp(System.currentTimeMillis());
        Timestamp startDate = DateUtil.getTimestamp((int)DateUtil.getYear((Date)refDate), (int)DateUtil.getMonthOfYear((Date)refDate), (int)DateUtil.getDayOfMonth((Date)refDate), (int)0, (int)1, (int)0);
        refDate = new Timestamp(System.currentTimeMillis() + aMonth);
        Timestamp endDate = DateUtil.getTimestamp((int)DateUtil.getYear((Date)refDate), (int)DateUtil.getMonthOfYear((Date)refDate), (int)DateUtil.getDayOfMonth((Date)refDate), (int)23, (int)59, (int)59);
        TimestampPeriodComplete p = new TimestampPeriodComplete(startDate, endDate);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.periodEditor = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)n);
        this.search = new TextButton("Add");
        this.clearAll = new TextButton("Clear All");
        if (!isNoPro) {
            this.excludeCancelledFlights = new TitledItem<CheckBox>(new CheckBox(), Words.EXCLUDE_CANCELED_FLIGHTS, TitledItem.TitledItemOrientation.EAST);
            this.excludeCancelledFlights.getElement().setChecked(true);
            this.departmentFilter = new MatDispoDepartmentFilter();
        }
        this.table = new Table2(false, "", true, true);
        this.table.setTitleText(Words.FLIGHTS);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FLIGHT_NUMBER, null, null, null, "", 80, 80, 80));
        int tw = TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.PAX_TYPE, null, null, null, "", 90, 90, 90));
        columns.add(new TableColumnInfo(Words.PAX, null, null, null, "", 30, 30, 30));
        tw = 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model, Table2RowPanel.TableControlsType.ONE)));
        this.table.getModel().setNode((Node)new ViewNode("flights"));
        this.search.addButtonListener(this);
        this.clearAll.addButtonListener(this);
        this.export = new TablePanelAddSaveButton("Export");
        this.export.addButtonListener(this);
        if (!isNoPro) {
            this.groupByCustomer = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)INodeCreator.getDefaultImpl().getNode4DTO((Object)false, false, false)), "Group by Customer", TitledItem.TitledItemOrientation.EAST);
            this.includeActualStock = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)INodeCreator.getDefaultImpl().getNode4DTO((Object)false, false, false)), "Include Actual Stock", TitledItem.TitledItemOrientation.EAST);
            this.includeMaterialCosts = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)INodeCreator.getDefaultImpl().getNode4DTO((Object)false, false, false)), "Include Material Costs", TitledItem.TitledItemOrientation.EAST);
            this.includeForecastSheet = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)INodeCreator.getDefaultImpl().getNode4DTO((Object)false, false, false)), "Include Forecast Sheet", TitledItem.TitledItemOrientation.EAST);
            this.excludePurchaseWaste = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)INodeCreator.getDefaultImpl().getNode4DTO((Object)false, false, false)), "Exclude Purchase Waste", TitledItem.TitledItemOrientation.EAST);
            this.generateArticleBarcodes = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)INodeCreator.getDefaultImpl().getNode4DTO((Object)false, false, false)), "Generate Barcodes for Article", TitledItem.TitledItemOrientation.EAST);
            ComboBox combo = new ComboBox();
            combo.addItem(Words.ARTICLE_FROM_PRODUCTS_ONLY);
            combo.addItem(Words.ARTICLE_FROM_STOWING_ONLY);
            combo.addItem(Words.ALL_ARTICLES);
            combo.setSelectedItem(Words.ARTICLE_FROM_PRODUCTS_ONLY);
            ComboBox bondedCombo = new ComboBox();
            bondedCombo.setViewConverter(ConverterRegistry.getConverter(BondedStateEConverter.class));
            StaticEnumServiceManager.getAllBondedStates();
            bondedCombo.setPossibleValues(NodeToolkit.getAffixList(BondedStateE.class));
            this.filterBonded = new TitledItem<ComboBox>(bondedCombo, Words.BONDED, TitledItem.TitledItemOrientation.WEST);
            this.matDispoType = new TitledItem<ComboBox>(combo, "Calculation Type", TitledItem.TitledItemOrientation.WEST);
            this.matDispoType.setIgnorePrefWidth(true);
        }
        Node dd = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(dd), Words.DUE_DATE + " (to calculate sum)", TitledItem.TitledItemOrientation.WEST);
        this.dueDate.setIgnorePrefWidth(true);
        this.dueDate.getElement().setIsTimestamp(true);
        if (this.showSupplierAndStoreSelection()) {
            this.supplierTable = new SupplierTable(true, true, Words.SUPPLIERS);
            this.storeSearchTable = new StoreSearchTable(true, true, Words.STORES);
            this.templateCombo = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(MatDispoSupplierAndStoreTemplateComplete.class), ConverterRegistry.getConverter(MatDispoSupplierAndStoreTemplateConverter.class), true), Words.TEMPLATE, TitledItem.TitledItemOrientation.WEST);
            this.templateCombo.getElement().addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    if (this.templateCombo.getElement().getSelectedItem() instanceof Node) {
                        Node rt = (Node)this.templateCombo.getElement().getSelectedItem();
                        this.supplierTable.setNode((Node<List<SupplierLight>>)INodeCreator.getDefaultImpl().createNodes(((MatDispoSupplierAndStoreTemplateComplete)rt.getValue()).getSuppliers(), false));
                        this.storeSearchTable.setNode((Node<List<StoreLight>>)INodeCreator.getDefaultImpl().createNodes(((MatDispoSupplierAndStoreTemplateComplete)rt.getValue()).getStores(), false));
                    } else {
                        this.supplierTable.setNode((Node<List<SupplierLight>>)new ListNode());
                        this.storeSearchTable.setNode((Node<List<StoreLight>>)new ListNode());
                    }
                }
            });
            this.supplierTable.setNode((Node<List<SupplierLight>>)new Node());
            this.storeSearchTable.setNode((Node<List<StoreLight>>)new Node());
            this.templateCombo.setIgnorePrefWidth(true);
        }
        if (!isNoPro) {
            this.includeSPMLMeals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SPML_MEALS, TitledItem.TitledItemOrientation.EAST);
            this.includeRegularMeals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_REGULAR_MEALS, TitledItem.TitledItemOrientation.EAST);
            this.includeReserve = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_RESERVE, TitledItem.TitledItemOrientation.EAST);
            this.includeSPMLMeals.getElement().setChecked(true);
            this.includeRegularMeals.getElement().setChecked(true);
            this.includeReserve.getElement().setChecked(false);
        }
        this.setLayout(new Layout());
        this.ensureAnimation();
        if (this.showSupplierAndStoreSelection()) {
            this.add(this.supplierTable);
            this.add(this.storeSearchTable);
            this.add(this.templateCombo);
        }
        if (!isNoPro) {
            this.add(this.includeSPMLMeals);
            this.add(this.includeRegularMeals);
            this.add(this.includeReserve);
            this.add(this.haulPanel);
            this.add(this.excludeCancelledFlights);
            this.add(this.filterBonded);
            this.add(this.groupByCustomer);
            this.add(this.includeActualStock);
            this.add(this.includeMaterialCosts);
            this.add(this.matDispoType);
            this.add(this.includeForecastSheet);
            this.add(this.excludePurchaseWaste);
            this.add(this.generateArticleBarcodes);
            this.add(this.departmentFilter);
        }
        this.add(this.numberSearch);
        this.add(this.customerSearch);
        this.add(this.periodEditor);
        this.add(this.search);
        this.add(this.clearAll);
        this.add(this.table);
        this.add(this.dueDate);
        this.add(this.export);
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                MatDispoModule.this.handler.loadMasterData(0L, null, null);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return MatDispoModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private boolean showSupplierAndStoreSelection() {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        return settings.getMatDispoSettings() != null && Boolean.TRUE.equals(settings.getMatDispoSettings().getShowMatDispoSupplierAndStoreSelection());
    }

    private void ensureAnimation() {
        this.ensureAnimation("Load");
    }

    private void ensureAnimation(String string) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(string);
            this.animation.fadeIn();
            this.animation.start();
            this.add((Component)this.animation, 0);
        } else {
            this.animation.stateChanged(string);
        }
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.kill();
            this.animation = null;
        }
    }

    public void showAnimation(boolean b) {
        if (b) {
            this.setEnabled(false);
            this.ensureAnimation();
            this.validate();
        } else {
            this.setEnabled(true);
            this.hideAnimation();
        }
    }

    public void undo() {
    }

    public void redo() {
    }

    @Override
    public String getOverriddenModuleRights() {
        return null;
    }

    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel model) {
        return true;
    }

    public boolean isDeletable(RowModel model) {
        return false;
    }

    public boolean isRestorable(RowModel model) {
        return false;
    }

    @Override
    public String getScreenTitle() {
        return MatDispo2Access.MODULE_MATERIAL_DISPOSITION2.getDisplayName();
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    public List<FlightLight> getFlightList() {
        ArrayList<FlightLight> flights = new ArrayList<FlightLight>();
        Iterator it = this.table.getModel().getNode().getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            FlightLight l = (FlightLight)n.getValue(FlightLight.class);
            flights.add(l);
        }
        return flights;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.numberSearch.setEnabled(isEnabled);
        this.customerSearch.setEnabled(isEnabled);
        this.periodEditor.setEnabled(isEnabled);
        this.search.setEnabled(isEnabled);
        this.clearAll.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.export.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
        if (!isNoPro) {
            this.excludeCancelledFlights.setEnabled(isEnabled);
            this.haulPanel.setEnabled(isEnabled);
            this.groupByCustomer.setEnabled(isEnabled);
            this.includeActualStock.setEnabled(isEnabled);
            this.includeMaterialCosts.setEnabled(isEnabled && this.showMaterialCosts);
            this.matDispoType.setEnabled(isEnabled);
            this.filterBonded.setEnabled(isEnabled);
            this.includeForecastSheet.setEnabled(isEnabled);
            this.excludePurchaseWaste.setEnabled(isEnabled);
            this.generateArticleBarcodes.setEnabled(isEnabled);
            this.departmentFilter.setEnabled(isEnabled);
            this.includeRegularMeals.setEnabled(isEnabled);
            this.includeReserve.setEnabled(isEnabled && this.accessReserve);
            this.includeSPMLMeals.setEnabled(isEnabled);
        }
        if (this.showSupplierAndStoreSelection()) {
            this.supplierTable.setEnabled(isEnabled);
            this.storeSearchTable.setEnabled(isEnabled);
            this.templateCombo.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.numberSearch.kill();
        this.numberSearch = null;
        this.customerSearch.kill();
        this.customerSearch = null;
        this.periodEditor.kill();
        this.periodEditor = null;
        this.search.kill();
        this.search = null;
        if (!isNoPro) {
            this.excludeCancelledFlights.kill();
            this.excludeCancelledFlights = null;
            this.includeRegularMeals.kill();
            this.includeSPMLMeals.kill();
            this.includeReserve.kill();
            this.includeRegularMeals = null;
            this.includeSPMLMeals = null;
            this.includeReserve = null;
            this.supplierTable = null;
            this.storeSearchTable = null;
            this.templateCombo = null;
            this.groupByCustomer.kill();
            this.groupByCustomer = null;
            this.includeActualStock.kill();
            this.includeActualStock = null;
            this.includeMaterialCosts.kill();
            this.includeMaterialCosts = null;
            this.matDispoType.kill();
            this.matDispoType = null;
            this.filterBonded.kill();
            this.filterBonded = null;
            this.departmentFilter.kill();
            this.departmentFilter = null;
            this.includeForecastSheet.kill();
            this.includeForecastSheet = null;
            this.excludePurchaseWaste.kill();
            this.excludePurchaseWaste = null;
            this.generateArticleBarcodes.kill();
            this.generateArticleBarcodes = null;
        }
        if (this.haulPanel != null) {
            this.haulPanel.kill();
            this.haulPanel = null;
        }
        if (this.showSupplierAndStoreSelection()) {
            if (this.supplierTable != null) {
                this.supplierTable.kill();
            }
            if (this.storeSearchTable != null) {
                this.storeSearchTable.kill();
            }
            if (this.templateCombo != null) {
                this.templateCombo.kill();
            }
        }
        this.clearAll.kill();
        this.clearAll = null;
        this.export.kill();
        this.export = null;
        this.table.kill();
        this.table = null;
        this.dueDate.kill();
        this.dueDate = null;
    }

    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.numberSearch);
        CheckedListAdder.addToList(focusList, this.customerSearch);
        CheckedListAdder.addToList(focusList, this.periodEditor);
        CheckedListAdder.addToList(focusList, this.haulPanel);
        CheckedListAdder.addToList(focusList, this.excludeCancelledFlights);
        CheckedListAdder.addToList(focusList, this.search);
        CheckedListAdder.addToList(focusList, this.clearAll);
        CheckedListAdder.addToList(focusList, this.table);
        CheckedListAdder.addToList(focusList, this.dueDate);
        CheckedListAdder.addToList(focusList, this.groupByCustomer);
        CheckedListAdder.addToList(focusList, this.includeActualStock);
        CheckedListAdder.addToList(focusList, this.includeMaterialCosts);
        CheckedListAdder.addToList(focusList, this.matDispoType);
        CheckedListAdder.addToList(focusList, this.filterBonded);
        CheckedListAdder.addToList(focusList, this.includeForecastSheet);
        CheckedListAdder.addToList(focusList, this.excludePurchaseWaste);
        CheckedListAdder.addToList(focusList, this.generateArticleBarcodes);
        CheckedListAdder.addToList(focusList, this.includeRegularMeals);
        CheckedListAdder.addToList(focusList, this.includeSPMLMeals);
        CheckedListAdder.addToList(focusList, this.includeReserve);
        if (this.showSupplierAndStoreSelection()) {
            CheckedListAdder.addToList(this.getFocusComponents(), this.supplierTable);
            CheckedListAdder.addToList(this.getFocusComponents(), this.storeSearchTable);
            CheckedListAdder.addToList(this.getFocusComponents(), this.templateCombo);
        }
        CheckedListAdder.addToList(focusList, this.departmentFilter);
        return focusList;
    }

    private boolean containsFlight(FlightLight l) {
        for (Table2RowPanel p : this.table.getRows()) {
            if (!p.getModel().getNode().getValue().equals(l)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.hideAnimation();
        if (this.departmentFilter != null) {
            this.departmentFilter.setNode(node);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.clearAll) {
            this.table.getModel().getNode().removeAllChilds();
            this.table.getModel().setNode((Node)new ViewNode("flights"));
        } else if (source == this.export) {
            this.showAnimation(true);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    MatDispoConfiguration config = new MatDispoConfiguration();
                    for (FlightLight flightLight : MatDispoModule.this.getFlightList()) {
                        config.getReferences().add(new FlightReference(flightLight.getId()));
                    }
                    config.setCallerID(UUID.randomUUID().toString());
                    BondedStateE bondedState = BondedStateE.ALL;
                    if (MatDispoModule.this.filterBonded != null) {
                        if (((ComboBox)MatDispoModule.this.filterBonded.getElement()).getSelectedItem() instanceof BondedStateE) {
                            bondedState = (BondedStateE)((ComboBox)MatDispoModule.this.filterBonded.getElement()).getSelectedItem();
                        } else if (((ComboBox)MatDispoModule.this.filterBonded.getElement()).getSelectedItem() instanceof Node) {
                            bondedState = (BondedStateE)((Node)((ComboBox)MatDispoModule.this.filterBonded.getElement()).getSelectedItem()).getValue();
                        }
                    }
                    if (bondedState == null) {
                        bondedState = BondedStateE.ALL;
                    }
                    config.setBondedState(bondedState);
                    MatDispoParameters parameters = new MatDispoParameters();
                    parameters.setProductDueDate((Timestamp)((DateChooser)MatDispoModule.this.dueDate.getElement()).getNode().getValue());
                    if (isNoPro) {
                        parameters.setGroupByCustomer(Boolean.valueOf(true));
                        parameters.setIncludeMaterialCosts(Boolean.valueOf(false));
                        parameters.setIncludeForecastSheet(Boolean.valueOf(false));
                        parameters.setExcludePurchaseWaste(Boolean.valueOf(false));
                        parameters.setIncludeRegularMeals(Boolean.valueOf(true));
                        parameters.setIncludeReserve(Boolean.valueOf(false));
                        parameters.setIncludeSPMLMeals(Boolean.valueOf(false));
                        parameters.setGenerateBarcodesForArticles(Boolean.valueOf(false));
                        parameters.setMatDispoType(MatDispoParameters.MatDispoType.PRODUCTS);
                        parameters.setIncludeActualStock(Boolean.valueOf(true));
                    } else {
                        parameters.setGroupByCustomer((Boolean)((CheckBox)MatDispoModule.this.groupByCustomer.getElement()).getNode().getValue());
                        parameters.setIncludeMaterialCosts((Boolean)((CheckBox)MatDispoModule.this.includeMaterialCosts.getElement()).getNode().getValue());
                        parameters.setIncludeForecastSheet((Boolean)((CheckBox)MatDispoModule.this.includeForecastSheet.getElement()).getNode().getValue());
                        parameters.setExcludePurchaseWaste((Boolean)((CheckBox)MatDispoModule.this.excludePurchaseWaste.getElement()).getNode().getValue());
                        parameters.setIncludeRegularMeals(Boolean.valueOf(((CheckBox)MatDispoModule.this.includeRegularMeals.getElement()).isChecked()));
                        parameters.setIncludeReserve(Boolean.valueOf(((CheckBox)MatDispoModule.this.includeReserve.getElement()).isChecked()));
                        parameters.setIncludeSPMLMeals(Boolean.valueOf(((CheckBox)MatDispoModule.this.includeSPMLMeals.getElement()).isChecked()));
                        parameters.setGenerateBarcodesForArticles((Boolean)((CheckBox)MatDispoModule.this.generateArticleBarcodes.getElement()).getNode().getValue());
                        if (((ComboBox)MatDispoModule.this.matDispoType.getElement()).getSelectedItem().equals(Words.ALL_ARTICLES)) {
                            parameters.setMatDispoType(MatDispoParameters.MatDispoType.STOWINGLIST_AND_PRODUCTS);
                        } else if (((ComboBox)MatDispoModule.this.matDispoType.getElement()).getSelectedItem().equals(Words.ARTICLE_FROM_PRODUCTS_ONLY)) {
                            parameters.setMatDispoType(MatDispoParameters.MatDispoType.PRODUCTS);
                        } else if (((ComboBox)MatDispoModule.this.matDispoType.getElement()).getSelectedItem().equals(Words.ARTICLE_FROM_STOWING_ONLY)) {
                            parameters.setMatDispoType(MatDispoParameters.MatDispoType.STOWINGLIST_WITHOUT_PRODUCTS);
                        }
                        parameters.setIncludeActualStock((Boolean)((CheckBox)MatDispoModule.this.includeActualStock.getElement()).getNode().getValue());
                    }
                    config.setParameterObject(parameters);
                    if (MatDispoModule.this.supplierTable != null && MatDispoModule.this.supplierTable.getNode() != null) {
                        Iterator it = MatDispoModule.this.supplierTable.getNode().getFailSafeChildIterator();
                        while (it.hasNext()) {
                            Node supplier = (Node)it.next();
                            config.getSuppliers().add(supplier.getValue());
                        }
                    }
                    if (MatDispoModule.this.storeSearchTable != null && MatDispoModule.this.storeSearchTable.getNode() != null) {
                        Iterator it2 = MatDispoModule.this.storeSearchTable.getNode().getFailSafeChildIterator();
                        while (it2.hasNext()) {
                            Node store = (Node)it2.next();
                            config.getStores().add(store.getValue());
                        }
                    }
                    if (!isNoPro) {
                        config.setDepartments(MatDispoModule.this.departmentFilter.getDepartments());
                        config.setFilterProducts(MatDispoModule.this.departmentFilter.getFilterProduct());
                        config.setFilterGroups(MatDispoModule.this.departmentFilter.getFilterProductGroup());
                        config.setFilterComponent(MatDispoModule.this.departmentFilter.getFilterProductComponent());
                        config.setFilterStowingListArticles(MatDispoModule.this.departmentFilter.getFilterStowingListArticle());
                    }
                    config.setValidityDate(new Timestamp(System.currentTimeMillis()));
                    Future result = ((GenericReportServiceManager)ServiceManagerRegistry.getService(GenericReportServiceManager.class)).createMatDispoFromConfig(config, config.getCallerID());
                    while (!result.isDone()) {
                        Thread.sleep(2000L);
                        Tuple progressTuple = ((GenericReportServiceManager)ServiceManagerRegistry.getService(GenericReportServiceManager.class)).getProgressTuple(config.getCallerID());
                        if (progressTuple == null || (Long)progressTuple.getS() == 0L) continue;
                        MatDispoModule.this.ensureAnimation("Processing data set " + progressTuple.getS() + " of " + progressTuple.getT());
                    }
                    PegasusFileComplete p = (PegasusFileComplete)result.get();
                    ViewNode n = new ViewNode("");
                    n.setValue((Object)p, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            PegasusFileComplete p = (PegasusFileComplete)node.getValue();
                            InnerPopupFactory.showFileDownloadPopup(node, MatDispoModule.this, MatDispoModule.this, true);
                        }

                        public void errorOccurred(ClientException exception) {
                            ClientException e = exception;
                            if (exception.getCause() != null && exception.getCause().getMessage().startsWith("EJBCLIENT000400") && exception.getCause().getCause() != null) {
                                e = new ClientException(exception.getCause().getCause().getMessage(), null);
                            }
                            MatDispoModule.this.errorOccurred(e);
                            MatDispoModule.this.showAnimation(false);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.search) {
            this.showAnimation(true);
            final FlightSearchConfiguration c = new FlightSearchConfiguration();
            if (this.haulPanel != null && this.haulPanel.getElement().isActivated()) {
                Object[] oo = this.haulPanel.getElement().getSelectedObjects();
                ArrayList<HaulTypeComplete> haulType = new ArrayList<HaulTypeComplete>();
                if (oo != null) {
                    for (Object o : this.haulPanel.getElement().getSelectedObjects()) {
                        haulType.add((HaulTypeComplete)o);
                    }
                }
                c.setHaulTypeList(haulType);
                c.setShowNullHaulTypes(Boolean.valueOf(true));
            }
            c.setCustomer((CustomerLight)this.customerSearch.getElement().getNode().getValue());
            c.setFlightNumber(this.numberSearch.getElement().getText());
            TimestampPeriodComplete stamp = this.periodEditor.getTimePeriod();
            c.setDayTimePeriod(stamp);
            c.setFlightStdSta(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)c);
                    ViewNode n = new ViewNode("");
                    ArrayList<FlightLight> r = new ArrayList<FlightLight>();
                    for (FlightLight f : sri) {
                        if (MatDispoModule.this.excludeCancelledFlights != null && ((CheckBox)MatDispoModule.this.excludeCancelledFlights.getElement()).isChecked()) {
                            if (f.getFlightState() == FlightStateE.CANCELLED) continue;
                            r.add(f);
                            continue;
                        }
                        r.add(f);
                    }
                    n.setValue(r, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            List r = (List)node.getValue();
                            if (r.isEmpty()) {
                                InnerPopupFactory.showErrorDialog("No Flight found for this configuration", "No Flight found", (Component)MatDispoModule.this.search);
                            } else {
                                TimestampPeriodComplete stamp2 = MatDispoModule.this.periodEditor.getTimePeriod();
                                for (FlightLight f : r) {
                                    if (f.getFlightState() == FlightStateE.PLANNED || MatDispoModule.this.containsFlight(f) || f.getStd().getTime() < stamp2.getStartTime().getTime() || f.getStd().getTime() > stamp2.getEndTime().getTime()) continue;
                                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, false);
                                    MatDispoModule.this.table.getModel().getNode().addChild(n, 0L);
                                }
                                MatDispoModule.this.revalidate();
                            }
                            MatDispoModule.this.showAnimation(false);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)MatDispoModule.this.search);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            super.buttonPressed(source, x, y);
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        this.showAnimation(false);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel flightNo;
        private TextLabel flightDate;
        private TextLabel paxType;
        private TextLabel paxFigures;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m, Table2RowPanel.TableControlsType controlSkin) {
            super(m);
            this.setUseControlSkin(controlSkin);
            this.flightNo = new TextLabel(m.getNode().getChildNamed(new String[]{"outboundCode"}), ConverterRegistry.getConverter(StringConverter.class));
            this.flightDate = new TextLabel(m.getNode().getChildNamed(new String[]{"std"}), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.paxType = new TextLabel(m.getNode().getChildNamed(FlightLight_.selectedPaxType), ConverterRegistry.getConverter(PaxFigureTypeConverter.class));
            this.paxFigures = new TextLabel(m.getNode().getChildNamed(new String[]{"legs"}), ConverterRegistry.getConverter(PaxFigureStringConverter.class));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.flightDate);
            this.add(this.flightNo);
            this.add(this.paxType);
            this.add(this.paxFigures);
            this.add(this.delete);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.flightDate.kill();
            this.flightNo.kill();
            this.paxFigures.kill();
            this.delete.kill();
            this.paxType.kill();
            this.flightDate = null;
            this.flightNo = null;
            this.paxFigures = null;
            this.delete = null;
            this.paxType = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.delete.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"outboundCode"}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new String[]{"std"}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(FlightLight_.selectedPaxType).getValue();
                }
                case 3: {
                    return this.paxFigures.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.flightDate.setEnabled(isEnabled);
            this.flightNo.setEnabled(isEnabled);
            this.paxFigures.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
            this.paxType.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.delete == source) {
                MatDispoModule.this.table.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.flightNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.flightDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.paxType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.paxType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.paxType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.paxFigures.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.paxFigures.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxFigures.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.paxFigures.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int departmentPanelWidth = 300;
            int supplierPanelWidth = 300;
            int y = MatDispoModule.this.layoutTitle(parent);
            MatDispoModule.this.numberSearch.setLocation(2, y + 10);
            MatDispoModule.this.numberSearch.setSize(150, (int)MatDispoModule.this.numberSearch.getPreferredSize().getHeight());
            MatDispoModule.this.customerSearch.setLocation(MatDispoModule.this.numberSearch.getX() + MatDispoModule.this.numberSearch.getWidth() + 10, MatDispoModule.this.numberSearch.getY());
            MatDispoModule.this.customerSearch.setSize(150, (int)MatDispoModule.this.customerSearch.getPreferredSize().getHeight());
            MatDispoModule.this.periodEditor.setLocation(MatDispoModule.this.customerSearch.getX() + MatDispoModule.this.customerSearch.getWidth() + 15, MatDispoModule.this.numberSearch.getY());
            MatDispoModule.this.periodEditor.setSize(MatDispoModule.this.periodEditor.getPreferredSize());
            if (!isNoPro) {
                MatDispoModule.this.haulPanel.setLocation(MatDispoModule.this.periodEditor.getX() + MatDispoModule.this.periodEditor.getWidth() + 15, MatDispoModule.this.numberSearch.getY());
                MatDispoModule.this.haulPanel.setSize((int)MatDispoModule.this.haulPanel.getPreferredSize().getWidth(), (int)MatDispoModule.this.haulPanel.getPreferredSize().getHeight());
                MatDispoModule.this.excludeCancelledFlights.setLocation(MatDispoModule.this.haulPanel.getX() + MatDispoModule.this.haulPanel.getWidth() + 15, MatDispoModule.this.numberSearch.getY() + 24);
                MatDispoModule.this.excludeCancelledFlights.setSize(MatDispoModule.this.excludeCancelledFlights.getPreferredSize());
            }
            MatDispoModule.this.search.setLocation(2, MatDispoModule.this.periodEditor.getY() + MatDispoModule.this.periodEditor.getHeight() + 10);
            MatDispoModule.this.search.setSize(MatDispoModule.this.search.getPreferredSize());
            MatDispoModule.this.clearAll.setLocation(MatDispoModule.this.search.getX() + MatDispoModule.this.search.getWidth() + 10, MatDispoModule.this.search.getY());
            MatDispoModule.this.clearAll.setSize(MatDispoModule.this.clearAll.getPreferredSize());
            MatDispoModule.this.table.setLocation(2, MatDispoModule.this.search.getY() + MatDispoModule.this.search.getHeight() + 10);
            int cy = 0;
            if (MatDispoModule.this.showSupplierAndStoreSelection()) {
                MatDispoModule.this.table.setSize(parent.getWidth() - (20 + departmentPanelWidth + 10 + supplierPanelWidth), parent.getHeight() - (MatDispoModule.this.table.getY() + 70));
                MatDispoModule.this.templateCombo.setLocation(MatDispoModule.this.table.getX() + MatDispoModule.this.table.getWidth() + 10, MatDispoModule.this.table.getY());
                MatDispoModule.this.templateCombo.setSize(295, (int)MatDispoModule.this.templateCombo.getPreferredSize().getHeight());
                MatDispoModule.this.supplierTable.setLocation(MatDispoModule.this.table.getX() + MatDispoModule.this.table.getWidth() + 5, MatDispoModule.this.templateCombo.getY() + MatDispoModule.this.templateCombo.getHeight() + 3);
                MatDispoModule.this.supplierTable.setSize(supplierPanelWidth, MatDispoModule.this.table.getHeight() / 2 - 15);
                MatDispoModule.this.storeSearchTable.setLocation(MatDispoModule.this.table.getX() + MatDispoModule.this.table.getWidth() + 5, MatDispoModule.this.supplierTable.getY() + MatDispoModule.this.supplierTable.getHeight() + 5);
                MatDispoModule.this.storeSearchTable.setSize(supplierPanelWidth, MatDispoModule.this.supplierTable.getHeight());
                cy = MatDispoModule.this.storeSearchTable.getX() + MatDispoModule.this.storeSearchTable.getWidth() + 5;
            } else {
                MatDispoModule.this.table.setSize(parent.getWidth() - 20, parent.getHeight() - (MatDispoModule.this.table.getY() + 70));
                cy = MatDispoModule.this.table.getX() + MatDispoModule.this.table.getWidth() + 5;
            }
            MatDispoModule.this.dueDate.setLocation(2, MatDispoModule.this.table.getY() + MatDispoModule.this.table.getHeight() + 10);
            MatDispoModule.this.dueDate.setSize(MatDispoModule.this.dueDate.getPreferredSize());
            if (!isNoPro) {
                MatDispoModule.this.departmentFilter.setLocation(cy, MatDispoModule.this.table.getY());
                MatDispoModule.this.departmentFilter.setSize(departmentPanelWidth, MatDispoModule.this.table.getHeight());
                MatDispoModule.this.matDispoType.setLocation(2, MatDispoModule.this.dueDate.getY() + MatDispoModule.this.dueDate.getHeight() + 10);
                MatDispoModule.this.matDispoType.setSize(320, (int)MatDispoModule.this.matDispoType.getPreferredSize().getHeight());
                MatDispoModule.this.groupByCustomer.setLocation(350, MatDispoModule.this.table.getY() + MatDispoModule.this.table.getHeight() + 11);
                MatDispoModule.this.groupByCustomer.setSize(MatDispoModule.this.groupByCustomer.getPreferredSize());
                MatDispoModule.this.includeActualStock.setLocation(350, MatDispoModule.this.groupByCustomer.getY() + MatDispoModule.this.groupByCustomer.getHeight());
                MatDispoModule.this.includeActualStock.setSize(MatDispoModule.this.includeActualStock.getPreferredSize());
                MatDispoModule.this.includeMaterialCosts.setLocation(350, MatDispoModule.this.includeActualStock.getY() + MatDispoModule.this.includeActualStock.getHeight());
                MatDispoModule.this.includeMaterialCosts.setSize(MatDispoModule.this.includeMaterialCosts.getPreferredSize());
                MatDispoModule.this.filterBonded.setLocation(520, MatDispoModule.this.table.getY() + MatDispoModule.this.table.getHeight() + 10);
                MatDispoModule.this.filterBonded.setSize(130, (int)MatDispoModule.this.filterBonded.getPreferredSize().getHeight());
                MatDispoModule.this.includeForecastSheet.setLocation(660, MatDispoModule.this.table.getY() + MatDispoModule.this.table.getHeight() + 10);
                MatDispoModule.this.includeForecastSheet.setSize((int)MatDispoModule.this.includeForecastSheet.getPreferredSize().getWidth(), (int)MatDispoModule.this.includeForecastSheet.getPreferredSize().getHeight());
                MatDispoModule.this.excludePurchaseWaste.setLocation(660, MatDispoModule.this.includeForecastSheet.getY() + MatDispoModule.this.includeForecastSheet.getHeight());
                MatDispoModule.this.excludePurchaseWaste.setSize((int)MatDispoModule.this.excludePurchaseWaste.getPreferredSize().getWidth(), (int)MatDispoModule.this.excludePurchaseWaste.getPreferredSize().getHeight());
                MatDispoModule.this.generateArticleBarcodes.setLocation(660, MatDispoModule.this.excludePurchaseWaste.getY() + MatDispoModule.this.excludePurchaseWaste.getHeight());
                MatDispoModule.this.generateArticleBarcodes.setSize((int)MatDispoModule.this.generateArticleBarcodes.getPreferredSize().getWidth(), (int)MatDispoModule.this.generateArticleBarcodes.getPreferredSize().getHeight());
                MatDispoModule.this.includeRegularMeals.setLocation(MatDispoModule.this.excludePurchaseWaste.getX() + MatDispoModule.this.excludePurchaseWaste.getWidth() + 10, MatDispoModule.this.includeForecastSheet.getY());
                MatDispoModule.this.includeRegularMeals.setSize(MatDispoModule.this.includeRegularMeals.getPreferredSize());
                MatDispoModule.this.includeSPMLMeals.setLocation(MatDispoModule.this.includeRegularMeals.getX(), MatDispoModule.this.includeRegularMeals.getY() + MatDispoModule.this.includeRegularMeals.getHeight());
                MatDispoModule.this.includeSPMLMeals.setSize(MatDispoModule.this.includeSPMLMeals.getPreferredSize());
                MatDispoModule.this.includeReserve.setLocation(MatDispoModule.this.includeRegularMeals.getX() + MatDispoModule.this.includeRegularMeals.getWidth() + 10, MatDispoModule.this.includeForecastSheet.getY());
                MatDispoModule.this.includeReserve.setSize(MatDispoModule.this.includeReserve.getPreferredSize());
            }
            MatDispoModule.this.export.setLocation(parent.getWidth() - MatDispoModule.this.export.getPreferredSize().width - 10, parent.getHeight() - MatDispoModule.this.export.getPreferredSize().height - 10);
            MatDispoModule.this.export.setSize(MatDispoModule.this.export.getPreferredSize());
            if (MatDispoModule.this.animation != null) {
                MatDispoModule.this.animation.setLocation((int)(((double)parent.getWidth() - MatDispoModule.this.animation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - MatDispoModule.this.animation.getPreferredSize().getHeight()) / 2);
                MatDispoModule.this.animation.setSize(MatDispoModule.this.animation.getPreferredSize());
            }
        }
    }
}

