/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.mealplan;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.MealPlanConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxMealTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class MealPlanModuleDataHandler
extends DefaultDataHandler<MealPlanLight, MealPlanComplete> {
    public MealPlanModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<MealPlanLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(MealPlanComplete.class);
                MealPlanComplete cat = (MealPlanComplete)node.getValue(MealPlanComplete.class);
                for (MealPlanConfigurationComplete conf : cat.getMealplanConfigs()) {
                    ArrayList<ALegComplete> legs2Remove = new ArrayList<ALegComplete>();
                    for (ALegComplete l : conf.getLegMapping().keySet()) {
                        if (cat.getLegs().contains(l)) continue;
                        legs2Remove.add(l);
                    }
                    for (ALegComplete l : legs2Remove) {
                        conf.getLegMapping().remove(l);
                    }
                }
                MealPlanComplete nCat = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).updateMealPlan(cat).getValue();
                if (nCat != null) {
                    node.removeExistingValues();
                    node.setValue((Object)nCat, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<MealPlanComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(ProductCatalogComplete.class);
                MealPlanComplete cat = (MealPlanComplete)node.getValue(MealPlanComplete.class);
                if (cat.getEligibleLocations().isEmpty()) {
                    cat.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                MealPlanComplete nCat = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).createMealPlan(cat).getValue();
                node.removeExistingValues();
                node.setValue((Object)nCat, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MealPlanModuleDataHandler.this.setCurrentLoadMaximum(10);
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllFlightTypes();
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AirportComplete.class);
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SpecialMenuTypeComplete.class);
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxRateComplete.class);
                MealPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PaxMealTypeComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return MealPlanModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, "Refresh Meal Plan");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node dlNode;
                MealPlanLight cat = (MealPlanLight)node.getValue(MealPlanLight.class);
                MealPlanComplete nCat = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlan(new MealPlanReference(cat.getId())).getValue();
                ArrayList referencedLegs = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getUsedLegs((MealPlanReference)cat).getList();
                if (referencedLegs == null) {
                    referencedLegs = new ArrayList();
                }
                if ((dlNode = NodeToolkit.getAffixNamed((String)"referencedLegs")) == null) {
                    dlNode = INodeCreator.getDefaultImpl().createNodes(referencedLegs, true);
                    if (dlNode == null) {
                        dlNode = new ListNode();
                    }
                    dlNode.setName("referencedLegs");
                    NodeToolkit.addAffix((Node)dlNode);
                }
                dlNode.removeExistingValues();
                dlNode.setValue(referencedLegs, 0L);
                HashSet<StowingListTemplateVariantReference> stowingListIds = new HashSet<StowingListTemplateVariantReference>();
                for (MealPlanConfigurationComplete mealplanConfig : nCat.getMealplanConfigs()) {
                    if (mealplanConfig.getStowingList() != null || mealplanConfig.getStowingListId() == null) continue;
                    stowingListIds.add(new StowingListTemplateVariantReference(mealplanConfig.getStowingListId()));
                }
                if (!stowingListIds.isEmpty()) {
                    boolean onlyActive = false;
                    ListWrapper variants = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(new ArrayList(stowingListIds)));
                    HashMap<Long, StowingListTemplateVariantLight> variantIndex = new HashMap<Long, StowingListTemplateVariantLight>();
                    for (StowingListTemplateVariantLight light : variants.getList()) {
                        variantIndex.put(light.getId(), light);
                    }
                    for (MealPlanConfigurationComplete mealplanConfig : nCat.getMealplanConfigs()) {
                        if (mealplanConfig.getStowingList() != null || mealplanConfig.getStowingListId() == null) continue;
                        mealplanConfig.setStowingList((StowingListTemplateVariantLight)variantIndex.get(mealplanConfig.getStowingListId()));
                    }
                }
                node.removeExistingValues();
                node.setValue((Object)nCat, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<MealPlanComplete> resetData(Node<MealPlanComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<MealPlanComplete> createEmptyNode() {
        MealPlanComplete cat = new MealPlanComplete();
        cat.setClientOId(Long.valueOf(ADTO.getNextId()));
        cat.setState(ModificationStateE.DRAFT);
        cat.setPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)cat, true, false);
    }

    @Override
    public Class<MealPlanComplete> getCommittingClass() {
        return MealPlanComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<MealPlanLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

