/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.mealplan.details;

import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDImageChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.MealPlanAccess;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends StateDependantDetailsPanel<MealPlanLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> no;
    private TitledItem<RDTextField> name;
    private TitledItem<RDSearchTextField2> customer;
    private TitledItem<RDComboBox> state;
    private TitledPeriodEditor periodChooser;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDTextField> reportName;
    private TitledItem<RDImageChooser> imageChooser;
    private TitledItem<RDTextArea> internalComment;
    private boolean stateChangeNow;

    public SpecificationDetailsPanel(RowEditor<MealPlanLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.no = new TitledItem<TextLabel>(new TextLabel(), Words.NO_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.no.getElement().setReadOnlyTextField(true);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.customer = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.state = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ModificationStateEConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.periodChooser = new TitledPeriodEditor(null, null, true, provider, MealPlanLight_.period);
        this.periodChooser.enableInfinity(false, true);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.reportName = new TitledItem<RDTextField>(new RDTextField(provider), Words.REPORT_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.imageChooser = new TitledItem<RDImageChooser>(new RDImageChooser(provider), Words.IMAGE, TitledItem.TitledItemOrientation.NORTH);
        this.internalComment = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.INTERNAL_COMMENT, TitledItem.TitledItemOrientation.NORTH);
        this.internalComment.setIgnorePrefHeight(true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.no);
        this.addToView(this.name);
        this.addToView(this.customer);
        this.addToView(this.state);
        this.addToView(this.periodChooser);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.internalComment);
        this.addToView(this.reportName);
        this.addToView(this.imageChooser);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return MealPlanComplete_.state;
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        return this.imageChooser.getElement().commitImage();
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable()) {
            String t = (String)this.editor.getModel().getNode().getChildNamed(MealPlanComplete_.name).getValue();
            if (t == null || t.isEmpty()) {
                this.name.getElement().setInvalid();
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
            } else {
                this.name.getElement().setValid();
            }
        }
        if (this.customer.getElement().isWritable()) {
            CustomerLight c = (CustomerLight)this.editor.getModel().getNode().getChildNamed(MealPlanComplete_.customer).getValue();
            if (c == null) {
                this.customer.getElement().setInvalid();
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.CUSTOMER_NOT_SET));
            } else {
                this.customer.getElement().setValid();
            }
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
        }
        a.addAll(ValidationUtil.validatePeriod((Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{MealPlanComplete_.period, PeriodComplete_.startDate}), (Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{MealPlanComplete_.period, PeriodComplete_.endDate}), this.periodChooser));
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean b = isDraft && isEnabled;
        boolean canRedraft = true;
        if (!isDraft) {
            canRedraft = this.stateChangeNow ? true : this.provider.isWritable(MealPlanAccess.CAN_REDRAFT);
        }
        super.setEnabled(b);
        this.no.setEnabled(b);
        this.name.setEnabled(b);
        this.customer.setEnabled(b);
        this.state.setEnabled(isEnabled && canRedraft);
        this.periodChooser.setEdit(b);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(b);
        }
        this.internalComment.setEnabled(b);
        this.reportName.setEnabled(b);
        this.imageChooser.setEnabled(isEnabled);
        this.imageChooser.getElement().enablePreviewAnyWay(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null) {
            this.node.getChildNamed(MealPlanComplete_.state).removeNodeListener((NodeListener)this);
        }
        this.no.kill();
        this.name.kill();
        this.customer.kill();
        this.state.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.periodChooser.kill();
        this.internalComment.kill();
        this.reportName.kill();
        this.imageChooser.kill();
        this.no = null;
        this.name = null;
        this.customer = null;
        this.state = null;
        this.periodChooser = null;
        this.locations = null;
        this.internalComment = null;
        this.reportName = null;
        this.imageChooser = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.reportName);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.periodChooser);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.imageChooser);
        CheckedListAdder.addToList(focusList, this.internalComment);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            MealPlanLight dto = (MealPlanLight)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        if (this.node != null) {
            this.node.getChildNamed(MealPlanComplete_.state).removeNodeListener((NodeListener)this);
        }
        this.node = node;
        if (node.getChildNamed(MealPlanComplete_.period).getValue() == null) {
            PeriodComplete p = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
            node.getChildNamed(MealPlanComplete_.period).setValue((Object)p, 0L);
        }
        this.no.getElement().setNode(node.getChildNamed(MealPlanComplete_.number));
        this.name.getElement().setNode(node.getChildNamed(MealPlanComplete_.name));
        this.customer.getElement().setNode(node.getChildNamed(MealPlanComplete_.customer));
        this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ModificationStateE.class));
        this.state.getElement().setNode(node.getChildNamed(MealPlanComplete_.state));
        this.periodChooser.setStartDateNode(node.getChildNamed(new DtoField[]{MealPlanComplete_.period, PeriodComplete_.startDate}));
        this.periodChooser.setEndDateNode(node.getChildNamed(new DtoField[]{MealPlanComplete_.period, PeriodComplete_.endDate}));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(MealPlanComplete_.eligibleLocations));
        }
        this.internalComment.getElement().setNode(node.getChildNamed(MealPlanComplete_.comment));
        this.imageChooser.getElement().setNode(node.getChildNamed(MealPlanComplete_.image));
        this.reportName.getElement().setNode(node.getChildNamed(MealPlanComplete_.reportName));
        this.node.getChildNamed(MealPlanComplete_.state).addNodeListener((NodeListener)this);
    }

    @Override
    public void valueChanged(Node<?> node) {
        this.stateChangeNow = true;
        this.editor.setEnabled(this.editor.isEnabled());
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.reportName.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.periodChooser.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.imageChooser.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h += 120;
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w3tl = (parent.getWidth() - 3 * SpecificationDetailsPanel.this.horizontalBorder) / 3;
            SpecificationDetailsPanel.this.no.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.no.setSize(w3tl, (int)SpecificationDetailsPanel.this.no.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.no.getX() + SpecificationDetailsPanel.this.no.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.horizontalBorder), (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.reportName.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.reportName.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.reportName.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.reportName.getY() + SpecificationDetailsPanel.this.reportName.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.customer.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.periodChooser.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.customer.getY() + SpecificationDetailsPanel.this.customer.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.periodChooser.setSize(SpecificationDetailsPanel.this.periodChooser.getPreferredSize());
            SpecificationDetailsPanel.this.state.setLocation(SpecificationDetailsPanel.this.customer.getX(), SpecificationDetailsPanel.this.periodChooser.getY() + SpecificationDetailsPanel.this.periodChooser.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.state.setSize(150, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            int cy = SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight();
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.state.getX() + SpecificationDetailsPanel.this.state.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY());
                SpecificationDetailsPanel.this.locations.setSize(SpecificationDetailsPanel.this.locations.getPreferredSize());
                cy = SpecificationDetailsPanel.this.locations.getY() + SpecificationDetailsPanel.this.locations.getHeight();
            }
            SpecificationDetailsPanel.this.imageChooser.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.imageChooser.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.imageChooser.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.internalComment.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.imageChooser.getY() + SpecificationDetailsPanel.this.imageChooser.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.internalComment.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, 120);
        }
    }
}

