/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.productcatalog.details.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.modules.productcatalog.details.utils.GroupComparator;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogProductGroupComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CatBreadCrumbGroupTable
extends BreadCrumbGroupTable {
    private static final long serialVersionUID = 1L;
    private boolean isDeletable;
    private boolean isOrderable;

    public CatBreadCrumbGroupTable(IDataHandler dataHandler, BreadCrumbPanel master, String buttonText, RDProvider provider) {
        super(dataHandler, master, buttonText, provider);
        this.disableTitle();
        this.isDeletable = provider.isDeletable("groups");
        this.isOrderable = provider.isOrderChangable("groups");
    }

    @Override
    public void addButtonPressed() {
        ProductCatalogProductGroupComplete p = new ProductCatalogProductGroupComplete();
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setSequenceNumber(Integer.valueOf(this.table.getRowCount() + 1));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, false);
        this.table.setRequestFocusOnAdd(true);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.table.setRequestFocusOnAdd(false);
        this.table.updateOrder();
        this.table.revalidate();
    }

    @Override
    public void childRemoved() {
        this.table.writeNumber("sequenceNumber", 1);
        this.table.updateOrder();
        this.table.revalidate();
    }

    public ArrayList<TableColumnInfo> getColumns() {
        TableColumnInfo c1 = new TableColumnInfo(0.0, 0.0, Words.NO_NUMBER, "", null, null, null, 40, 40, 40);
        TableColumnInfo c2 = new TableColumnInfo(1.0, 0.0, Words.NAME, "", null, null, null, 25, 25, 25);
        int tw = TableColumnInfo.getSortableColumnWidth(this.table);
        TableColumnInfo c3 = new TableColumnInfo(0.0, 0.0, "", "", null, null, null, tw, tw, tw);
        ArrayList<TableColumnInfo> a = new ArrayList<TableColumnInfo>();
        a.add(c1);
        a.add(c2);
        a.add(c3);
        return a;
    }

    @Override
    public Comparator<?> getGroupComparator() {
        return ComparatorRegistry.getComparator(GroupComparator.class);
    }

    @Override
    public Table2RowPanel getGroupTableRow(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
        return p;
    }

    @Override
    public int getSortingIndex() {
        return 0;
    }

    public Converter getTitleConverter() {
        return null;
    }

    private class TableRowImpl
    extends SortableTable2RowPanel {
        private TextLabel no;
        private RDTextField name;

        public TableRowImpl(Table2RowModel m) {
            super(m, CatBreadCrumbGroupTable.this.isOrderable, CatBreadCrumbGroupTable.this.isDeletable);
            this.setSortAttributeName("sequenceNumber");
            this.setStartEndOffset(1, 0);
            this.no = new TextLabel(m.getNode().getChildNamed(new String[]{"sequenceNumber"}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new RDTextField(CatBreadCrumbGroupTable.this.provider);
            this.name.setNode(m.getNode().getChildNamed(new String[]{"name"}));
            this.name.setSelectionDelegate(this);
            this.setLayout(new Layout());
            this.setSelectable(true);
            this.add(this.no);
            this.add(this.name);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.name.kill();
            this.no = null;
            this.name = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.no.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.name);
            a.addAll(super.getFocusComponents());
            return a;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = 0;
                int currentX = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.no.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(TableRowImpl.this.no.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

