/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager;

import ch.icit.pegasus.client.actions.ClientAction;
import ch.icit.pegasus.client.actions.impl.PrintPurchaseOrderForReceiving;
import ch.icit.pegasus.client.actions.impl.PrintPurchaseOrderSheet;
import ch.icit.pegasus.client.actions.impl.SendPurchaseOrderAction;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.utils.OrderPositionComparator;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanToolkit;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleOriginComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DeliveryTermComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TransportCostTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReceivingGroupComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReceivingGroupComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionMutationRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionReceivingRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionRejectionRemarkComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceAndUnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.PurchaseApprovalSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import java.awt.Component;
import java.io.File;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PurchaseOrderModuleDataHandler
extends DefaultDataHandler<PurchaseOrderComplete, PurchaseOrderComplete> {
    public PurchaseOrderModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return "Load Article Prices";
    }

    @Override
    public void doRemoteValidation(final Node<PurchaseOrderComplete> node, final RemoteLoader listener, ProgressListener l, boolean validateAll) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
                SupplierReference supplier = (SupplierReference)node.getChildNamed(new String[]{"supplier"}).getValue();
                Date orderDate = (Date)node.getChildNamed(new String[]{"orderDate"}).getValue();
                Boolean useTaxZone = Boolean.TRUE.equals(node.getChildNamed(new String[]{"useTaxZone"}).getValue());
                TaxZoneComplete taxZone = (TaxZoneComplete)node.getChildNamed(new String[]{"taxZone"}).getValue();
                Iterator it = node.getChildNamed(new String[]{"orderPositions"}).getFailSafeChildIterator();
                long counter = 0L;
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    boolean isUpdateNeeded = false;
                    if (n.getChildNamed(PurchaseOrderPositionComplete_.orderUnitConversionValidity).getValue() != null && !((Boolean)n.getChildNamed(PurchaseOrderPositionComplete_.orderUnitConversionValidity).getValue()).booleanValue()) {
                        String cause = (String)n.getChildNamed(PurchaseOrderPositionComplete_.conversionWarnings).getValue();
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, cause));
                    }
                    if (n.getChildNamed(new String[]{"hasQuantityChange"}) != null) {
                        isUpdateNeeded = true;
                    } else if (n.getChildNamed(new String[]{"priceUnit"}).getValue() == null) {
                        isUpdateNeeded = true;
                    } else if (n.getChildNamed(new String[]{"supplierPrice"}) != null) {
                        if (n.getChildNamed(new String[]{"supplierPrice-price"}).getValue() == null) {
                            isUpdateNeeded = true;
                        } else if (n.getChildNamed(new String[]{"supplierPrice-currency"}).getValue() == null) {
                            isUpdateNeeded = true;
                        }
                    } else {
                        isUpdateNeeded = true;
                    }
                    if (isUpdateNeeded) {
                        UnitComplete u = (UnitComplete)n.getChildNamed(new String[]{"quantity-unit"}).getValue();
                        QuantityComplete q = new QuantityComplete();
                        q.setUnit(u);
                        q.setQuantity(TransactionToolkit.getDoubleValue(n.getChildNamed(new String[]{"quantity-amount"})));
                        BasicArticleLight r = (BasicArticleLight)n.getChildNamed(new String[]{"article"}).getValue();
                        SupplierConditionComplete supplierCondition = (SupplierConditionComplete)n.getChildNamed(new String[]{"supplierCondition"}).getValue();
                        try {
                            String t;
                            PriceAndUnitComplete ret = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticlePrice((BasicArticleReference)r, supplier, new DateWrapper(orderDate), q, useTaxZone, taxZone, supplierCondition);
                            if (ret != null) {
                                n.getChildNamed(new String[]{"supplierPrice-price"}).setValue((Object)ret.getPrice().getPrice(), 0L);
                                n.getChildNamed(new String[]{"supplierPrice-currency"}).setValue((Object)ret.getPrice().getCurrency(), 0L);
                                n.getChildNamed(new String[]{"priceUnit"}).setValue((Object)ret.getUnit(), 0L);
                                n.getChildNamed(new String[]{"contractEntry"}).setValue((Object)ret.getContractEntry(), 0L);
                                t = r.getNumber() + " - " + r.getName() + ": " + ret.toString();
                                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
                            } else {
                                t = "No Supplier Price found for: " + r.getNumber() + " - " + r.getName();
                                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, t));
                            }
                        }
                        catch (Exception e) {
                            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                        }
                    }
                    if (n.getChildNamed(new String[]{OrderPositionComplete_.quantity.getFieldName() + "-" + StoreQuantityComplete_.amount.getFieldName()}) == null) {
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Quantity set"));
                        continue;
                    }
                    counter += ((Long)n.getChildNamed(new String[]{OrderPositionComplete_.quantity.getFieldName() + "-" + StoreQuantityComplete_.amount.getFieldName()}).getValue()).longValue();
                }
                if (node.getChildNamed(new String[]{"orderPositions"}).getChildCount() == 0) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Order Positions defined"));
                }
                node.commit(PurchaseOrderComplete.class);
                ListNode retNode = new ListNode();
                if (!validationObjects.isEmpty()) {
                    retNode.setValue(validationObjects, 0L);
                }
                return retNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<PurchaseOrderComplete> createEmptyNode() {
        PurchaseOrderComplete o = new PurchaseOrderComplete();
        o.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (NodeToolkit.getAffixClass(SystemSettingsComplete.class) != null) {
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            o.setFooter(s.getDefaultOrderFooter());
            if (!Boolean.TRUE.equals(s.getAllowMixedOrdersWithCustomerOwnedArticles())) {
                o.setCustomerOwnedOnly(Boolean.valueOf(true));
            }
        }
        o.setState(OrderStateE.PLACED);
        o.setReviewState(OrderReviewStateE.UNCHECKED);
        o.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getDefaultLocation());
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)o, false, false);
    }

    private void revalidateOrderPositionState(PurchaseOrderComplete order) {
        int i = 0;
        Collections.sort(order.getOrderPositions(), ComparatorRegistry.getComparator(OrderPositionComparator.class));
        for (PurchaseOrderPositionComplete pos : order.getOrderPositions()) {
            if (pos.getState() == null) {
                pos.setState(OrderStateE.PLACED);
            }
            if (pos.getDeliveryDate() == null) {
                pos.setDeliveryDate(order.getDeliveryDate());
            }
            if (pos.getReviewState() == null) {
                pos.setReviewState(OrderReviewStateE.UNCHECKED);
            }
            pos.setSequenceNumber(Integer.valueOf(i));
            ++i;
        }
    }

    private void revalidateOrderReviewState(PurchaseOrderComplete order) {
        OrderReviewStateE cs = OrderReviewStateE.UNCHECKED;
        for (PurchaseOrderPositionComplete p : order.getOrderPositions()) {
            if (p.getReviewState() == null) {
                p.setReviewState(OrderReviewStateE.UNCHECKED);
                continue;
            }
            if (p.getReviewState() == OrderReviewStateE.NOT_APPROVED) {
                cs = OrderReviewStateE.NOT_APPROVED;
                continue;
            }
            if (cs == OrderReviewStateE.NOT_APPROVED) continue;
            cs = p.getReviewState();
        }
        order.setReviewState(cs);
    }

    @Override
    public void updateData(final Node<PurchaseOrderComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it = node.getChildNamed(PurchaseOrderComplete_.checkinGroups).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    Iterator it2 = next.getChildNamed(PurchaseOrderReceivingGroupComplete_.customsDocuments).getFailSafeChildIterator();
                    while (it2.hasNext()) {
                        Node next1 = (Node)it2.next();
                        if (!(next1 instanceof DTOProxyNode)) continue;
                        next1 = ((DTOProxyNode)next1).getRefNode();
                        next1.commitThis(CustomsDocumentComplete.class);
                    }
                }
                node.commitThis(PurchaseOrderComplete.class);
                PurchaseOrderComplete order = (PurchaseOrderComplete)node.getValue(PurchaseOrderComplete.class);
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                List orderPositions = order.getOrderPositions();
                orderPositions.sort((o1, o2) -> {
                    if (o1.getSequenceNumber() == null) {
                        return o2.getSequenceNumber() == null ? 0 : -1;
                    }
                    if (o2.getSequenceNumber() == null) {
                        return 1;
                    }
                    return o1.getSequenceNumber().compareTo(o2.getSequenceNumber());
                });
                int count = 0;
                for (PurchaseOrderPositionComplete p : order.getOrderPositions()) {
                    p.setOrder(order);
                    p.setSequenceNumber(Integer.valueOf(count++));
                    if (p.getId() != null) continue;
                    PriceAndUnitComplete a = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticlePrice((BasicArticleReference)p.getArticle(), (SupplierReference)order.getSupplier(), new DateWrapper(order.getOrderDate()), new QuantityComplete(Double.valueOf(p.getQuantity().getAmount().doubleValue()), p.getQuantity().getUnit()), order.getUseTaxZone(), order.getTaxZone(), p.getSupplierCondition());
                    p.setPriceUnit(a.getUnit());
                    p.setSupplierPrice(a.getPrice());
                }
                PurchaseOrderModuleDataHandler.this.revalidateOrderReviewState(order);
                ArrayList<ArticleChargeComplete> chargeToUpdate = new ArrayList<ArticleChargeComplete>();
                ArrayList<PurchaseOrderAcceptationComplete> transactions2Update = new ArrayList<PurchaseOrderAcceptationComplete>();
                it = node.getChildNamed(new String[]{"orderPositions"}).getChilds();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    Node nn = n.getChildNamed(new String[]{"updateCharge"});
                    Node nnt = n.getChildNamed(new String[]{"updateTransaction"});
                    if (nn == null && nnt == null) continue;
                    Iterator it2 = n.getChildNamed(new String[]{"transactions"}).getChilds();
                    while (it2.hasNext()) {
                        Node nnn = (Node)it2.next();
                        if (!(nnn.getValue() instanceof PurchaseOrderAcceptationComplete)) continue;
                        PurchaseOrderAcceptationComplete a = (PurchaseOrderAcceptationComplete)nnn.getValue();
                        ArticleChargeComplete charge = a.getCharge();
                        if (nn != null) {
                            chargeToUpdate.add(charge);
                        }
                        if (nnt == null) continue;
                        transactions2Update.add(a);
                    }
                }
                try {
                    for (PurchaseOrderReceivingGroupComplete group : order.getCheckinGroups()) {
                        PegasusFileComplete fileData;
                        boolean hasNewDocument = false;
                        for (CustomsDocumentComplete documentComplete : group.getCustomsDocuments()) {
                            if (documentComplete.getId() != null) continue;
                            hasNewDocument = true;
                        }
                        if (hasNewDocument) {
                            transactions2Update.addAll(group.getCheckins());
                        }
                        group.setCustomsDocuments(((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).mergeCustomsDocuments(new ListWrapper(group.getCustomsDocuments()), false).getList());
                        if (group.getDocumentScan() == null || (fileData = group.getDocumentScan().getFileData()) == null || fileData.getId() != null || fileData.getLocalFile() == null) continue;
                        try {
                            File localFile = fileData.getLocalFile();
                            group.getDocumentScan().setContentAsText(DocumentScanToolkit.readRawTextFromPDF(fileData.getLocalFile()));
                            PegasusFileComplete uploaded = FileTransferUtil.upload((PegasusFileComplete)fileData, (FileTransferListener[])new FileTransferListener[0]);
                            group.getDocumentScan().setFileData(uploaded);
                            String fileName = "Purchase-" + group.getOrder().getNumber();
                            DocumentScanToolkit.moveScannedFile(settings, localFile, group.getOrder().getOrderDate(), fileName);
                        }
                        catch (Exception e) {
                            InnerPopupFactory.showErrorDialog("Something went wrong with the PDF file (order should be saved correctly): " + e.getMessage(), (Component)PurchaseOrderModuleDataHandler.this.tableView);
                            group.setDocumentScan(null);
                        }
                    }
                    PurchaseOrderComplete no = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updatePurchaseOrder(order).getValue();
                    if (!transactions2Update.isEmpty()) {
                        for (PurchaseOrderAcceptationComplete transaction : transactions2Update) {
                            if (Boolean.TRUE.equals(settings.getAllowPurchaseBondedRestriction()) && !Boolean.TRUE.equals(transaction.getCharge().getBasicArticle().getBonded())) continue;
                            for (PurchaseOrderReceivingGroupComplete group : no.getCheckinGroups()) {
                                boolean receiveGroup = false;
                                for (PurchaseOrderAcceptationComplete checkin : group.getCheckins()) {
                                    if (!checkin.getId().equals(transaction.getId())) continue;
                                    receiveGroup = true;
                                }
                                if (!receiveGroup) continue;
                                HashSet usedDocs = new HashSet();
                                usedDocs.addAll(transaction.getCustomsDocs());
                                for (CustomsDocumentComplete doc : group.getCustomsDocuments()) {
                                    if (usedDocs.contains(doc)) continue;
                                    transaction.getCustomsDocs().add(doc);
                                }
                                usedDocs.clear();
                                usedDocs.addAll(transaction.getOrderPosition().getCustomsDocuments());
                                for (CustomsDocumentComplete doc : group.getCustomsDocuments()) {
                                    if (usedDocs.contains(doc)) continue;
                                    transaction.getOrderPosition().getCustomsDocuments().add(doc);
                                }
                            }
                            List updatedCustomsDocuments = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).mergeCustomsDocuments(new ListWrapper(transaction.getCustomsDocs()), true).getList();
                            transaction.getCustomsDocs().clear();
                            transaction.getCustomsDocs().addAll(updatedCustomsDocuments);
                            ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateAcceptation(transaction);
                        }
                        PurchaseOrderModuleDataHandler.this.revalidateOrderPositionState(no);
                        no = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updatePurchaseOrder(order).getValue();
                    }
                    if (!chargeToUpdate.isEmpty()) {
                        for (ArticleChargeComplete charge : chargeToUpdate) {
                            ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateCharge(charge, true);
                        }
                        PurchaseOrderModuleDataHandler.this.revalidateOrderPositionState(no);
                        no = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrderByReference(new PurchaseOrderReference(no.getId())).getValue();
                    }
                    if ((no = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).recalculateAssociatedDocuments(new PurchaseOrderReference(no.getId())).getValue()) != null) {
                        node.removeExistingValues();
                        node.setValue((Object)no, 0L);
                        node.updateNode();
                    }
                    return node;
                }
                catch (ClientServerCallException e) {
                    ViewNode r = new ViewNode("Error");
                    r.setValue((Object)e, 0L);
                    return r;
                }
            }

            @Override
            public RemoteLoader getInvoker() {
                if (model == null) {
                    return PurchaseOrderModuleDataHandler.this.model;
                }
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<PurchaseOrderComplete> node, final RemoteLoader model, boolean sameNode, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderComplete nO;
                boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
                NoProExchangeSettingsComplete noProExchangeSettings = (NoProExchangeSettingsComplete)NodeToolkit.getAffixClass(NoProExchangeSettingsComplete.class).getValue();
                PurchaseApprovalSettingsComplete purchaseReleaseSettings = (PurchaseApprovalSettingsComplete)NodeToolkit.getAffixClass(PurchaseApprovalSettingsComplete.class).getValue();
                node.commit(PurchaseOrderComplete.class);
                PurchaseOrderComplete order = (PurchaseOrderComplete)node.getValue(PurchaseOrderComplete.class);
                Node n = node;
                List orderPositions = order.getOrderPositions();
                orderPositions.sort((o1, o2) -> {
                    if (o1.getSequenceNumber() == null) {
                        return o2.getSequenceNumber() == null ? 0 : -1;
                    }
                    if (o2.getSequenceNumber() == null) {
                        return 1;
                    }
                    return o1.getSequenceNumber().compareTo(o2.getSequenceNumber());
                });
                int count = 0;
                Iterator it = order.getOrderPositions().iterator();
                while (it.hasNext()) {
                    PurchaseOrderPositionComplete p = (PurchaseOrderPositionComplete)it.next();
                    if (p.getArticle() != null && p.getQuantity().getAmount() > 0L) {
                        p.setOrder(order);
                        p.setSequenceNumber(Integer.valueOf(count++));
                        if (!isNoPro) continue;
                        p.setTargetStore(new StoreReference(noProExchangeSettings.getNoProStore().getId()));
                        continue;
                    }
                    it.remove();
                }
                if (order.getOrderPositions().size() == 0) {
                    return null;
                }
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                PurchaseOrderModuleDataHandler.this.revalidateOrderReviewState(order);
                if (order.getDeliveryDate() == null) {
                    order.setDeliveryDate(new Date(System.currentTimeMillis()));
                }
                if (order.getEligibleLocations().isEmpty()) {
                    order.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                if ((nO = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).createPurchaseOrder(order).getValue()) != null) {
                    if (model instanceof RowModel) {
                        Iterator<ClientAction> it2 = ((RowModel)model).getActions();
                        while (it2.hasNext()) {
                            ClientAction e = it2.next();
                            if (e instanceof SendPurchaseOrderAction) {
                                boolean sendToSupplier = true;
                                if (Boolean.TRUE.equals(purchaseReleaseSettings.getUsePurchaseApproval()) && !Boolean.TRUE.equals(nO.getApproved())) {
                                    sendToSupplier = false;
                                }
                                if (!sendToSupplier) continue;
                                SendPurchaseOrderAction p = (SendPurchaseOrderAction)e;
                                p.performAction(PurchaseOrderModuleDataHandler.this.model.getTable(), l, nO, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                                continue;
                            }
                            if (e instanceof PrintPurchaseOrderForReceiving) {
                                PrintPurchaseOrderForReceiving p = (PrintPurchaseOrderForReceiving)e;
                                p.performAction(PurchaseOrderModuleDataHandler.this.model.getTable(), l, nO, settings);
                                continue;
                            }
                            if (!(e instanceof PrintPurchaseOrderSheet)) continue;
                            PrintPurchaseOrderSheet p = (PrintPurchaseOrderSheet)e;
                            p.performAction(PurchaseOrderModuleDataHandler.this.model.getTable(), l, nO, settings);
                        }
                    }
                    if (nO != null) {
                        node.removeExistingValues();
                        node.setValue((Object)nO, 0L);
                        node.updateNode();
                    }
                    return node;
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderModuleDataHandler.this.setCurrentLoadMaximum(18);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ExternalCostCenterComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderDeliveryWindowComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderPositionReceivingRemarkComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderPositionRejectionRemarkComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(DeliveryTermComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllReviewStates();
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderPositionMutationRemarkComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllBondedStates();
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TransportCostTypeComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ArticleOriginComplete.class);
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllOrderPricingStates();
                PurchaseOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxZoneComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return PurchaseOrderModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void reloadBasicArticle(Node<BasicArticleReference> node) throws ClientServerCallException {
        if (node.getValue(BasicArticleComplete.class) == null) {
            BasicArticleComplete art = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)node.getValue()).getValue();
            node.removeExistingValues();
            node.setValue((Object)art, 0L);
            node.updateNode();
        }
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, "Refresh Purchase Order");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderLight o = (PurchaseOrderLight)node.getValue();
                PurchaseOrderComplete no = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrderByReference(new PurchaseOrderReference(o.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)no, 0L);
                node.updateNode();
                if (node.getChildNamed(new String[]{"orderPositions"}) != null) {
                    Iterator it = node.getChildNamed(new String[]{"orderPositions"}).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node storeNode;
                        Node n = (Node)it.next();
                        Node artL = n.getChildNamed(new String[]{"article"});
                        if (artL.getValue(BasicArticleComplete.class) == null) {
                            BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)((BasicArticleLight)artL.getValue(BasicArticleLight.class))).getValue();
                            artL.setValue((Object)artC, 0L);
                        }
                        if ((storeNode = n.getChildNamed(PurchaseOrderPositionComplete_.targetStore)).getValue() == null || storeNode.getValue(StoreLight.class) != null) continue;
                        StoreReference storeValue = (StoreReference)storeNode.getValue();
                        StoreLight storeLight = (StoreLight)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStoreLightByReference(storeValue).getValue();
                        storeNode.removeExistingValues();
                        storeNode.setValue((Object)storeLight, 0L);
                        storeNode.updateNode();
                    }
                }
                SupplierLight l = (SupplierLight)node.getChildNamed(new String[]{"supplier"}).getValue();
                SupplierComplete lc = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getSupplier((SupplierReference)l).getValue();
                node.getChildNamed(new String[]{"supplier"}).setValue((Object)lc, 0L);
                Collections.sort(no.getOrderPositions());
                for (PurchaseOrderPositionComplete position : no.getOrderPositions()) {
                    Collections.sort(position.getTransactions());
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<PurchaseOrderComplete> resetData(Node<PurchaseOrderComplete> node) {
        return new DTONode();
    }

    @Override
    public Class<PurchaseOrderComplete> getCommittingClass() {
        return PurchaseOrderComplete.class;
    }
}

