/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow;

import ch.icit.pegasus.client.actions.impl.SendPurchaseOrderAction;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.OrderDeliveryWindowConverter;
import ch.icit.pegasus.client.converter.StandaloneContactConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.ArticleOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils.DeliveryTimeConverter;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils.TableRowImpl;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.utils.IConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.activators.ActivationAdapterRegistry;
import ch.icit.pegasus.client.gui.utils.combobox.activators.SupplierActivationAdapter;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.SupplierScreenToolkit;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.APurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierDeliveryCostTypeE;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SolarConfigurationDetailsPanel
extends DefaultDetailsPanel<PurchaseOrderLight>
implements InnerPopUpListener2,
SearchTextField2Listener,
NodeListener,
IConfigurationDetailsPanel {
    private static final long serialVersionUID = 1L;
    private final boolean isNoPro;
    private TitledItem<SearchTextField2<SupplierLight>> suppliers;
    private TitledItem<ComboBox> customer;
    private InfoButton supplierInfo;
    private TitledItem<DateChooser> deliveryDate;
    private TitledItem<ComboBox> deliveryWindow;
    private TitledItem<DateChooser> orderDate;
    private TitledItem<CheckBox> sendOrderAfterCreation;
    private ArticleOrderDetailsPanel articlePanel;
    private TitledItem<ComboBox> deliveryAddress;
    private final boolean canSend;
    private final boolean canPrint;
    private boolean disablePopup = false;
    private boolean onlyAddFromTemplate;

    public SolarConfigurationDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider) {
        super(editor, provider);
        boolean isNoPro;
        this.setTitleText(Words.CONFIGURATION);
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        Node supplierNode = editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier);
        if (this.isNoPro) {
            NoProExchangeSettingsComplete noProSettings = (NoProExchangeSettingsComplete)NodeToolkit.getAffixClass(NoProExchangeSettingsComplete.class).getValue();
            supplierNode.setValue((Object)noProSettings.getNoProAsSupplier(), 0L);
        }
        this.suppliers = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(false, editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier)), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        this.suppliers.getElement().addSearchTextFieldListener(this);
        this.suppliers.getElement().setDefaultActivationAdapter(ActivationAdapterRegistry.getAdapter(SupplierActivationAdapter.class));
        this.customer = new TitledItem<ComboBox>(new ComboBox(editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.customer), NodeToolkit.getAffixList(ExternalCostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.onlyAddFromTemplate = !provider.isWritable(APurchaseOrderAccess.CAN_ORDER_WITHOUT_TEMPLATE);
        this.canSend = provider.isWritable(APurchaseOrderAccess.SEND);
        this.canPrint = provider.isWritable(APurchaseOrderAccess.PRINT);
        Node n1 = editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryDate);
        if (n1.getValue() == null) {
            Calendar c = TimeUtil.createCalendar();
            c.setTimeInMillis(System.currentTimeMillis());
            c.add(6, 1);
            n1.setValue((Object)new Date(c.getTimeInMillis()), 0L);
        }
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryAddress).getValue() == null) {
            editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryAddress).setValue((Object)settings.getDefaultDeliveryAddress(), 0L);
        }
        this.deliveryAddress = new TitledItem<ComboBox>(new ComboBox(editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryAddress), NodeToolkit.getAffixClass(SystemSettingsComplete.class).getChildNamed(SystemSettingsComplete_.deliveryAddresses), ConverterRegistry.getConverter(StandaloneContactConverter.class)), Words.DELIVERY_ADDRESS, TitledItem.TitledItemOrientation.NORTH);
        this.supplierInfo = new InfoButton();
        Node n2 = editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDeliveryWindow);
        if (n2.getValue() == null) {
            n2.setValue((Object)settings.getDefaultReceiveWindow(), 0L);
        }
        this.deliveryDate = new TitledItem<DateChooser>(new DateChooser(n1), Words.SCHEDULED_DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryWindow = new TitledItem<ComboBox>(new ComboBox(n2, NodeToolkit.getAffixList(OrderDeliveryWindowComplete.class), ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), ConverterRegistry.getConverter(OrderDeliveryWindowConverter.class)), Words.DELIVERY_TIME_WINDOW, TitledItem.TitledItemOrientation.NORTH);
        Node n3 = editor.getModel().getNode().getChildNamed(new String[]{"orderDate"});
        if (n3.getValue() == null) {
            Calendar c = TimeUtil.createCalendar();
            c.setTimeInMillis(System.currentTimeMillis());
            n3.setValue((Object)new Date(c.getTimeInMillis()), 0L);
        }
        this.orderDate = new TitledItem<DateChooser>(new DateChooser(n3), Words.ORDER_DATE, TitledItem.TitledItemOrientation.NORTH);
        if (editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryTerm).getValue() == null) {
            editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryTerm).setValue((Object)settings.getDefaultDeliveryTerm(), 0L);
        }
        if (!(isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue())))) {
            this.sendOrderAfterCreation = new TitledItem<CheckBox>(new CheckBox(), Words.SEND_PURCHASE_ORDER, TitledItem.TitledItemOrientation.EAST);
            this.sendOrderAfterCreation.getElement().setChecked(settings.getSendPurchaseOrderAfterCreation());
        }
        this.setCustomLayouter(new Layout());
        ((DeliveryTimeConverter)ConverterRegistry.getConverter(DeliveryTimeConverter.class)).setCurrentSupplier((SupplierReference)editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue());
        editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).addNodeListener((NodeListener)this);
        this.addToView(this.suppliers);
        this.addToView(this.deliveryDate);
        this.addToView(this.deliveryWindow);
        this.addToView(this.deliveryAddress);
        if (this.sendOrderAfterCreation != null) {
            this.addToView(this.sendOrderAfterCreation);
        }
        this.addToView(this.supplierInfo);
        this.addToView(this.orderDate);
        this.addToView(this.customer);
    }

    @Override
    public boolean isSupplierChoosen() {
        return this.suppliers.getElement().isItemSelected();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        boolean mixedOrdersAllowed;
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (this.canSend && (this.sendOrderAfterCreation != null && this.sendOrderAfterCreation.getElement().isChecked() || isNoPro)) {
            if (!this.editor.getModel().hasActionType(SendPurchaseOrderAction.class)) {
                this.editor.getModel().addClientAction(new SendPurchaseOrderAction());
            }
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            SupplierComplete supplier = (SupplierComplete)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue(SupplierComplete.class);
            if (user.getContact().getEmail() == null || user.getContact().getEmail().isEmpty()) {
                if (this.sendOrderAfterCreation != null) {
                    this.sendOrderAfterCreation.getElement().setInvalid();
                }
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Your EMail Address is not set. Unable to send Order EMail"));
            }
            if (supplier == null) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Supplier selected."));
            } else if ((supplier.getOrderContactNumber() == null || supplier.getOrderContactNumber().isEmpty()) && (supplier.getOrderContact() == null || supplier.getOrderContact().getEmail() == null || supplier.getOrderContact().getEmail().isEmpty())) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "EMail of Supplier's Order Contact not set. Unable to send Order EMail"));
            }
        }
        if (this.suppliers.getElement().getNode().getValue() == null) {
            this.suppliers.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Supplier must be set"));
        }
        if (this.deliveryDate.getElement().getNode().getValue() == null) {
            this.deliveryDate.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Delivery Date is set"));
        }
        if (this.orderDate.getElement().getNode().getValue() == null) {
            this.orderDate.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Order Date is set"));
        }
        boolean bl = mixedOrdersAllowed = Boolean.TRUE.equals(this.settings.getAllowMixedOrdersWithCustomerOwnedArticles()) || isNoPro;
        if (!mixedOrdersAllowed) {
            String articlesToRemove;
            Boolean customerOwnedOnly = (Boolean)this.editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).getValue();
            boolean foundOwnedArticle = false;
            boolean foundNotOwnedArticle = false;
            HashSet<BasicArticleLight> ownedArticles = new HashSet<BasicArticleLight>();
            HashSet<BasicArticleLight> notOwnedArticles = new HashSet<BasicArticleLight>();
            Iterator it = this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderPositions).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node position = (Node)it.next();
                BasicArticleLight article = (BasicArticleLight)position.getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleLight.class);
                if (Boolean.TRUE.equals(article.getCustomerIsOwner())) {
                    foundOwnedArticle = true;
                    ownedArticles.add(article);
                    continue;
                }
                foundNotOwnedArticle = true;
                notOwnedArticles.add(article);
            }
            if (Boolean.TRUE.equals(customerOwnedOnly) && foundNotOwnedArticle) {
                articlesToRemove = "";
                for (BasicArticleLight article : notOwnedArticles) {
                    articlesToRemove = articlesToRemove + article.getNumber() + ",";
                }
                articlesToRemove = articlesToRemove.substring(0, articlesToRemove.length() - 1);
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "This order can only contains 'customer owned' articles, please remove article " + articlesToRemove));
            } else if (Boolean.FALSE.equals(customerOwnedOnly) && foundOwnedArticle) {
                articlesToRemove = "";
                for (BasicArticleLight article : ownedArticles) {
                    articlesToRemove = articlesToRemove + article.getNumber() + ",";
                }
                articlesToRemove = articlesToRemove.substring(0, articlesToRemove.length() - 1);
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "This order can only contains 'not customer owned' articles, please remove article " + articlesToRemove));
            }
        }
        return o;
    }

    public void setArticlePanel(ArticleOrderDetailsPanel panel) {
        this.articlePanel = panel;
        if (this.isNoPro) {
            this.popUpClosed(null, this);
        }
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.suppliers);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.deliveryDate);
        CheckedListAdder.addToList(focusList, this.orderDate);
        CheckedListAdder.addToList(focusList, this.deliveryWindow);
        CheckedListAdder.addToList(focusList, this.deliveryAddress);
        CheckedListAdder.addToList(focusList, this.sendOrderAfterCreation);
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.suppliers.kill();
        this.suppliers = null;
        this.customer.kill();
        this.customer = null;
        this.supplierInfo.kill();
        this.supplierInfo = null;
        this.deliveryWindow.kill();
        this.deliveryWindow = null;
        this.deliveryDate.kill();
        this.deliveryDate = null;
        this.deliveryAddress.kill();
        this.deliveryAddress = null;
        if (this.sendOrderAfterCreation != null) {
            this.sendOrderAfterCreation.kill();
        }
        this.sendOrderAfterCreation = null;
        this.orderDate.kill();
        this.orderDate = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isNoPro) {
            this.suppliers.setEnabled(false);
        } else {
            this.suppliers.setEnabled(isEnabled && !this.onlyAddFromTemplate);
        }
        this.customer.setEnabled(isEnabled);
        this.supplierInfo.setEnabled(isEnabled);
        this.deliveryWindow.setEnabled(isEnabled);
        this.deliveryDate.setEnabled(isEnabled);
        this.orderDate.setEnabled(isEnabled);
        this.deliveryAddress.setEnabled(isEnabled);
        if (this.sendOrderAfterCreation != null) {
            this.sendOrderAfterCreation.setEnabled(isEnabled && this.canSend);
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            this.fireFocusCycleChanged(this);
        } else {
            if (this.suppliers.getElement().getNode().getValue(SupplierComplete.class) != null) {
                this.remoteObjectLoaded(this.suppliers.getElement().getNode());
            } else {
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        SupplierLight s = (SupplierLight)((SearchTextField2)SolarConfigurationDetailsPanel.this.suppliers.getElement()).getNode().getValue();
                        SupplierComplete ss = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getSupplier((SupplierReference)s).getValue();
                        if (ss == null) {
                            throw new ClientServerCallException("Error while load Supplier. Please restart CATIT");
                        }
                        if (ss.getCostType() == null) {
                            ss.setCostType(SupplierDeliveryCostTypeE.NONE);
                        }
                        ((SearchTextField2)SolarConfigurationDetailsPanel.this.suppliers.getElement()).getNode().setValue((Object)ss, 0L);
                        return ((SearchTextField2)SolarConfigurationDetailsPanel.this.suppliers.getElement()).getNode();
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return SolarConfigurationDetailsPanel.this;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            }
            if (!this.disablePopup) {
                this.articlePanel.clearRows();
            }
        }
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        SupplierLight supplier = (SupplierLight)n.getValue();
        if (supplier != null) {
            this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDeliveryWindow).setValue((Object)supplier.getDefaultDeliveryWindow(), 0L);
            if (!StringUtil.isBlank((String)supplier.getDefaultOrderRemark())) {
                this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.remark).setValue((Object)supplier.getDefaultOrderRemark(), 0L);
            }
        }
        if (!this.disablePopup) {
            InnerPopupFactory.showMessageDialog("Supplier changed, all existing Order Positions will be removed.", "Attention", (source1, xargs) -> {
                Iterator it = this.editor.getModel().getNode().getChildNamed(new String[]{"orderPositions"}).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node m = (Node)it.next();
                    this.editor.getModel().getNode().getChildNamed(new String[]{"orderPositions"}).removeChild(m, 0L);
                }
            }, (Component)source);
        } else {
            this.popUpClosed(null, "");
        }
        this.disablePopup = false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        SupplierComplete sup = (SupplierComplete)node.getValue(SupplierComplete.class);
        ((DeliveryTimeConverter)ConverterRegistry.getConverter(DeliveryTimeConverter.class)).setCurrentSupplier((SupplierReference)sup);
        if (this.articlePanel != null) {
            this.articlePanel.setSupplierSet();
        }
        this.supplierInfo.installStringViewer(SupplierScreenToolkit.getSupplierConditionString(sup));
        this.fireFocusCycleChanged(this);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.suppliers.requestFocusInWindowNow();
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    @Override
    public Date getDeliveryDate() {
        return (Date)this.deliveryDate.getElement().getNode().getValue();
    }

    public void valueChanged(Node<?> node) {
        this.disablePopup = true;
        this.updatePositions();
    }

    private void updatePositions() {
        for (Table2RowPanel row : this.articlePanel.getTable().getRows()) {
            TableRowImpl rowImpl = (TableRowImpl)row;
            rowImpl.updatePosition(this, false);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SolarConfigurationDetailsPanel.this.suppliers.setLocation(SolarConfigurationDetailsPanel.this.horizontalBorder, SolarConfigurationDetailsPanel.this.verticalBorder);
            SolarConfigurationDetailsPanel.this.suppliers.setSize(200, (int)SolarConfigurationDetailsPanel.this.suppliers.getPreferredSize().getHeight());
            SolarConfigurationDetailsPanel.this.supplierInfo.setLocation(SolarConfigurationDetailsPanel.this.suppliers.getX() + SolarConfigurationDetailsPanel.this.suppliers.getWidth() + SolarConfigurationDetailsPanel.this.inner_horizontalBorder, (int)((double)(SolarConfigurationDetailsPanel.this.suppliers.getY() + SolarConfigurationDetailsPanel.this.suppliers.getHeight()) - (SolarConfigurationDetailsPanel.this.supplierInfo.getPreferredSize().getHeight() + 3.0)));
            SolarConfigurationDetailsPanel.this.supplierInfo.setSize(SolarConfigurationDetailsPanel.this.supplierInfo.getPreferredSize());
            SolarConfigurationDetailsPanel.this.customer.setLocation(SolarConfigurationDetailsPanel.this.supplierInfo.getX() + SolarConfigurationDetailsPanel.this.supplierInfo.getWidth() + SolarConfigurationDetailsPanel.this.horizontalBorder, SolarConfigurationDetailsPanel.this.suppliers.getY());
            SolarConfigurationDetailsPanel.this.customer.setSize(parent.getWidth() - (SolarConfigurationDetailsPanel.this.horizontalBorder + SolarConfigurationDetailsPanel.this.customer.getX()), (int)SolarConfigurationDetailsPanel.this.customer.getPreferredSize().getHeight());
            SolarConfigurationDetailsPanel.this.deliveryDate.setLocation(SolarConfigurationDetailsPanel.this.horizontalBorder, SolarConfigurationDetailsPanel.this.suppliers.getY() + SolarConfigurationDetailsPanel.this.suppliers.getHeight() + SolarConfigurationDetailsPanel.this.verticalBorder);
            SolarConfigurationDetailsPanel.this.deliveryDate.setSize(SolarConfigurationDetailsPanel.this.deliveryDate.getPreferredSize());
            SolarConfigurationDetailsPanel.this.deliveryWindow.setLocation(SolarConfigurationDetailsPanel.this.supplierInfo.getX() + SolarConfigurationDetailsPanel.this.supplierInfo.getWidth() + SolarConfigurationDetailsPanel.this.horizontalBorder, SolarConfigurationDetailsPanel.this.deliveryDate.getY());
            SolarConfigurationDetailsPanel.this.deliveryWindow.setSize(250, (int)SolarConfigurationDetailsPanel.this.deliveryWindow.getPreferredSize().getHeight());
            SolarConfigurationDetailsPanel.this.deliveryAddress.setLocation(SolarConfigurationDetailsPanel.this.deliveryWindow.getX(), SolarConfigurationDetailsPanel.this.deliveryWindow.getY() + SolarConfigurationDetailsPanel.this.deliveryWindow.getHeight() + SolarConfigurationDetailsPanel.this.inner_verticalBorder);
            SolarConfigurationDetailsPanel.this.deliveryAddress.setSize(250, (int)SolarConfigurationDetailsPanel.this.deliveryAddress.getPreferredSize().getHeight());
            SolarConfigurationDetailsPanel.this.orderDate.setLocation(SolarConfigurationDetailsPanel.this.deliveryDate.getX(), SolarConfigurationDetailsPanel.this.deliveryAddress.getY());
            SolarConfigurationDetailsPanel.this.orderDate.setSize(SolarConfigurationDetailsPanel.this.orderDate.getPreferredSize());
            int currentY = SolarConfigurationDetailsPanel.this.deliveryAddress.getY() + SolarConfigurationDetailsPanel.this.deliveryAddress.getHeight() + SolarConfigurationDetailsPanel.this.verticalBorder;
            if (SolarConfigurationDetailsPanel.this.sendOrderAfterCreation != null) {
                SolarConfigurationDetailsPanel.this.sendOrderAfterCreation.setLocation(SolarConfigurationDetailsPanel.this.deliveryAddress.getX(), SolarConfigurationDetailsPanel.this.deliveryAddress.getY() + SolarConfigurationDetailsPanel.this.deliveryAddress.getHeight() + SolarConfigurationDetailsPanel.this.verticalBorder);
                SolarConfigurationDetailsPanel.this.sendOrderAfterCreation.setSize(250, (int)SolarConfigurationDetailsPanel.this.sendOrderAfterCreation.getPreferredSize().getHeight());
                currentY = SolarConfigurationDetailsPanel.this.sendOrderAfterCreation.getY() + SolarConfigurationDetailsPanel.this.sendOrderAfterCreation.getHeight() + SolarConfigurationDetailsPanel.this.inner_horizontalBorder;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SolarConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SolarConfigurationDetailsPanel.this.suppliers.getPreferredSize().getHeight());
            h += SolarConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SolarConfigurationDetailsPanel.this.deliveryWindow.getPreferredSize().getHeight());
            h += SolarConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SolarConfigurationDetailsPanel.this.deliveryAddress.getPreferredSize().getHeight());
            h += SolarConfigurationDetailsPanel.this.verticalBorder;
            if (SolarConfigurationDetailsPanel.this.sendOrderAfterCreation != null) {
                h = (int)((double)h + SolarConfigurationDetailsPanel.this.sendOrderAfterCreation.getPreferredSize().getHeight());
                h += SolarConfigurationDetailsPanel.this.verticalBorder;
            }
            return new Dimension(0, h);
        }
    }
}

