/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.SupplierConditionOrderCostsConverter;
import ch.icit.pegasus.client.converter.SupplierConditionPreviewOrderCostsConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.ManualOrderCreatorDataHandler;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.ManualPurchaseOrderCreatorModule;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.OrderBreadCrumpPanel;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitView;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.EnterListener;
import ch.icit.pegasus.client.gui.utils.Enterable;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBoxConfiguration;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.CheapestSupplierTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.searcher.searchfieldimpls.BasicArticleSearchFieldRemoteSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.RoundingStrategyE;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionPreviewComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchTypeE;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.utils.RoundingToolkit;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ArticleDetailsPanel
extends SplitView
implements SearchTextField2Listener,
RemoteLoader,
ButtonListener,
NodeListener,
EnterListener {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private Table2 table;
    private SystemSettingsComplete settings;
    private SystemViewSettingsComplete viewSettings;
    private int horizontalBorder;
    private boolean isBlocked;
    private int verticalBorder;
    private MiniComboBox articleSearchConfiguration;
    private TitledItem<SearchTextField2> articleSearch;
    private InfoButton articleInfo;
    private TitledItem<InputComboBox2> quantity;
    private TextButton add;
    private TitledItem<ComboBox> customerOwnedOnly;
    private TitledItem<ComboBox> halalOrder;
    private CheapestSupplierTable supplier;
    private Container aaParent;
    protected Node orderList;
    private Node articleList;
    private BasicArticleComplete artC;
    private boolean isLoading;
    private boolean allUnitsAllowed = false;
    private UserComplete currentUser;
    private CurrencyVariantAccessor accessor = new CurrencyVariantAccessorImpl();

    public ArticleDetailsPanel(ManualPurchaseOrderCreatorModule creator, RDProvider provider) {
        this(creator, creator.getSplitView2List(), creator.getSplitView1List(), provider);
    }

    public ArticleDetailsPanel(Container aParent, Node orderList, Node articleList, RDProvider provider) {
        this.orderList = orderList;
        this.aaParent = aParent;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.isSolarCompany = Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType()) || CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        this.viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
        this.allUnitsAllowed = true;
        if (!CompanyUtil.isFPB((SystemSettingsComplete)this.settings) && !this.isSolarCompany) {
            this.customerOwnedOnly = new TitledItem<ComboBox>(ComboBoxFactory.getCustomerOwned(Boolean.TRUE.equals(this.settings.getAllowMixedOrdersWithCustomerOwnedArticles())), Words.CUSTOMER_OWNED_ONLY, TitledItem.TitledItemOrientation.NORTH);
            this.customerOwnedOnly.getElement().addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.updateSearchState();
                }
            });
            boolean withAll = Boolean.TRUE.equals(this.viewSettings.getUseHalalOnlyOrders());
            this.halalOrder = new TitledItem<ComboBox>(ComboBoxFactory.getHalal(!withAll), Words.HALAL_ORDER, TitledItem.TitledItemOrientation.NORTH);
            if (!withAll) {
                this.halalOrder.getElement().setSelectedItem(Words.ALL);
            } else {
                this.halalOrder.getElement().setSelectedItem(Words.NOT_HALAL_ONLY);
            }
            this.halalOrder.getElement().addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.updateSearchState();
                }
            });
        }
        this.horizontalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_horizontal_border"));
        this.verticalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_vertical_border"));
        MiniComboBoxConfiguration mcbc = new MiniComboBoxConfiguration(BasicArticleSearchTypeE.ALL);
        this.articleSearchConfiguration = new MiniComboBox();
        this.articleSearchConfiguration.setVisible(true);
        this.articleSearchConfiguration.addItem(BasicArticleSearchTypeE.ALL, mcbc.getPicture(BasicArticleSearchTypeE.ALL));
        this.articleSearchConfiguration.addItem(BasicArticleSearchTypeE.ARTICLE_NAME, mcbc.getPicture(BasicArticleSearchTypeE.ARTICLE_NAME));
        this.articleSearchConfiguration.addItem(BasicArticleSearchTypeE.ARTICLE_NUMBER, mcbc.getPicture(BasicArticleSearchTypeE.ARTICLE_NUMBER));
        this.articleSearchConfiguration.addItem(BasicArticleSearchTypeE.SUPPLIER_NUMBER, mcbc.getPicture(BasicArticleSearchTypeE.SUPPLIER_NUMBER));
        this.articleSearchConfiguration.addItem(BasicArticleSearchTypeE.CUSTOMER_NUMBER, mcbc.getPicture(BasicArticleSearchTypeE.CUSTOMER_NUMBER));
        this.articleSearchConfiguration.setSelectedItem(BasicArticleSearchTypeE.ALL);
        this.articleSearch = new TitledItem<SearchTextField2<BasicArticleLight>>(SearchTextField2Factory.getBasicArticleSearchField(true, new DTOProxyNode(), false, false), Words.ARTICLE, TitledItem.TitledItemOrientation.NORTH);
        ((BasicArticleSearchFieldRemoteSearchAlgorithm)this.articleSearch.getElement().getSearchAlgorithm()).setMiniComboBox(this.articleSearchConfiguration);
        this.articleSearch.getElement().setKeepCurrentValue(false);
        this.quantity = new TitledItem<InputComboBox2>(new InputComboBox2((Node)new DTONode(), (Node)new DTOProxyNode(), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG), Words.QUANTITY, TitledItem.TitledItemOrientation.NORTH);
        this.supplier = new CheapestSupplierTable();
        this.articleInfo = new InfoButton();
        this.add = new TextButton(Words.ADD);
        this.add.addButtonListener(this);
        this.updateSearchState();
        this.table = new Table2(false, "", false, false);
        this.table.setScrollDownOnAdd(true);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ArticleDetailsPanel.this.aaParent.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.ARTICLE), null, null, null, "", 40, 40, 40));
        int tw1 = 2 * this.table.getCellPadding() + InputComboBox2.getPreferredWidth(this, 3);
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.CALC), null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.STOCK), null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.QUANTITY), null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.SUPPLIER), null, null, null, "", 30, 30, 30));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.setArticleListNode(articleList);
        this.setLayout(new Layout());
        this.articleInfo.setEnabled(false);
        this.quantity.setEnabled(false);
        this.supplier.setEnabled(false);
        this.add.setEnabled(false);
        this.articleSearch.getElement().addSearchTextFieldListener(this);
        this.quantity.getElement().addEnterListener(this);
        this.createFocusCycle();
        this.table.setSortable(false);
        this.add(this.table);
        this.add(this.articleSearchConfiguration);
        this.add(this.articleInfo);
        this.add(this.articleSearch);
        this.add(this.quantity);
        this.add(this.supplier);
        this.add(this.add);
        if (this.customerOwnedOnly != null) {
            this.add(this.customerOwnedOnly);
        }
        if (this.halalOrder != null) {
            this.add(this.halalOrder);
        }
    }

    private void updateSearchState() {
        Object[] o = new Object[8];
        if (this.halalOrder != null) {
            if (this.halalOrder.getElement().getSelectedItem().equals(Words.ALL)) {
                o[7] = null;
            } else if (this.halalOrder.getElement().getSelectedItem().equals(Words.HALAL_ONLY)) {
                o[7] = true;
            } else if (this.halalOrder.getElement().getSelectedItem().equals(Words.NOT_HALAL_ONLY)) {
                o[7] = false;
            }
        } else {
            o[7] = null;
        }
        if (this.customerOwnedOnly != null) {
            if (this.customerOwnedOnly.getElement().getSelectedItem().equals(Words.ALL)) {
                o[1] = null;
            } else if (this.customerOwnedOnly.getElement().getSelectedItem().equals(Words.CUSTOMER_OWNED)) {
                o[1] = true;
            } else if (this.customerOwnedOnly.getElement().getSelectedItem().equals(Words.NOT_CUSTOMER_OWNED)) {
                o[1] = false;
            }
        } else {
            o[1] = null;
        }
        this.articleSearch.getElement().setAdditionalSearchField(o);
    }

    protected boolean isPreview() {
        return false;
    }

    private void createFocusCycle() {
        List<Component> a = this.getFocusComponents();
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.articleSearchConfiguration.setEnabled(isEnabled);
        this.articleSearch.setEnabled(isEnabled);
        this.articleInfo.setEnabled(this.articleSearch.getElement().isItemSelected() && isEnabled);
        this.quantity.setEnabled(this.articleSearch.getElement().isItemSelected() && isEnabled);
        this.supplier.setEnabled(this.articleSearch.getElement().isItemSelected() && isEnabled);
        this.add.setEnabled(this.articleSearch.getElement().isItemSelected() && isEnabled);
        if (this.customerOwnedOnly != null) {
            this.customerOwnedOnly.setEnabled(isEnabled);
        }
        if (this.halalOrder != null) {
            this.halalOrder.setEnabled(isEnabled);
        }
        this.table.setEnabled(isEnabled);
    }

    public void block() {
        this.isBlocked = true;
    }

    public void unblock() {
        this.isBlocked = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.articleSearchConfiguration.kill();
        this.articleSearch.kill();
        this.articleInfo.kill();
        this.quantity.kill();
        this.supplier.kill();
        this.add.kill();
        this.table.kill();
        if (this.customerOwnedOnly != null) {
            this.customerOwnedOnly.kill();
        }
        if (this.halalOrder != null) {
            this.halalOrder.kill();
        }
        this.articleSearchConfiguration = null;
        this.articleSearch = null;
        this.articleInfo = null;
        this.quantity = null;
        this.supplier = null;
        this.add = null;
        this.table = null;
        this.halalOrder = null;
        this.customerOwnedOnly = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.articleSearchConfiguration);
        CheckedListAdder.addToList(a, this.articleSearch);
        if (this.articleSearch.getElement().isItemSelected()) {
            CheckedListAdder.addToList(a, this.quantity);
            CheckedListAdder.addToList(a, this.supplier);
            CheckedListAdder.addToList(a, this.add);
        }
        return a;
    }

    private void addArticle() {
        if (this.supplier == null || this.supplier.getModel().getSelectedNode() == null) {
            return;
        }
        if (this.articleSearch.getElement().getNode().getValue(BasicArticleComplete.class) == null || this.isLoading) {
            InnerPopupFactory.showErrorDialog("Please wait till selected Article is completely loaded. Press Add again.", (Component)this.add);
            return;
        }
        Node scNode = this.supplier.getModel().getSelectedNode();
        SupplierConditionComplete supplierCondition = (SupplierConditionComplete)scNode.getValue();
        this.insertArticle((BasicArticleComplete)this.articleSearch.getElement().getNode().getValue(BasicArticleComplete.class), supplierCondition, TransactionToolkit.getLongValue(this.quantity.getElement().getValueNode()).longValue(), (UnitComplete)this.quantity.getElement().getUnitNode().getValue(), null, null, false);
    }

    public void insertArticle(BasicArticleComplete article, SupplierConditionComplete supplierCondition, double orderAmount, UnitComplete orderUnit, QuantityComplete calculatedQuantity, QuantityComplete stockQuantity, boolean normalize) {
        this.insertArticle(article, null, supplierCondition, orderAmount, orderUnit, calculatedQuantity, stockQuantity, normalize);
    }

    public void insertArticle(BasicArticleComplete article, CostCenterComplete department, SupplierConditionComplete supplierCondition, double orderAmount, UnitComplete orderUnit, QuantityComplete calculatedQuantity, QuantityComplete stockQuantity, boolean normalize) {
        if (supplierCondition == null) {
            InnerPopupFactory.showErrorDialog("Article " + article.getNumber() + " - " + article.getName() + " has no supplier defined", (Component)this);
            return;
        }
        QuantityComplete qc = new QuantityComplete(Double.valueOf(orderAmount), orderUnit);
        if (normalize && (qc = UnitConversionToolkit.normalizeQuantity((QuantityComplete)qc, (BasicArticleComplete)article, (Timestamp)new Timestamp(System.currentTimeMillis()))).getQuantity() == 0.0) {
            qc.setUnit(article.getMainStoreUnit());
        }
        StoreQuantityComplete quantity = new StoreQuantityComplete();
        Double nd = RoundingToolkit.round((Double)qc.getQuantity(), (RoundingStrategyE)RoundingStrategyE.UP);
        quantity.setAmount(Long.valueOf(nd.longValue()));
        quantity.setUnit(qc.getUnit());
        quantity.setClientOId(Long.valueOf(quantity.getNextId()));
        int i = UnitConversionToolkit.isUnitContaining((UnitComplete)quantity.getUnit(), (UnitComplete)article.getMainStoreUnit(), (BasicArticleLight)article, (SupplierConditionComplete)supplierCondition, (Timestamp)new Timestamp(System.currentTimeMillis()));
        switch (i) {
            case 3: 
            case 5: {
                break;
            }
            case 11: {
                InnerPopupFactory.showErrorDialog("Selected Unit (" + quantity.getUnit().getShortName() + ") is not convertible within Article's Packaging Table (" + article.getNumber() + " - " + article.getName() + "). Please delete current Article and readd it.", (Component)this);
                return;
            }
        }
        SupplierConditionComplete copySupplierCondition = CopyTemplateToolkit.copySupplierCondition((SupplierConditionComplete)supplierCondition);
        Node nArticle = this.createPositionNode(article, quantity, copySupplierCondition, new Timestamp(System.currentTimeMillis()), false);
        nArticle = this.setNodeValue(nArticle, "calcQty", article, calculatedQuantity);
        nArticle = this.setNodeValue(nArticle, "stockQty", article, stockQuantity);
        Node order = this.getOrderNode4Supplier(copySupplierCondition, department);
        order.getChildNamed(this.getPositionField()).addChild((Node)new DTOProxyNode(nArticle), System.currentTimeMillis());
        DTOProxyNode supplier = new DTOProxyNode((Object)copySupplierCondition);
        supplier.setName("supplier");
        nArticle.addChild((Node)supplier, 0L);
        this.articleList.addChild(nArticle, System.currentTimeMillis());
        this.setEnabled(true);
        this.articleSearch.getElement().requestFocusOnSearchField();
        this.revalidate();
    }

    private Node setNodeValue(Node node, String name, BasicArticleComplete article, QuantityComplete quantity) {
        Node n = node.getChildNamed(new String[]{name});
        if (n == null) {
            n = new Node();
            n.setName(name);
            node.addChild(n, 0L);
        }
        if (quantity != null) {
            quantity.setQuantity(Double.valueOf(UnitConversionToolkit.convertUnit((UnitComplete)quantity.getUnit(), (UnitComplete)quantity.getUnit(), (double)quantity.getQuantity(), (BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis()))));
            quantity.setUnit(quantity.getUnit());
        }
        n.setValue((Object)quantity, 0L);
        return node;
    }

    public DtoField<?> getPositionField() {
        return PurchaseOrderComplete_.orderPositions;
    }

    public Node createPositionNode(BasicArticleComplete article, StoreQuantityComplete q, SupplierConditionComplete copySupplierCondition, Timestamp validity, boolean active) {
        NoProExchangeSettingsComplete noProSettings;
        PurchaseOrderPositionComplete npos = new PurchaseOrderPositionComplete();
        npos.setClientOId(Long.valueOf(ADTO.getNextId()));
        npos.setArticle((BasicArticleLight)article);
        npos.setArticleLabelCount(Integer.valueOf(0));
        if (active && copySupplierCondition.getUsePackingQuantity() != null && copySupplierCondition.getUsePackingQuantity().booleanValue() && copySupplierCondition.getPackingQuantities() != null && !copySupplierCondition.getPackingQuantities().isEmpty()) {
            double v = UnitConversionToolkit.convertUnit((UnitComplete)q.getUnit(), (UnitComplete)article.getBaseUnit(), (double)q.getAmount().longValue(), (BasicArticleLight)article, (Timestamp)validity);
            StoreQuantityComplete qNew = this.convertBestUnit(v, article.getBaseUnit(), article, copySupplierCondition, validity);
            if (qNew == null) {
                return null;
            }
            npos.setQuantity(qNew);
        } else {
            npos.setQuantity(q);
        }
        npos.setPriceUnit(article.getPriceUnit());
        npos.setReviewState(OrderReviewStateE.UNCHECKED);
        npos.setSupplierCondition(copySupplierCondition);
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        if (isNoPro && (noProSettings = (NoProExchangeSettingsComplete)NodeToolkit.getAffixClass(NoProExchangeSettingsComplete.class).getValue()) != null) {
            npos.setTargetStore(new StoreReference(noProSettings.getNoProStore().getId()));
        }
        if (copySupplierCondition.getStepPrice().getSteps().size() > 0) {
            npos.setSupplierPrice(((StepPriceFunctionComplete)copySupplierCondition.getStepPrice().getSteps().get(0)).getPrice());
        } else {
            npos.setSupplierPrice(new PriceComplete(copySupplierCondition.getSupplier().getPaymentCurrency(), Double.valueOf(0.0)));
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)npos, true, false);
        return n;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.add) {
            this.addArticle();
        }
    }

    protected Node getOrderNode4Supplier(SupplierConditionComplete supplierCondition, CostCenterComplete department) {
        Iterator it = this.orderList.getChilds();
        while (it.hasNext()) {
            Node order = (Node)it.next();
            if (!((SupplierLight)order.getChildNamed(PurchaseOrderComplete_.supplier).getValue()).equals((Object)supplierCondition.getSupplier())) continue;
            Boolean orderTaxZone = (Boolean)order.getChildNamed(PurchaseOrderComplete_.useTaxZone).getValue();
            TaxZoneComplete orderUseTaxZone = (TaxZoneComplete)order.getChildNamed(PurchaseOrderComplete_.taxZone).getValue();
            TaxZoneComplete newTaxZone = supplierCondition.getCategoryTaxZone();
            if (!(Boolean.TRUE.equals(orderTaxZone) ? (orderUseTaxZone == null ? newTaxZone == null : orderUseTaxZone.equals((Object)newTaxZone)) : newTaxZone == null)) continue;
            return order;
        }
        long oneDay = 86400000L;
        Node n = this.createOrderNode(supplierCondition, department, oneDay);
        this.orderList.addChild(n, System.currentTimeMillis());
        return n;
    }

    protected Node createOrderNode(SupplierConditionComplete supplierCondition, CostCenterComplete department, long oneDay) {
        PurchaseOrderComplete o = new PurchaseOrderComplete();
        if (!StringUtil.isBlank((String)supplierCondition.getSupplier().getDefaultOrderRemark())) {
            o.setRemark(supplierCondition.getSupplier().getDefaultOrderRemark());
        }
        o.setClientOId(Long.valueOf(ADTO.getNextId()));
        o.setSupplier(supplierCondition.getSupplier());
        o.setUseTaxZone(Boolean.valueOf(supplierCondition.getCategoryTaxZone() != null));
        o.setTaxZone(supplierCondition.getCategoryTaxZone());
        o.setOrderDeliveryWindow(supplierCondition.getSupplier().getDefaultDeliveryWindow());
        o.setState(OrderStateE.PLACED);
        o.setReviewState(OrderReviewStateE.UNCHECKED);
        o.getEligibleLocations().add(this.currentUser.getDefaultLocation());
        o.setOrderDate(new Date(System.currentTimeMillis()));
        o.setDeliveryDate(new Date(System.currentTimeMillis() + oneDay));
        o.setCostCenter(department);
        if (this.customerOwnedOnly != null) {
            o.setCustomerOwnedOnly(Boolean.valueOf(this.customerOwnedOnly.getElement().getSelectedItem() == Words.CUSTOMER_OWNED));
        } else {
            o.setCustomerOwnedOnly(null);
        }
        if (this.halalOrder != null) {
            if (this.halalOrder.getElement().getSelectedItem().equals(Words.HALAL_ONLY)) {
                o.setHalalOrder(Boolean.valueOf(true));
            } else if (this.halalOrder.getElement().getSelectedItem().equals(Words.NOT_HALAL_ONLY)) {
                o.setHalalOrder(Boolean.valueOf(false));
            } else {
                o.setHalalOrder(null);
            }
        } else {
            o.setHalalOrder(null);
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)o, false, false);
        return n;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.isLoading = true;
        if (n.getValue() != null) {
            if (n != null) {
                new BasicArticleLoader((BasicArticleReference)n.getValue(BasicArticleLight.class), this, n, this);
            } else {
                this.remoteObjectLoaded(n);
            }
        } else {
            this.articleInfo.setEnabled(false);
            this.quantity.setEnabled(false);
            this.supplier.setEnabled(false);
            this.add.setEnabled(false);
        }
    }

    private Node getSupplierList(BasicArticleComplete ac) {
        ViewNode n = new ViewNode("");
        for (SupplierConditionBaseComplete base : ac.getSuppliers()) {
            Timestamp validity = new Timestamp(System.currentTimeMillis());
            for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                for (SupplierConditionComplete sc : category.getConditions()) {
                    if (sc.getValidity().getStartDate().getTime() > validity.getTime() || sc.getValidity().getEndDate().getTime() < validity.getTime() || !Boolean.TRUE.equals(sc.getCanBeOrdered()) || !Boolean.TRUE.equals(sc.getSupplier().getUseForOrder())) continue;
                    Node nn = INodeCreator.getDefaultImpl().getNode4DTO((Object)sc, true, false);
                    DTOProxyNode nnn = new DTOProxyNode(nn);
                    n.addChild((Node)nnn, 0L);
                }
            }
        }
        return n;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.artC = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
        if (this.artC == null) {
            if (node.getValue(BasicArticleLight.class) != null) {
                BasicArticleLight artL = (BasicArticleLight)node.getValue(BasicArticleLight.class);
                new BasicArticleLoader((BasicArticleReference)artL, this, node, this);
                return;
            }
            return;
        }
        if (this.supplier == null) {
            return;
        }
        this.supplier.setArticle(this.artC);
        this.articleInfo.installStringViewer(ArticleToolkit.getArticleInfoPopupString(this.artC, new Timestamp(System.currentTimeMillis()), 373065, false));
        Long amount = 0L;
        boolean hasFocusAlready = false;
        if (this.quantity.getElement().getTextField().getTextField().hasFocus()) {
            hasFocusAlready = true;
            amount = (Long)this.quantity.getElement().getValueNode().getValue();
        }
        StoreQuantityComplete q = new StoreQuantityComplete();
        q.setClientOId(Long.valueOf(q.getNextId()));
        q.setAmount(amount);
        q.setUnit(this.artC.getMainStoreUnit());
        this.quantity.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false));
        this.supplier.getModel().selectRow(null, false, false, 3);
        this.supplier.getModel().setNode(this.getSupplierList(this.artC));
        this.quantity.getElement().getValueNode().addNodeListener((NodeListener)this);
        this.quantity.getElement().getUnitNode().addNodeListener((NodeListener)this);
        SupplierConditionComplete supplierConditionComplete = this.ensureCheapestSupplier();
        List possibleUnits = StoreToolkit.getPossibleUnits((BasicArticleLight)this.artC, (SupplierConditionComplete)supplierConditionComplete, (Timestamp)new Timestamp(System.currentTimeMillis()), (TransactionType)TransactionType.PURCHASE, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
        this.quantity.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(possibleUnits));
        this.setEnabled(true);
        this.createFocusCycle();
        if (hasFocusAlready) {
            this.quantity.getElement().getTextField().setTextSelected();
        } else {
            this.quantity.getElement().requestFocusInWindowNow();
        }
        this.isLoading = false;
        this.supplier.resortTable();
    }

    private SupplierConditionComplete ensureCheapestSupplier() {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (this.quantity != null) {
            SupplierConditionComplete cheapestSupplier = ArticleToolkit.getCheapestSupplier(this.artC, (Node<UnitComplete>)this.quantity.getElement().getUnitNode(), (Node<Object>)this.quantity.getElement().getValueNode(), false, null, settings, this, this.accessor, new Timestamp(System.currentTimeMillis()));
            if (cheapestSupplier != null) {
                for (Table2RowPanel r : this.supplier.getRows()) {
                    if (!r.getModel().getNode().getValue().equals(cheapestSupplier)) continue;
                    r.setSelected(3);
                }
            } else {
                InnerPopupFactory.showErrorDialog("Unable to find Supplier for Article " + (this.artC != null ? this.artC.getName() : ""), (Component)this);
            }
            return cheapestSupplier;
        }
        return null;
    }

    public void setArticleListNode(Node articleListNode) {
        this.articleList = articleListNode;
        this.table.getModel().setNode(this.articleList);
    }

    public void setOrderListNode(Node<List<PurchaseOrderPreviewComplete>> orderList) {
        this.orderList = orderList;
    }

    public void switchSuppliers(Node node, SupplierConditionComplete oldSupplier, SupplierConditionComplete newSupplier, Boolean newUseTaxZone, TaxZoneComplete newTaxZone) {
        Node oldOne = this.getOrderNode4Supplier(oldSupplier, null);
        Node newOne = null;
        if (newSupplier != null) {
            newOne = this.getOrderNode4Supplier(newSupplier, null);
        }
        Node currentNode = node;
        this.removeReferenceNode(oldOne, currentNode);
        if (newOne != null) {
            newOne.getChildNamed(this.getPositionField()).addChild((Node)new DTOProxyNode(currentNode), 0L);
            SupplierConditionComplete newSupplierCondition = CopyTemplateToolkit.copySupplierCondition((SupplierConditionComplete)newSupplier);
            node.getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).setValue((Object)newSupplierCondition, 0L);
        }
    }

    private void removeReferenceNode(Node order, Node position) {
        Node n;
        HashSet<Node> foundOrders = new HashSet<Node>();
        Iterator it = order.getChildNamed(this.getPositionField()).getFailSafeChildIterator();
        while (it.hasNext()) {
            n = (Node)it.next();
            if (!n.getValue().equals(position.getValue())) continue;
            order.getChildNamed(this.getPositionField()).removeChild(n, System.currentTimeMillis());
            foundOrders.add(order);
        }
        it = this.orderList.getFailSafeChildIterator();
        while (it.hasNext()) {
            n = (Node)it.next();
            Iterator it2 = n.getChildNamed(this.getPositionField()).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node nn = (Node)it2.next();
                if (!nn.getValue().equals(position.getValue())) continue;
                n.getChildNamed(this.getPositionField()).removeChild(nn, System.currentTimeMillis());
                foundOrders.add(n);
            }
        }
        for (Node o : foundOrders) {
            if (o.getChildNamed(this.getPositionField()).getChildCount() != 0) continue;
            o.getParent().removeChild(o, System.currentTimeMillis());
        }
    }

    private Node getSupplierList(Node article, Node currentSupplierCondition) {
        SupplierConditionComplete selectedCondition = currentSupplierCondition != null ? (SupplierConditionComplete)currentSupplierCondition.getValue() : null;
        ViewNode nn = new ViewNode("");
        Timestamp validity = new Timestamp(System.currentTimeMillis());
        Iterator it = article.getChildNamed(BasicArticleComplete_.suppliers).getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            for (SupplierConditionCategoryComplete category : ((SupplierConditionBaseComplete)n.getValue()).getSupplierConditionCategory()) {
                for (SupplierConditionComplete condition : category.getConditions()) {
                    Node currentArticle;
                    DTOProxyNode child;
                    if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    if (selectedCondition != null && condition.equals((Object)selectedCondition.getOriginCondition())) {
                        child = new DTOProxyNode((Object)selectedCondition);
                        currentArticle = child.getChildNamed(new String[]{"currentArticle"});
                        if (currentArticle == null) {
                            currentArticle = new DTOProxyNode(article);
                            currentArticle.setName("currentArticle");
                            child.addChild(currentArticle, 0L);
                        }
                        nn.addChild((Node)child, 0L);
                        continue;
                    }
                    child = new DTOProxyNode((Object)condition);
                    currentArticle = child.getChildNamed(new String[]{"currentArticle"});
                    if (currentArticle == null) {
                        currentArticle = new DTOProxyNode(article);
                        currentArticle.setName("currentArticle");
                        child.addChild(currentArticle, 0L);
                    }
                    nn.addChild((Node)child, 0L);
                }
            }
        }
        return nn;
    }

    @Override
    public void resetData() {
        this.table.getModel().getNode().removeAllChilds();
    }

    public void valueChanged(Node<?> node) {
        this.ensureCheapestSupplier();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void enterPressed(Enterable source) {
        this.addArticle();
    }

    public boolean isSwingOnly() {
        return true;
    }

    public CurrencyVariantAccessor getAccessor() {
        return this.accessor;
    }

    public void setAccessor(CurrencyVariantAccessor accessor) {
        this.accessor = accessor;
    }

    public void createOrders(TextButton button, Node node, OrderBreadCrumpPanel orderBreadCrumpPanel, LoadingAnimation anim, boolean send, boolean printRec, boolean printOrder) {
        ((ManualOrderCreatorDataHandler)orderBreadCrumpPanel.getDataHandler()).createOrders(button, node, orderBreadCrumpPanel, anim, send, printRec, printOrder);
    }

    public StoreQuantityComplete convertBestUnit(double sourceAmount, UnitComplete unit, BasicArticleComplete article, SupplierConditionComplete scc, Timestamp validity) {
        boolean flag = false;
        int count = 0;
        double value = 0.0;
        if (sourceAmount == 0.0) {
            InnerPopupFactory.showErrorDialog("Selected value > 0.", (Component)this);
            return null;
        }
        if (scc.getMinOrderAmountIsMandatory().booleanValue()) {
            value = UnitConversionToolkit.convertUnit((UnitComplete)unit, (UnitComplete)scc.getMinOrderAmountUnit(), (double)sourceAmount, (BasicArticleComplete)article, (SupplierConditionComplete)scc, (Timestamp)validity);
            if (value < scc.getMinOrderAmount()) {
                InnerPopupFactory.showErrorDialog("Selected MinOrderAmount/MinOrderAmountUnit (" + scc.getMinOrderAmount() + " " + scc.getMinOrderAmountUnit() + ") is not reached (" + value + " " + scc.getMinOrderAmountUnit() + "). Please change value.", (Component)this);
                return null;
            }
            long l = (long)value;
            double v = value - (double)((long)value);
            if (value - (double)((long)value) != 0.0) {
                InnerPopupFactory.showErrorDialog("Selected MinOrderAmount/MinOrderAmountUnit (" + value + " " + scc.getMinOrderAmountUnit() + ") is not whole-number. Please change value.", (Component)this);
                return null;
            }
        } else {
            Collections.sort(scc.getPackingQuantities());
            while (!flag && scc.getPackingQuantities().get(count) != null) {
                value = UnitConversionToolkit.convertUnit((UnitComplete)unit, (UnitComplete)((PackagingQuantityComplete)scc.getPackingQuantities().get(count)).getUnit(), (double)sourceAmount, (BasicArticleComplete)article, (SupplierConditionComplete)scc, (Timestamp)validity);
                if (value - (double)((long)value) == 0.0) {
                    flag = true;
                    continue;
                }
                ++count;
            }
        }
        return new StoreQuantityComplete(Long.valueOf((long)value), ((PackagingQuantityComplete)scc.getPackingQuantities().get(count)).getUnit());
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    ItemListener {
        private static final long serialVersionUID = 1L;
        private TextLabel aName;
        private QuantityRenderer calc;
        private QuantityRenderer onStock;
        private InputComboBox2 aQuantity;
        private Component aSupplier;
        private DeleteButton delete;
        private InfoButton info;
        private SupplierConditionComplete currentSupplier;

        public TableRowImpl(Table2RowModel m) {
            BasicArticleComplete ac;
            PurchaseOrderPositionPreviewComplete preview;
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            boolean isPersistedPreview = false;
            if (m.getNode().getValue() instanceof PurchaseOrderPositionPreviewComplete && (preview = (PurchaseOrderPositionPreviewComplete)m.getNode().getValue()).getId() != null) {
                isPersistedPreview = true;
            }
            if (isPersistedPreview) {
                this.aName = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionPreviewComplete_.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
                this.aQuantity = new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
                this.info = new InfoButton();
                this.currentSupplier = (SupplierConditionComplete)m.getNode().getChildNamed(PurchaseOrderPositionPreviewComplete_.supplierCondition).getValue();
                this.info.installStringViewer(ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)m.getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class), new Timestamp(System.currentTimeMillis()), 373065, false));
                ac = (BasicArticleComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionPreviewComplete_.article).getValue(BasicArticleComplete.class);
                List list = UnitConversionToolkit.getPossibleUnits((BasicArticleLight)ac, (Timestamp)new Timestamp(System.currentTimeMillis()), (boolean)ArticleDetailsPanel.this.allUnitsAllowed, (SystemSettingsComplete)ArticleDetailsPanel.this.settings);
                this.aQuantity.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
                this.aQuantity.setNode(m.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionPreviewComplete_.quantity, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionPreviewComplete_.quantity, StoreQuantityComplete_.unit}));
                this.aSupplier = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionPreviewComplete_.supplierCondition), ConverterRegistry.getConverter(SupplierConditionPreviewOrderCostsConverter.class));
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.setLayout(new InnerLayout());
                this.calc = new QuantityRenderer(null);
                this.onStock = new QuantityRenderer(null);
                this.add(this.aName);
                this.add(this.info);
                this.add(this.aQuantity);
                this.add(this.aSupplier);
                this.add(this.delete);
                this.add(this.calc);
                this.add(this.onStock);
            } else {
                this.aName = new TextLabel(m.getNode().getChildNamed(new String[]{"article"}), ConverterRegistry.getConverter(BasicArticleConverter.class));
                this.aQuantity = new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
                this.currentSupplier = (SupplierConditionComplete)m.getNode().getChildNamed(new String[]{"supplier"}).getValue();
                this.info = new InfoButton();
                this.info.installStringViewer(ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)m.getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class), new Timestamp(System.currentTimeMillis()), 373065, false));
                if (this.currentSupplier != null && Boolean.TRUE.equals(this.currentSupplier.getUsePackingQuantity())) {
                    List list = UnitConversionToolkit.getPossibleUnits((List)this.currentSupplier.getPackingQuantities());
                    this.aQuantity.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
                } else {
                    ac = (BasicArticleComplete)this.model.getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class);
                    List possibleUnits = StoreToolkit.getPossibleUnits((BasicArticleLight)ac, (SupplierConditionComplete)this.currentSupplier, (Timestamp)new Timestamp(System.currentTimeMillis()), (TransactionType)TransactionType.PURCHASE, (UserComplete)ArticleDetailsPanel.this.currentUser, null, null, (SystemSettingsComplete)ArticleDetailsPanel.this.settings);
                    this.aQuantity.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(possibleUnits));
                }
                this.aQuantity.setNode(m.getNode().getChildNamed(new String[]{"quantity-amount"}), m.getNode().getChildNamed(new String[]{"quantity-unit"}));
                this.aSupplier = new ComboBox(m.getNode().getChildNamed(new String[]{"supplier"}), ArticleDetailsPanel.this.getSupplierList(m.getNode().getChildNamed(new String[]{"article"}), m.getNode().getChildNamed(new String[]{"supplier"})), ConverterRegistry.getConverter(SupplierConditionOrderCostsConverter.class));
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                ((ComboBox)this.aSupplier).addItemListener(this);
                this.setLayout(new InnerLayout());
                this.calc = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(new String[]{"calcQty"}));
                this.onStock = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(new String[]{"stockQty"}));
                this.add(this.aName);
                this.add(this.info);
                this.add(this.aQuantity);
                this.add(this.aSupplier);
                this.add(this.delete);
                this.add(this.calc);
                this.add(this.onStock);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                ArticleDetailsPanel.this.switchSuppliers(this.model.getNode(), this.currentSupplier, null, null, null);
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (!ArticleDetailsPanel.this.isBlocked) {
                    Node n = (Node)e.getItem();
                    SupplierConditionComplete newCondition = (SupplierConditionComplete)n.getValue();
                    ArticleDetailsPanel.this.switchSuppliers(this.model.getNode(), this.currentSupplier, newCondition, newCondition.getCategoryTaxZone() != null, newCondition.getCategoryTaxZone());
                    this.currentSupplier = newCondition;
                } else if (ArticleDetailsPanel.this.isBlocked) {
                    SupplierConditionComplete newCondition;
                    Node n = (Node)e.getItem();
                    this.currentSupplier = newCondition = (SupplierConditionComplete)n.getValue();
                }
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.aQuantity);
            if (this.aSupplier instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.aSupplier));
            }
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.aName.setEnabled(isEnabled);
            this.aQuantity.setEnabled(isEnabled);
            this.aSupplier.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
            this.info.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.aName.kill();
            this.aQuantity.kill();
            if (this.aSupplier instanceof Killable) {
                ((Killable)((Object)this.aSupplier)).kill();
            }
            this.delete.kill();
            this.info.kill();
            this.aName = null;
            this.aQuantity = null;
            this.aSupplier = null;
            this.delete = null;
            this.info = null;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.aName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)((double)parent.getHeight() - TableRowImpl.this.aName.getPreferredSize().getHeight()));
                TableRowImpl.this.aName.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.info.getPreferredSize().getWidth())), (int)TableRowImpl.this.aName.getPreferredSize().getHeight());
                TableRowImpl.this.info.setLocation(TableRowImpl.this.aName.getX() + TableRowImpl.this.aName.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.info.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.info.setSize(TableRowImpl.this.info.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.calc.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.calc.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.calc.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.calc.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.onStock.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.onStock.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.onStock.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.onStock.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.aQuantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.aQuantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.aQuantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.aQuantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.aSupplier.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.aSupplier.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.aSupplier.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.aSupplier.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.delete.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            int aw = parent.getWidth() - (5 * ArticleDetailsPanel.this.horizontalBorder + 5);
            aw = (int)((double)aw - ArticleDetailsPanel.this.articleInfo.getPreferredSize().getWidth());
            aw = (int)((double)aw - ArticleDetailsPanel.this.quantity.getPreferredSize().getWidth());
            aw -= 350;
            if ((aw = (int)((double)aw - ArticleDetailsPanel.this.add.getPreferredSize().getWidth())) > 450) {
                aw = 450;
            }
            ArticleDetailsPanel.this.articleSearchConfiguration.setLocation(ArticleDetailsPanel.this.horizontalBorder, (int)((double)ArticleDetailsPanel.this.verticalBorder + ArticleDetailsPanel.this.articleSearch.getPreferredSize().getHeight() - 23.0));
            ArticleDetailsPanel.this.articleSearchConfiguration.setSize(25, 25);
            ArticleDetailsPanel.this.articleSearch.setLocation(ArticleDetailsPanel.this.articleSearchConfiguration.getX() + ArticleDetailsPanel.this.articleSearchConfiguration.getWidth(), ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.articleSearch.setSize(aw, (int)ArticleDetailsPanel.this.articleSearch.getPreferredSize().getHeight());
            int cy = ArticleDetailsPanel.this.articleSearch.getY() + ArticleDetailsPanel.this.articleSearch.getHeight();
            if (ArticleDetailsPanel.this.customerOwnedOnly != null) {
                ArticleDetailsPanel.this.customerOwnedOnly.setLocation(ArticleDetailsPanel.this.articleSearch.getX(), ArticleDetailsPanel.this.articleSearch.getY() + ArticleDetailsPanel.this.articleSearch.getHeight() + ArticleDetailsPanel.this.verticalBorder);
                ArticleDetailsPanel.this.customerOwnedOnly.setSize(200, (int)ArticleDetailsPanel.this.customerOwnedOnly.getPreferredSize().getHeight());
                cy = ArticleDetailsPanel.this.customerOwnedOnly.getY() + ArticleDetailsPanel.this.customerOwnedOnly.getHeight();
            }
            if (ArticleDetailsPanel.this.halalOrder != null) {
                ArticleDetailsPanel.this.halalOrder.setLocation(ArticleDetailsPanel.this.articleSearch.getX(), cy + ArticleDetailsPanel.this.verticalBorder);
                ArticleDetailsPanel.this.halalOrder.setSize(200, (int)ArticleDetailsPanel.this.halalOrder.getPreferredSize().getHeight());
            }
            ArticleDetailsPanel.this.articleInfo.setLocation(ArticleDetailsPanel.this.articleSearch.getX() + ArticleDetailsPanel.this.articleSearch.getWidth() + 5, (int)((double)(ArticleDetailsPanel.this.articleSearch.getY() + ArticleDetailsPanel.this.articleSearch.getHeight()) - (ArticleDetailsPanel.this.articleInfo.getPreferredSize().getHeight() + 3.0)));
            ArticleDetailsPanel.this.articleInfo.setSize(ArticleDetailsPanel.this.articleInfo.getPreferredSize());
            ArticleDetailsPanel.this.quantity.setLocation(ArticleDetailsPanel.this.articleInfo.getX() + ArticleDetailsPanel.this.articleInfo.getWidth() + ArticleDetailsPanel.this.horizontalBorder, ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.quantity.setSize(ArticleDetailsPanel.this.quantity.getPreferredSize());
            ArticleDetailsPanel.this.supplier.setLocation(ArticleDetailsPanel.this.quantity.getX() + ArticleDetailsPanel.this.quantity.getWidth() + ArticleDetailsPanel.this.horizontalBorder, ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.supplier.setSize((int)((double)parent.getWidth() - ((double)ArticleDetailsPanel.this.supplier.getX() + ArticleDetailsPanel.this.add.getPreferredSize().getWidth() + (double)(2 * ArticleDetailsPanel.this.horizontalBorder))), 143);
            ArticleDetailsPanel.this.add.setLocation(ArticleDetailsPanel.this.supplier.getX() + ArticleDetailsPanel.this.supplier.getWidth() + ArticleDetailsPanel.this.horizontalBorder, (int)((double)(ArticleDetailsPanel.this.supplier.getY() + ArticleDetailsPanel.this.supplier.getHeight()) - ArticleDetailsPanel.this.add.getPreferredSize().getHeight()));
            ArticleDetailsPanel.this.add.setSize(ArticleDetailsPanel.this.add.getPreferredSize());
            ArticleDetailsPanel.this.table.setLocation(2, ArticleDetailsPanel.this.add.getY() + ArticleDetailsPanel.this.add.getHeight() + ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.table.setSize(parent.getWidth() - 4, parent.getHeight() - (ArticleDetailsPanel.this.table.getY() + 2));
        }
    }
}

