/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.quality.measurement.ccp0102;

import ch.icit.pegasus.client.converter.CCP0102MeasurementStateEConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.quality.measurement.ccp0102.CCP0102MeasurementModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.quality.measurement.ccp0102.details.MeasurementDetailsPanel;
import ch.icit.pegasus.client.gui.modules.quality.measurement.ccp0102.details.MeasurementDetailsPanel2;
import ch.icit.pegasus.client.gui.modules.quality.measurement.ccp0102.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.quality.measurement.ccp0102.details.SpecificationDetailsPanel2;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.CCP0102MeasurementSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102ConfigComplete_;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementLight;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementLight_;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.CCP0102MeasurementAccess;
import ch.icit.pegasus.server.core.dtos.search.CCP0102MeasurementSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.QualitySettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class CCP0102MeasurementModule
extends ScreenTableView<CCP0102MeasurementLight, CCP0102MeasurementSearchConfiguration.CCP_MEASUREMENT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    public final String FILTER_NAME = "number";
    public final String FILTER_DATE = "date";
    public final String FILTER_DEPARTMENT = "department";
    public final String FILTER_VALIDITY = "validity";
    public final String FILTER_STATE = "state";
    public final String FILTER_CUSTOMER = "customer";
    private String searchName;
    private PeriodComplete searchDate;
    private InternalCostCenterComplete searchDepartment;
    private Boolean searchValidity;
    private CCP0102MeasurementStateE searchState;
    private CustomerLight searchCustomer;
    private ComboBox departments;
    private ComboBox validityCombo;
    private ComboBox states;
    private TitledPeriodEditor periodChooser;

    public CCP0102MeasurementModule() {
        super(CCP0102MeasurementLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return CCP0102MeasurementAccess.CCP_MEASUREMENT_MODULE;
    }

    @Override
    public boolean isDeletable(RowModel<CCP0102MeasurementLight> model) {
        CCP0102MeasurementLight measurement = model.getDTO();
        return measurement.getCcpState() == CCP0102MeasurementStateE.Planned;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField("number", Words.NAME, "");
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodChooser = this.filterChain.addPeriodSelection("date", p.getStartDate(), p.getEndDate(), "", true);
        this.periodChooser.setCheckBoxEnabled();
        this.validityCombo = new ComboBox();
        this.validityCombo.addItem(Words.ALL);
        this.validityCombo.addItem(Words.VALID);
        this.validityCombo.addItem(Words.INVALID);
        this.validityCombo.setSelectedItem(Words.ALL);
        this.filterChain.addSelectionComboBox(this.validityCombo, 90, "validity", Words.VALIDITY, Words.ALL);
        this.states = new ComboBox();
        this.states.setViewConverter(ConverterRegistry.getConverter(CCP0102MeasurementStateEConverter.class));
        this.states.addItem(Words.ALL);
        this.states.setSelectedItem(Words.ALL);
        this.filterChain.addSelectionComboBox(this.states, 90, "state", Words.STATE, Words.ALL);
        this.departments = new ComboBox();
        this.departments.setViewConverter(ConverterRegistry.getConverter(DepartmentConverter.class));
        this.departments.addItem(Words.ALL);
        this.departments.setSelectedItem(Words.ALL);
        this.filterChain.addSelectionComboBox(this.departments, 90, "department", Words.DEPARTMENT, Words.ALL);
        this.filterChain.addCustomerSearchField("customer");
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<CCP0102MeasurementLight, CCP0102MeasurementSearchConfiguration.CCP_MEASUREMENT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchName = null;
            this.searchDate = null;
            this.searchDepartment = null;
            this.searchValidity = null;
            this.searchState = null;
            this.searchCustomer = null;
        } else if (name != null) {
            if (name.equals("number")) {
                this.searchName = (String)value;
            } else if (name.equals("date")) {
                TitledPeriodEditor ed = (TitledPeriodEditor)value;
                PeriodComplete per = new PeriodComplete();
                per.setStartDate(ed.getStartDate());
                per.setEndDate(ed.getEndDate());
                this.searchDate = per;
            } else if (name.equals("department")) {
                this.searchDepartment = value instanceof InternalCostCenterComplete ? (InternalCostCenterComplete)value : (value instanceof Node ? (InternalCostCenterComplete)((Node)value).getValue() : null);
            } else if (name.equals("validity")) {
                this.searchValidity = value.equals(Words.VALID) ? Boolean.valueOf(true) : (value.equals(Words.INVALID) ? Boolean.valueOf(false) : null);
            } else if (name.equals("state")) {
                this.searchState = value instanceof CCP0102MeasurementStateE ? (CCP0102MeasurementStateE)value : (value instanceof Node ? (CCP0102MeasurementStateE)((Node)value).getValue() : null);
            } else if (name.equals("customer")) {
                this.searchCustomer = value instanceof CustomerLight ? (CustomerLight)value : (value instanceof Node ? (CustomerLight)((Node)value).getValue() : null);
            }
        }
        CCP0102MeasurementSearchConfiguration c = new CCP0102MeasurementSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setName(this.searchName);
        c.setDepartment(this.searchDepartment);
        c.setValidity(this.searchValidity);
        c.setCustomer(this.searchCustomer);
        c.setMeasurementState(this.searchState);
        if (this.searchDate != null) {
            c.setSearchPeriod(this.searchDate);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.departments.refreshPossibleValues(NodeToolkit.getAffixList(InternalCostCenterComplete.class));
        this.departments.addItem(Words.ALL);
        this.departments.setSelectedItem(Words.ALL);
        this.states.refreshPossibleValues(NodeToolkit.getAffixList(CCP0102MeasurementStateE.class));
        this.states.addItem(Words.ALL);
        this.states.setSelectedItem(Words.ALL);
    }

    @Override
    public SearchAlgorithm<CCP0102MeasurementLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(CCP0102MeasurementSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<CCP0102MeasurementLight> model) {
        try {
            if (model == null || model.getNode() == null || model.getNode().getValue() == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return model != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<CCP0102MeasurementLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<CCP0102MeasurementLight> rowEditor = new MessageProvidedRowEditor<CCP0102MeasurementLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            QualitySettingsComplete settings = (QualitySettingsComplete)NodeToolkit.getAffixClass(QualitySettingsComplete.class).getValue();
            if (Boolean.TRUE.equals(settings.getUseCCP02Generator())) {
                SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<CCP0102MeasurementLight>)rowEditor, p);
                MeasurementDetailsPanel d2 = new MeasurementDetailsPanel((RowEditor<CCP0102MeasurementLight>)rowEditor, p);
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                rowEditor.addToFocusQueue(d1);
                rowEditor.addToFocusQueue(d2);
            } else {
                SpecificationDetailsPanel2 d1 = new SpecificationDetailsPanel2((RowEditor<CCP0102MeasurementLight>)rowEditor, p);
                MeasurementDetailsPanel2 d2 = new MeasurementDetailsPanel2((RowEditor<CCP0102MeasurementLight>)rowEditor, p);
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                rowEditor.addToFocusQueue(d1);
                rowEditor.addToFocusQueue(d2);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new CCP0102MeasurementModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STATE, "", (Class)DefaultObject2ObjectConverter.class, null, CCP0102MeasurementLight_.ccpState, TableColumnInfo.state3WithExpandWidth));
        columns.add(new TableColumnInfo(Words.NAME, "", StringConverter.class, null, CCP0102MeasurementLight_.name, 150, Integer.MAX_VALUE, 150));
        columns.add(new TableColumnInfo(Words.PRODUCTION_DATE, "", (Class)DateConverter.class, (Enum<?>)CCP0102MeasurementSearchConfiguration.CCP_MEASUREMENT_COLUMN.DATE, CCP0102MeasurementLight_.productionDate, TableColumnInfo.dateColumnWidth));
        columns.add(new TableColumnInfo(Words.DEPARTMENT, "", (Class)DepartmentConverter.class, null, "#" + CCP0102MeasurementLight_.baseConfig.getName() + "-" + CCP0102ConfigComplete_.department.getName(), 150));
        columns.add(new TableColumnInfo(Words.FLIGHT_PERIOD, "", (Class)PeriodConverter.class, null, CCP0102MeasurementLight_.period, TableColumnInfo.periodColumnWidth * 2));
        return columns;
    }
}

