/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.FileReferenceConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.PreparationGroupConverter;
import ch.icit.pegasus.client.converter.RecipeCategoryConverter;
import ch.icit.pegasus.client.converter.RecipeStateEWithWarningConverter;
import ch.icit.pegasus.client.converter.RecipeVariantPriceConverter;
import ch.icit.pegasus.client.converter.RecipeVariantPriceInKgConverter;
import ch.icit.pegasus.client.converter.SingleRecipeCategoryConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.article.details.ContentDetailsPanel;
import ch.icit.pegasus.client.gui.modules.recipe.RecipeModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.recipe.details.CommentDetailsPanel;
import ch.icit.pegasus.client.gui.modules.recipe.details.ComponentsAssemblyDetailsPanel;
import ch.icit.pegasus.client.gui.modules.recipe.details.ProcessCostsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.recipe.details.RecipeBasicDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.recipe.details.TemplateDetailsPanel;
import ch.icit.pegasus.client.gui.modules.recipe.details.VariantBasicDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.recipe.details.VariantDetailsPanel;
import ch.icit.pegasus.client.gui.modules.recipe.details.utils.GroupLoader;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.VariantMessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.RecipeSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AdditiveCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AllergenCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.OtherCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PreparationGroupComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AdditiveDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AdditiveDeclarationComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.AllergenDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AllergenDeclarationComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.OtherDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.OtherDeclarationComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RecipeAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ServiceItemAccess;
import ch.icit.pegasus.server.core.dtos.search.ARecipeSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.RecipeSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

public class RecipeModule
extends ScreenTableView<RecipeComplete, ARecipeSearchConfiguration.RECIPE_COLUMN>
implements ItemListener,
Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_RECIPE_NAME = "RecipeName";
    private static final String FILTER_TYPE1 = "Category";
    private static final String FILTER_TYPE2 = "Category2";
    private static final String FILTER_STATE = "State";
    private static final String FILTER_DEPARTMENT = "department";
    private static final String FILTER_VALIDATION = "validation";
    private static final String FILTER_HALAL = "halal";
    private static final String FILTER_PREPARATION_GROUP = "preparationGroup";
    private static final String FILTER_CUSTOMER = "customer";
    private String filterValue1;
    private RecipeCategoryLight filterValue2;
    private RecipeCategoryLight filterValue3;
    private ModificationStateE filterValue4;
    private CostCenterComplete filterCostCenter;
    private Boolean validationFilter;
    private Boolean halalFilter;
    private PreparationGroupComplete preparationFilter;
    private CustomerLight selectedCustomer;
    private ComboBox validationCombo;
    private ComboBox mainCatCombo;
    private ComboBox subCatCombo;
    private ComboBox departments;
    private ComboBox preparationGroup;

    public RecipeModule() {
        super(RecipeComplete.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.mainCatCombo.kill();
        this.subCatCombo.kill();
        this.departments.kill();
        if (this.validationCombo != null) {
            this.validationCombo.kill();
        }
        if (this.preparationGroup != null) {
            this.preparationGroup.kill();
        }
        this.mainCatCombo = null;
        this.subCatCombo = null;
        this.departments = null;
        this.validationCombo = null;
        this.preparationGroup = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return RecipeAccess.MODULE_RECIPE;
    }

    public String getSearchName() {
        return Words.RECIPE_NAME_OR_NUMBER;
    }

    public boolean isServiceItem() {
        return false;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", ARecipeSearchConfiguration.RECIPE_COLUMN.NUMBER + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        this.filterChain.addSearchField(FILTER_RECIPE_NAME, Words.NUMBER_OR_NAME, "");
        this.mainCatCombo = new ComboBox();
        this.mainCatCombo.addItem(Words.ALL);
        this.mainCatCombo.addItemListener(this);
        this.mainCatCombo.setViewConverter(ConverterRegistry.getConverter(SingleRecipeCategoryConverter.class));
        this.filterChain.addSelectionComboBox(this.mainCatCombo, FILTER_TYPE1, Words.MAIN_CATEGORY, Words.ALL);
        this.subCatCombo = new ComboBox();
        this.subCatCombo.addItem(Words.ALL);
        this.mainCatCombo.setViewConverter(ConverterRegistry.getConverter(SingleRecipeCategoryConverter.class));
        this.filterChain.addSelectionComboBox(this.subCatCombo, FILTER_TYPE2, Words.SUB_CATEGORY, Words.ALL);
        this.filterChain.addModificationStateComboBox(FILTER_STATE);
        this.departments = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.departments, FILTER_DEPARTMENT, Words.COSTCENTER, Words.ALL);
        if (!isNoPro) {
            this.validationCombo = ComboBoxFactory.getRecipeValidationCombo(true);
            this.filterChain.addSelectionComboBox(this.validationCombo, 130, FILTER_VALIDATION, Words.YIELD_VALIDATION, Words.ALL);
            ComboBox halalCombo = ComboBoxFactory.getYesNoComboBox(true);
            this.filterChain.addSelectionComboBox(halalCombo, FILTER_HALAL, Words.HALAL, Words.ALL);
            this.preparationGroup = new ComboBox(null, null, ConverterRegistry.getConverter(PreparationGroupConverter.class));
            this.filterChain.addSelectionComboBox(this.preparationGroup, FILTER_PREPARATION_GROUP, Words.GROUP, Words.ALL);
        }
        this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<RecipeComplete, ARecipeSearchConfiguration.RECIPE_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterValue1 = null;
            this.filterValue2 = null;
            this.filterValue3 = null;
            this.filterValue4 = null;
            this.filterCostCenter = null;
            this.validationFilter = null;
            this.halalFilter = null;
            this.preparationFilter = null;
            this.selectedCustomer = null;
        } else if (name == FILTER_RECIPE_NAME) {
            this.filterValue1 = (String)value;
        } else if (name == FILTER_CUSTOMER) {
            Node n;
            this.selectedCustomer = value instanceof CustomerLight ? (CustomerLight)value : (value instanceof Node ? ((n = (Node)value).getValue() instanceof CustomerLight ? (CustomerLight)n.getValue() : null) : null);
        } else if (name == FILTER_TYPE1) {
            if (value instanceof RecipeCategoryLight) {
                this.filterValue2 = (RecipeCategoryLight)value;
                this.filterValue3 = null;
            } else if (value instanceof Node) {
                if (((Node)value).getValue() instanceof RecipeCategoryLight) {
                    this.filterValue2 = (RecipeCategoryLight)((Node)value).getValue();
                    this.filterValue3 = null;
                }
            } else {
                this.filterValue2 = null;
                this.filterValue3 = null;
            }
        } else if (name == FILTER_TYPE2) {
            if (value instanceof RecipeCategoryLight) {
                this.filterValue3 = (RecipeCategoryLight)value;
            } else if (value instanceof Node) {
                if (((Node)value).getValue() instanceof RecipeCategoryLight) {
                    this.filterValue3 = (RecipeCategoryLight)((Node)value).getValue();
                }
            } else {
                this.filterValue3 = null;
            }
        } else if (name == FILTER_STATE) {
            this.filterValue4 = value instanceof ModificationStateE ? (ModificationStateE)value : null;
        } else if (name == FILTER_DEPARTMENT) {
            this.filterCostCenter = value instanceof Node ? (CostCenterComplete)((Node)value).getValue() : (value instanceof InternalCostCenterComplete ? (InternalCostCenterComplete)value : null);
        } else if (name == FILTER_VALIDATION) {
            this.validationFilter = Words.VALID.equals(value) ? Boolean.valueOf(false) : (Words.HAS_WARNINGS.equals(value) ? Boolean.valueOf(true) : null);
        } else if (name == FILTER_HALAL) {
            this.halalFilter = Words.NO_ANSWER.equals(value) ? Boolean.valueOf(false) : (Words.YES.equals(value) ? Boolean.valueOf(true) : null);
        } else if (name == FILTER_PREPARATION_GROUP) {
            this.preparationFilter = value instanceof PreparationGroupComplete ? (PreparationGroupComplete)value : (value instanceof Node ? (((Node)value).getValue() instanceof PreparationGroupComplete ? (PreparationGroupComplete)((Node)value).getValue() : null) : null);
        }
        RecipeSearchConfiguration c = new RecipeSearchConfiguration();
        c.setFirstLevelCategory((RecipeCategoryReference)this.filterValue2);
        c.setSecondLevelCategory((RecipeCategoryReference)this.filterValue3);
        c.setNumResults(this.numberOfShownResults);
        c.setState(this.filterValue4);
        c.setServiceItem(Boolean.valueOf(this.isServiceItem()));
        c.setDefaultCostCenter(this.filterCostCenter);
        c.setHasWarnings(this.validationFilter);
        c.setHalal(this.halalFilter);
        c.setPreparationGroup(this.preparationFilter);
        c.setCustomer((CustomerReference)this.selectedCustomer);
        String v = this.filterValue1;
        if (v != null) {
            try {
                Integer a = Integer.valueOf(v.trim());
                c.setNumber(a);
                c.setName(null);
            }
            catch (NumberFormatException e) {
                c.setNumber(null);
                c.setName(v);
            }
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    private void fillTypeFilterChain(Node n) {
        Node cats = NodeToolkit.getAffixList(RecipeCategoryComplete.class);
        this.mainCatCombo.refreshPossibleValues(cats);
        this.mainCatCombo.addItem(Words.ALL);
        this.mainCatCombo.setSelectedItem(Words.ALL);
        this.mainCatCombo.addItemListener(this);
        this.itemStateChanged(new ItemEvent(this.mainCatCombo, (int)System.currentTimeMillis(), null, 1));
        this.subCatCombo.setSelectedItem(Words.ALL);
        if (this.preparationGroup != null) {
            this.preparationGroup.refreshPossibleValues(NodeToolkit.getAffixList(PreparationGroupComplete.class));
            this.preparationGroup.addItem(Words.ALL);
            this.preparationGroup.setSelectedItem(Words.ALL);
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.fillTypeFilterChain(null);
        this.departments.refreshPossibleValues(ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), null, ComboBoxFactory.DepartmentType.PRODUCTION));
        this.departments.addItem(Words.ALL);
        this.departments.setSelectedItem(Words.ALL);
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<RecipeComplete> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(RecipeSearchAlgorithm.class);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.mainCatCombo.getSelectedItem() instanceof Node && this.filterChain != null) {
            Node d = (Node)this.mainCatCombo.getSelectedItem();
            this.filterChain.setBlind(true);
            this.subCatCombo.removeAllItems();
            this.subCatCombo.setViewConverter(ConverterRegistry.getConverter(SingleRecipeCategoryConverter.class));
            this.subCatCombo.refreshPossibleValues(d.getChildNamed(new String[]{"subCategories"}));
            this.subCatCombo.addItem(Words.ALL);
            this.subCatCombo.setSelectedItem(Words.ALL);
            this.filterChain.setBlind(false);
        } else if (this.filterChain != null) {
            this.filterChain.setBlind(true);
            this.subCatCombo.removeAllItems();
            this.subCatCombo.addItem(Words.ALL);
            this.filterChain.setBlind(false);
        }
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<RecipeComplete> model) {
        return (screen.getInvokingName().toLowerCase().contains(RecipeAccess.PRINT_RECIPE_EAN_SHEET.getIdentifier()) || screen.getInvokingName().toLowerCase().contains(RecipeAccess.EXPORT_ARTICLE_BY_RECIPE.getIdentifier()) || screen.getInvokingName().toLowerCase().contains(RecipeAccess.PRINT_RECIPE_CHARGE_TRANSACTIONS.getIdentifier()) || screen.getInvokingName().toLowerCase().contains(RecipeAccess.PRINT_RECIPE_FACT_SHEET.getIdentifier()) || screen.getInvokingName().toLowerCase().contains(RecipeAccess.PRINT_RECIPE_USAGE.getIdentifier()) || screen.getInvokingName().toLowerCase().contains(ServiceItemAccess.PRINT_SERVICE_ITEM_SHEET.getIdentifier()) || screen.getInvokingName().toLowerCase().contains(ServiceItemAccess.PRINT_SERVICE_ITEM_USAGE.getIdentifier()) || screen.getInvokingName().toLowerCase().contains(RecipeAccess.PRINT_RECIPE_CHARGE_STOCK.getIdentifier()) || screen.getInvokingName().toLowerCase().contains(RecipeAccess.INFO_RECIPE_CHANGELOG.getIdentifier())) && model != null;
    }

    @Override
    public boolean isDeletable(RowModel<RecipeComplete> model) {
        RecipeComplete recipe = model.getDTO(RecipeComplete.class);
        RecipeVariantLight currentVariant = recipe != null ? recipe.getCurrentVariant() : null;
        return super.isDeletable(model) && currentVariant != null && currentVariant.getState() == ModificationStateE.DRAFT;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<RecipeComplete> getRowEditorFactory() {
        return model -> {
            VariantMessageProvidedRowEditor<RecipeComplete> rowEditor = new VariantMessageProvidedRowEditor<RecipeComplete>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)settings);
            GroupLoader loader = new GroupLoader(this);
            if (model.isAddRow()) {
                CombinedDetailsParagraph d = new CombinedDetailsParagraph();
                TemplateDetailsPanel d0 = new TemplateDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p, this.isServiceItem());
                RecipeBasicDataDetailsPanel d02 = new RecipeBasicDataDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p);
                VariantBasicDataDetailsPanel d1 = new VariantBasicDataDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p, this.isServiceItem());
                ComponentsAssemblyDetailsPanel d2 = new ComponentsAssemblyDetailsPanel(rowEditor, p, loader);
                CommentDetailsPanel d33 = new CommentDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p);
                ContentDetailsPanel d31 = new ContentDetailsPanel(rowEditor, p, RecipeVariantComplete_.state, AllergenDeclarationComplete_.characteristic, "Allergens", ContentDetailsPanel.DeclarationType.ALLERGEN, true){

                    public Class getAllAttributeName() {
                        return AllergenCharacteristicComplete.class;
                    }

                    public DtoField<List<AllergenDeclarationComplete>> getAttribute() {
                        return RecipeVariantComplete_.allergenDeclarations;
                    }

                    @Override
                    public DtoField<Boolean> getTracesAttribute() {
                        return AllergenDeclarationComplete_.containsTraces;
                    }
                };
                ContentDetailsPanel d32 = new ContentDetailsPanel(rowEditor, p, RecipeVariantComplete_.state, AdditiveDeclarationComplete_.characteristic, "Additives", ContentDetailsPanel.DeclarationType.ADDITIVE, true){

                    public Class getAllAttributeName() {
                        return AdditiveCharacteristicComplete.class;
                    }

                    public DtoField<List<AdditiveDeclarationComplete>> getAttribute() {
                        return RecipeVariantComplete_.additiveDeclarations;
                    }

                    @Override
                    public DtoField<Boolean> getTracesAttribute() {
                        return null;
                    }
                };
                ContentDetailsPanel d34 = new ContentDetailsPanel(rowEditor, p, RecipeVariantComplete_.state, OtherDeclarationComplete_.characteristic, "Others", ContentDetailsPanel.DeclarationType.OTHER, true){

                    public Class getAllAttributeName() {
                        return OtherCharacteristicComplete.class;
                    }

                    public DtoField<List<OtherDeclarationComplete>> getAttribute() {
                        return RecipeVariantComplete_.otherDeclarations;
                    }

                    @Override
                    public DtoField<Boolean> getTracesAttribute() {
                        return null;
                    }
                };
                ProcessCostsDetailsPanel d44 = new ProcessCostsDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p);
                CombinedDetailsParagraph vcv = new CombinedDetailsParagraph();
                vcv.add((Component)d31, new TableLayoutConstraint(0, 0, 1.0, 0.3));
                vcv.add((Component)d32, new TableLayoutConstraint(0, 1, 1.0, 0.3));
                vcv.add((Component)d34, new TableLayoutConstraint(0, 2, 1.0, 0.4));
                CombinedDetailsParagraph hcv = new CombinedDetailsParagraph();
                hcv.add((Component)d44, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                hcv.add((Component)vcv, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                d.add((Component)d0, new TableLayoutConstraint(0, 0, 0.7, 1.0));
                d.add((Component)d02, new TableLayoutConstraint(1, 0, 0.3, 1.0));
                rowEditor.add(d, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
                rowEditor.add(d33, (Object)new TableLayoutConstraint(0, 3, 1.0, 0.0));
                rowEditor.add(hcv, (Object)new TableLayoutConstraint(0, 4, 1.0, 0.0));
                rowEditor.addToFocusQueue(d0);
                rowEditor.addToFocusQueue(d1);
                rowEditor.addToFocusQueue(d2);
                rowEditor.addToFocusQueue(d33);
                rowEditor.addToFocusQueue(d31);
                rowEditor.addToFocusQueue(d32);
                rowEditor.addToFocusQueue(d34);
            } else {
                VariantDetailsPanel d01 = new VariantDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p);
                RecipeBasicDataDetailsPanel d02 = new RecipeBasicDataDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p);
                rowEditor.setVariantPanel(d01);
                VariantBasicDataDetailsPanel d1 = new VariantBasicDataDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p, this.isServiceItem());
                ComponentsAssemblyDetailsPanel d2 = new ComponentsAssemblyDetailsPanel(rowEditor, p, loader);
                CommentDetailsPanel d33 = new CommentDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p);
                if (!isNoPro) {
                    ProcessCostsDetailsPanel d44 = new ProcessCostsDetailsPanel((RowEditor<RecipeComplete>)rowEditor, p);
                    ContentDetailsPanel d31 = new ContentDetailsPanel(rowEditor, p, RecipeVariantComplete_.state, AllergenDeclarationComplete_.characteristic, "Allergens", ContentDetailsPanel.DeclarationType.ALLERGEN, true){

                        public Class getAllAttributeName() {
                            return AllergenCharacteristicComplete.class;
                        }

                        public DtoField<List<AllergenDeclarationComplete>> getAttribute() {
                            return RecipeVariantComplete_.allergenDeclarations;
                        }

                        @Override
                        public DtoField<Boolean> getTracesAttribute() {
                            return AllergenDeclarationComplete_.containsTraces;
                        }
                    };
                    ContentDetailsPanel d32 = new ContentDetailsPanel(rowEditor, p, RecipeVariantComplete_.state, AdditiveDeclarationComplete_.characteristic, "Additives", ContentDetailsPanel.DeclarationType.ADDITIVE, true){

                        public Class getAllAttributeName() {
                            return AdditiveCharacteristicComplete.class;
                        }

                        public DtoField<List<AdditiveDeclarationComplete>> getAttribute() {
                            return RecipeVariantComplete_.additiveDeclarations;
                        }

                        @Override
                        public DtoField<Boolean> getTracesAttribute() {
                            return null;
                        }
                    };
                    ContentDetailsPanel d34 = new ContentDetailsPanel(rowEditor, p, RecipeVariantComplete_.state, OtherDeclarationComplete_.characteristic, "Others", ContentDetailsPanel.DeclarationType.OTHER, true){

                        public Class getAllAttributeName() {
                            return OtherCharacteristicComplete.class;
                        }

                        public DtoField<List<OtherDeclarationComplete>> getAttribute() {
                            return RecipeVariantComplete_.otherDeclarations;
                        }

                        @Override
                        public DtoField<Boolean> getTracesAttribute() {
                            return null;
                        }
                    };
                    CombinedDetailsParagraph vcv = new CombinedDetailsParagraph();
                    vcv.add((Component)d31, new TableLayoutConstraint(0, 0, 1.0, 0.3));
                    vcv.add((Component)d32, new TableLayoutConstraint(0, 1, 1.0, 0.3));
                    vcv.add((Component)d34, new TableLayoutConstraint(0, 2, 1.0, 0.4));
                    CombinedDetailsParagraph hcv = new CombinedDetailsParagraph();
                    hcv.add((Component)d44, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                    hcv.add((Component)vcv, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                    rowEditor.add(d01, (Object)new TableLayoutConstraint(0, 0, 0.7, 0.0));
                    rowEditor.add(d02, (Object)new TableLayoutConstraint(1, 0, 0.3, 0.0));
                    rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                    rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
                    rowEditor.add(d33, (Object)new TableLayoutConstraint(0, 3, 1.0, 0.0));
                    rowEditor.add(hcv, (Object)new TableLayoutConstraint(0, 4, 1.0, 0.0));
                    rowEditor.addToFocusQueue(d1);
                    rowEditor.addToFocusQueue(d2);
                    rowEditor.addToFocusQueue(d33);
                    rowEditor.addToFocusQueue(d44);
                    rowEditor.addToFocusQueue(d31);
                    rowEditor.addToFocusQueue(d32);
                    rowEditor.addToFocusQueue(d34);
                } else {
                    rowEditor.add(d01, (Object)new TableLayoutConstraint(0, 0, 0.7, 0.0));
                    rowEditor.add(d02, (Object)new TableLayoutConstraint(1, 0, 0.3, 0.0));
                    rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                    rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
                    rowEditor.add(d33, (Object)new TableLayoutConstraint(0, 3, 1.0, 0.0));
                    rowEditor.addToFocusQueue(d1);
                    rowEditor.addToFocusQueue(d2);
                    rowEditor.addToFocusQueue(d33);
                }
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new RecipeModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)ARecipeSearchConfiguration.RECIPE_COLUMN.NUMBER, RecipeComplete_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        columns.add(new TableColumnInfo("", "", FileReferenceConverter.class, null, "#currentVariant-imageReference", TableColumnInfo.imageIndicatorWidth, TableColumnInfo.imageIndicatorWidth, TableColumnInfo.imageIndicatorWidth));
        columns.add(new TableColumnInfo("", "", (Class)RecipeStateEWithWarningConverter.class, (Enum<?>)ARecipeSearchConfiguration.RECIPE_COLUMN.STATE, "", TableColumnInfo.state2 + 10, TableColumnInfo.state2 + 10, TableColumnInfo.state2 + 10));
        if (!isNoPro) {
            columns.add(new TableColumnInfo(Words.HALAL, "", BooleanConverter.class, null, "#currentVariant-halal", TableColumnInfo.imageIndicatorWidth, TableColumnInfo.imageIndicatorWidth, TableColumnInfo.imageIndicatorWidth));
        }
        columns.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)ARecipeSearchConfiguration.RECIPE_COLUMN.NAME, "#currentVariant-name", 200, Integer.MAX_VALUE, 200));
        columns.add(new TableColumnInfo(Words.CATEGORY, "", (Class)RecipeCategoryConverter.class, (Enum<?>)ARecipeSearchConfiguration.RECIPE_COLUMN.CATEGORY, "#currentVariant-category", 200, Integer.MAX_VALUE, 200));
        if (!isNoPro) {
            columns.add(new TableColumnInfo(Words.GROUP, "", PreparationGroupConverter.class, null, "#currentVariant-preparationGroup", 100, 100, 100));
            columns.add(new TableColumnInfo(Words.PRICE, "", RecipeVariantPriceConverter.class, null, "#currentVariant", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
            columns.add(new TableColumnInfo(Words.PRICE_IN_KG, "", RecipeVariantPriceInKgConverter.class, null, "#currentVariant", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        }
        columns.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)ARecipeSearchConfiguration.RECIPE_COLUMN.CUSTOMER, "#currentVariant-customer", TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
        columns.add(new TableColumnInfo(Words.VALIDITY, "", (Class)PeriodConverter.class, (Enum<?>)ARecipeSearchConfiguration.RECIPE_COLUMN.START_DATE, RecipeComplete_.period, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        columns.add(new TableColumnInfo(Words.CREATION_DATE, "", (Class)DateConverter.class, (Enum<?>)ARecipeSearchConfiguration.RECIPE_COLUMN.CREATION_DATE, RecipeComplete_.creationDate, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth));
        return columns;
    }
}

