/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sageimport.details;

import ch.icit.pegasus.client.converter.SageAccountTypeConverter;
import ch.icit.pegasus.client.converter.SageImportDataPriceConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.sage.SageImportComplete_;
import ch.icit.pegasus.server.core.dtos.sage.SageImportDataComplete_;
import ch.icit.pegasus.server.core.dtos.sage.SageImportLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SageDataDetails
extends TableDetailsPanel<SageImportLight> {
    private static final long serialVersionUID = 1L;

    public SageDataDetails(RowEditor<SageImportLight> editor, RDProvider provider) {
        super(editor, provider);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DESCRIPTION, 100));
        columns.add(new TableColumnInfo(Words.ACCOUNT, TableColumnInfo.dateColumnWidth + 2 * this.table.getCellPadding()));
        columns.add(new TableColumnInfo("Income", TableColumnInfo.priceColumnWidth + 2 * this.table.getCellPadding()));
        columns.add(new TableColumnInfo("Spent", TableColumnInfo.priceColumnWidth + 2 * this.table.getCellPadding()));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(SageImportComplete_.data));
    }

    @Override
    public void configTable(Table2 table) {
        table.setUseAddButton(false);
        table.setDontUseScrollBar(15);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.NONE);
        return p;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel description;
        private TextLabel account;
        private TextLabel income;
        private TextLabel spent;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.description = new TextLabel(m.getNode().getChildNamed(SageImportDataComplete_.description));
            this.account = new TextLabel(m.getNode().getChildNamed(SageImportDataComplete_.accountType), ConverterRegistry.getConverter(SageAccountTypeConverter.class));
            this.income = new TextLabel(m.getNode().getChildNamed(SageImportDataComplete_.priceIn), ConverterRegistry.getConverter(SageImportDataPriceConverter.class));
            this.spent = new TextLabel(m.getNode().getChildNamed(SageImportDataComplete_.priceOut), ConverterRegistry.getConverter(SageImportDataPriceConverter.class));
            this.setLayout(new Layout());
            this.add(this.description);
            this.add(this.account);
            this.add(this.income);
            this.add(this.spent);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.description.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.description.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.description.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.description.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.account.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.account.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.account.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.account.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.income.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.income.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.income.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.income.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.spent.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.spent.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.spent.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.spent.getPreferredSize().getHeight());
            }
        }
    }
}

