/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sealtracker;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.SealTypeConverter;
import ch.icit.pegasus.client.gui.modules.sealtracker.SealTrackerModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.sealtracker.details.AssociatedDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.sealtracker.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.SealSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.SealAccess;
import ch.icit.pegasus.server.core.dtos.search.SealSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete_;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SealTrackerModule
extends ScreenTableView<SealComplete, SealSearchConfiguration.SEAL_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NUMBER = "matriculation_filter";
    private String searchCriteria1 = null;

    public SealTrackerModule() {
        super(SealComplete.class);
        this.isSynchronSearch = false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return SealAccess.MODULE_SEAL_TRACKER;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", SealSearchConfiguration.SEAL_COLUMN.SEAL_NUMBER.toString() + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NUMBER, Words.SEAL_NO, "");
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<SealComplete, SealSearchConfiguration.SEAL_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean emptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
        } else if (name == FILTER_NUMBER) {
            this.searchCriteria1 = (String)value;
        }
        SealSearchConfiguration c = new SealSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setSealNumber(this.searchCriteria1);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    protected RowEditorFactory<SealComplete> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<SealComplete> rowEditor = new MessageProvidedRowEditor<SealComplete>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel details1 = new SpecificationDetailsPanel((RowEditor<SealComplete>)rowEditor, p);
            AssociatedDataDetailsPanel details2 = new AssociatedDataDetailsPanel((RowEditor<SealComplete>)rowEditor, p);
            CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
            c1.add((Component)details1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
            c1.add((Component)details2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
            rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            rowEditor.addToFocusQueue(details1);
            rowEditor.addToFocusQueue(details2);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new SealTrackerModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.SEAL_NO, "", (Class)IntegerConverter.class, (Enum<?>)SealSearchConfiguration.SEAL_COLUMN.SEAL_NUMBER, SealComplete_.sealNumber, TableColumnInfo.sealNumberColumnWithExpandWidth, Integer.MAX_VALUE, TableColumnInfo.sealNumberColumnWithExpandWidth));
        columns.add(new TableColumnInfo(Words.COLOR, "", (Class)ColorConverter.class, (Enum<?>)SealSearchConfiguration.SEAL_COLUMN.SEAL_COLOR, SealComplete_.color, TableColumnInfo.colorColumnWidth, TableColumnInfo.colorColumnWidth, TableColumnInfo.colorColumnWidth));
        columns.add(new TableColumnInfo(Words.TYPE, "", (Class)SealTypeConverter.class, (Enum<?>)SealSearchConfiguration.SEAL_COLUMN.SEAL_TYPE, SealComplete_.type, 90, 90, 90));
        return columns;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<SealComplete> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(SealSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<SealComplete> model) {
        return model != null && model.getDTO(SealComplete.class) != null;
    }
}

