/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.spotcheck.ccp0102.details;

import ch.icit.pegasus.client.converter.CCP0102MeasurementConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.RecipeConverter;
import ch.icit.pegasus.client.converter.RecipeProductGroupConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.RecipeProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchComplete_;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchMeasurementComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchMeasurementComplete_;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchMeasurementTypeE;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102EntryComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102EntryComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewEntryComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewEntryComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewLight;
import ch.icit.pegasus.server.core.dtos.spotcheck.haccp.HACCPSpotCheckReviewEntryComplete_;
import ch.icit.pegasus.server.core.dtos.system.QualitySettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CCP0102Details
extends TableDetailsPanel<CCP0102SpotCheckReviewLight> {
    private static final long serialVersionUID = 1L;
    private final boolean checked;

    public CCP0102Details(RowEditor<CCP0102SpotCheckReviewLight> editor, RDProvider provider, boolean checked) {
        super(editor, provider);
        this.checked = checked;
        if (checked) {
            this.setTitleText("Valid - " + Words.DETAILED_VIEW);
        } else {
            this.setTitleText("Invalid - " + Words.DETAILED_VIEW);
        }
    }

    @Override
    public void setNode(Node<?> node) {
        this.setNodes(node);
    }

    @Override
    public void resetParagraph() {
        this.setNodes(this.editor.getModel().getNode());
    }

    private void setNodes(Node<?> node) {
        ViewNode entries = new ViewNode("ok-entries");
        Iterator it = node.getChildNamed(CCP0102SpotCheckReviewComplete_.entries).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node entry = (Node)it.next();
            boolean reviewed = Boolean.TRUE.equals(((CCP0102SpotCheckReviewEntryComplete)entry.getValue()).getReviewed());
            if (reviewed != this.checked) continue;
            entries.addChild(entry, 0L);
        }
        this.table.getModel().setNode((Node)entries);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        return rets;
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        QualitySettingsComplete qualitySettings = (QualitySettingsComplete)NodeToolkit.getAffixClass(QualitySettingsComplete.class).getValue();
        headers.add(new TableColumnInfo(0.0, Words.DATE, TableColumnInfo.dateTimeColumnWidth));
        headers.add(new TableColumnInfo(0.25, Words.RECIPE_NAME, 0, Integer.MAX_VALUE, 250));
        headers.add(new TableColumnInfo(0.0, Words.GROUP, 50));
        headers.add(new TableColumnInfo(0.0, Words.PRODUCED, 50));
        if (Boolean.TRUE.equals(qualitySettings.getUseRecipeBatchQuantity())) {
            headers.add(new TableColumnInfo(0.0, "Quantity", 135));
        }
        headers.add(new TableColumnInfo(0.0, "Produced Date", 160));
        headers.add(new TableColumnInfo(0.0, "Heating Date", 160));
        headers.add(new TableColumnInfo(0.0, "Heating Temp", 75));
        headers.add(new TableColumnInfo(0.0, "Heating Duration", 75));
        headers.add(new TableColumnInfo(0.0, "Heating End Temp", 75));
        headers.add(new TableColumnInfo(0.25, "Heating Comment", 100, Integer.MAX_VALUE, 100));
        headers.add(new TableColumnInfo(0.0, "User", 100));
        headers.add(new TableColumnInfo(0.0, "Fast Chill Begin", 160));
        headers.add(new TableColumnInfo(0.0, "Fast Chill Temp", 75));
        headers.add(new TableColumnInfo(0.0, "Fast Chill User", 100));
        headers.add(new TableColumnInfo(0.0, "Fast Chill End", 160));
        headers.add(new TableColumnInfo(0.0, "Fast Chill Duration", 75));
        headers.add(new TableColumnInfo(0.0, "Fast Chill Temp", 75));
        headers.add(new TableColumnInfo(0.0, "Fast Chill User", 100));
        headers.add(new TableColumnInfo(0.25, "Fast Chill Comment", 100, Integer.MAX_VALUE, 100));
        headers.add(new TableColumnInfo(0.25, Words.QUALITY_COMMENT, 0, Integer.MAX_VALUE, 150));
        headers.add(new TableColumnInfo(0.0, Words.REVIEWED, TableColumnInfo.checkBoxColumnWith + 2 * this.table.getCellPadding()));
        return headers;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setSortedColumn(2);
        table.setSortDirection(false);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private final boolean isCorrection;
        private final DecimalFormat dfSec;
        private final QualitySettingsComplete qualitySettings;
        private TextLabel measurement;
        private TextLabel recipe;
        private TextLabel recipeGroup;
        private RDCheckBox produced;
        private Component producedDate;
        private Component producedTime;
        private Component quantity;
        private Component heatingDate;
        private Component heatingTime;
        private Component heatingTemp;
        private Component heatingDuration;
        private Component heatingTempEnd;
        private TextLabel heatingComment;
        private TextLabel heatingUser;
        private Component fastChillBeginDate;
        private Component fastChillBeginTime;
        private Component fastChillBeginTemp;
        private TextLabel fastChillBeginUser;
        private Component fastChillEndDate;
        private Component fastChillEndTime;
        private TextLabel fastChillDuration;
        private Component fastChillEndTemp;
        private TextLabel fastChillEndUser;
        private TextLabel fastChillEndComment;
        private TextField reviewComment;
        private CheckBox approved;
        private boolean init;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.init = false;
            this.qualitySettings = (QualitySettingsComplete)NodeToolkit.getAffixClass(QualitySettingsComplete.class).getValue();
            this.isCorrection = !Boolean.TRUE.equals(m.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.reviewed).getValue());
            Node entryNode = m.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.position);
            Node batchNode = m.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.batch);
            if (batchNode != null && batchNode.getChildNamed(CCP0102BatchComplete_.measurements) != null) {
                Iterator it = batchNode.getChildNamed(CCP0102BatchComplete_.measurements).getFailSafeChildIterator();
                while (it.hasNext()) {
                    it.next();
                }
            }
            this.measurement = new TextLabel(m.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.measurement), ConverterRegistry.getConverter(CCP0102MeasurementConverter.class));
            this.recipe = new TextLabel(entryNode.getChildNamed(CCP0102EntryComplete_.recipe), ConverterRegistry.getConverter(RecipeConverter.class));
            this.recipeGroup = new TextLabel(entryNode.getChildNamed(new DtoField[]{CCP0102EntryComplete_.recipe, RecipeComplete_.currentVariant, RecipeVariantLight_.productGroup}), ConverterRegistry.getConverter(RecipeProductGroupConverter.class));
            this.produced = new RDCheckBox(CCP0102Details.this.provider, entryNode.getChildNamed(CCP0102EntryComplete_.produced));
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            if (this.isCorrection) {
                this.producedTime = new DateTimeTextField(entryNode.getChildNamed(CCP0102EntryComplete_.notProducedDate), TextFieldType.DAYTIME);
                this.producedDate = new DateTimeTextField(entryNode.getChildNamed(CCP0102EntryComplete_.notProducedDate), TextFieldType.DATE);
                ((DateTimeTextField)this.producedTime).setPermanent(true);
                ((DateTimeTextField)this.producedDate).setPermanent(true);
                ((DateTimeTextField)this.producedTime).getFader().setPermanent(true);
                ((DateTimeTextField)this.producedDate).getFader().setPermanent(true);
                if (Boolean.TRUE.equals(((CCP0102EntryComplete)entryNode.getValue()).getProduced())) {
                    ((DateTimeTextField)this.producedTime).getFader().setProgress(0.0f);
                    ((DateTimeTextField)this.producedDate).getFader().setProgress(0.0f);
                } else {
                    ((DateTimeTextField)this.producedTime).getFader().setProgress(1.0f);
                    ((DateTimeTextField)this.producedDate).getFader().setProgress(1.0f);
                }
            } else {
                this.producedTime = new TextLabel();
                this.producedDate = new TextLabel();
                Timestamp notProducedDate = ((CCP0102EntryComplete)entryNode.getValue()).getNotProducedDate();
                if (notProducedDate == null) {
                    notProducedDate = new Timestamp(System.currentTimeMillis());
                }
                ((TextLabel)this.producedTime).setText(df.format(notProducedDate) + "h");
                ((TextLabel)this.producedTime).setPermanent(true);
                ((TextLabel)this.producedDate).setPermanent(true);
                ((TextLabel)this.producedTime).getFader().setPermanent(true);
                ((TextLabel)this.producedDate).getFader().setPermanent(true);
                if (Boolean.TRUE.equals(((CCP0102EntryComplete)entryNode.getValue()).getProduced())) {
                    ((TextLabel)this.producedTime).getFader().setProgress(0.0f);
                    ((TextLabel)this.producedDate).getFader().setProgress(0.0f);
                } else {
                    ((TextLabel)this.producedTime).getFader().setProgress(1.0f);
                    ((TextLabel)this.producedDate).getFader().setProgress(1.0f);
                }
            }
            CCP0102BatchComplete batch = batchNode != null ? (CCP0102BatchComplete)batchNode.getValue() : null;
            CCP0102BatchMeasurementComplete heatMeasure = this.findMeasurement(batch, CCP0102BatchMeasurementTypeE.Heating);
            CCP0102BatchMeasurementComplete fastChillStartMeasure = this.findMeasurement(batch, CCP0102BatchMeasurementTypeE.FastChillBegin);
            CCP0102BatchMeasurementComplete fastChillEndMeasure = this.findMeasurement(batch, CCP0102BatchMeasurementTypeE.FastChillEnd);
            if (!this.isCorrection) {
                this.heatingTime = new TextLabel();
                this.heatingTemp = new TextLabel();
                this.heatingDuration = new TextLabel();
                this.heatingTempEnd = new TextLabel();
                if (Boolean.TRUE.equals(this.qualitySettings.getUseRecipeBatchQuantity())) {
                    this.quantity = new TextLabel(batchNode.getChildNamed(CCP0102BatchComplete_.batchQuantity), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
                }
            } else if (Boolean.TRUE.equals(this.qualitySettings.getUseRecipeBatchQuantity())) {
                this.quantity = new InputComboBox2(batchNode.getChildNamed(new DtoField[]{CCP0102BatchComplete_.batchQuantity, QuantityComplete_.quantity}), batchNode.getChildNamed(new DtoField[]{CCP0102BatchComplete_.batchQuantity, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
                ViewNode vn = new ViewNode("");
                vn.setValue(Collections.singletonList(((CCP0102BatchComplete)batchNode.getValue()).getBatchQuantity().getUnit()), 0L);
                ((InputComboBox2)this.quantity).setPossibleUnits((Node)vn);
            }
            this.heatingComment = new TextLabel();
            this.heatingUser = new TextLabel();
            if (!Boolean.TRUE.equals(((CCP0102EntryComplete)entryNode.getValue()).getProduced())) {
                this.heatingUser.setText(((CCP0102EntryComplete)entryNode.getValue()).getNotProducedUser() != null ? ((CCP0102EntryComplete)entryNode.getValue()).getNotProducedUser().getUserName() + " " + (this.isCorrection ? "*" : "") : "");
            }
            DecimalFormat dfHeat = new DecimalFormat("0.#");
            this.dfSec = new DecimalFormat("0");
            if (heatMeasure != null) {
                if (this.isCorrection) {
                    this.heatingTime = new DateTimeTextField(null, TextFieldType.DAYTIME);
                    this.heatingDate = new DateTimeTextField(null, TextFieldType.DATE);
                    this.heatingTemp = new TextField(null, TextFieldType.DOUBLE);
                    this.heatingDuration = new TextField(null, TextFieldType.DOUBLE);
                    this.heatingTempEnd = new TextField(null, TextFieldType.DOUBLE);
                    ((TextField)this.heatingTemp).addTextFieldListener(field -> this.validateCCP());
                    ((TextField)this.heatingDuration).addTextFieldListener(field -> this.validateCCP());
                    ((TextField)this.heatingTempEnd).addTextFieldListener(field -> this.validateCCP());
                    ((TextField)this.heatingTime).addTextFieldListener(field -> this.validateCCP());
                    ((TextField)this.heatingDate).addTextFieldListener(field -> this.validateCCP());
                    ((TextField)this.heatingDate).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)heatMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.measureTimeStart));
                    ((TextField)this.heatingTime).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)heatMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.measureTimeStart));
                    ((TextField)this.heatingTemp).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)heatMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.temperatureStart));
                    ((TextField)this.heatingDuration).setText(this.dfSec.format(this.getDurationSeconds(heatMeasure.getMeasureTimeStart(), heatMeasure.getMeasureTimeEnd())));
                    ((TextField)this.heatingTempEnd).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)heatMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.temperatureEnd));
                } else {
                    ((TextLabel)this.heatingTime).setText(df.format(this.getMeasureTime(heatMeasure)) + "h");
                    if (heatMeasure.getTemperatureStart() != null) {
                        ((TextLabel)this.heatingTemp).setText(dfHeat.format(heatMeasure.getTemperatureStart()) + "\u00b0C");
                    } else {
                        ((TextLabel)this.heatingTemp).setText(dfHeat.format(heatMeasure.getTemperatureEnd()) + "\u00b0C");
                    }
                    ((TextLabel)this.heatingTempEnd).setText(dfHeat.format(heatMeasure.getTemperatureEnd()) + "\u00b0C");
                    ((TextLabel)this.heatingDuration).setText(this.dfSec.format(this.getDurationSeconds(heatMeasure.getMeasureTimeStart(), heatMeasure.getMeasureTimeEnd())) + "s");
                }
                this.heatingComment.setText(heatMeasure.getCommentText());
                this.heatingUser.setText(heatMeasure.getUser().getUserName() + " " + (this.isCorrection ? "*" : ""));
            } else {
                this.heatingTime = new TextLabel();
                this.heatingTemp = new TextLabel();
                this.heatingDuration = new TextLabel();
                this.heatingTempEnd = new TextLabel();
            }
            if (this.isCorrection) {
                this.fastChillBeginTime = new DateTimeTextField(null, TextFieldType.DAYTIME);
                this.fastChillBeginDate = new DateTimeTextField(null, TextFieldType.DATE);
                this.fastChillBeginTemp = new TextField(null, TextFieldType.DOUBLE);
                ((TextField)this.fastChillBeginTime).addTextFieldListener(field -> this.validateCCP());
                ((TextField)this.fastChillBeginTemp).addTextFieldListener(field -> this.validateCCP());
            } else {
                this.fastChillBeginTime = new TextLabel();
                this.fastChillBeginTemp = new TextLabel();
            }
            this.fastChillBeginUser = new TextLabel();
            if (fastChillStartMeasure != null) {
                if (this.isCorrection) {
                    ((TextField)this.fastChillBeginDate).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)fastChillStartMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.measureTimeEnd));
                    ((TextField)this.fastChillBeginTime).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)fastChillStartMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.measureTimeEnd));
                    ((TextField)this.fastChillBeginTemp).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)fastChillStartMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.temperatureEnd));
                } else {
                    ((TextLabel)this.fastChillBeginTime).setText(df.format(this.getMeasureTime(fastChillStartMeasure)) + "h");
                    ((TextLabel)this.fastChillBeginTemp).setText(dfHeat.format(this.getMeasurementTemperature(fastChillStartMeasure.getTemperatureStart(), fastChillStartMeasure.getTemperatureEnd())) + "\u00b0C");
                }
                if (fastChillStartMeasure.getUser() != null) {
                    this.fastChillBeginUser.setText(fastChillStartMeasure.getUser().getUserName() + " " + (this.isCorrection ? "*" : ""));
                }
            }
            if (this.isCorrection) {
                this.fastChillEndTime = new DateTimeTextField(null, TextFieldType.DAYTIME);
                this.fastChillEndDate = new DateTimeTextField(null, TextFieldType.DATE);
                this.fastChillEndTemp = new TextField(null, TextFieldType.DOUBLE);
                ((TextField)this.fastChillEndTime).addTextFieldListener(field -> this.validateCCP());
                ((TextField)this.fastChillEndTemp).addTextFieldListener(field -> this.validateCCP());
            } else {
                this.fastChillEndTime = new TextLabel();
                this.fastChillEndTemp = new TextLabel();
            }
            this.fastChillDuration = new TextLabel();
            this.fastChillEndUser = new TextLabel();
            this.fastChillEndComment = new TextLabel();
            if (fastChillEndMeasure != null) {
                if (this.isCorrection) {
                    ((TextField)this.fastChillEndDate).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)fastChillEndMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.measureTimeEnd));
                    ((TextField)this.fastChillEndTime).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)fastChillEndMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.measureTimeEnd));
                    ((TextField)this.fastChillEndTemp).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)fastChillEndMeasure, true, false).getChildNamed(CCP0102BatchMeasurementComplete_.temperatureEnd));
                } else {
                    ((TextLabel)this.fastChillEndTime).setText(df.format(this.getMeasureTime(fastChillEndMeasure)) + "h");
                    ((TextLabel)this.fastChillEndTemp).setText(dfHeat.format(this.getMeasurementTemperature(fastChillEndMeasure.getTemperatureStart(), fastChillEndMeasure.getTemperatureEnd())) + "\u00b0C");
                }
                this.fastChillDuration.setText(this.dfSec.format(this.getMeasurementDurationMinutes(fastChillStartMeasure, fastChillEndMeasure)) + "min");
                if (fastChillEndMeasure.getUser() != null) {
                    this.fastChillEndUser.setText(fastChillEndMeasure.getUser().getUserName() + " " + (this.isCorrection ? "*" : ""));
                }
                this.fastChillEndComment.setText(fastChillEndMeasure.getCommentText());
            }
            this.reviewComment = new TextField(m.getNode().getChildNamed(HACCPSpotCheckReviewEntryComplete_.comment));
            this.approved = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(HACCPSpotCheckReviewEntryComplete_.reviewed));
            this.setLayout(new Layout());
            this.init = true;
            this.produced.addButtonListener((source, x, y) -> {
                if (!this.produced.isChecked() && entryNode.getChildNamed(CCP0102EntryComplete_.notProducedDate).getValue() == null) {
                    CCP0102SpotCheckReviewEntryComplete value = (CCP0102SpotCheckReviewEntryComplete)this.model.getNode().getValue();
                    Date productionDate = value.getMeasurement().getProductionDate();
                    if (productionDate == null) {
                        productionDate = new Date(System.currentTimeMillis());
                    }
                    entryNode.getChildNamed(CCP0102EntryComplete_.notProducedDate).setValue((Object)new Timestamp(productionDate.getTime()), 0L);
                    entryNode.getChildNamed(CCP0102EntryComplete_.notProducedUser).setValue((Object)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), 0L);
                }
                this.showNotProducedDate(!this.produced.isChecked());
                this.validateCCP();
            });
            this.validateCCP();
            this.add(this.measurement);
            this.add(this.recipe);
            this.add(this.recipeGroup);
            this.add(this.produced);
            this.add(this.heatingTime);
            this.add(this.heatingTemp);
            this.add(this.heatingDuration);
            this.add(this.heatingTempEnd);
            this.add(this.heatingComment);
            this.add(this.heatingUser);
            this.add(this.fastChillBeginTime);
            this.add(this.fastChillBeginTemp);
            this.add(this.fastChillBeginUser);
            this.add(this.fastChillEndTime);
            this.add(this.fastChillDuration);
            this.add(this.fastChillEndTemp);
            this.add(this.fastChillEndUser);
            this.add(this.fastChillEndComment);
            this.add(this.reviewComment);
            this.add(this.approved);
            this.add(this.producedTime);
            this.add(this.producedDate);
            if (this.heatingDate != null) {
                this.add(this.heatingDate);
            }
            if (this.fastChillBeginDate != null) {
                this.add(this.fastChillBeginDate);
            }
            if (this.fastChillEndDate != null) {
                this.add(this.fastChillEndDate);
            }
            if (this.quantity != null) {
                this.add(this.quantity);
            }
        }

        private void showNotProducedDate(boolean show) {
            if (show) {
                if (this.producedTime instanceof Fadable) {
                    ((Fadable)((Object)this.producedTime)).fadeIn();
                }
                if (this.producedDate instanceof Fadable) {
                    ((Fadable)((Object)this.producedDate)).fadeIn();
                }
            } else {
                if (this.producedTime instanceof Fadable) {
                    ((Fadable)((Object)this.producedTime)).fadeOut(false);
                }
                if (this.producedDate instanceof Fadable) {
                    ((Fadable)((Object)this.producedDate)).fadeOut(false);
                }
            }
        }

        private void validateCCP() {
            Double targetTemp;
            if (!this.init) {
                return;
            }
            QualitySettingsComplete settings = (QualitySettingsComplete)NodeToolkit.getAffixClass(QualitySettingsComplete.class).getValue();
            Node batchNode = this.model.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.batch);
            CCP0102BatchComplete batch = (CCP0102BatchComplete)batchNode.getValue();
            CCP0102BatchMeasurementComplete fastChillStartMeasure = this.findMeasurement(batch, CCP0102BatchMeasurementTypeE.FastChillBegin);
            CCP0102BatchMeasurementComplete fastChillEndMeasure = this.findMeasurement(batch, CCP0102BatchMeasurementTypeE.FastChillEnd);
            CCP0102BatchMeasurementComplete heatingMeasure = this.findMeasurement(batch, CCP0102BatchMeasurementTypeE.Heating);
            Boolean produced = (Boolean)this.model.getNode().getChildNamed(new DtoField[]{CCP0102SpotCheckReviewEntryComplete_.position, CCP0102EntryComplete_.produced}).getValue();
            if (!Boolean.TRUE.equals(produced)) {
                boolean valid;
                Node entry = this.model.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.position);
                if (entry.getChildNamed(CCP0102EntryComplete_.notProducedDate).getValue() == null) {
                    if (this.producedDate instanceof Validatable) {
                        ((Validatable)((Object)this.producedDate)).setInvalid();
                    }
                    if (this.producedTime instanceof Validatable) {
                        ((Validatable)((Object)this.producedTime)).setInvalid();
                    }
                    valid = false;
                } else {
                    if (this.producedTime instanceof Validatable) {
                        ((Validatable)((Object)this.producedTime)).setValid();
                    }
                    if (this.producedDate instanceof Validatable) {
                        ((Validatable)((Object)this.producedDate)).setValid();
                    }
                    valid = true;
                }
                if (this.heatingTemp instanceof Validatable) {
                    ((Validatable)((Object)this.heatingTemp)).setValid();
                }
                if (this.heatingTempEnd instanceof Validatable) {
                    ((Validatable)((Object)this.heatingTempEnd)).setValid();
                }
                if (this.heatingDuration instanceof Validatable) {
                    ((Validatable)((Object)this.heatingDuration)).setValid();
                }
                if (this.heatingTime instanceof Validatable) {
                    ((Validatable)((Object)this.heatingTime)).setValid();
                }
                if (this.heatingDate instanceof Validatable) {
                    ((Validatable)((Object)this.heatingDate)).setValid();
                }
                this.fastChillDuration.setValid();
                if (this.isCorrection) {
                    ((TextField)this.fastChillEndTemp).lafAttributeChanged("");
                } else {
                    ((TextLabel)this.fastChillEndTemp).setValid();
                }
                if (valid) {
                    this.model.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.reviewed).setValue((Object)true, 0L);
                } else {
                    this.model.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.reviewed).setValue((Object)false, 0L);
                }
                return;
            }
            boolean heatTempValid = true;
            boolean heatTimeValid = true;
            if (heatingMeasure != null) {
                double average = this.getMeasurementTemperature(heatingMeasure.getTemperatureStart(), heatingMeasure.getTemperatureEnd());
                Node entryNode = this.model.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.position);
                CCP0102EntryComplete value = (CCP0102EntryComplete)entryNode.getValue();
                targetTemp = value != null && value.getUsedGroup() != null && value.getUsedGroup().getTemperature() != null ? value.getUsedGroup().getTemperature() : 0.0;
                if (targetTemp == null) {
                    targetTemp = 0.0;
                }
                if (average < targetTemp) {
                    heatTempValid = false;
                }
                if (this.isCorrection) {
                    try {
                        Double seconds = Double.valueOf(((TextField)this.heatingDuration).getText());
                        Timestamp start = heatingMeasure.getMeasureTimeStart();
                        long time = start.getTime();
                        time = (long)((double)time + seconds * 1000.0);
                        heatingMeasure.setMeasureTimeEnd(new Timestamp(time));
                    }
                    catch (Exception seconds) {
                        // empty catch block
                    }
                }
                double durationSeconds = this.getDurationSeconds(heatingMeasure.getMeasureTimeStart(), heatingMeasure.getMeasureTimeEnd());
                if (Boolean.TRUE.equals(settings.getDoubleMeasureHeating()) && durationSeconds < settings.getDefaultHeatingDoubleMeasurementDuration()) {
                    heatTimeValid = false;
                }
            } else {
                RecipeProductGroupComplete group = (RecipeProductGroupComplete)this.model.getNode().getChildNamed(new DtoField[]{CCP0102SpotCheckReviewEntryComplete_.position, CCP0102EntryComplete_.usedGroup}).getValue();
                if (group != null && Boolean.TRUE.equals(group.getHeating())) {
                    heatTimeValid = false;
                    heatTempValid = false;
                }
            }
            boolean endTempValid = true;
            boolean durationValid = true;
            if (fastChillStartMeasure != null && fastChillEndMeasure != null) {
                double durationMinutes;
                double average = this.getMeasurementTemperature(fastChillEndMeasure.getTemperatureStart(), fastChillEndMeasure.getTemperatureEnd());
                targetTemp = settings.getDefaultFastCoolingTargetTemperature();
                CCP0102SpotCheckReviewEntryComplete entry = (CCP0102SpotCheckReviewEntryComplete)this.model.getNode().getValue();
                if (entry.getPosition().getCustomer() != null) {
                    targetTemp = entry.getPosition().getCustomer().getChillTemperatureAtCCP0102();
                }
                if (average > targetTemp) {
                    endTempValid = false;
                }
                if ((durationMinutes = this.getMeasurementDurationMinutes(fastChillStartMeasure, fastChillEndMeasure)) > settings.getDefaultFastCoolingDuration() * 60.0 || durationMinutes < settings.getDefaultFastCoolingMinimumDuration() * 60.0) {
                    durationValid = false;
                }
                this.fastChillDuration.setText(this.dfSec.format(durationMinutes) + "min");
            } else {
                endTempValid = false;
                durationValid = false;
            }
            if (!endTempValid) {
                if (this.isCorrection) {
                    ((TextField)this.fastChillEndTemp).setForeground(Color.RED);
                } else {
                    ((TextLabel)this.fastChillEndTemp).setInvalid();
                }
            } else if (this.isCorrection) {
                ((TextField)this.fastChillEndTemp).lafAttributeChanged("");
            } else {
                ((TextLabel)this.fastChillEndTemp).setValid();
            }
            if (!durationValid) {
                this.fastChillDuration.setInvalid();
            } else {
                this.fastChillDuration.setValid();
            }
            if (!heatTempValid) {
                if (this.heatingTemp instanceof Validatable) {
                    ((Validatable)((Object)this.heatingTemp)).setInvalid();
                }
                if (this.heatingTempEnd instanceof Validatable) {
                    ((Validatable)((Object)this.heatingTempEnd)).setInvalid();
                }
            } else {
                if (this.heatingTemp instanceof Validatable) {
                    ((Validatable)((Object)this.heatingTemp)).setValid();
                }
                if (this.heatingTempEnd instanceof Validatable) {
                    ((Validatable)((Object)this.heatingTempEnd)).setValid();
                }
            }
            if (!heatTimeValid) {
                if (this.heatingDuration instanceof Validatable) {
                    ((Validatable)((Object)this.heatingDuration)).setInvalid();
                }
                if (this.heatingTime instanceof Validatable) {
                    ((Validatable)((Object)this.heatingTime)).setInvalid();
                }
                if (this.heatingDate instanceof Validatable) {
                    ((Validatable)((Object)this.heatingDate)).setInvalid();
                }
            } else {
                if (this.heatingDuration instanceof Validatable) {
                    ((Validatable)((Object)this.heatingDuration)).setValid();
                }
                if (this.heatingTime instanceof Validatable) {
                    ((Validatable)((Object)this.heatingTime)).setValid();
                }
                if (this.heatingDate instanceof Validatable) {
                    ((Validatable)((Object)this.heatingDate)).setValid();
                }
            }
            if (heatTimeValid && heatTempValid && endTempValid && durationValid) {
                this.model.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.reviewed).setValue((Object)true, 0L);
            } else {
                this.model.getNode().getChildNamed(CCP0102SpotCheckReviewEntryComplete_.reviewed).setValue((Object)false, 0L);
            }
        }

        private double getMeasurementTemperature(Double startMeasure, Double endMeasure) {
            if (startMeasure == null) {
                return endMeasure;
            }
            if (endMeasure == null) {
                return startMeasure;
            }
            return (startMeasure + endMeasure) / 2.0;
        }

        private Timestamp getMeasureTime(CCP0102BatchMeasurementComplete measurement) {
            if (measurement.getMeasureTimeStart() != null) {
                return measurement.getMeasureTimeStart();
            }
            return measurement.getMeasureTimeEnd();
        }

        private double getMeasurementDurationMinutes(CCP0102BatchMeasurementComplete start, CCP0102BatchMeasurementComplete end) {
            Timestamp startTime = this.getMeasureTime(start);
            Timestamp endTime = this.getMeasureTime(end);
            long difSec = endTime.getTime() - startTime.getTime();
            return (double)difSec / 1000.0 / 60.0;
        }

        private CCP0102BatchMeasurementComplete findMeasurement(CCP0102BatchComplete batch, CCP0102BatchMeasurementTypeE ccp0102BatchMeasurementTypeE) {
            if (batch != null) {
                for (CCP0102BatchMeasurementComplete measurement : batch.getMeasurements()) {
                    if (!measurement.getBatchMeasurementType().equals((Object)ccp0102BatchMeasurementTypeE) || !Boolean.TRUE.equals(measurement.getCorrection())) continue;
                    return measurement;
                }
                for (CCP0102BatchMeasurementComplete measurement : batch.getMeasurements()) {
                    if (!measurement.getBatchMeasurementType().equals((Object)ccp0102BatchMeasurementTypeE)) continue;
                    return measurement;
                }
            }
            return null;
        }

        private double getAverageTemperature(Double ... temp) {
            double totalTemp = 0.0;
            for (Double v : temp) {
                totalTemp += v.doubleValue();
            }
            return totalTemp / (double)temp.length;
        }

        private long getDurationSeconds(Timestamp startDate, Timestamp endDate) {
            if (endDate == null || startDate == null) {
                return 0L;
            }
            long dif = endDate.getTime() - startDate.getTime();
            return dif / 1000L;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            if (this.produced instanceof Focusable) {
                CheckedListAdder.addToList(focusList, this.produced);
            }
            if (this.producedTime instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.producedTime));
            }
            if (this.producedDate instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.producedDate));
            }
            if (this.quantity instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.quantity));
            }
            if (this.heatingTime instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.heatingTime));
            }
            if (this.heatingDate instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.heatingDate));
            }
            if (this.heatingTemp instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.heatingTemp));
            }
            if (this.heatingDuration instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.heatingDuration));
            }
            if (this.heatingTempEnd instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.heatingTempEnd));
            }
            if (this.fastChillBeginDate instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.fastChillBeginDate));
            }
            if (this.fastChillBeginTime instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.fastChillBeginTime));
            }
            if (this.fastChillBeginTemp instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.fastChillBeginTemp));
            }
            if (this.fastChillEndDate instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.fastChillEndDate));
            }
            if (this.fastChillEndTime instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.fastChillEndTime));
            }
            if (this.fastChillEndTemp instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.fastChillEndTemp));
            }
            CheckedListAdder.addToList(focusList, this.reviewComment);
            CheckedListAdder.addToList(focusList, this.approved);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.measurement.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.measurement.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.measurement.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.measurement.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.recipe.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.recipe.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.recipe.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.recipe.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.recipeGroup.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.recipeGroup.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.recipeGroup.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.recipeGroup.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.produced.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.produced.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.produced.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.produced.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(4);
                int index = 5;
                if (Boolean.TRUE.equals(TableRowImpl.this.qualitySettings.getUseRecipeBatchQuantity())) {
                    TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                }
                int tempSize = 50;
                if (TableRowImpl.this.producedTime instanceof TextLabel) {
                    tempSize = w - 2 * TableRowImpl.this.getCellPadding();
                }
                TableRowImpl.this.producedTime.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.producedTime.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.producedTime.setSize(tempSize, (int)TableRowImpl.this.producedTime.getPreferredSize().getHeight());
                TableRowImpl.this.producedDate.setLocation(TableRowImpl.this.producedTime.getX() + TableRowImpl.this.producedTime.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.producedDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.producedDate.setSize(w - (3 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.producedTime.getWidth()), (int)TableRowImpl.this.producedDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                tempSize = TableRowImpl.this.heatingDate != null ? 50 : w - 2 * TableRowImpl.this.getCellPadding();
                TableRowImpl.this.heatingTime.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.heatingTime.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.heatingTime.setSize(tempSize, (int)TableRowImpl.this.heatingTime.getPreferredSize().getHeight());
                if (TableRowImpl.this.heatingDate != null) {
                    TableRowImpl.this.heatingDate.setLocation(TableRowImpl.this.heatingTime.getX() + TableRowImpl.this.heatingTime.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.heatingDate.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.heatingDate.setSize(w - (3 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.heatingTime.getWidth()), (int)TableRowImpl.this.heatingDate.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.heatingTemp.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.heatingTemp.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.heatingTemp.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.heatingTemp.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.heatingDuration.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.heatingDuration.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.heatingDuration.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.heatingDuration.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.heatingTempEnd.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.heatingTempEnd.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.heatingTempEnd.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.heatingTempEnd.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.heatingComment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.heatingComment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.heatingComment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.heatingComment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.heatingUser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.heatingUser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.heatingUser.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.heatingUser.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                tempSize = TableRowImpl.this.fastChillBeginDate != null ? 50 : w - 2 * TableRowImpl.this.getCellPadding();
                TableRowImpl.this.fastChillBeginTime.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillBeginTime.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fastChillBeginTime.setSize(tempSize, (int)TableRowImpl.this.fastChillBeginTime.getPreferredSize().getHeight());
                if (TableRowImpl.this.fastChillBeginDate != null) {
                    TableRowImpl.this.fastChillBeginDate.setLocation(TableRowImpl.this.fastChillBeginTime.getX() + TableRowImpl.this.fastChillBeginTime.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillBeginDate.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.fastChillBeginDate.setSize(w - (3 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.fastChillBeginTime.getWidth()), (int)TableRowImpl.this.fastChillBeginDate.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.fastChillBeginTemp.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillBeginTemp.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fastChillBeginTemp.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fastChillBeginTemp.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.fastChillBeginUser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillBeginUser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fastChillBeginUser.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fastChillBeginUser.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                tempSize = TableRowImpl.this.fastChillEndDate != null ? 50 : w - 2 * TableRowImpl.this.getCellPadding();
                TableRowImpl.this.fastChillEndTime.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillEndTime.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fastChillEndTime.setSize(tempSize, (int)TableRowImpl.this.fastChillEndTime.getPreferredSize().getHeight());
                if (TableRowImpl.this.fastChillEndDate != null) {
                    TableRowImpl.this.fastChillEndDate.setLocation(TableRowImpl.this.fastChillEndTime.getX() + TableRowImpl.this.fastChillEndTime.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillEndDate.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.fastChillEndDate.setSize(w - (3 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.fastChillEndTime.getWidth()), (int)TableRowImpl.this.fastChillEndDate.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.fastChillDuration.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillDuration.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fastChillDuration.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fastChillDuration.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.fastChillEndTemp.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillEndTemp.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fastChillEndTemp.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fastChillEndTemp.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.fastChillEndUser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillEndUser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fastChillEndUser.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fastChillEndUser.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.fastChillEndComment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fastChillEndComment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fastChillEndComment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fastChillEndComment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.reviewComment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.reviewComment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.reviewComment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.reviewComment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(index++);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.approved.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.approved.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.approved.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.approved.getPreferredSize().getHeight());
            }
        }
    }
}

