/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.spotcheck.haccp_po;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SpotCheckServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.haccp.HACCPSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.haccp.HACCPSpotCheckReviewEntryComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.haccp.HACCPSpotCheckReviewLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;

public class HACCPSpotCheckModuleDataHandler
extends DefaultDataHandler<HACCPSpotCheckReviewLight, HACCPSpotCheckReviewComplete> {
    public HACCPSpotCheckModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HACCPSpotCheckReviewLight group = (HACCPSpotCheckReviewLight)node.getValue(HACCPSpotCheckReviewLight.class);
                HACCPSpotCheckReviewComplete ngroup = (HACCPSpotCheckReviewComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).getHACCPSpotCheck(group).getValue();
                for (HACCPSpotCheckReviewEntryComplete entry : ngroup.getEntries()) {
                    BasicArticleComplete basicArticle = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(entry.getPosition().getCharge().getBasicArticle().getId())).getValue();
                    entry.getPosition().getCharge().setBasicArticle((BasicArticleLight)basicArticle);
                }
                node.removeExistingValues();
                node.setValue((Object)ngroup, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<HACCPSpotCheckReviewLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HACCPSpotCheckReviewComplete g = (HACCPSpotCheckReviewComplete)node.getValue(HACCPSpotCheckReviewComplete.class);
                HACCPSpotCheckReviewComplete gn = (HACCPSpotCheckReviewComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).updateHACCPSpotCheck(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<HACCPSpotCheckReviewComplete> createEmptyNode() {
        HACCPSpotCheckReviewComplete r = new HACCPSpotCheckReviewComplete();
        r.setClientOId(Long.valueOf(ADTO.getNextId()));
        r.setCreationDate(new Timestamp(System.currentTimeMillis()));
        r.setCreationUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        r.setTimestampPeriod(new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())));
        r.setHaccpSystem(Boolean.valueOf(true));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)r, false, false);
    }

    @Override
    public void createNewData(final Node<HACCPSpotCheckReviewComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HACCPSpotCheckReviewComplete g = (HACCPSpotCheckReviewComplete)node.getValue(HACCPSpotCheckReviewComplete.class);
                HACCPSpotCheckReviewComplete gn = (HACCPSpotCheckReviewComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).createHACCPSpotCheck(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HACCPSpotCheckModuleDataHandler.this.setCurrentLoadMaximum(0);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return HACCPSpotCheckModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<HACCPSpotCheckReviewComplete> resetData(Node<HACCPSpotCheckReviewComplete> node) {
        HACCPSpotCheckReviewComplete n = new HACCPSpotCheckReviewComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        n.setCreationDate(new Timestamp(System.currentTimeMillis()));
        n.setCreationUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        n.setTimestampPeriod(new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())));
        n.setHaccpSystem(Boolean.valueOf(false));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<AllergenSpotCheckReviewComplete> getCommittingClass() {
        return AllergenSpotCheckReviewComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<HACCPSpotCheckReviewLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

