/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stock;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryRemarkComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.InventorySearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.ManualStockCheckinRemarkComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.ManualStockMovementRemarkComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.search.SortDirection;

public class StockModuleDataHandler
extends DefaultDataHandler<StoreReference, StoreComplete> {
    public StockModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<StoreReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataAfterClosing(Node<?> node, RemoteLoader listener, ProgressListener progressListener) {
        return false;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, "Load latest Product/Recipe Count");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventorySearchConfiguration config = new InventorySearchConfiguration();
                config.setStore((StoreLight)node.getValue(StoreLight.class));
                config.setSortColumn((Enum)InventorySearchConfiguration.INVENTORY_COLUMN.INVENTORY_DATE);
                config.setSortDirection(SortDirection.DESCENDING);
                SearchResult search = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)config);
                Node recipeCountNode = node.getChildNamed(InventoryComplete_.recipeCounts);
                Node productCountNode = node.getChildNamed(InventoryComplete_.productCounts);
                if (recipeCountNode != null) {
                    node.removeChild(recipeCountNode, 0L);
                }
                if (productCountNode != null) {
                    node.removeChild(productCountNode, 0L);
                }
                if (!search.getResults().isEmpty()) {
                    InventoryLight lastInventory = (InventoryLight)search.getResults().get(0);
                    InventoryComplete complete = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).get(new InventoryReference(lastInventory.getId())).getValue();
                    recipeCountNode = INodeCreator.getDefaultImpl().createNodes(complete.getRecipeCounts(), false);
                    recipeCountNode.setName(InventoryComplete_.recipeCounts);
                    node.addChild(recipeCountNode, 0L);
                    productCountNode = INodeCreator.getDefaultImpl().createNodes(complete.getProductCounts(), false);
                    productCountNode.setName(InventoryComplete_.productCounts);
                    node.addChild(productCountNode, 0L);
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<StoreComplete> createEmptyNode() {
        return null;
    }

    @Override
    public void createNewData(Node<StoreComplete> node, RemoteLoader model, boolean sameNode, ProgressListener l) {
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StockModuleDataHandler.this.setCurrentLoadMaximum(11);
                StockModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                StockModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InventoryRemarkComplete.class);
                StockModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                StockModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                StockModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ManualStockMovementRemarkComplete.class);
                StockModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ManualStockCheckinRemarkComplete.class);
                StockModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                StockModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                StockModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllArticleReportTypes();
                StockModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllBondedStates();
                StockModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getWeeklyPlanSettingsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return StockModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<StoreComplete> resetData(Node<StoreComplete> node) {
        return null;
    }

    @Override
    public Class<StoreComplete> getCommittingClass() {
        return StoreComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<StoreReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

