/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stock.details.utils;

import ch.icit.pegasus.client.gui.modules.stock.details.StockContentDetailsPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.ExcelExportPopupInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StoreArticleContentSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreArticleContentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreArticleContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StockExportPopup
extends ExcelExportPopupInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node store;
    private TitledItem<RadioButton> all;
    private TitledItem<RadioButton> filtered;
    private TitledItem<RadioButton> screen;
    private TitledItem<CheckBox> customerMaterialOnly;
    private TitledItem<CheckBox> includeZeroStockCustomerMaterial;
    private StockContentDetailsPanel para;
    private UserComplete currentUser;
    private boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());

    public StockExportPopup(Node store, UserComplete currentUser, StockContentDetailsPanel para) {
        super(true);
        this.currentUser = currentUser;
        this.store = store;
        this.para = para;
        this.createComponents();
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        this.setLayout(new Layout());
        this.all = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_ALL, TitledItem.TitledItemOrientation.EAST);
        this.filtered = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_FILTERED, TitledItem.TitledItemOrientation.EAST);
        this.screen = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_SHOWN, TitledItem.TitledItemOrientation.EAST);
        if (!this.isSolarCompany) {
            this.customerMaterialOnly = new TitledItem<CheckBox>(new CheckBox(), "Customer material only", TitledItem.TitledItemOrientation.EAST);
            this.includeZeroStockCustomerMaterial = new TitledItem<CheckBox>(new CheckBox(), "Include zero stock Customer Material", TitledItem.TitledItemOrientation.EAST);
            this.includeZeroStockCustomerMaterial.setEnabled(false);
            this.customerMaterialOnly.getElement().addButtonListener(this);
            this.add(this.customerMaterialOnly);
            this.add(this.includeZeroStockCustomerMaterial);
        }
        this.filtered.getElement().setChecked(true);
        this.add(this.all);
        this.add(this.screen);
        this.add(this.filtered);
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public String getTitleString() {
        return Words.STORE;
    }

    @Override
    public String getTitleValue() {
        return (String)this.store.getChildNamed(StoreLight_.code).getValue();
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.screen != null) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.screen);
            CheckedListAdder.addToList(focusList, this.filtered);
            CheckedListAdder.addToList(focusList, this.all);
            CheckedListAdder.addToList(focusList, this.customerMaterialOnly);
            CheckedListAdder.addToList(focusList, this.includeZeroStockCustomerMaterial);
            return focusList;
        }
        return super.getFocusComponents();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.screen.setVisible(false);
        this.filtered.setVisible(false);
        this.all.setVisible(false);
        if (this.customerMaterialOnly != null) {
            this.customerMaterialOnly.setVisible(false);
        }
        if (this.includeZeroStockCustomerMaterial != null) {
            this.includeZeroStockCustomerMaterial.setVisible(false);
        }
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                QuantityComplete q;
                StoreArticleContentSearchConfiguration searchConfig = null;
                if (((RadioButton)StockExportPopup.this.screen.getElement()).isChecked()) {
                    searchConfig = StockExportPopup.this.para.getSearchConfig(true);
                } else if (((RadioButton)StockExportPopup.this.filtered.getElement()).isChecked()) {
                    searchConfig = StockExportPopup.this.para.getSearchConfig(true);
                    searchConfig.setPageNumber(0);
                    searchConfig.setNumResults(Integer.MAX_VALUE);
                } else if (((RadioButton)StockExportPopup.this.all.getElement()).isChecked()) {
                    StoreArticleContentSearchConfiguration tempSearch = StockExportPopup.this.para.getSearchConfig(true);
                    searchConfig = new StoreArticleContentSearchConfiguration();
                    searchConfig.setPageNumber(0);
                    searchConfig.setStore(tempSearch.getStore());
                    searchConfig.setNumResults(Integer.MAX_VALUE);
                }
                BasicArticleSearchConfiguration newSearch = ((StoreArticleContentSearchAlgorithm)SearchAlgorithmRegistry.getSearchAlgorithm(StoreArticleContentSearchAlgorithm.class)).convertToBasicArticleSearchConfiguration(searchConfig);
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                HashMap<Object, QuantityComplete> quantity = new HashMap<Object, QuantityComplete>();
                SearchResult r = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStoreArticleContent(newSearch);
                SearchResult r2 = null;
                if (StockExportPopup.this.includeZeroStockCustomerMaterial != null && ((CheckBox)StockExportPopup.this.includeZeroStockCustomerMaterial.getElement()).isChecked() && searchConfig.getCustomer() != null) {
                    BasicArticleSearchConfiguration sac = new BasicArticleSearchConfiguration();
                    sac.setCustomer(searchConfig.getCustomer());
                    sac.setCustomerOwned(Boolean.valueOf(true));
                    sac.setNumResults(Integer.MAX_VALUE);
                    r2 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)sac);
                }
                for (StoreArticleContentComplete sac : r.getResults()) {
                    q = (QuantityComplete)quantity.get(sac.getArticle());
                    if (q != null) continue;
                    QuantityComplete totalQuantityInStoreUnit = UnitConversionToolkit.getTotalQuantityInStoreUnit((StoreArticleContentComplete)sac);
                    quantity.put(sac.getArticle(), totalQuantityInStoreUnit);
                }
                if (r2 != null) {
                    for (StoreArticleContentComplete sac : r2.getResults()) {
                        q = (QuantityComplete)quantity.get(sac);
                        if (q != null) continue;
                        quantity.put(sac, new QuantityComplete(Double.valueOf(0.0), sac.getFloatStoreUnit()));
                    }
                }
                ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
                ExcelRow h = new ExcelRow(null);
                h.setHeader(true);
                h.addCell((Object)Words.CUSTOMER_NUMBER, new String[0]);
                h.addCell((Object)Words.NUMBER, new String[0]);
                h.addCell((Object)Words.NAME, new String[0]);
                h.addCell((Object)"EAN", new String[0]);
                h.addCell((Object)Words.QTY, new String[0]);
                h.addCell((Object)"", new String[0]);
                rows.add(h);
                for (BasicArticleLight artL : quantity.keySet()) {
                    ExcelRow t = new ExcelRow((Object)artL);
                    String ss = artL.getCustomerArticleNumber();
                    if (ss == null) {
                        ss = "";
                    }
                    t.addCell((Object)ss, new String[0]);
                    t.addCell((Object)artL.getNumber(), new String[0]);
                    t.addCell((Object)artL.getName(), new String[0]);
                    BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                    t.addCell((Object)artC.getEanCode(), new String[0]);
                    QuantityComplete p = (QuantityComplete)quantity.get(artL);
                    if (p == null) {
                        p = new QuantityComplete();
                    }
                    if (p.getQuantity() == null) {
                        p.setQuantity(Double.valueOf(0.0));
                    }
                    if (p.getUnit() == null) {
                        p.setUnit(artC.getFloatStoreUnit());
                    }
                    t.addCell((Object)p.getQuantity(), new String[0]);
                    t.addCell((Object)p.getUnit().getShortName(), new String[0]);
                    rows.add(t);
                }
                ExcelToolkit.writeWorkBook((File)StockExportPopup.this.getSelectedFile().getAbsoluteFile(), rows, (String)("Stock " + StockExportPopup.this.store.getChildNamed(StoreLight_.code).getValue()));
                StockExportPopup.this.errorMSG = null;
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return StockExportPopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getFinishedText() {
        return Words.SUCCESSFULLY_EXPORTED;
    }

    @Override
    protected String getProgressText() {
        return Words.EXPORTING;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.customerMaterialOnly.getElement()) {
            this.includeZeroStockCustomerMaterial.setEnabled(this.customerMaterialOnly.getElement().isChecked());
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(280, 250);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = StockExportPopup.this.layoutInheritedComponents(parent);
            StockExportPopup.this.screen.setLocation(StockExportPopup.this.border, y += StockExportPopup.this.border);
            StockExportPopup.this.screen.setSize(parent.getWidth() - 2 * StockExportPopup.this.border, (int)StockExportPopup.this.screen.getPreferredSize().getHeight());
            StockExportPopup.this.filtered.setLocation(StockExportPopup.this.border, StockExportPopup.this.screen.getY() + StockExportPopup.this.screen.getHeight() + StockExportPopup.this.border / 2);
            StockExportPopup.this.filtered.setSize(parent.getWidth() - 2 * StockExportPopup.this.border, (int)StockExportPopup.this.filtered.getPreferredSize().getHeight());
            StockExportPopup.this.all.setLocation(StockExportPopup.this.border, StockExportPopup.this.filtered.getY() + StockExportPopup.this.filtered.getHeight() + StockExportPopup.this.border / 2);
            StockExportPopup.this.all.setSize(parent.getWidth() - 2 * StockExportPopup.this.border, (int)StockExportPopup.this.all.getPreferredSize().getHeight());
            if (StockExportPopup.this.customerMaterialOnly != null) {
                StockExportPopup.this.customerMaterialOnly.setLocation(StockExportPopup.this.border, StockExportPopup.this.all.getY() + StockExportPopup.this.all.getHeight() + StockExportPopup.this.border);
                StockExportPopup.this.customerMaterialOnly.setSize(parent.getWidth() - 2 * StockExportPopup.this.border, (int)StockExportPopup.this.customerMaterialOnly.getPreferredSize().getHeight());
                StockExportPopup.this.includeZeroStockCustomerMaterial.setLocation(StockExportPopup.this.border * 2, StockExportPopup.this.customerMaterialOnly.getY() + StockExportPopup.this.customerMaterialOnly.getHeight() + StockExportPopup.this.border / 2);
                StockExportPopup.this.includeZeroStockCustomerMaterial.setSize(parent.getWidth() - 3 * StockExportPopup.this.border, (int)StockExportPopup.this.includeZeroStockCustomerMaterial.getPreferredSize().getHeight());
            }
        }
    }
}

