/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.template.purchaseorder.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.template.purchaseorder.details.OrderPositionDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.tables.UserSearchTable;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.template.PurchaseOrderTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T>
implements SearchTextField2Listener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private OrderPositionDetailsPanel positionPanel;
    private SupplierLight oldValue;
    private TitledItem<RDTextField> name;
    private TitledItem<RDComboBox> costCenter;
    private TitledItem<RDSearchTextField2> supplier;
    private TitledItem<TextLabel> supplierRo;
    private TitledItem<RDMultiLocationComboBox> locations;
    private UserSearchTable userSearchTable;

    public ConfigurationDetailsPanel(RowEditor<T> editor, RDProvider provider, boolean withSupplier, boolean withUsers, OrderPositionDetailsPanel p) {
        super(editor, provider);
        this.positionPanel = p;
        this.setTitleText(Words.CONFIGURATION);
        this.setCustomLayouter(new Layout());
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.costCenter = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class)), this.getDepartmentTitleName(), TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        if (withUsers) {
            this.userSearchTable = new UserSearchTable(false);
        }
        if (withSupplier) {
            if (!editor.getModel().isAddRow()) {
                this.supplierRo = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(SupplierConverter.class)), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
                this.supplierRo.getElement().setReadOnlyTextField(true);
                this.addToView(this.supplierRo);
            } else {
                this.supplier = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.SUPPLIER), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
                this.supplier.setEnabled(editor.getModel().isAddRow());
                this.supplier.getElement().addSearchTextFieldListener(this);
                this.addToView(this.supplier);
            }
        }
        this.addToView(this.name);
        this.addToView(this.costCenter);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        if (this.userSearchTable != null) {
            this.addToView(this.userSearchTable);
        }
        this.ensureAddButtonState();
    }

    public String getDepartmentTitleName() {
        return Words.DEPARTMENT;
    }

    private void ensureAddButtonState() {
        if (this.supplier != null) {
            if (this.supplier.getElement().isItemSelected()) {
                this.positionPanel.enableAdd((SupplierLight)this.supplier.getElement().getNode().getValue());
            }
        } else {
            this.positionPanel.enableAdd(null);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = this.name.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.costCenter);
        if (this.editor.getModel().isAddRow()) {
            CheckedListAdder.addToList(focusList, this.supplier);
        }
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.userSearchTable);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.costCenter.kill();
        if (this.supplier != null) {
            this.supplier.kill();
        }
        if (this.supplierRo != null) {
            this.supplierRo.kill();
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.locations = null;
        if (this.userSearchTable != null) {
            this.userSearchTable.kill();
        }
        this.userSearchTable = null;
        this.name = null;
        this.costCenter = null;
        this.supplier = null;
        this.supplierRo = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.name.getElement().setNode(node.getChildNamed(OrderTemplateComplete_.name));
        this.costCenter.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
        this.costCenter.getElement().setNode(node.getChildNamed(OrderTemplateComplete_.costCenter));
        if (this.supplier != null) {
            this.supplier.getElement().setNode(node.getChildNamed(PurchaseOrderTemplateComplete_.supplier));
            this.oldValue = (SupplierLight)node.getChildNamed(PurchaseOrderTemplateComplete_.supplier).getValue();
        }
        if (this.supplierRo != null) {
            this.supplierRo.getElement().setNode(node.getChildNamed(PurchaseOrderTemplateComplete_.supplier));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(OrderTemplateComplete_.eligibleLocations));
        }
        if (this.userSearchTable != null) {
            this.userSearchTable.getModel().setNode(node.getChildNamed(OrderTemplateComplete_.templateUsers));
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.costCenter.setEnabled(isEnabled);
        if (this.supplier != null) {
            this.supplier.setEnabled(isEnabled && this.editor.getModel().isAddRow());
        }
        if (this.supplierRo != null) {
            this.supplierRo.setEnabled(isEnabled);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled);
        }
        if (this.userSearchTable != null) {
            this.userSearchTable.setEnabled(isEnabled);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        SupplierLight nV = (SupplierLight)n.getValue();
        if (this.positionPanel.getRowCount() > 0 && this.oldValue != null && !this.oldValue.equals((Object)nV)) {
            InnerPopupFactory.showDesicionPopup(Words.SUPPLIER_CHANGED, Words.SUPPLIER_CHANGED_LONG, source, this, 350, -1, PopupType.FATAL);
        } else {
            this.oldValue = nV;
            this.ensureAddButtonState();
            this.positionPanel.enableAdd(this.oldValue);
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            this.supplier.getElement().getNode().setValue((Object)this.oldValue, System.currentTimeMillis());
            return;
        }
        this.oldValue = (SupplierLight)this.supplier.getElement().getNode().getValue();
        this.positionPanel.cleanTable();
        this.positionPanel.enableAdd(this.oldValue);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && (this.name.getElement().getNode().getValue() == null || this.name.getElement().getNode().getValue().equals(""))) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (this.supplier != null && this.supplier.getElement().isWritable() && this.supplier.getElement().getNode().getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_SUPPLIER_IS_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.AT_LEAST_ONE_LOCATION_MUST_BE_SET));
        }
        return validationObjects;
    }

    public boolean isSupplierSet() {
        if (this.supplier == null) {
            return true;
        }
        return this.supplier.getElement().isItemSelected();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.costCenter.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            if (ConfigurationDetailsPanel.this.supplier != null) {
                h = (int)((double)h + ConfigurationDetailsPanel.this.supplier.getPreferredSize().getHeight());
                h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            }
            if (ConfigurationDetailsPanel.this.supplierRo != null) {
                h = (int)((double)h + ConfigurationDetailsPanel.this.supplierRo.getPreferredSize().getHeight());
                h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            }
            if (Boolean.TRUE.equals(ConfigurationDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + ConfigurationDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += ConfigurationDetailsPanel.this.verticalBorder;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            ConfigurationDetailsPanel.this.name.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.name.setSize(200, (int)ConfigurationDetailsPanel.this.name.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.costCenter.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.name.getY() + ConfigurationDetailsPanel.this.name.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.costCenter.setSize(200, (int)ConfigurationDetailsPanel.this.costCenter.getPreferredSize().getHeight());
            int cy = ConfigurationDetailsPanel.this.costCenter.getY() + ConfigurationDetailsPanel.this.costCenter.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder;
            if (ConfigurationDetailsPanel.this.supplier != null) {
                ConfigurationDetailsPanel.this.supplier.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, cy);
                int i = 200;
                ConfigurationDetailsPanel.this.supplier.setSize(i, (int)ConfigurationDetailsPanel.this.supplier.getPreferredSize().getHeight());
                cy = ConfigurationDetailsPanel.this.supplier.getY() + ConfigurationDetailsPanel.this.supplier.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder;
            }
            if (ConfigurationDetailsPanel.this.supplierRo != null) {
                ConfigurationDetailsPanel.this.supplierRo.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, cy);
                ConfigurationDetailsPanel.this.supplierRo.setSize(200, (int)ConfigurationDetailsPanel.this.supplierRo.getPreferredSize().getHeight());
                cy = ConfigurationDetailsPanel.this.supplierRo.getY() + ConfigurationDetailsPanel.this.supplierRo.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder;
            }
            if (Boolean.TRUE.equals(ConfigurationDetailsPanel.this.viewSettings.getShowLocation())) {
                ConfigurationDetailsPanel.this.locations.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, cy);
                ConfigurationDetailsPanel.this.locations.setSize(200, (int)ConfigurationDetailsPanel.this.locations.getPreferredSize().getHeight());
            }
            if (ConfigurationDetailsPanel.this.userSearchTable != null) {
                ConfigurationDetailsPanel.this.userSearchTable.setLocation(ConfigurationDetailsPanel.this.horizontalBorder + 200 + ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.name.getY());
                ConfigurationDetailsPanel.this.userSearchTable.setSize(parent.getWidth() - (ConfigurationDetailsPanel.this.userSearchTable.getX() + ConfigurationDetailsPanel.this.horizontalBorder), parent.getHeight() - (ConfigurationDetailsPanel.this.userSearchTable.getY() + ConfigurationDetailsPanel.this.verticalBorder));
            }
        }
    }
}

