/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.useradmin.details;

import ch.icit.pegasus.client.gui.modules.useradmin.details.utils.StoreAccessEditPopup;
import ch.icit.pegasus.client.gui.modules.useradmin.details.utils.StoreAccessTable;
import ch.icit.pegasus.client.gui.modules.useradmin.details.utils.StoreAssignmentTable;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.LocationAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.LocationAccessRightComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class StoreRightsDetailsPanel
extends DefaultDetailsPanel<UserLight> {
    private static final long serialVersionUID = 1L;
    private StoreAccessTable stores;
    private TitledItem<EditButton> editButton;
    private Node<LocationAccessRightComplete> node;
    private StoreAssignmentTable storeAssignmentTable;

    public StoreRightsDetailsPanel(RowEditor<UserLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true);
        this.setExanded(false);
        this.setTitleText(Words.STORE_ACCESS);
        this.stores = new StoreAccessTable(this.node);
        this.editButton = new TitledItem<EditButton>(new EditButton(), Words.DEFAULT_STORE_ACCESS, TitledItem.TitledItemOrientation.EAST);
        this.editButton.getElement().addButtonListener((source, x, y) -> {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, false, false, Words.DEFAULT_STORE_ACCESS);
            popUp.setView(new StoreAccessEditPopup(this.node, true));
            popUp.showPopUp(x, y, 280, -1, null, source, PopupType.NORMAL);
        });
        if (this.settings.getStoreAccessRightsForMovementRestrictionsActive() != null && this.settings.getStoreAccessRightsForMovementRestrictionsActive().booleanValue()) {
            this.stores.setEnabled(true);
        } else {
            this.stores.setEnabled(false);
        }
        if (this.settings.getAccessRightsForMovementRestrictionsActive() != null && this.settings.getAccessRightsForMovementRestrictionsActive().booleanValue()) {
            this.editButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
        }
        this.storeAssignmentTable = new StoreAssignmentTable();
        this.setCustomLayouter(new Layout());
        this.addToView(this.stores);
        this.addToView(this.storeAssignmentTable);
        this.addToView(this.editButton);
    }

    @Override
    public boolean hasExpandableContent() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.editButton);
        CheckedListAdder.addToList(focusList, this.stores);
        CheckedListAdder.addToList(focusList, this.storeAssignmentTable);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.editButton.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    protected void updateNode(Node<LocationAccessRightComplete> node) {
        this.node = node;
        this.stores.setNode(node.getChildNamed(LocationAccessRightComplete_.storeAccessRights));
        this.storeAssignmentTable.setNode(node.getChildNamed(LocationAccessRightComplete_.storeAssignments));
        Node n = this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.currentLocation);
        if (n != null) {
            this.editor.getModel().getNode().removeChild(n, 0L);
        }
        if (this.node != null) {
            this.node.setName(DtoFieldConstants.currentLocation);
            this.editor.getModel().getNode().addChild(this.node, 0L);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 400);
        }

        @Override
        public void layoutContainer(Container parent) {
            StoreRightsDetailsPanel.this.editButton.setLocation(StoreRightsDetailsPanel.this.horizontalBorder, StoreRightsDetailsPanel.this.verticalBorder);
            StoreRightsDetailsPanel.this.editButton.setSize(StoreRightsDetailsPanel.this.editButton.getPreferredSize());
            StoreRightsDetailsPanel.this.stores.setLocation(0, StoreRightsDetailsPanel.this.editButton.getY() + StoreRightsDetailsPanel.this.editButton.getHeight() + StoreRightsDetailsPanel.this.verticalBorder);
            StoreRightsDetailsPanel.this.stores.setSize(parent.getWidth(), parent.getHeight() / 2 - StoreRightsDetailsPanel.this.stores.getY());
            StoreRightsDetailsPanel.this.storeAssignmentTable.setLocation(0, StoreRightsDetailsPanel.this.stores.getY() + StoreRightsDetailsPanel.this.stores.getHeight());
            StoreRightsDetailsPanel.this.storeAssignmentTable.setSize(parent.getWidth(), parent.getHeight() - StoreRightsDetailsPanel.this.storeAssignmentTable.getY());
        }
    }
}

