/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.weeklyplan.details;

import ch.icit.pegasus.client.gui.modules.weeklyplan.details.WeeklyPlanDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class LoadDataDetailsPanel
extends DefaultDetailsPanel<WeeklyPlanLight> {
    private static final long serialVersionUID = 1L;
    private final WeeklyPlanDetailsPanel weeklyPlanDetailsPanel;
    private TextButton reloadFlights;
    private TextButton loadMatDispo;

    public LoadDataDetailsPanel(RowEditor<WeeklyPlanLight> editor, RDProvider provider, WeeklyPlanDetailsPanel weeklyPlanDetailsPanel) {
        super(editor, provider);
        this.weeklyPlanDetailsPanel = weeklyPlanDetailsPanel;
        this.setTitleText("Load Data");
        this.reloadFlights = new TextButton("Load Flights");
        this.reloadFlights.addButtonListener((source, x, y) -> this.reloadFlights());
        this.loadMatDispo = new TextButton("Load Mat Dispo");
        this.loadMatDispo.addButtonListener((source, x, y) -> this.loadMatDispo());
        this.setCustomLayouter(new Layout());
        this.addToView(this.loadMatDispo);
        this.addToView(this.reloadFlights);
    }

    private void loadMatDispo() {
        this.editor.showCommittingAnimation("Load Production Targets from Forecast");
        this.weeklyPlanDetailsPanel.loadMatDispo(new RemoteLoader(){

            public void remoteObjectLoaded(Node<?> node) {
                LoadDataDetailsPanel.this.editor.hideCommittingAnimation();
            }

            public void errorOccurred(ClientException exception) {
                LoadDataDetailsPanel.this.editor.hideCommittingAnimation();
            }
        });
    }

    private void reloadFlights() {
        this.editor.showCommittingAnimation("Load Flights");
        this.weeklyPlanDetailsPanel.reloadFlights(new RemoteLoader(){

            public void remoteObjectLoaded(Node<?> node) {
                LoadDataDetailsPanel.this.editor.hideCommittingAnimation();
            }

            public void errorOccurred(ClientException exception) {
                LoadDataDetailsPanel.this.editor.hideCommittingAnimation();
            }
        });
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.loadMatDispo.setEnabled(isEnabled);
        this.reloadFlights.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.loadMatDispo.kill();
        this.reloadFlights.kill();
        this.loadMatDispo = null;
        this.reloadFlights = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.reloadFlights);
        CheckedListAdder.addToList(focusList, this.loadMatDispo);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.reloadFlights.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = LoadDataDetailsPanel.this.verticalBorder;
            h = (int)((double)h + LoadDataDetailsPanel.this.reloadFlights.getPreferredSize().getHeight());
            return new Dimension(300, h += LoadDataDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            LoadDataDetailsPanel.this.reloadFlights.setLocation(LoadDataDetailsPanel.this.horizontalBorder, LoadDataDetailsPanel.this.verticalBorder);
            LoadDataDetailsPanel.this.reloadFlights.setSize(LoadDataDetailsPanel.this.reloadFlights.getPreferredSize());
            LoadDataDetailsPanel.this.loadMatDispo.setLocation(LoadDataDetailsPanel.this.reloadFlights.getX() + LoadDataDetailsPanel.this.reloadFlights.getWidth() + LoadDataDetailsPanel.this.horizontalBorder, LoadDataDetailsPanel.this.verticalBorder);
            LoadDataDetailsPanel.this.loadMatDispo.setSize(LoadDataDetailsPanel.this.loadMatDispo.getPreferredSize());
        }
    }
}

