/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.ScreenViewProvider;
import ch.icit.pegasus.client.gui.batch.BatchList;
import ch.icit.pegasus.client.gui.hud.ConnectionToOutside;
import ch.icit.pegasus.client.gui.hud.externopentool.SmartExternOpenTool;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.SubModuleProvider;
import ch.icit.pegasus.client.gui.modules.AppModulesUtils;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.OrderingsUtil;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataRightsE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.Access;
import ch.icit.pegasus.server.core.general.IUniversal;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScreenLoader<T extends IUniversal> {
    Logger log = LoggerFactory.getLogger(ScreenLoader.class);

    public void loadScreen(SubModuleDefinitionComplete m, int x, int y, Component invoker) {
        this.loadScreen(m, x, y, invoker, null);
    }

    public void loadScreen(SubModuleDefinitionComplete m, int x, int y, Component invoker, BatchList<?, ?> batchList) {
        ThreadSafeLoader.clearLoadingList();
        MainFrame mf = this.getMainFrame();
        if (mf != null) {
            Screen s = this.getMainFrame().getCurrenScreen();
            String screenName = m.getInvokingName();
            boolean isScreenInsert = ScreenViewProvider.isScreenInsert(HUDToolkit.getScreenClassForInvoker(screenName));
            boolean isSmartScreen = ScreenViewProvider.isSmartScreen(HUDToolkit.getScreenClassForInvoker(screenName));
            boolean isSmartExternOpenTool = ScreenViewProvider.isSmartExternOpenTool(HUDToolkit.getScreenClassForInvoker(screenName));
            Object screen = ScreenViewProvider.forName(HUDToolkit.getScreenClassForInvoker(screenName), this.getMainFrame(), m.getDisplayName(), this.getMainFrame().getCurrenScreen());
            if (screen != null && screen instanceof Screen) {
                this.getMainFrame().showScreen((Screen)screen, HUDToolkit.getScreenClassForInvoker(screenName));
                if (this.getPopup() != null) {
                    this.getPopup().hidePopUp(new Object[0]);
                    this.clearPopup();
                }
            } else if (screen != null && screen instanceof SmartExternOpenTool) {
                ((SmartExternOpenTool)screen).setBatchList(batchList);
                ((SmartExternOpenTool)screen).setDependantPopup(this.getPopup());
                this.getMainFrame().openExternalTool((SmartExternOpenTool)screen, invoker, x, y);
            }
        }
    }

    public SubModuleAccessRightComplete getPreferredSmartAccessRight(List<SubModuleTypeE> excludeTypes) {
        ArrayList smartScreens = new ArrayList();
        JPanel cv = ScreenViewProvider.getCurrentScreenView();
        ConnectionToOutside<T, ?> a = this.getConnectionToOutside();
        boolean hasDeleteRight = false;
        boolean hasRestoreRight = false;
        if (a instanceof SubModuleProvider) {
            SubModuleProvider s = (SubModuleProvider)((Object)a);
            if (cv instanceof SubModuleProvider) {
                String currentName = HUDToolkit.getInvokerNameForTopScreenClass(ScreenViewProvider.getCurrentScreenClass());
                UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
                for (ModuleAccessRightComplete r : user.getModules()) {
                    if (!r.getModule().getInvokingName().equals(currentName)) continue;
                    if (r.getPreferredSubModule() != null && !excludeTypes.contains(r.getPreferredSubModule().getModule().getType()) && s.isSmartScreenAllowed(r.getPreferredSubModule().getModule(), this.getModel())) {
                        return r.getPreferredSubModule();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public List<SubModuleAccessRightComplete> fillUpSmartAccessRights(List<SubModuleTypeE> excludeTypes) {
        SubModuleDefinitionComplete d;
        ArrayList<SubModuleAccessRightComplete> smartScreens = new ArrayList<SubModuleAccessRightComplete>();
        JPanel cv = ScreenViewProvider.getCurrentScreenView();
        ConnectionToOutside<T, ?> a = this.getConnectionToOutside();
        boolean hasDeleteRight = false;
        boolean hasRestoreRight = false;
        if (a instanceof SubModuleProvider) {
            SubModuleProvider s = (SubModuleProvider)((Object)a);
            if (cv instanceof SubModuleProvider) {
                String currentName = HUDToolkit.getInvokerNameForTopScreenClass(ScreenViewProvider.getCurrentScreenClass());
                if (((SubModuleProvider)((Object)cv)).getOverriddenModuleRights() != null) {
                    currentName = ((SubModuleProvider)((Object)cv)).getOverriddenModuleRights();
                }
                UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
                List modules = (List)((ArrayList)user.getModules()).clone();
                for (ModuleAccessRightComplete r : modules) {
                    if (!r.getModule().getInvokingName().equals(currentName)) continue;
                    for (SubModuleAccessRightComplete rr : r.getSubModules()) {
                        SubModuleDefinitionComplete module;
                        String v;
                        if (excludeTypes.contains(rr.getModule().getType()) || rr.getModule().getInvokingName() == null || !s.isSmartScreenAllowed(rr.getModule(), this.getModel()) || (v = AppModulesUtils.getSubModuleName((module = rr.getModule()).getInvokingName(), module.getDisplayName())) == null || v.isEmpty()) continue;
                        boolean found = false;
                        for (SubModuleAccessRightComplete rt : smartScreens) {
                            if (!rt.getModule().equals((Object)rr.getModule())) continue;
                            found = true;
                        }
                        if (found) continue;
                        smartScreens.add(rr);
                    }
                    for (DataAccessRightComplete acR : r.getAccessRights()) {
                        if (acR.getDataAccessRight().getAccessRight() == DataRightsE.DELETE && s.isDeletable(this.getModel())) {
                            hasDeleteRight = true;
                        }
                        if (acR.getDataAccessRight().getAccessRight() != DataRightsE.RESTORE || !s.isRestorable(this.getModel())) continue;
                        hasRestoreRight = true;
                    }
                }
            }
        }
        if (hasDeleteRight) {
            SubModuleAccessRightComplete delete = new SubModuleAccessRightComplete();
            d = Access.getSubModuleDefinition((SubModuleAccessDefinition)Access.ACTION_DELETE_ITEM);
            delete.setModule(d);
            smartScreens.add(delete);
        }
        if (hasRestoreRight) {
            SubModuleAccessRightComplete restore = new SubModuleAccessRightComplete();
            d = Access.getSubModuleDefinition((SubModuleAccessDefinition)Access.ACTION_RESTORE_ITEM);
            restore.setModule(d);
            smartScreens.add(restore);
        }
        Collections.sort(smartScreens, OrderingsUtil.getSubModuleOrderingByType());
        return smartScreens;
    }

    public List<SubModuleAccessRightComplete> fillUpSmartAccessRights() {
        return this.fillUpSmartAccessRights(new ArrayList<SubModuleTypeE>());
    }

    public abstract ConnectionToOutside<T, ?> getConnectionToOutside();

    public abstract MainFrame getMainFrame();

    public abstract RowModel<T> getModel();

    public abstract InnerPopUp2 getPopup();

    public abstract void clearPopup();
}

