/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates;

import ch.icit.pegasus.client.ScreenViewProvider;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.hud.HistoryObject;
import ch.icit.pegasus.client.gui.hud.smartscreen.SmartScreenTool;
import ch.icit.pegasus.client.gui.screentemplates.SubModuleFrameIconBar;
import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.panels.FrameIconBar;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.util.ConcurrentModificationException;

public abstract class SubModuleScreenInsert<T extends IDTO>
extends TitledScreenInsert<T>
implements SmartScreenTool<T>,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    protected FrameIconBar titleBar;
    protected int currentState;

    @Override
    public void cancelDocument() {
        if (!this.isKilled()) {
            this.setEnabled(false);
        }
        try {
            INodeCreator.getDefaultImpl().clearAllNonPermanentNodes();
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
        HistoryObject h = ScreenViewProvider.getPreviousScreen();
        Screen screen = (Screen)ScreenViewProvider.forName(h, this.getMainFrame());
        if (screen != null && this.getMainFrame() != null && h != null) {
            this.getMainFrame().showScreen(screen, h.getClassName());
        }
    }

    public void setRow(FakeSmartScreenTableRow<T> row) {
        this.titleBar = new SubModuleFrameIconBar(this, row, true, true, null);
        this.titleBar.setProgress(1.0f);
        this.titleBar.setVisible(true);
        this.add(this.titleBar);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.titleBar != null) {
            this.titleBar.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.titleBar != null) {
            this.titleBar.kill();
        }
        this.titleBar = null;
    }

    public int layoutTitleBar(int y, int w) {
        if (this.titleBar != null) {
            this.titleBar.layoutPanel(w, 0, false);
            this.titleBar.setLocation(0, y + AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_screentitle")));
            return this.titleBar.getY() + this.titleBar.getHeight();
        }
        return 0;
    }

    public FrameIconBar getTitleBar() {
        return this.titleBar;
    }

    @Override
    public void errorOccurred(ClientException exception) {
        exception.printStackTrace();
        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)this);
        if (exception.getSate() != ClientExceptionType.SAVE && exception.getSate() != ClientExceptionType.UPDATE) {
            this.cancelDocument();
        } else {
            this.setEnabled(true);
        }
    }
}

