/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.flight.documentscan;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ActionAddDeliverySlipComponent
extends DefaultScrollablePrintPopup2<FlightLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> node;
    private RowModel<FlightLight> rowModel;
    private DocumentScanPanel panel;

    public ActionAddDeliverySlipComponent(Node<FlightLight> node, RowModel<FlightLight> m) {
        super(false, false, false, false, null);
        this.node = node;
        this.rowModel = m;
        this.insertElements();
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.reportTypesLoaded = true;
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.getViewContainer().add(this.panel);
        this.createComponents();
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.node.getChildNamed(FlightLight_.outboundCode).getValue() == null) {
            return "-";
        }
        return "" + (String)this.node.getChildNamed(FlightLight_.outboundCode).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a = super.validateBeforePrint();
        Node<DocumentScanComplete> document = this.panel.getDocument();
        if (document == null || document.getValue() == null || ((DocumentScanComplete)document.getValue()).getFileData().getLocalFile() == null) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No File selected"));
        }
        return a;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.rowModel.getView().refreshCells();
        super.remoteObjectLoaded(node);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                DocumentScanComplete value = null;
                FlightLight flight = (FlightLight)ActionAddDeliverySlipComponent.this.node.getValue();
                value.setDescription("Flight " + flight.getOutboundCode() + " " + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)flight.getStd(), null, new Object[0]));
                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).addScanDocument(new FlightReference(flight.getId()), value);
                ActionAddDeliverySlipComponent.this.node.removeExistingValues();
                ActionAddDeliverySlipComponent.this.node.setValue((Object)flight, 0L);
                ActionAddDeliverySlipComponent.this.node.updateNode();
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionAddDeliverySlipComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.node;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ActionAddDeliverySlipComponent.this.layoutInheritedComponents(parent);
            ActionAddDeliverySlipComponent.this.panel.setLocation(ActionAddDeliverySlipComponent.this.border, y + ActionAddDeliverySlipComponent.this.border);
            ActionAddDeliverySlipComponent.this.panel.setSize(parent.getWidth() - 2 * ActionAddDeliverySlipComponent.this.border, parent.getHeight() - ActionAddDeliverySlipComponent.this.panel.getY() - ActionAddDeliverySlipComponent.this.border);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ActionAddDeliverySlipComponent.this.getInheritedComponentsHeight();
            h += ActionAddDeliverySlipComponent.this.border;
            if (ActionAddDeliverySlipComponent.this.animation != null) {
                h = (int)((double)h + ActionAddDeliverySlipComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(ActionAddDeliverySlipComponent.this.border * 2) + ActionAddDeliverySlipComponent.this.animation.getPreferredSize().getWidth()), h += ActionAddDeliverySlipComponent.this.border);
            }
            h = (int)((double)h + ActionAddDeliverySlipComponent.this.panel.getPreferredSize().getHeight());
            return new Dimension(0, h += ActionAddDeliverySlipComponent.this.border);
        }
    }
}

