/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printallcheckers;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printall.AnalysisPrintAllSheetsComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.panels.CheckerSheetConfigPanel;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ConfigPanelAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.TimePeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightCheckerSheetConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.SingleDTOReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.FlightAnalysisCheckerSheetsConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

public class AnalysisPrintFlightCheckerSheetsComponent
extends AnalysisPrintAllSheetsComponent {
    private static final long serialVersionUID = 1L;
    private TitledDateTimePeriodChooser periodChooser;
    private TitledItem<CheckBox> finalizePaxType;
    private CheckerSheetConfigPanel configPanel;

    public AnalysisPrintFlightCheckerSheetsComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis, ReportTypeE reportType) {
        super(defaultAnalysis, reportType);
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public void addOptionItems() {
        super.addOptionItems();
        PeriodComplete p = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        TimestampPeriodComplete tp = new TimestampPeriodComplete(new Timestamp(p.getStartDate().getTime()), new Timestamp(p.getEndDate().getTime()));
        this.periodChooser = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)tp, false, false));
        this.finalizePaxType = new TitledItem<CheckBox>(new CheckBox(), Words.SET_PAX_TO_FINAL, TitledItem.TitledItemOrientation.EAST);
        this.configPanel = new CheckerSheetConfigPanel();
        this.addOptionsItem(new TimePeriodEditorAnalysisItem(this.periodChooser, "time"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.finalizePaxType, "finalizePaxType"));
        this.addOptionsItem(new ConfigPanelAnalysisItem(this.configPanel, "flightCheckerConfigPanel"));
    }

    @Override
    public String getTitleValue() {
        return Words.ALL + " " + Words.SELECTED;
    }

    @Override
    public List<PegasusFileComplete> processSingleFile(FlightLight flight, AGenericReportConfiguration flightConfig) throws ClientServerCallException {
        FlightAnalysisCheckerSheetsConfiguration aconfig = (FlightAnalysisCheckerSheetsConfiguration)flightConfig;
        aconfig.setTimePeriod(this.periodChooser.getTimePeriod());
        ReportFileComplete reportFileComplete = this.getSelectedReport();
        FlightCheckerSheetConfiguration config = aconfig.getSingleConfiguration();
        config.setStylesheet(reportFileComplete);
        config.setFormat(ReportingOutputFormatE.PDF);
        config.setDto((IDTO)new FlightReference(flight.getId()));
        PegasusFileComplete fileComplete = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightCheckerSheet((SingleDTOReportConfiguration)config).getValue();
        return Collections.singletonList(fileComplete);
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        FlightAnalysisCheckerSheetsConfiguration config = new FlightAnalysisCheckerSheetsConfiguration();
        config.setReportType(this.getReportType());
        config.setTimePeriod(this.periodChooser.getTimePeriod());
        ReportingOutputFormatE format = ReportingOutputFormatE.PDF;
        config.setReportFormatType(format);
        this.configPanel.fillReportConfiguration(config);
        if (this.finalizePaxType != null) {
            config.setFinalizePaxType(Boolean.valueOf(this.finalizePaxType.getElement().isChecked()));
        }
        return config;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> screenValidationObjects = this.configPanel.validateBeforePrint();
        return screenValidationObjects;
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.AnalysisFlightCheckerSheets;
    }
}

