/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.productsdailyops;

import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.impl.FlightPrintBatch;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.DailyOpsSheetTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.IFlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.SearchReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public class PrintProductDailyOpsComponent<T extends IFlightReference>
extends DefaultScrollablePrintPopup2<T> {
    private static final long serialVersionUID = 1L;
    protected TextLabel options;
    protected TitledItem<CheckBox> includePlannedFlights;
    protected TitledItem<CheckBox> showAllProducts;
    protected TitledItem<CheckBox> hideFromToNSDS;
    protected TitledItem<CheckBox> useChronology;
    protected TitledItem<CheckBox> showAllClasses;
    protected TitledItem<DateChooserPopup> dateChooser;
    protected TitledDateTimePeriodChooser dateTimeChooser;
    protected TitledItem<SearchComboBox> customer;
    protected TitledItem<ComboBox> category;
    private TitledItem<SearchTextField2<AirportComplete>> deliveryAirport;
    protected Date selectedDate;
    private final boolean withTime;

    public PrintProductDailyOpsComponent(Date date, boolean withTime) {
        super(true, true, false, false, ReportTypeE.PRODUCT_DAILY_OPS);
        this.selectedDate = date;
        this.withTime = withTime;
    }

    @Override
    public void insertElements() {
        this.createComponents();
        Font tf = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type"));
        Color tfc = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground"));
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.deliveryAirport = new TitledItem<SearchTextField2<AirportComplete>>(SearchTextField2Factory.getAirportSearchField(true, new DTOProxyNode()), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryAirport.setTitleFont(f);
        this.deliveryAirport.setTitleForeground(fb);
        this.options = new TextLabel(Words.OPTIONS);
        this.options.setFont(tf);
        this.options.setForeground(tfc);
        this.includePlannedFlights = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PLANNED_FLIGHTS, TitledItem.TitledItemOrientation.EAST);
        this.includePlannedFlights.setTitleFont(f);
        this.includePlannedFlights.setTitleForeground(fb);
        this.showAllProducts = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ALL_PRODUCTS, TitledItem.TitledItemOrientation.EAST);
        this.showAllProducts.setTitleFont(f);
        this.showAllProducts.setTitleForeground(fb);
        this.hideFromToNSDS = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_FLIGHTS_FORM_NS_DS, TitledItem.TitledItemOrientation.EAST);
        this.hideFromToNSDS.setTitleFont(f);
        this.hideFromToNSDS.setTitleForeground(fb);
        this.useChronology = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_FLIGHTS_CHRONO, TitledItem.TitledItemOrientation.EAST);
        this.useChronology.setTitleFont(f);
        this.useChronology.setTitleForeground(fb);
        this.showAllClasses = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ALL_CLASSES, TitledItem.TitledItemOrientation.EAST);
        this.showAllClasses.setTitleFont(f);
        this.showAllClasses.setTitleForeground(fb);
        if (this.withTime) {
            Calendar cal = TimeUtil.createCalendar();
            cal.setTime(this.selectedDate);
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            Timestamp s = new Timestamp(cal.getTimeInMillis());
            cal.add(5, 1);
            Timestamp e = new Timestamp(cal.getTimeInMillis());
            this.dateTimeChooser = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new TimestampPeriodComplete(s, e), false, false));
            this.getViewContainer().add(this.dateTimeChooser);
        } else {
            this.dateChooser = new TitledItem<DateChooserPopup>(new DateChooserPopup(this.selectedDate), Words.OPS_DATE, TitledItem.TitledItemOrientation.NORTH);
            this.dateChooser.getElement().enableSkin(true);
            this.getViewContainer().add(this.dateChooser);
        }
        this.customer = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCustomerSearchField(true, new DTOProxyNode()), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.category = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(FlightCategoryComplete.class), ConverterRegistry.getConverter(FlightCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.options);
        this.getViewContainer().add(this.includePlannedFlights);
        this.getViewContainer().add(this.showAllProducts);
        this.getViewContainer().add(this.hideFromToNSDS);
        this.getViewContainer().add(this.useChronology);
        this.getViewContainer().add(this.customer);
        this.getViewContainer().add(this.category);
        this.getViewContainer().add(this.showAllClasses);
        this.getViewContainer().add(this.deliveryAirport);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "include_planned": {
                    this.includePlannedFlights.getElement().setChecked(b);
                    break;
                }
                case "show_all_products": {
                    this.showAllProducts.getElement().setChecked(b);
                    break;
                }
                case "hideNSDS": {
                    this.hideFromToNSDS.getElement().setChecked(b);
                    break;
                }
                case "use_chronology": {
                    this.useChronology.getElement().setChecked(b);
                    break;
                }
                case "show_all_classes": {
                    this.showAllClasses.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("include_planned", "" + this.includePlannedFlights.getElement().isChecked());
        conf.addProperty("show_all_products", "" + this.showAllProducts.getElement().isChecked());
        conf.addProperty("hideNSDS", "" + this.hideFromToNSDS.getElement().isChecked());
        conf.addProperty("use_chronology", "" + this.useChronology.getElement().isChecked());
        conf.addProperty("show_all_classes", "" + this.showAllClasses.getElement().isChecked());
        return conf;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.options.setVisible(true);
        this.customer.setVisible(true);
        if (this.withTime) {
            this.dateTimeChooser.setVisible(true);
        } else {
            this.dateChooser.setVisible(true);
        }
        this.showAllProducts.setVisible(true);
        this.hideFromToNSDS.setVisible(true);
        this.useChronology.setVisible(true);
        this.includePlannedFlights.setVisible(true);
        this.showAllClasses.setVisible(true);
        this.category.setVisible(true);
        this.deliveryAirport.setVisible(true);
    }

    @Override
    public String getTitleString() {
        return Words.DAILY_OPS_BY_PRODUCT;
    }

    @Override
    public String getTitleValue() {
        return Words.ALL_FLIGHTS;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[3];
        return o;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includePlannedFlights);
        CheckedListAdder.addToList(focusList, this.showAllProducts);
        CheckedListAdder.addToList(focusList, this.hideFromToNSDS);
        CheckedListAdder.addToList(focusList, this.useChronology);
        CheckedListAdder.addToList(focusList, this.showAllClasses);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.category);
        if (this.withTime) {
            CheckedListAdder.addToList(focusList, this.dateTimeChooser);
        } else {
            CheckedListAdder.addToList(focusList, this.dateChooser);
        }
        CheckedListAdder.addToList(focusList, this.deliveryAirport);
        return focusList;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean innerComponent;
        if (this.customer != null && (innerComponent = this.customer.isInnerComponent(c))) {
            return true;
        }
        if (this.deliveryAirport != null && (innerComponent = this.deliveryAirport.isInnerComponent(c))) {
            return true;
        }
        if (this.category != null && (innerComponent = this.category.isInnerComponent(c))) {
            return true;
        }
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.options != null) {
            this.options.kill();
        }
        this.options = null;
        if (this.includePlannedFlights != null) {
            this.includePlannedFlights.kill();
        }
        this.includePlannedFlights = null;
        if (this.showAllProducts != null) {
            this.showAllProducts.kill();
        }
        this.showAllProducts = null;
        if (this.showAllClasses != null) {
            this.showAllClasses.kill();
        }
        this.showAllClasses = null;
        if (this.deliveryAirport != null) {
            this.deliveryAirport.kill();
        }
        this.deliveryAirport = null;
        if (this.hideFromToNSDS != null) {
            this.hideFromToNSDS.kill();
        }
        this.hideFromToNSDS = null;
        if (this.useChronology != null) {
            this.useChronology.kill();
        }
        this.useChronology = null;
        if (this.withTime) {
            if (this.dateTimeChooser != null) {
                this.dateTimeChooser.kill();
            }
            this.dateTimeChooser = null;
        } else {
            if (this.dateChooser != null) {
                this.dateChooser.kill();
            }
            this.dateChooser = null;
        }
        if (this.customer != null) {
            this.customer.kill();
        }
        this.customer = null;
        if (this.category != null) {
            this.category.kill();
        }
        this.category = null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.options.setVisible(false);
        this.includePlannedFlights.setVisible(false);
        this.showAllProducts.setVisible(false);
        this.hideFromToNSDS.setVisible(false);
        this.useChronology.setVisible(false);
        this.showAllClasses.setVisible(false);
        this.category.setVisible(false);
        this.deliveryAirport.setVisible(false);
        if (this.withTime) {
            this.dateTimeChooser.setVisible(false);
        } else {
            this.dateChooser.setVisible(false);
        }
        this.customer.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                boolean ipF = PrintProductDailyOpsComponent.this.includePlannedFlights.getElement().isChecked();
                boolean groupMeals = PrintProductDailyOpsComponent.this.showAllProducts.getElement().isChecked();
                boolean hideNSDS = PrintProductDailyOpsComponent.this.hideFromToNSDS.getElement().isChecked();
                boolean isChronological = PrintProductDailyOpsComponent.this.useChronology.getElement().isChecked();
                boolean isAddSpaces = false;
                boolean showAllClass = PrintProductDailyOpsComponent.this.showAllClasses.getElement().isChecked();
                FlightCategoryComplete cat = (FlightCategoryComplete)PrintProductDailyOpsComponent.this.category.getElement().getNode().getValue();
                FlightSearchConfiguration f = new FlightSearchConfiguration();
                f.setCategory(cat);
                if (PrintProductDailyOpsComponent.this.withTime) {
                    f.setDayTimePeriod(PrintProductDailyOpsComponent.this.dateTimeChooser.getTimePeriod());
                } else {
                    Calendar a = PrintProductDailyOpsComponent.this.dateChooser.getElement().getSelectedDate();
                    PeriodComplete p = new PeriodComplete(new Date(a.getTimeInMillis()), new Date(a.getTimeInMillis()));
                    f.setDayPeriod(p);
                }
                f.setCustomer((CustomerLight)PrintProductDailyOpsComponent.this.customer.getElement().getNode().getValue());
                if (!ipF) {
                    f.setOnlyOpenFlights(Boolean.valueOf(true));
                }
                f.setDeliveryAirport((AirportComplete)((SearchTextField2)PrintProductDailyOpsComponent.this.deliveryAirport.getElement()).getNode().getValue());
                f.setNumResults(Integer.MAX_VALUE);
                f.setSortColumn((Enum)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL);
                ReportFileComplete file = PrintProductDailyOpsComponent.this.getSelectedReport();
                SearchReportConfiguration sc = new SearchReportConfiguration(ReportTypeE.FLIGHT, PrintProductDailyOpsComponent.this.getOutputFormat(), file);
                sc.setSearchConfig((ADtoSearchConfiguration)f);
                sc.setTitle(Words.DAILY_OPS_BY_PRODUCT);
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightDailyOpsReport(sc, groupMeals, hideNSDS, isChronological, showAllClass, false, null, DailyOpsSheetTypeE.PRODUCT_BASED, isAddSpaces, !PrintProductDailyOpsComponent.this.withTime).getValue();
                PrintProductDailyOpsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductDailyOpsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<T> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<T> createBatchJob(Node<T> value, ThreadSafeExecutable job) {
        return new FlightPrintBatch<T>(job, value, this.getPrintProcessor(), false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductDailyOpsComponent.this.getInheritedComponentsHeight();
            if (PrintProductDailyOpsComponent.this.animation != null) {
                return new Dimension((int)PrintProductDailyOpsComponent.this.animation.getPreferredSize().getWidth() + 2 * PrintProductDailyOpsComponent.this.border, (int)(PrintProductDailyOpsComponent.this.animation.getPreferredSize().getHeight() + (double)(2 * PrintProductDailyOpsComponent.this.border)));
            }
            h = (int)((double)h + PrintProductDailyOpsComponent.this.options.getPreferredSize().getHeight());
            h += PrintProductDailyOpsComponent.this.border;
            h = (int)((double)h + PrintProductDailyOpsComponent.this.includePlannedFlights.getPreferredSize().getHeight());
            h += PrintProductDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintProductDailyOpsComponent.this.showAllProducts.getPreferredSize().getHeight());
            h += PrintProductDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintProductDailyOpsComponent.this.hideFromToNSDS.getPreferredSize().getHeight());
            h += PrintProductDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintProductDailyOpsComponent.this.useChronology.getPreferredSize().getHeight());
            h += PrintProductDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintProductDailyOpsComponent.this.showAllClasses.getPreferredSize().getHeight());
            h += PrintProductDailyOpsComponent.this.border;
            h = PrintProductDailyOpsComponent.this.withTime ? (int)((double)h + PrintProductDailyOpsComponent.this.dateTimeChooser.getPreferredSize().getHeight()) : (int)((double)h + PrintProductDailyOpsComponent.this.dateChooser.getPreferredSize().getHeight());
            h += PrintProductDailyOpsComponent.this.border;
            h = (int)((double)h + PrintProductDailyOpsComponent.this.customer.getPreferredSize().getHeight());
            h += PrintProductDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintProductDailyOpsComponent.this.category.getPreferredSize().getHeight());
            h += PrintProductDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintProductDailyOpsComponent.this.deliveryAirport.getPreferredSize().getHeight());
            return new Dimension(0, h += PrintProductDailyOpsComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = PrintProductDailyOpsComponent.this.layoutInheritedComponents(parent);
            PrintProductDailyOpsComponent.this.options.setLocation(PrintProductDailyOpsComponent.this.border, h += PrintProductDailyOpsComponent.this.border);
            PrintProductDailyOpsComponent.this.options.setSize(PrintProductDailyOpsComponent.this.options.getPreferredSize());
            PrintProductDailyOpsComponent.this.includePlannedFlights.setLocation(PrintProductDailyOpsComponent.this.border, PrintProductDailyOpsComponent.this.options.getY() + PrintProductDailyOpsComponent.this.options.getHeight() + PrintProductDailyOpsComponent.this.border);
            PrintProductDailyOpsComponent.this.includePlannedFlights.setSize(PrintProductDailyOpsComponent.this.includePlannedFlights.getPreferredSize());
            PrintProductDailyOpsComponent.this.showAllProducts.setLocation(PrintProductDailyOpsComponent.this.border, PrintProductDailyOpsComponent.this.includePlannedFlights.getY() + PrintProductDailyOpsComponent.this.includePlannedFlights.getHeight() + PrintProductDailyOpsComponent.this.border / 2);
            PrintProductDailyOpsComponent.this.showAllProducts.setSize(PrintProductDailyOpsComponent.this.showAllProducts.getPreferredSize());
            PrintProductDailyOpsComponent.this.hideFromToNSDS.setLocation(PrintProductDailyOpsComponent.this.border, PrintProductDailyOpsComponent.this.showAllProducts.getY() + PrintProductDailyOpsComponent.this.showAllProducts.getHeight() + PrintProductDailyOpsComponent.this.border / 2);
            PrintProductDailyOpsComponent.this.hideFromToNSDS.setSize(PrintProductDailyOpsComponent.this.hideFromToNSDS.getPreferredSize());
            PrintProductDailyOpsComponent.this.useChronology.setLocation(PrintProductDailyOpsComponent.this.border, PrintProductDailyOpsComponent.this.hideFromToNSDS.getY() + PrintProductDailyOpsComponent.this.hideFromToNSDS.getHeight() + PrintProductDailyOpsComponent.this.border / 2);
            PrintProductDailyOpsComponent.this.useChronology.setSize(PrintProductDailyOpsComponent.this.useChronology.getPreferredSize());
            int y = PrintProductDailyOpsComponent.this.useChronology.getY() + PrintProductDailyOpsComponent.this.useChronology.getHeight();
            PrintProductDailyOpsComponent.this.showAllClasses.setLocation(PrintProductDailyOpsComponent.this.border, y + PrintProductDailyOpsComponent.this.border / 2);
            PrintProductDailyOpsComponent.this.showAllClasses.setSize(PrintProductDailyOpsComponent.this.showAllClasses.getPreferredSize());
            y = PrintProductDailyOpsComponent.this.showAllClasses.getY() + PrintProductDailyOpsComponent.this.showAllClasses.getHeight() + PrintProductDailyOpsComponent.this.border;
            if (PrintProductDailyOpsComponent.this.withTime) {
                PrintProductDailyOpsComponent.this.dateTimeChooser.setLocation(PrintProductDailyOpsComponent.this.border, y);
                PrintProductDailyOpsComponent.this.dateTimeChooser.setSize(PrintProductDailyOpsComponent.this.dateTimeChooser.getPreferredSize());
                y = (int)((double)y + PrintProductDailyOpsComponent.this.dateTimeChooser.getPreferredSize().getHeight());
            } else {
                PrintProductDailyOpsComponent.this.dateChooser.setLocation(PrintProductDailyOpsComponent.this.border, y);
                PrintProductDailyOpsComponent.this.dateChooser.setSize(PrintProductDailyOpsComponent.this.dateChooser.getPreferredSize());
                y = (int)((double)y + PrintProductDailyOpsComponent.this.dateChooser.getPreferredSize().getHeight());
            }
            PrintProductDailyOpsComponent.this.deliveryAirport.setLocation(PrintProductDailyOpsComponent.this.border, y + PrintProductDailyOpsComponent.this.border / 2);
            PrintProductDailyOpsComponent.this.deliveryAirport.setSize(parent.getWidth() - 2 * PrintProductDailyOpsComponent.this.border, (int)PrintProductDailyOpsComponent.this.deliveryAirport.getPreferredSize().getHeight());
            y = PrintProductDailyOpsComponent.this.deliveryAirport.getY() + PrintProductDailyOpsComponent.this.deliveryAirport.getHeight();
            PrintProductDailyOpsComponent.this.customer.setLocation(PrintProductDailyOpsComponent.this.border, y + PrintProductDailyOpsComponent.this.border);
            PrintProductDailyOpsComponent.this.customer.setSize(parent.getWidth() - 2 * PrintProductDailyOpsComponent.this.border, (int)PrintProductDailyOpsComponent.this.customer.getPreferredSize().getHeight());
            y = PrintProductDailyOpsComponent.this.customer.getY() + PrintProductDailyOpsComponent.this.customer.getHeight() + PrintProductDailyOpsComponent.this.border / 2;
            PrintProductDailyOpsComponent.this.category.setLocation(PrintProductDailyOpsComponent.this.border, y);
            PrintProductDailyOpsComponent.this.category.setSize(parent.getWidth() - 2 * PrintProductDailyOpsComponent.this.border, (int)PrintProductDailyOpsComponent.this.category.getPreferredSize().getHeight());
        }
    }
}

