/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.groupedcheckin.product.ean;

import ch.icit.pegasus.client.gui.submodules.analysis.groupedcheckin.product.ean.AnalysisProductCheckinEanSheetReport;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class AnalysisProductCheckinEanSheetComponent
extends DefaultServerSideAnalysisComponent<ProductStockCheckinGroupComplete, ProductStockCheckinGroupReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;

    public AnalysisProductCheckinEanSheetComponent(AnalysisProductCheckinEanSheetReport productListAnalysis) {
        super(productListAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(n), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.dueDate, "dueDate"));
    }

    @Override
    public ProductStockCheckinGroupReference createReference(ProductStockCheckinGroupComplete item) {
        return new ProductStockCheckinGroupReference(item.getId());
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        List references = this.loadItemReferences();
        ProductFactSheetReportConfiguration configuration = new ProductFactSheetReportConfiguration();
        Timestamp d = null;
        if (this.dueDate.getElement().getNode().getValue() instanceof Date) {
            d = new Timestamp(((Date)this.dueDate.getElement().getNode().getValue()).getTime());
        } else if (this.dueDate.getElement().getNode().getValue() instanceof Timestamp) {
            d = (Timestamp)this.dueDate.getElement().getNode().getValue();
        }
        configuration.setDueDate(d);
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductCheckinEANSheet(new ListWrapper(references), configuration).getValue();
        return file;
    }
}

