/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.articlestockswap.articlelabels;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ArticleSwapServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportLight;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportLight_;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportReference;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapLabelConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PrintArticleSwapLabelsComponent
extends DefaultScrollablePrintPopup2<ArticleStockSwapDataImportLight> {
    private static final long serialVersionUID = 1L;
    private List<StoreLight> availableStores;
    private Node<ArticleStockSwapDataImportLight> order;
    private TitledItem<TextField> startPosition;
    private TitledItem<CheckBox> includeBarCode;
    private TitledItem<CheckBox> newPageByStore;
    private TitledItem<CheckBox> newPageByArticle;
    private TitledItem<RadioButton> chooseByStore;
    private TitledItem<RadioButton> chooseByStoreType;
    private HorizontalSeparator sep;
    private TitledItem<CheckBox> useFixLabelCount;
    private TitledItem<TextField> labelCount;
    private TitledItem<CheckBox> includeMainStore;
    private TitledItem<CheckBox> includeFloatStore;
    private List<TitledItem<CheckBox>> stores = new ArrayList<TitledItem<CheckBox>>();

    public PrintArticleSwapLabelsComponent(Node<ArticleStockSwapDataImportLight> currentNode) {
        super(true, true, false, false, ReportTypeE.ARTICLE_STORE_INFO_SHEET);
        this.order = currentNode;
        this.loadBeforeShowing(() -> {
            try {
                this.availableStores = ((ArticleSwapServiceManager)ServiceManagerRegistry.getService(ArticleSwapServiceManager.class)).getStores(new ArticleStockSwapDataImportReference(((ArticleStockSwapDataImportLight)currentNode.getValue()).getId())).getList();
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), "Unable to load Stores", (Component)this);
            }
        });
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        return reportFile.getDescription().contains("Label");
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public String getTitleString() {
        return Words.STOCK_SWAP;
    }

    @Override
    public String getTitleValue() {
        return "" + (String)this.order.getChildNamed(ArticleStockSwapDataImportLight_.name).getValue();
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.getViewContainer().setLayout(new Layout());
        this.includeBarCode = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_BAR_CODE, TitledItem.TitledItemOrientation.EAST);
        this.includeBarCode.getElement().setChecked(true);
        this.getViewContainer().add(this.includeBarCode);
        this.startPosition = new TitledItem<TextField>(new TextField((Node)new DTONode(), TextFieldType.INT), Words.START_POSITION, TitledItem.TitledItemOrientation.NORTH);
        this.startPosition.getElement().setText("1");
        this.includeMainStore = new TitledItem<CheckBox>(new CheckBox(), "Print Main Store Labels", TitledItem.TitledItemOrientation.EAST);
        this.includeFloatStore = new TitledItem<CheckBox>(new CheckBox(), "Print Float Store Labels", TitledItem.TitledItemOrientation.EAST);
        this.includeMainStore.getFader().setProgress(0.0f);
        this.includeFloatStore.getFader().setProgress(0.0f);
        this.includeMainStore.getFader().setPermanent(true);
        this.includeFloatStore.getFader().setPermanent(true);
        this.sep = new HorizontalSeparator();
        this.chooseByStore = new TitledItem<RadioButton>(new RadioButton(), "Filter by Store", TitledItem.TitledItemOrientation.EAST);
        this.chooseByStoreType = new TitledItem<RadioButton>(new RadioButton(), "Filter by Store Type", TitledItem.TitledItemOrientation.EAST);
        this.newPageByArticle = new TitledItem<CheckBox>(new CheckBox(), "New Page by Article", TitledItem.TitledItemOrientation.EAST);
        this.newPageByStore = new TitledItem<CheckBox>(new CheckBox(), "New Page by Store", TitledItem.TitledItemOrientation.EAST);
        this.chooseByStore.getElement().setChecked(true);
        this.useFixLabelCount = new TitledItem<CheckBox>(new CheckBox(), "Use Fix Label Count", TitledItem.TitledItemOrientation.EAST);
        this.useFixLabelCount.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        this.labelCount = new TitledItem<TextField>(new TextField(null, TextFieldType.INT), "Label Count", TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.startPosition);
        this.getViewContainer().add(this.includeMainStore);
        this.getViewContainer().add(this.includeFloatStore);
        this.getViewContainer().add(this.sep);
        this.getViewContainer().add(this.chooseByStore);
        this.getViewContainer().add(this.chooseByStoreType);
        this.getViewContainer().add(this.newPageByArticle);
        this.getViewContainer().add(this.newPageByStore);
        this.getViewContainer().add(this.useFixLabelCount);
        this.getViewContainer().add(this.labelCount);
        this.chooseByStore.getElement().addButtonListener((e, x, y) -> {
            for (TitledItem<CheckBox> store : this.stores) {
                store.fadeIn();
            }
            this.includeMainStore.fadeOut(false);
            this.includeFloatStore.fadeOut(false);
            this.setEnabled(this.isEnabled());
        });
        this.chooseByStoreType.getElement().addButtonListener((e, x, y) -> {
            for (TitledItem<CheckBox> store : this.stores) {
                store.fadeOut(false);
            }
            this.includeMainStore.fadeIn();
            this.includeFloatStore.fadeIn();
            this.setEnabled(this.isEnabled());
        });
        for (StoreLight availableStore : this.availableStores) {
            TitledItem<CheckBox> checkBoxTitledItem = new TitledItem<CheckBox>(new CheckBox(), availableStore.getCode(), TitledItem.TitledItemOrientation.EAST);
            checkBoxTitledItem.setUserObject(availableStore);
            this.stores.add(checkBoxTitledItem);
            checkBoxTitledItem.getFader().setPermanent(true);
            this.getViewContainer().add(checkBoxTitledItem);
        }
        this.validate();
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includeBarCode);
        CheckedListAdder.addToList(focusList, this.newPageByArticle);
        CheckedListAdder.addToList(focusList, this.newPageByStore);
        CheckedListAdder.addToList(focusList, this.chooseByStore);
        CheckedListAdder.addToList(focusList, this.chooseByStoreType);
        CheckedListAdder.addToList(focusList, this.includeMainStore);
        CheckedListAdder.addToList(focusList, this.includeFloatStore);
        CheckedListAdder.addToList(focusList, this.useFixLabelCount);
        CheckedListAdder.addToList(focusList, this.labelCount);
        for (TitledItem<CheckBox> store : this.stores) {
            CheckedListAdder.addToList(focusList, store);
        }
        CheckedListAdder.addToList(focusList, this.startPosition);
        return focusList;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.startPosition != null) {
            this.startPosition.kill();
        }
        this.startPosition = null;
        if (this.includeBarCode != null) {
            this.includeBarCode.kill();
        }
        this.includeBarCode = null;
        if (this.includeFloatStore != null) {
            this.includeFloatStore.kill();
        }
        if (this.includeMainStore != null) {
            this.includeMainStore.kill();
        }
        if (this.useFixLabelCount != null) {
            this.useFixLabelCount.kill();
        }
        this.useFixLabelCount = null;
        if (this.labelCount != null) {
            this.labelCount.kill();
        }
        this.labelCount = null;
        if (this.sep != null) {
            this.sep.kill();
        }
        if (this.chooseByStoreType != null) {
            this.chooseByStoreType.kill();
        }
        if (this.chooseByStore != null) {
            this.chooseByStore.kill();
        }
        if (this.newPageByStore != null) {
            this.newPageByStore.kill();
        }
        if (this.newPageByArticle != null) {
            this.newPageByArticle.kill();
        }
        if (this.stores != null) {
            this.stores.forEach(checkBoxTitledItem -> checkBoxTitledItem.kill());
        }
        this.includeMainStore = null;
        this.includeFloatStore = null;
        this.sep = null;
        this.chooseByStoreType = null;
        this.chooseByStore = null;
        this.newPageByArticle = null;
        this.newPageByStore = null;
        this.stores.clear();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean filterStores = this.chooseByStore.getElement().isChecked();
        this.includeBarCode.setEnabled(isEnabled);
        this.includeMainStore.setEnabled(isEnabled && !filterStores);
        this.includeFloatStore.setEnabled(isEnabled && !filterStores);
        this.chooseByStore.setEnabled(isEnabled);
        this.chooseByStoreType.setEnabled(isEnabled);
        this.useFixLabelCount.setEnabled(isEnabled);
        this.labelCount.setEnabled(isEnabled && this.useFixLabelCount.getElement().isChecked());
        this.newPageByStore.setEnabled(isEnabled);
        this.newPageByArticle.setEnabled(isEnabled);
        for (TitledItem<CheckBox> store : this.stores) {
            store.setEnabled(isEnabled && filterStores);
        }
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete selectedReport = PrintArticleSwapLabelsComponent.this.getSelectedReport();
                int startPosition = 1;
                try {
                    startPosition = Integer.valueOf(((TextField)PrintArticleSwapLabelsComponent.this.startPosition.getElement()).getText());
                }
                catch (NumberFormatException e) {
                    startPosition = 1;
                }
                boolean inclBarCode = ((CheckBox)PrintArticleSwapLabelsComponent.this.includeBarCode.getElement()).isChecked();
                ArticleStockSwapLabelConfiguration conf = new ArticleStockSwapLabelConfiguration();
                conf.setSwapReference(new ArticleStockSwapDataImportReference(((ArticleStockSwapDataImportLight)PrintArticleSwapLabelsComponent.this.order.getValue()).getId()));
                conf.setStyleSheet(selectedReport);
                conf.setIncludeBarCode(Boolean.valueOf(inclBarCode));
                conf.setStartPosition(Integer.valueOf(startPosition));
                conf.setIncludeMainStore(((CheckBox)PrintArticleSwapLabelsComponent.this.includeMainStore.getElement()).isChecked());
                conf.setIncludeFloatStore(((CheckBox)PrintArticleSwapLabelsComponent.this.includeFloatStore.getElement()).isChecked());
                conf.setFilterByStore(((RadioButton)PrintArticleSwapLabelsComponent.this.chooseByStore.getElement()).isChecked());
                conf.setNewPageByStore(((CheckBox)PrintArticleSwapLabelsComponent.this.newPageByStore.getElement()).isChecked());
                conf.setNewPageByArticle(((CheckBox)PrintArticleSwapLabelsComponent.this.newPageByArticle.getElement()).isChecked());
                if (((CheckBox)PrintArticleSwapLabelsComponent.this.useFixLabelCount.getElement()).isChecked()) {
                    int lc = 1;
                    try {
                        lc = Integer.parseInt(((TextField)PrintArticleSwapLabelsComponent.this.labelCount.getElement()).getText());
                    }
                    catch (NumberFormatException e) {
                        lc = 1;
                    }
                    conf.setLabelCount(Integer.valueOf(lc));
                } else {
                    conf.setLabelCount(null);
                }
                for (TitledItem store : PrintArticleSwapLabelsComponent.this.stores) {
                    if (!((CheckBox)store.getElement()).isChecked()) continue;
                    StoreLight userObject = (StoreLight)store.getUserObject();
                    conf.getStores().add(new StoreReference(userObject.getId()));
                }
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createArticleLabelsForStockSwap(conf).getValue();
                PrintArticleSwapLabelsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleSwapLabelsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ArticleStockSwapDataImportLight> getCurrentNode() {
        return this.order;
    }

    @Override
    public BatchJob<ArticleStockSwapDataImportLight> createBatchJob(Node<ArticleStockSwapDataImportLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void insertElements() {
        this.createComponents();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticleSwapLabelsComponent.this.layoutInheritedComponents(parent);
            PrintArticleSwapLabelsComponent.this.includeBarCode.setLocation(PrintArticleSwapLabelsComponent.this.border, PrintArticleSwapLabelsComponent.this.border + y);
            PrintArticleSwapLabelsComponent.this.includeBarCode.setSize(parent.getWidth() - 2 * PrintArticleSwapLabelsComponent.this.border, (int)PrintArticleSwapLabelsComponent.this.includeBarCode.getPreferredSize().getHeight());
            PrintArticleSwapLabelsComponent.this.newPageByArticle.setLocation(PrintArticleSwapLabelsComponent.this.border, PrintArticleSwapLabelsComponent.this.includeBarCode.getY() + PrintArticleSwapLabelsComponent.this.includeBarCode.getHeight() + PrintArticleSwapLabelsComponent.this.border);
            PrintArticleSwapLabelsComponent.this.newPageByArticle.setSize(PrintArticleSwapLabelsComponent.this.newPageByArticle.getPreferredSize());
            PrintArticleSwapLabelsComponent.this.newPageByStore.setLocation(PrintArticleSwapLabelsComponent.this.border, PrintArticleSwapLabelsComponent.this.newPageByArticle.getY() + PrintArticleSwapLabelsComponent.this.newPageByArticle.getHeight() + PrintArticleSwapLabelsComponent.this.border);
            PrintArticleSwapLabelsComponent.this.newPageByStore.setSize(PrintArticleSwapLabelsComponent.this.newPageByStore.getPreferredSize());
            PrintArticleSwapLabelsComponent.this.sep.setLocation(0, PrintArticleSwapLabelsComponent.this.newPageByStore.getY() + PrintArticleSwapLabelsComponent.this.newPageByStore.getHeight() + PrintArticleSwapLabelsComponent.this.border);
            PrintArticleSwapLabelsComponent.this.sep.setSize(parent.getWidth(), (int)PrintArticleSwapLabelsComponent.this.sep.getPreferredSize().getHeight());
            PrintArticleSwapLabelsComponent.this.chooseByStore.setLocation(PrintArticleSwapLabelsComponent.this.border, PrintArticleSwapLabelsComponent.this.sep.getY() + PrintArticleSwapLabelsComponent.this.sep.getHeight() + PrintArticleSwapLabelsComponent.this.border);
            PrintArticleSwapLabelsComponent.this.chooseByStore.setSize(PrintArticleSwapLabelsComponent.this.chooseByStore.getPreferredSize());
            PrintArticleSwapLabelsComponent.this.chooseByStoreType.setLocation(PrintArticleSwapLabelsComponent.this.border, PrintArticleSwapLabelsComponent.this.chooseByStore.getY() + PrintArticleSwapLabelsComponent.this.chooseByStore.getHeight() + PrintArticleSwapLabelsComponent.this.border);
            PrintArticleSwapLabelsComponent.this.chooseByStoreType.setSize(PrintArticleSwapLabelsComponent.this.chooseByStoreType.getPreferredSize());
            int cy = PrintArticleSwapLabelsComponent.this.chooseByStoreType.getY() + PrintArticleSwapLabelsComponent.this.chooseByStoreType.getHeight() + PrintArticleSwapLabelsComponent.this.border;
            if (PrintArticleSwapLabelsComponent.this.includeMainStore.getFader().getProgress() > 0.0f) {
                PrintArticleSwapLabelsComponent.this.includeMainStore.setLocation(PrintArticleSwapLabelsComponent.this.border, PrintArticleSwapLabelsComponent.this.chooseByStoreType.getY() + PrintArticleSwapLabelsComponent.this.chooseByStoreType.getHeight() + PrintArticleSwapLabelsComponent.this.border);
                PrintArticleSwapLabelsComponent.this.includeMainStore.setSize(PrintArticleSwapLabelsComponent.this.includeMainStore.getPreferredSize());
                PrintArticleSwapLabelsComponent.this.includeFloatStore.setLocation(PrintArticleSwapLabelsComponent.this.border, PrintArticleSwapLabelsComponent.this.includeMainStore.getY() + PrintArticleSwapLabelsComponent.this.includeMainStore.getHeight() + PrintArticleSwapLabelsComponent.this.border);
                PrintArticleSwapLabelsComponent.this.includeFloatStore.setSize(PrintArticleSwapLabelsComponent.this.includeFloatStore.getPreferredSize());
                cy = PrintArticleSwapLabelsComponent.this.includeFloatStore.getY() + PrintArticleSwapLabelsComponent.this.includeFloatStore.getHeight() + PrintArticleSwapLabelsComponent.this.border;
            }
            PrintArticleSwapLabelsComponent.this.useFixLabelCount.setLocation(PrintArticleSwapLabelsComponent.this.border, cy);
            PrintArticleSwapLabelsComponent.this.useFixLabelCount.setSize(PrintArticleSwapLabelsComponent.this.useFixLabelCount.getPreferredSize());
            PrintArticleSwapLabelsComponent.this.labelCount.setLocation(PrintArticleSwapLabelsComponent.this.border, PrintArticleSwapLabelsComponent.this.useFixLabelCount.getY() + PrintArticleSwapLabelsComponent.this.useFixLabelCount.getHeight() + PrintArticleSwapLabelsComponent.this.border / 2);
            PrintArticleSwapLabelsComponent.this.labelCount.setSize(PrintArticleSwapLabelsComponent.this.labelCount.getPreferredSize());
            cy = PrintArticleSwapLabelsComponent.this.labelCount.getY() + PrintArticleSwapLabelsComponent.this.labelCount.getHeight() + PrintArticleSwapLabelsComponent.this.border;
            for (TitledItem store : PrintArticleSwapLabelsComponent.this.stores) {
                if (!(store.getProgress() > 0.0f)) continue;
                store.setLocation(PrintArticleSwapLabelsComponent.this.border, cy + PrintArticleSwapLabelsComponent.this.border / 2);
                store.setSize(store.getPreferredSize());
                cy = store.getY() + store.getHeight();
            }
            PrintArticleSwapLabelsComponent.this.startPosition.setLocation(PrintArticleSwapLabelsComponent.this.border, cy + PrintArticleSwapLabelsComponent.this.border);
            PrintArticleSwapLabelsComponent.this.startPosition.setSize(parent.getWidth() - 2 * PrintArticleSwapLabelsComponent.this.border, (int)PrintArticleSwapLabelsComponent.this.startPosition.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (PrintArticleSwapLabelsComponent.this.animation != null) {
                return PrintArticleSwapLabelsComponent.this.animation.getPreferredSize();
            }
            int h = PrintArticleSwapLabelsComponent.this.getInheritedComponentsHeight();
            h = (int)((double)h + PrintArticleSwapLabelsComponent.this.includeBarCode.getPreferredSize().getHeight());
            h += PrintArticleSwapLabelsComponent.this.border;
            h = (int)((double)h + PrintArticleSwapLabelsComponent.this.newPageByStore.getPreferredSize().getHeight());
            h += PrintArticleSwapLabelsComponent.this.border;
            h = (int)((double)h + PrintArticleSwapLabelsComponent.this.newPageByArticle.getPreferredSize().getHeight());
            h += PrintArticleSwapLabelsComponent.this.border;
            h = (int)((double)h + PrintArticleSwapLabelsComponent.this.sep.getPreferredSize().getHeight());
            h += PrintArticleSwapLabelsComponent.this.border;
            h = (int)((double)h + PrintArticleSwapLabelsComponent.this.chooseByStoreType.getPreferredSize().getHeight());
            h += PrintArticleSwapLabelsComponent.this.border;
            h = (int)((double)h + PrintArticleSwapLabelsComponent.this.chooseByStore.getPreferredSize().getHeight());
            h += PrintArticleSwapLabelsComponent.this.border;
            if (PrintArticleSwapLabelsComponent.this.includeMainStore.getProgress() > 0.0f) {
                h = (int)((double)h + PrintArticleSwapLabelsComponent.this.includeMainStore.getPreferredSize().getHeight());
                h += PrintArticleSwapLabelsComponent.this.border;
                h = (int)((double)h + PrintArticleSwapLabelsComponent.this.includeFloatStore.getPreferredSize().getHeight());
                h += PrintArticleSwapLabelsComponent.this.border;
            }
            h = (int)((double)h + PrintArticleSwapLabelsComponent.this.useFixLabelCount.getPreferredSize().getHeight());
            h += PrintArticleSwapLabelsComponent.this.border / 2;
            h = (int)((double)h + (PrintArticleSwapLabelsComponent.this.labelCount.getPreferredSize().getHeight() + (double)PrintArticleSwapLabelsComponent.this.border));
            for (TitledItem store : PrintArticleSwapLabelsComponent.this.stores) {
                if (!(store.getProgress() > 0.0f)) continue;
                h = (int)((double)h + store.getPreferredSize().getHeight());
                h += PrintArticleSwapLabelsComponent.this.border / 2;
            }
            h -= PrintArticleSwapLabelsComponent.this.border / 2;
            h += PrintArticleSwapLabelsComponent.this.border;
            h = (int)((double)h + PrintArticleSwapLabelsComponent.this.startPosition.getPreferredSize().getHeight());
            return new Dimension(100, h);
        }
    }
}

