/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.kitchenforecast;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.KitchenForecastConfigPanel_ComboStyle;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.KitchenreportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.KitchenForecastReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PrintFlightKitchenForecastComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> flightNode;
    private KitchenForecastConfigPanel_ComboStyle configPanel;

    public PrintFlightKitchenForecastComponent(Node<FlightLight> node) {
        super(false, false, false, false, ReportTypeE.KITCHEN_FORECAST_PRODUCT_BASED);
        this.flightNode = node;
        this.loadBeforeShowing(() -> {
            try {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
            }
            catch (Exception e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        });
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.configPanel = new KitchenForecastConfigPanel_ComboStyle(null, false);
        this.configPanel.loadComboData();
        this.getViewContainer().add(this.configPanel);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT_KITCHEN_FORECAST;
    }

    @Override
    public String getTitleValue() {
        return ((FlightLight)this.flightNode.getValue()).getOutboundCode();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                KitchenForecastReportConfiguration config = PrintFlightKitchenForecastComponent.this.configPanel.getConfig();
                ArrayList warnings = new ArrayList();
                config.setPeriod(new TimestampPeriodComplete(((FlightLight)PrintFlightKitchenForecastComponent.this.flightNode.getValue()).getStd(), ((FlightLight)PrintFlightKitchenForecastComponent.this.flightNode.getValue()).getStd()));
                config.getFlights().add(PrintFlightKitchenForecastComponent.this.flightNode.getValue());
                List ref = ((KitchenreportServiceManager)ServiceManagerRegistry.getService(KitchenreportServiceManager.class)).createKitchenForecastReport(config, new ListWrapper(warnings)).getList();
                for (PegasusFileComplete pf : ref) {
                    File f = FileTransferUtil.download((PegasusFileComplete)pf, (FileTransferListener[])new FileTransferListener[0]);
                    PrintPopupToolkit.previewFile(f);
                }
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintFlightKitchenForecastComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.flightNode;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintFlightKitchenForecastComponent.this.layoutInheritedComponents(parent) + PrintFlightKitchenForecastComponent.this.border;
            if (PrintFlightKitchenForecastComponent.this.configPanel != null) {
                PrintFlightKitchenForecastComponent.this.configPanel.setLocation(PrintFlightKitchenForecastComponent.this.border, y);
                PrintFlightKitchenForecastComponent.this.configPanel.setSize(parent.getWidth() - 2 * PrintFlightKitchenForecastComponent.this.border, (int)PrintFlightKitchenForecastComponent.this.configPanel.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintFlightKitchenForecastComponent.this.getInheritedComponentsHeight();
            h += PrintFlightKitchenForecastComponent.this.border;
            int w = 250;
            if (PrintFlightKitchenForecastComponent.this.configPanel != null) {
                h = (int)((double)h + PrintFlightKitchenForecastComponent.this.configPanel.getPreferredSize().getHeight());
                h += PrintFlightKitchenForecastComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

