/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.label;

import ch.icit.pegasus.client.gui.submodules.print.shared.labels.PrintLabelComponent;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.LabelReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientCreateReportException;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StowingListReportConfiguration;
import ch.icit.pegasus.server.core.util.ServiceReturnWithMessage;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintFlightLabelComponent
extends PrintLabelComponent<FlightLight> {
    static Logger logger = LoggerFactory.getLogger(PrintFlightLabelComponent.class);
    private static final long serialVersionUID = 8898752790489802948L;
    private final TransferObject<FlightLight> flight;

    public PrintFlightLabelComponent(TransferObject<FlightLight> trans) {
        this.flight = trans;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node b = new Node();
                b.setValue((Object)false, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ReportFileComplete file = PrintFlightLabelComponent.this.getSelectedReport();
                        ArrayList<ScreenValidationObject> warnings = new ArrayList<ScreenValidationObject>();
                        StowingListReportConfiguration config = new StowingListReportConfiguration(ReportTypeE.STOWINGLIST_REPORT, ReportingOutputFormatE.PDF, file);
                        config.setLegs(((FlightLight)PrintFlightLabelComponent.this.flight.getDto()).getLegs());
                        PrintFlightLabelComponent.this.getConfig(config);
                        config.setDto((IDTO)PrintFlightLabelComponent.this.flight.getDto());
                        ServiceReturnWithMessage serviceReturn = null;
                        try {
                            serviceReturn = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).printFlightLabel(config, config.getSpmlLabel().booleanValue(), config.getDifferentOnly().booleanValue(), config.getLegs(), config.getLabelWithContents().booleanValue());
                        }
                        catch (ClientCreateReportException e) {
                            logger.trace("Error while print Labels", (Throwable)e);
                            if (serviceReturn == null) {
                                serviceReturn = new ServiceReturnWithMessage();
                            }
                            serviceReturn.getMessage().add(e.getMessage());
                        }
                        for (String s : serviceReturn.getMessage()) {
                            warnings.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, s));
                        }
                        final ServiceReturnWithMessage finalServiceReturn = serviceReturn;
                        if (warnings.size() > 0) {
                            InnerPopupFactory.showMessageDialog(warnings, "", new InnerPopUpListener2(){

                                @Override
                                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                                    List o = (List)finalServiceReturn.getObject();
                                    try {
                                        if (o != null) {
                                            for (PegasusFileComplete t : o) {
                                                PrintFlightLabelComponent.this.processFile(t);
                                            }
                                        }
                                        Node b = new Node();
                                        b.setValue((Object)true, 0L);
                                        PrintFlightLabelComponent.this.remoteObjectLoaded(b);
                                    }
                                    catch (ClientException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }, (Component)PrintFlightLabelComponent.this);
                        } else {
                            List o = (List)finalServiceReturn.getObject();
                            try {
                                for (PegasusFileComplete t : o) {
                                    PrintFlightLabelComponent.this.processFile(t);
                                }
                            }
                            catch (ClientException e) {
                                e.printStackTrace();
                            }
                            Node b = new Node();
                            b.setValue((Object)true, 0L);
                            PrintFlightLabelComponent.this.remoteObjectLoaded(b);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.flight.getNode();
    }

    @Override
    public String getTitleValue() {
        if (this.flight == null || this.flight.getDto() == null) {
            return "";
        }
        return this.flight.getDto().getOutboundCode();
    }
}

