/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.returnscount.worksheet.pdf;

import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.impl.FlightPrintBatch;
import ch.icit.pegasus.client.gui.submodules.print.flight.TitleConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiCostcentersComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.ReturnsCountReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReturnsCountReportConfiguration_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PrintReturnsCountComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private TextLabel options;
    protected TitledItem<MultiCostcentersComboBox> costCenterChooser;
    protected TitledItem<CheckBox> signed;
    protected TitledItem<CheckBox> groupByDrawer;
    private Node<FlightLight> flight;
    private Node<ReturnsCountReportConfiguration> configNode;
    private boolean isReturnsCount = false;

    public PrintReturnsCountComponent(Node<FlightLight> node) {
        super(true, false, false, false, ReportTypeE.RETURNS_COUNT);
        this.flight = node;
        this.isReturnsCount = ((FlightLight)this.flight.getValue()).getFlightType() != FlightTypeE.TRANSIT;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.options = new TextLabel(Words.OPTIONS);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new ReturnsCountReportConfiguration(ReportTypeE.RETURNS_COUNT, ReportingOutputFormatE.PDF, null), false, false);
        this.costCenterChooser = new TitledItem<MultiCostcentersComboBox>(new MultiCostcentersComboBox(this.configNode.getChildNamed(ReturnsCountReportConfiguration_.departments)), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.signed = new TitledItem<CheckBox>(new CheckBox(true), Words.SIGNED, TitledItem.TitledItemOrientation.EAST);
        this.groupByDrawer = new TitledItem<CheckBox>(new CheckBox(true), Words.GROUP_BY_DRAWER, TitledItem.TitledItemOrientation.EAST);
        this.groupByDrawer.getElement().setChecked(true);
        this.costCenterChooser.setInnerGap(5);
        this.signed.getElement().setChecked(true);
        this.signed.setEnabled(false);
        this.getViewContainer().add(this.costCenterChooser);
        this.getViewContainer().add(this.options);
        this.getViewContainer().add(this.signed);
        this.getViewContainer().add(this.groupByDrawer);
    }

    @Override
    public String getTitleString() {
        if (this.isReturnsCount) {
            return Words.FLIGHT_RETURNS_WORKSHEET;
        }
        return Words.FLIGHT_UPLIFT_WORKSHEET;
    }

    @Override
    public String getTitleValue() {
        return ((TitleConverter)ConverterRegistry.getConverter(TitleConverter.class)).convert(this.flight.getValue(), (Node)null, new Object[0]);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.costCenterChooser.setEnabled(isEnabled);
        this.options.setEnabled(isEnabled);
        this.signed.setEnabled(false);
        this.groupByDrawer.setEnabled(isEnabled);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{this.costCenterChooser.getElement().getNode().getValue(), true};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.costCenterChooser != null) {
            return this.costCenterChooser.getElement().isInnerComponent(c);
        }
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.costCenterChooser != null) {
            this.costCenterChooser.kill();
        }
        this.costCenterChooser = null;
        if (this.signed != null) {
            this.signed.kill();
        }
        this.signed = null;
        if (this.groupByDrawer != null) {
            this.groupByDrawer.kill();
        }
        this.groupByDrawer = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.costCenterChooser != null) {
            this.costCenterChooser.setVisible(true);
        }
        if (this.signed != null) {
            this.signed.setVisible(true);
        }
        if (this.groupByDrawer != null) {
            this.groupByDrawer.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.costCenterChooser != null) {
            this.costCenterChooser.setVisible(false);
        }
        if (this.signed != null) {
            this.signed.setVisible(false);
        }
        if (this.groupByDrawer != null) {
            this.groupByDrawer.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        return l;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintReturnsCountComponent.this.getSelectedReport();
                PrintReturnsCountComponent.this.configNode.commit();
                ReturnsCountReportConfiguration config = (ReturnsCountReportConfiguration)PrintReturnsCountComponent.this.configNode.getValue();
                config.setDto((IDTO)new FlightReference(((FlightLight)PrintReturnsCountComponent.this.flight.getValue()).getId()));
                config.setStylesheet(file);
                config.setGroupByTray(Boolean.valueOf(PrintReturnsCountComponent.this.groupByDrawer.getElement().isChecked()));
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createReturnsCountSheet(config).getValue();
                PrintReturnsCountComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintReturnsCountComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.flight;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return new FlightPrintBatch<FlightLight>(job, value, this.getPrintProcessor(), false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintReturnsCountComponent.this.layoutInheritedComponents(parent);
            if (PrintReturnsCountComponent.this.costCenterChooser != null) {
                PrintReturnsCountComponent.this.costCenterChooser.setLocation(PrintReturnsCountComponent.this.border, y);
                PrintReturnsCountComponent.this.costCenterChooser.setSize(parent.getWidth() - 2 * PrintReturnsCountComponent.this.border, (int)PrintReturnsCountComponent.this.costCenterChooser.getPreferredSize().getHeight());
                y = PrintReturnsCountComponent.this.costCenterChooser.getY() + PrintReturnsCountComponent.this.costCenterChooser.getHeight() + PrintReturnsCountComponent.this.border;
            }
            if (PrintReturnsCountComponent.this.signed != null) {
                PrintReturnsCountComponent.this.signed.setLocation(PrintReturnsCountComponent.this.border, y);
                PrintReturnsCountComponent.this.signed.setSize(PrintReturnsCountComponent.this.signed.getPreferredSize());
                y = PrintReturnsCountComponent.this.signed.getY() + PrintReturnsCountComponent.this.signed.getHeight() + PrintReturnsCountComponent.this.border / 2;
            }
            if (PrintReturnsCountComponent.this.groupByDrawer != null) {
                PrintReturnsCountComponent.this.groupByDrawer.setLocation(PrintReturnsCountComponent.this.border, y);
                PrintReturnsCountComponent.this.groupByDrawer.setSize(PrintReturnsCountComponent.this.groupByDrawer.getPreferredSize());
                y = PrintReturnsCountComponent.this.groupByDrawer.getY() + PrintReturnsCountComponent.this.groupByDrawer.getHeight() + PrintReturnsCountComponent.this.border / 2;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintReturnsCountComponent.this.getInheritedComponentsHeight();
            h += PrintReturnsCountComponent.this.border;
            if (PrintReturnsCountComponent.this.costCenterChooser != null) {
                h = (int)((double)h + PrintReturnsCountComponent.this.costCenterChooser.getPreferredSize().getHeight());
                h += PrintReturnsCountComponent.this.border;
            }
            if (PrintReturnsCountComponent.this.signed != null) {
                h = (int)((double)h + PrintReturnsCountComponent.this.signed.getPreferredSize().getHeight());
                h += PrintReturnsCountComponent.this.border / 2;
            }
            if (PrintReturnsCountComponent.this.groupByDrawer != null) {
                h = (int)((double)h + PrintReturnsCountComponent.this.groupByDrawer.getPreferredSize().getHeight());
                h += PrintReturnsCountComponent.this.border;
            }
            int w = 2 * PrintReturnsCountComponent.this.border;
            if (PrintReturnsCountComponent.this.costCenterChooser != null) {
                w = (int)((double)w + PrintReturnsCountComponent.this.costCenterChooser.getPreferredSize().getWidth());
            }
            return new Dimension(w, h);
        }
    }
}

