/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.inventory.customer;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;

public class PrintInventoryCustomerComponent
extends DefaultScrollablePrintPopup2<InventoryLight> {
    private static final long serialVersionUID = 1L;
    private Node<InventoryLight> currentInventory;
    private TitledItem<SearchTextField2<CustomerLight>> customerSearchField;
    private TitledItem<CheckBox> nominatedOnly;
    private TitledItem<CheckBox> customerOwnedOnly;
    private TitledItem<CheckBox> bondedOnly;

    public PrintInventoryCustomerComponent(Node<InventoryLight> node) {
        super(false, false, false, true, ReportTypeE.INVENTORY_CUSTOMER_SHEET);
        this.currentInventory = node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.customerSearchField = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, new DTOProxyNode()), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.nominatedOnly = new TitledItem<CheckBox>(new CheckBox(), Words.NOMINATED_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.customerOwnedOnly = new TitledItem<CheckBox>(new CheckBox(), Words.CUSTOMER_OWNED_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.bondedOnly = new TitledItem<CheckBox>(new CheckBox(), Words.BONDED_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.customerSearchField);
        this.getViewContainer().add(this.nominatedOnly);
        this.getViewContainer().add(this.customerOwnedOnly);
        this.getViewContainer().add(this.bondedOnly);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.INVENTORY;
    }

    @Override
    public String getTitleValue() {
        if (this.currentInventory.getChildNamed(InventoryLight_.number).getValue() == null) {
            return "-";
        }
        return "" + this.currentInventory.getChildNamed(InventoryLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.customerSearchField != null) {
            this.customerSearchField.kill();
        }
        if (this.customerOwnedOnly != null) {
            this.customerOwnedOnly.kill();
        }
        if (this.bondedOnly != null) {
            this.bondedOnly.kill();
        }
        if (this.nominatedOnly != null) {
            this.nominatedOnly.kill();
        }
        this.customerSearchField = null;
        this.customerOwnedOnly = null;
        this.bondedOnly = null;
        this.nominatedOnly = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.customerSearchField != null) {
            this.customerSearchField.setVisible(true);
        }
        if (this.customerOwnedOnly != null) {
            this.customerOwnedOnly.setVisible(true);
        }
        if (this.bondedOnly != null) {
            this.bondedOnly.setVisible(true);
        }
        if (this.nominatedOnly != null) {
            this.nominatedOnly.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.customerSearchField != null) {
            this.customerSearchField.setVisible(false);
        }
        if (this.customerOwnedOnly != null) {
            this.customerOwnedOnly.setVisible(false);
        }
        if (this.bondedOnly != null) {
            this.bondedOnly.setVisible(false);
        }
        if (this.nominatedOnly != null) {
            this.nominatedOnly.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintInventoryCustomerComponent.this.getSelectedReport();
                CustomerLight customer = (CustomerLight)((SearchTextField2)PrintInventoryCustomerComponent.this.customerSearchField.getElement()).getNode().getValue();
                boolean custOnly = ((CheckBox)PrintInventoryCustomerComponent.this.customerOwnedOnly.getElement()).isChecked();
                boolean nomOnly = ((CheckBox)PrintInventoryCustomerComponent.this.nominatedOnly.getElement()).isChecked();
                boolean bondOnly = ((CheckBox)PrintInventoryCustomerComponent.this.bondedOnly.getElement()).isChecked();
                InventoryLight inventory = (InventoryLight)PrintInventoryCustomerComponent.this.currentInventory.getValue();
                PegasusFileComplete t = (PegasusFileComplete)((InventoryReportServiceManager)ServiceManagerRegistry.getService(InventoryReportServiceManager.class)).getCustomerInventoryReport(inventory, customer, custOnly, nomOnly, bondOnly).getValue();
                PrintInventoryCustomerComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintInventoryCustomerComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<InventoryLight> getCurrentNode() {
        return this.currentInventory;
    }

    @Override
    public BatchJob<InventoryLight> createBatchJob(Node<InventoryLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintInventoryCustomerComponent.this.layoutInheritedComponents(parent);
            if (PrintInventoryCustomerComponent.this.customerOwnedOnly != null) {
                PrintInventoryCustomerComponent.this.customerOwnedOnly.setLocation(PrintInventoryCustomerComponent.this.border, y + PrintInventoryCustomerComponent.this.border);
                PrintInventoryCustomerComponent.this.customerOwnedOnly.setSize(parent.getWidth() - 2 * PrintInventoryCustomerComponent.this.border, (int)PrintInventoryCustomerComponent.this.customerOwnedOnly.getPreferredSize().getHeight());
                y = PrintInventoryCustomerComponent.this.customerOwnedOnly.getY() + PrintInventoryCustomerComponent.this.customerOwnedOnly.getHeight();
            }
            if (PrintInventoryCustomerComponent.this.bondedOnly != null) {
                PrintInventoryCustomerComponent.this.bondedOnly.setLocation(PrintInventoryCustomerComponent.this.border, y + PrintInventoryCustomerComponent.this.border / 2);
                PrintInventoryCustomerComponent.this.bondedOnly.setSize(parent.getWidth() - 2 * PrintInventoryCustomerComponent.this.border, (int)PrintInventoryCustomerComponent.this.bondedOnly.getPreferredSize().getHeight());
                y = PrintInventoryCustomerComponent.this.bondedOnly.getY() + PrintInventoryCustomerComponent.this.bondedOnly.getHeight();
            }
            if (PrintInventoryCustomerComponent.this.nominatedOnly != null) {
                PrintInventoryCustomerComponent.this.nominatedOnly.setLocation(PrintInventoryCustomerComponent.this.border, y + PrintInventoryCustomerComponent.this.border / 2);
                PrintInventoryCustomerComponent.this.nominatedOnly.setSize(parent.getWidth() - 2 * PrintInventoryCustomerComponent.this.border, (int)PrintInventoryCustomerComponent.this.nominatedOnly.getPreferredSize().getHeight());
                y = PrintInventoryCustomerComponent.this.nominatedOnly.getY() + PrintInventoryCustomerComponent.this.nominatedOnly.getHeight();
            }
            if (PrintInventoryCustomerComponent.this.customerSearchField != null) {
                PrintInventoryCustomerComponent.this.customerSearchField.setLocation(PrintInventoryCustomerComponent.this.border, y + PrintInventoryCustomerComponent.this.border / 2);
                PrintInventoryCustomerComponent.this.customerSearchField.setSize(parent.getWidth() - 2 * PrintInventoryCustomerComponent.this.border, (int)PrintInventoryCustomerComponent.this.customerSearchField.getPreferredSize().getHeight());
                y = PrintInventoryCustomerComponent.this.customerSearchField.getY() + PrintInventoryCustomerComponent.this.customerSearchField.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintInventoryCustomerComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintInventoryCustomerComponent.this.border;
            if (PrintInventoryCustomerComponent.this.customerOwnedOnly != null) {
                h = (int)((double)h + PrintInventoryCustomerComponent.this.customerOwnedOnly.getPreferredSize().getHeight());
                h += PrintInventoryCustomerComponent.this.border / 2;
            }
            if (PrintInventoryCustomerComponent.this.bondedOnly != null) {
                h = (int)((double)h + PrintInventoryCustomerComponent.this.bondedOnly.getPreferredSize().getHeight());
                h += PrintInventoryCustomerComponent.this.border / 2;
            }
            if (PrintInventoryCustomerComponent.this.nominatedOnly != null) {
                h = (int)((double)h + PrintInventoryCustomerComponent.this.nominatedOnly.getPreferredSize().getHeight());
                h += PrintInventoryCustomerComponent.this.border / 2;
            }
            if (PrintInventoryCustomerComponent.this.customerSearchField != null) {
                h = (int)((double)h + PrintInventoryCustomerComponent.this.customerSearchField.getPreferredSize().getHeight());
                h += PrintInventoryCustomerComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

