/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.inventorytransition.detailed;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.submodules.print.inventorytransition.detailed.PrintInventoryTransitionReport;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionFileComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionReference;
import ch.icit.pegasus.server.core.dtos.report.InventoryDetailsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.InventoryDetailsReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PrintInventoryTransitionComponent
extends DefaultScrollablePrintPopup2<InventoryTransitionLight> {
    private static final long serialVersionUID = 1L;
    private Node<InventoryTransitionLight> inventoryTransition;
    private Node<InventoryDetailsReportConfiguration> configNode;
    private TitledItem<CheckBox> useDefaultInventoryTimeWhenNotBlocked;
    private TextLabel sheetConfig;
    private List<TitledItem<CheckBox>> includedSheets = new ArrayList<TitledItem<CheckBox>>();
    private TitledItem<CheckBox> overviewSheet;
    private TitledItem<CheckBox> parameterSheet;
    private TitledItem<CheckBox> storeSheet;
    private TitledItem<CheckBox> flightSheet;
    private TitledItem<CheckBox> usedInOutTransactions;
    private TitledItem<CheckBox> startSheet;
    private TitledItem<CheckBox> endSheet;
    private TitledItem<CheckBox> includeAllStores;
    private TitledItem<CheckBox> includeClosedStores;
    private TitledItem<CheckBox> includeFlightCheckOutStores;
    private TitledItem<CheckBox> unusedInOutTransactions;
    private TitledItem<CheckBox> matOutIncluded;
    private TitledItem<CheckBox> matOutRejected;
    private TitledItem<CheckBox> matInIncluded;
    private TitledItem<CheckBox> matInRejected;
    private TitledItem<CheckBox> validations;
    private TitledItem<CheckBox> inValidations;
    private TitledItem<CheckBox> outValidations;
    private TitledItem<CheckBox> validation;
    private TitledItem<CheckBox> matValidations;
    private TitledItem<SearchTextField2<StoreLight>> storeSearch;

    public PrintInventoryTransitionComponent(Node<InventoryTransitionLight> node) {
        super(false, false, false, false, false, ReportTypeE.INVENTORY_TRANSITION_SHEET);
        this.inventoryTransition = node;
        InventoryDetailsReportConfiguration config = new InventoryDetailsReportConfiguration(null);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.useDefaultInventoryTimeWhenNotBlocked = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.useDefaultInventoryTimeWhenNotBlocked)), Words.USE_DEFAULT_INVENTORY_TIME_WHEN_NOT_BLOCKED, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.useDefaultInventoryTimeWhenNotBlocked);
        this.sheetConfig = new TextLabel(Words.SHEET_CONFIGURATION);
        this.getViewContainer().add(this.sheetConfig);
        this.overviewSheet = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.overviewSheet)), Words.SHOW_ONLY_OVERVIEW, TitledItem.TitledItemOrientation.EAST);
        this.parameterSheet = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.parameterSheet)), Words.PARAMETERS, TitledItem.TitledItemOrientation.EAST);
        this.storeSheet = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.storeSheet)), Words.STORES_CONFIGURATION, TitledItem.TitledItemOrientation.EAST);
        this.flightSheet = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.flightSheet)), Words.FLIGHT_SUMMARY, TitledItem.TitledItemOrientation.EAST);
        this.usedInOutTransactions = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.usedInOutTransactions)), Words.INOUT_TRANSACTIONS_USED, TitledItem.TitledItemOrientation.EAST);
        this.startSheet = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.startSheet)), Words.START_INVENTORY, TitledItem.TitledItemOrientation.EAST);
        this.endSheet = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.endSheet)), Words.END_INVENTORY, TitledItem.TitledItemOrientation.EAST);
        this.unusedInOutTransactions = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.unusedInOutTransactions)), Words.INOUT_TRANSACTIONS_UNUSED, TitledItem.TitledItemOrientation.EAST);
        this.matOutIncluded = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.matOutIncluded)), Words.MAT_DISPO_OUT_INCLUDED, TitledItem.TitledItemOrientation.EAST);
        this.matOutRejected = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.matOutRejected)), Words.MAT_DISPO_OUT_REJECTED, TitledItem.TitledItemOrientation.EAST);
        this.matInIncluded = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.matInIncluded)), Words.MAT_DISPO_IN_INCLUDED, TitledItem.TitledItemOrientation.EAST);
        this.matInRejected = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.matInRejected)), Words.MAT_DISPO_IN_REJECTED, TitledItem.TitledItemOrientation.EAST);
        this.validations = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.validations)), Words.VALIDATIONS, TitledItem.TitledItemOrientation.EAST);
        this.inValidations = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.inValidations)), Words.IN_VALIDATIONS, TitledItem.TitledItemOrientation.EAST);
        this.outValidations = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.outValidations)), Words.OUT_VALIDATIONS, TitledItem.TitledItemOrientation.EAST);
        this.validation = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.validations)), Words.VALIDATION_RIM, TitledItem.TitledItemOrientation.EAST);
        this.matValidations = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.matValidations)), Words.MAT_DISPO_WARNINGS, TitledItem.TitledItemOrientation.EAST);
        this.includeAllStores = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includeAllStores)), Words.INCLUDE_ALL_STORES, TitledItem.TitledItemOrientation.EAST);
        this.includeClosedStores = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includeClosedStores)), Words.INCLUDE_CLOSED_STORES, TitledItem.TitledItemOrientation.EAST);
        this.includeFlightCheckOutStores = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includeAutoCheckoutStores)), Words.INCLUDE_AUTO_CHECKOUT_STORE, TitledItem.TitledItemOrientation.EAST);
        this.storeSearch = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.filterByStore)), Words.STORE, TitledItem.TitledItemOrientation.NORTH);
        this.includedSheets.add(this.overviewSheet);
        this.includedSheets.add(this.includeAllStores);
        this.includedSheets.add(this.includeClosedStores);
        this.includedSheets.add(this.includeFlightCheckOutStores);
        this.includedSheets.add(this.parameterSheet);
        this.includedSheets.add(this.storeSheet);
        this.includedSheets.add(this.flightSheet);
        this.includedSheets.add(this.usedInOutTransactions);
        this.includedSheets.add(this.endSheet);
        this.includedSheets.add(this.startSheet);
        this.includedSheets.add(this.unusedInOutTransactions);
        this.includedSheets.add(this.matOutIncluded);
        this.includedSheets.add(this.matOutRejected);
        this.includedSheets.add(this.matInIncluded);
        this.includedSheets.add(this.matInRejected);
        this.includedSheets.add(this.validations);
        this.includedSheets.add(this.inValidations);
        this.includedSheets.add(this.outValidations);
        this.includedSheets.add(this.validation);
        this.includedSheets.add(this.matValidations);
        this.overviewSheet.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        for (TitledItem<CheckBox> titledItem : this.includedSheets) {
            this.getViewContainer().add(titledItem);
        }
        this.getViewContainer().add(this.storeSearch);
        this.createComponents();
    }

    private boolean useLeftIntent(TitledItem<CheckBox> component) {
        return component == this.includeAllStores || component == this.includeClosedStores || component == this.includeFlightCheckOutStores;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "useDefaultTime": {
                    this.useDefaultInventoryTimeWhenNotBlocked.getElement().setChecked(b);
                    break;
                }
                case "overviewSheet": {
                    this.overviewSheet.getElement().setChecked(b);
                    break;
                }
                case "parameterSheet": {
                    this.parameterSheet.getElement().setChecked(b);
                    break;
                }
                case "storeSheet": {
                    this.storeSheet.getElement().setChecked(b);
                    break;
                }
                case "flightSheet": {
                    this.flightSheet.getElement().setChecked(b);
                    break;
                }
                case "usedInOutTransactions": {
                    this.usedInOutTransactions.getElement().setChecked(b);
                    break;
                }
                case "startSheet": {
                    this.startSheet.getElement().setChecked(b);
                    break;
                }
                case "endSheet": {
                    this.endSheet.getElement().setChecked(b);
                    break;
                }
                case "unusedInOutTransactions": {
                    this.unusedInOutTransactions.getElement().setChecked(b);
                    break;
                }
                case "matOutIncluded": {
                    this.matOutIncluded.getElement().setChecked(b);
                    break;
                }
                case "matOutRejected": {
                    this.matOutRejected.getElement().setChecked(b);
                    break;
                }
                case "matInIncluded": {
                    this.matInIncluded.getElement().setChecked(b);
                    break;
                }
                case "matInRejected": {
                    this.matInRejected.getElement().setChecked(b);
                    break;
                }
                case "validations": {
                    this.validations.getElement().setChecked(b);
                    break;
                }
                case "inValidations": {
                    this.inValidations.getElement().setChecked(b);
                    break;
                }
                case "outValidations": {
                    this.outValidations.getElement().setChecked(b);
                    break;
                }
                case "validation": {
                    this.validation.getElement().setChecked(b);
                    break;
                }
                case "matValidations": {
                    this.matValidations.getElement().setChecked(b);
                    break;
                }
                case "includeAllStores": {
                    this.includeAllStores.getElement().setChecked(b);
                    break;
                }
                case "includeClosedStores": {
                    this.includeClosedStores.getElement().setChecked(b);
                    break;
                }
                case "includeAutoCheckoutStores": {
                    this.includeFlightCheckOutStores.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.useDefaultInventoryTimeWhenNotBlocked.setEnabled(isEnabled);
        this.storeSearch.setEnabled(isEnabled);
        for (TitledItem<CheckBox> titledItem : this.includedSheets) {
            boolean intent = this.useLeftIntent(titledItem);
            if (intent && isEnabled) {
                intent = this.overviewSheet.getElement().isChecked();
                titledItem.setEnabled(intent);
                continue;
            }
            titledItem.setEnabled(isEnabled);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("useDefaultTime", "" + this.useDefaultInventoryTimeWhenNotBlocked.getElement().isChecked());
        conf.addProperty("overviewSheet", "" + this.overviewSheet.getElement().isChecked());
        conf.addProperty("parameterSheet", "" + this.parameterSheet.getElement().isChecked());
        conf.addProperty("storeSheet", "" + this.storeSheet.getElement().isChecked());
        conf.addProperty("flightSheet", "" + this.flightSheet.getElement().isChecked());
        conf.addProperty("usedInOutTransactions", "" + this.usedInOutTransactions.getElement().isChecked());
        conf.addProperty("startSheet", "" + this.startSheet.getElement().isChecked());
        conf.addProperty("endSheet", "" + this.endSheet.getElement().isChecked());
        conf.addProperty("unusedInOutTransactions", "" + this.unusedInOutTransactions.getElement().isChecked());
        conf.addProperty("matOutIncluded", "" + this.matOutIncluded.getElement().isChecked());
        conf.addProperty("matOutRejected", "" + this.matOutRejected.getElement().isChecked());
        conf.addProperty("matInIncluded", "" + this.matInIncluded.getElement().isChecked());
        conf.addProperty("matInRejected", "" + this.matInRejected.getElement().isChecked());
        conf.addProperty("validations", "" + this.validations.getElement().isChecked());
        conf.addProperty("useDefaultTime", "" + this.validations.getElement().isChecked());
        conf.addProperty("inValidations", "" + this.inValidations.getElement().isChecked());
        conf.addProperty("outValidations", "" + this.outValidations.getElement().isChecked());
        conf.addProperty("validation", "" + this.validation.getElement().isChecked());
        conf.addProperty("matValidations", "" + this.matValidations.getElement().isChecked());
        conf.addProperty("includeAllStores", "" + this.includeAllStores.getElement().isChecked());
        conf.addProperty("includeClosedStores", "" + this.includeClosedStores.getElement().isChecked());
        conf.addProperty("includeAutoCheckoutStores", "" + this.includeFlightCheckOutStores.getElement().isChecked());
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.INVENTORY_TRANSITION;
    }

    @Override
    public String getTitleValue() {
        if (this.inventoryTransition.getChildNamed(InventoryTransitionLight_.number).getValue() == null) {
            return "-";
        }
        return "" + this.inventoryTransition.getChildNamed(InventoryTransitionLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.useDefaultInventoryTimeWhenNotBlocked != null) {
            this.useDefaultInventoryTimeWhenNotBlocked.kill();
        }
        this.useDefaultInventoryTimeWhenNotBlocked = null;
        if (this.storeSearch != null) {
            this.storeSearch.kill();
        }
        this.storeSearch = null;
        for (TitledItem<CheckBox> titledItem : this.includedSheets) {
            titledItem.kill();
        }
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.useDefaultInventoryTimeWhenNotBlocked != null) {
            this.useDefaultInventoryTimeWhenNotBlocked.setVisible(true);
        }
        if (this.storeSearch != null) {
            this.storeSearch.setVisible(true);
        }
        for (TitledItem<CheckBox> titledItem : this.includedSheets) {
            titledItem.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.useDefaultInventoryTimeWhenNotBlocked != null) {
            this.useDefaultInventoryTimeWhenNotBlocked.setVisible(false);
        }
        if (this.storeSearch != null) {
            this.storeSearch.setVisible(false);
        }
        for (TitledItem<CheckBox> titledItem : this.includedSheets) {
            titledItem.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> screenValidationObjects = super.validateBeforePrint();
        if (screenValidationObjects == null) {
            screenValidationObjects = new ArrayList<ScreenValidationObject>();
        }
        if (this.overviewSheet.getElement().isChecked()) {
            if (this.includeAllStores.getElement().isChecked() || this.includeClosedStores.getElement().isChecked() || this.includeFlightCheckOutStores.getElement().isChecked()) {
                this.includeAllStores.getElement().setInvalid();
                this.includeClosedStores.getElement().setInvalid();
                this.includeFlightCheckOutStores.getElement().setInvalid();
            } else {
                screenValidationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_SHEET_IS_SELECTED));
            }
        }
        return screenValidationObjects;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            this.setShowSaveFileDialog(true);
        } else {
            this.setShowSaveFileDialog(false);
        }
        super.enterPressed(isOK);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintInventoryTransitionComponent.this.getSelectedReport();
                PrintInventoryTransitionComponent.this.configNode.commit();
                InventoryTransitionComplete ic = (InventoryTransitionComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).getByTransition((InventoryTransitionReference)PrintInventoryTransitionComponent.this.inventoryTransition.getValue()).getValue();
                InventoryDetailsReportConfiguration config = (InventoryDetailsReportConfiguration)PrintInventoryTransitionComponent.this.configNode.getValue();
                config.setStylesheet(file);
                List<ScreenValidationObject> v = PrintInventoryTransitionReport.fillInventoryTransitionReportConfiguration(ic, config);
                if (!v.isEmpty()) {
                    ViewNode ret = new ViewNode("batchReturn");
                    ret.setValue(v, 0L);
                    return ret;
                }
                PegasusFileComplete t = null;
                t = (PegasusFileComplete)((InventoryReportServiceManager)ServiceManagerRegistry.getService(InventoryReportServiceManager.class)).getInventoryTransactionsReport(config).getValue();
                ic = (InventoryTransitionComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).getByTransition(new InventoryTransitionReference(ic.getId())).getValue();
                InventoryTransitionFileComplete fc = new InventoryTransitionFileComplete();
                fc.setClientOId(Long.valueOf(ADTO.getNextId()));
                fc.setFile(t);
                fc.setFinalized(Boolean.valueOf(false));
                ic.getTransitionReports().add(fc);
                fc.setParameterString(PrintInventoryTransitionReport.getParameterString(ic));
                ((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).updateInventoryTransition(ic);
                PrintInventoryTransitionComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintInventoryTransitionComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<InventoryTransitionLight> getCurrentNode() {
        return this.inventoryTransition;
    }

    @Override
    public BatchJob<InventoryTransitionLight> createBatchJob(Node<InventoryTransitionLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintInventoryTransitionComponent.this.layoutInheritedComponents(parent);
            if (PrintInventoryTransitionComponent.this.storeSearch != null) {
                PrintInventoryTransitionComponent.this.storeSearch.setLocation(PrintInventoryTransitionComponent.this.border, y + PrintInventoryTransitionComponent.this.border / 2);
                PrintInventoryTransitionComponent.this.storeSearch.setSize(parent.getWidth() - 2 * PrintInventoryTransitionComponent.this.border, (int)PrintInventoryTransitionComponent.this.storeSearch.getPreferredSize().getHeight());
                y = PrintInventoryTransitionComponent.this.storeSearch.getY() + PrintInventoryTransitionComponent.this.storeSearch.getHeight() + PrintInventoryTransitionComponent.this.border / 2;
            }
            if (PrintInventoryTransitionComponent.this.useDefaultInventoryTimeWhenNotBlocked != null) {
                PrintInventoryTransitionComponent.this.useDefaultInventoryTimeWhenNotBlocked.setLocation(PrintInventoryTransitionComponent.this.border, y + PrintInventoryTransitionComponent.this.border / 2);
                PrintInventoryTransitionComponent.this.useDefaultInventoryTimeWhenNotBlocked.setSize(PrintInventoryTransitionComponent.this.useDefaultInventoryTimeWhenNotBlocked.getPreferredSize());
                y = PrintInventoryTransitionComponent.this.useDefaultInventoryTimeWhenNotBlocked.getY() + PrintInventoryTransitionComponent.this.useDefaultInventoryTimeWhenNotBlocked.getHeight() + PrintInventoryTransitionComponent.this.border / 2;
            }
            PrintInventoryTransitionComponent.this.sheetConfig.setLocation(PrintInventoryTransitionComponent.this.border, y + PrintInventoryTransitionComponent.this.border / 2);
            PrintInventoryTransitionComponent.this.sheetConfig.setSize(PrintInventoryTransitionComponent.this.sheetConfig.getPreferredSize());
            y = PrintInventoryTransitionComponent.this.sheetConfig.getY() + PrintInventoryTransitionComponent.this.sheetConfig.getHeight() + PrintInventoryTransitionComponent.this.border;
            for (TitledItem titledItem : PrintInventoryTransitionComponent.this.includedSheets) {
                boolean intent = PrintInventoryTransitionComponent.this.useLeftIntent(titledItem);
                titledItem.setLocation(PrintInventoryTransitionComponent.this.border + (intent ? PrintInventoryTransitionComponent.this.border : 0), y + PrintInventoryTransitionComponent.this.border / 2);
                titledItem.setSize(titledItem.getPreferredSize());
                y = titledItem.getY() + titledItem.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintInventoryTransitionComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintInventoryTransitionComponent.this.border;
            if (PrintInventoryTransitionComponent.this.storeSearch != null) {
                h = (int)((double)h + PrintInventoryTransitionComponent.this.storeSearch.getPreferredSize().getHeight());
                h += PrintInventoryTransitionComponent.this.border / 2;
            }
            if (PrintInventoryTransitionComponent.this.useDefaultInventoryTimeWhenNotBlocked != null) {
                h = (int)((double)h + PrintInventoryTransitionComponent.this.useDefaultInventoryTimeWhenNotBlocked.getPreferredSize().getHeight());
                h += PrintInventoryTransitionComponent.this.border / 2;
            }
            h += PrintInventoryTransitionComponent.this.border / 2;
            h = (int)((double)h + PrintInventoryTransitionComponent.this.sheetConfig.getPreferredSize().getHeight());
            h += PrintInventoryTransitionComponent.this.border;
            for (TitledItem titledItem : PrintInventoryTransitionComponent.this.includedSheets) {
                h += PrintInventoryTransitionComponent.this.border / 2;
                h = (int)((double)h + titledItem.getPreferredSize().getHeight());
            }
            return new Dimension(w, h += PrintInventoryTransitionComponent.this.border);
        }
    }
}

