/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.productcatalog.articles;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.report.ProductRecipeSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;

public class PrintProductCatalogArticlesComponent
extends DefaultScrollablePrintPopup2<ProductCatalogLight> {
    private static final long serialVersionUID = 1L;
    private final Node<ProductCatalogLight> currentProductCatalog;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<CheckBox> showProductGroupAndRecipes;
    private TitledItem<CheckBox> showCosts;
    private TitledItem<CheckBox> includeTender;
    private boolean canExportCosts;
    private RowModel<ProductCatalogLight> model;

    public PrintProductCatalogArticlesComponent(Node<ProductCatalogLight> node, RowModel<ProductCatalogLight> model) {
        super(false, true, ReportTypeE.PRODUCT_CATALOG_ARTICLE_LIST);
        this.currentProductCatalog = node;
        this.model = model;
        this.canExportCosts = ProductToolkit.canExportProductCosts(true);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(n), Words.VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        this.showProductGroupAndRecipes = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_PRODUCT_GROUP_AND_RECIPE, TitledItem.TitledItemOrientation.EAST);
        this.includeTender = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TENDER, TitledItem.TitledItemOrientation.EAST);
        if (this.canExportCosts) {
            this.showCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS, TitledItem.TitledItemOrientation.EAST);
            this.getViewContainer().add(this.showCosts);
        }
        this.getViewContainer().add(this.validityDate);
        this.getViewContainer().add(this.showProductGroupAndRecipes);
        this.getViewContainer().add(this.includeTender);
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_CATALOG_ARTICLES;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProductCatalog.getChildNamed(ProductCatalogLight_.title).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.model.getView().revalidate();
        this.model = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.validityDate != null) {
            this.validityDate.setVisible(true);
        }
        if (this.showProductGroupAndRecipes != null) {
            this.showProductGroupAndRecipes.setVisible(true);
        }
        if (this.includeTender != null) {
            this.includeTender.setVisible(true);
        }
        if (this.showCosts != null) {
            this.showCosts.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.validityDate != null) {
            this.validityDate.setVisible(false);
        }
        if (this.showProductGroupAndRecipes != null) {
            this.showProductGroupAndRecipes.setVisible(false);
        }
        if (this.showCosts != null) {
            this.showCosts.setVisible(false);
        }
        if (this.includeTender != null) {
            this.includeTender.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductRecipeSheetReportConfiguration config = new ProductRecipeSheetReportConfiguration(PrintProductCatalogArticlesComponent.this.getSelectedReport());
                if (PrintProductCatalogArticlesComponent.this.asXLS != null && ((RadioButton)PrintProductCatalogArticlesComponent.this.asXLS.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                } else {
                    config.setFormat(ReportingOutputFormatE.PDF);
                }
                Date validity = (Date)((DateChooser)PrintProductCatalogArticlesComponent.this.validityDate.getElement()).getNode().getValue();
                config.setDueDate(new Timestamp(validity.getTime()));
                config.setShowProductGroupAndRecipes(Boolean.valueOf(((CheckBox)PrintProductCatalogArticlesComponent.this.showProductGroupAndRecipes.getElement()).isChecked()));
                config.setIncludeTender(Boolean.valueOf(((CheckBox)PrintProductCatalogArticlesComponent.this.includeTender.getElement()).isChecked()));
                if (PrintProductCatalogArticlesComponent.this.showCosts != null) {
                    config.setIncludeCost(Boolean.valueOf(((CheckBox)PrintProductCatalogArticlesComponent.this.showCosts.getElement()).isChecked()));
                }
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductCatalogArticleReport(new ProductCatalogReference(((ProductCatalogLight)PrintProductCatalogArticlesComponent.this.currentProductCatalog.getValue()).getId()), config, new TimestampWrapper(validity.getTime())).getValue();
                PrintProductCatalogArticlesComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductCatalogArticlesComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductCatalogLight> getCurrentNode() {
        return this.currentProductCatalog;
    }

    @Override
    public BatchJob<ProductCatalogLight> createBatchJob(Node<ProductCatalogLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductCatalogArticlesComponent.this.layoutInheritedComponents(parent);
            if (PrintProductCatalogArticlesComponent.this.validityDate != null) {
                PrintProductCatalogArticlesComponent.this.validityDate.setLocation(PrintProductCatalogArticlesComponent.this.border, y + PrintProductCatalogArticlesComponent.this.border);
                PrintProductCatalogArticlesComponent.this.validityDate.setSize(PrintProductCatalogArticlesComponent.this.validityDate.getPreferredSize());
                PrintProductCatalogArticlesComponent.this.showProductGroupAndRecipes.setLocation(PrintProductCatalogArticlesComponent.this.border, PrintProductCatalogArticlesComponent.this.validityDate.getY() + PrintProductCatalogArticlesComponent.this.validityDate.getHeight() + PrintProductCatalogArticlesComponent.this.border);
                PrintProductCatalogArticlesComponent.this.showProductGroupAndRecipes.setSize(PrintProductCatalogArticlesComponent.this.showProductGroupAndRecipes.getPreferredSize());
                PrintProductCatalogArticlesComponent.this.includeTender.setLocation(PrintProductCatalogArticlesComponent.this.border, PrintProductCatalogArticlesComponent.this.showProductGroupAndRecipes.getY() + PrintProductCatalogArticlesComponent.this.showProductGroupAndRecipes.getHeight() + PrintProductCatalogArticlesComponent.this.border);
                PrintProductCatalogArticlesComponent.this.includeTender.setSize(PrintProductCatalogArticlesComponent.this.includeTender.getPreferredSize());
                if (PrintProductCatalogArticlesComponent.this.showCosts != null) {
                    PrintProductCatalogArticlesComponent.this.showCosts.setLocation(PrintProductCatalogArticlesComponent.this.border, PrintProductCatalogArticlesComponent.this.includeTender.getY() + PrintProductCatalogArticlesComponent.this.includeTender.getHeight() + PrintProductCatalogArticlesComponent.this.border);
                    PrintProductCatalogArticlesComponent.this.showCosts.setSize(PrintProductCatalogArticlesComponent.this.showCosts.getPreferredSize());
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductCatalogArticlesComponent.this.getInheritedComponentsHeight();
            int w = 250;
            return new Dimension(w, h);
        }
    }
}

