/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.shared.stowinglistreport;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.impl.FlightPrintBatch;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.PaxLegTable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.IFlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.StowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class PrintStowingListComponent<T extends IFlightReference>
extends DefaultScrollablePrintPopup2<T>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    protected TitledItem<DateChooserPopup> dateChooser;
    protected TitledItem<PaxLegTable> paxCount;
    protected TextLabel printOptionTitle;
    private TitledItem<ComboBox> department;
    private TitledItem<ComboBox> colors;
    private TitledItem<CheckBox> includeGalleyMap;
    private TitledItem<CheckBox> includeCrewClasses;
    private TitledItem<CheckBox> summarizeCrew;
    private TitledItem<CheckBox> hideNSDSFlights;
    private TitledItem<CheckBox> finalizeFlight;
    private boolean isHideNSDSActive;
    protected final PeriodComplete p;
    private TitledItem<SearchTextField2<CustomerLight>> customerSerach;
    private static final String GALLEY_CONFIG_NAME = "galley";
    private static final String CREW_CONFIG_NAME = "crew";
    private static final String SUMMARIZE_CREW_NAME = "summarizeCrew";
    private static final String HIDE_NS_DS_FLIGHTS = "hideNSDSFlights";

    public PrintStowingListComponent(PeriodComplete p, boolean showHideNSDS) {
        super(true, false, false, false, ReportTypeE.STOWINGLIST_REPORT);
        this.isHideNSDSActive = showHideNSDS;
        this.p = p;
        Runnable r = () -> {
            try {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        };
        this.loadBeforeShowing(r);
    }

    public abstract boolean showPaxFinalize();

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.printOptionTitle = new TextLabel(Words.OPTIONS);
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.getViewContainer().add(this.printOptionTitle);
        if (this.showPaxFinalize()) {
            this.finalizeFlight = new TitledItem<CheckBox>(new CheckBox(), Words.SET_PAX_TO_FINAL, TitledItem.TitledItemOrientation.EAST);
            this.finalizeFlight.getTitle().setForeground(fb);
            this.finalizeFlight.getTitle().setFont(f);
            this.getViewContainer().add(this.finalizeFlight);
        }
        this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.DEPARTMENT), TitledItem.TitledItemOrientation.NORTH);
        this.colors = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.LABEL_COLOR, (boolean)true), TitledItem.TitledItemOrientation.NORTH);
        this.department.getTitle().setForeground(fb);
        this.department.getTitle().setFont(f);
        this.colors.getTitle().setForeground(fb);
        this.colors.getTitle().setFont(f);
        this.getViewContainer().add(this.department);
        this.getViewContainer().add(this.colors);
        this.includeGalleyMap = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GALLEY_MAP, TitledItem.TitledItemOrientation.EAST);
        this.includeGalleyMap.getElement().setChecked(true);
        this.includeGalleyMap.getTitle().setForeground(fb);
        this.includeGalleyMap.getTitle().setFont(f);
        this.getViewContainer().add(this.includeGalleyMap);
        this.includeCrewClasses = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CREW_PAX, TitledItem.TitledItemOrientation.EAST);
        this.includeCrewClasses.getTitle().setForeground(fb);
        this.includeCrewClasses.getTitle().setFont(f);
        this.includeCrewClasses.getElement().setChecked(true);
        this.includeCrewClasses.getElement().addButtonListener(this);
        this.getViewContainer().add(this.includeCrewClasses);
        this.summarizeCrew = new TitledItem<CheckBox>(new CheckBox(), Words.SUMMARIZE_CREW, TitledItem.TitledItemOrientation.EAST);
        this.summarizeCrew.getTitle().setForeground(fb);
        this.summarizeCrew.getTitle().setFont(f);
        this.summarizeCrew.getElement().setChecked(true);
        this.getViewContainer().add(this.summarizeCrew);
        if (this.isHideNSDSActive) {
            this.hideNSDSFlights = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_FLIGHTS_FROMTO_NS_DS, TitledItem.TitledItemOrientation.EAST);
            this.hideNSDSFlights.getTitle().setForeground(fb);
            this.hideNSDSFlights.getTitle().setFont(f);
            this.hideNSDSFlights.getElement().setChecked(true);
            this.getViewContainer().add(this.hideNSDSFlights);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        if (this.finalizeFlight != null) {
            this.finalizeFlight.setEnabled(isEnabled);
        }
        this.includeGalleyMap.setEnabled(isEnabled);
        this.includeCrewClasses.setEnabled(isEnabled);
        this.summarizeCrew.setEnabled(isEnabled && this.includeCrewClasses.getElement().isChecked());
        this.department.setEnabled(isEnabled);
        this.colors.setEnabled(isEnabled);
        if (this.dateChooser != null) {
            this.dateChooser.setEnabled(isEnabled);
        }
        if (this.paxCount != null) {
            this.paxCount.setEnabled(isEnabled);
        }
        if (this.isHideNSDSActive) {
            this.hideNSDSFlights.setEnabled(isEnabled);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "galley": {
                    this.includeGalleyMap.getElement().setChecked(b);
                    break;
                }
                case "crew": {
                    this.includeCrewClasses.getElement().setChecked(b);
                    break;
                }
                case "summarizeCrew": {
                    this.summarizeCrew.getElement().setChecked(b);
                    break;
                }
                case "hideNSDSFlights": {
                    if (this.hideNSDSFlights == null) break;
                    this.hideNSDSFlights.getElement().setChecked(b);
                }
            }
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty(GALLEY_CONFIG_NAME, "" + this.includeGalleyMap.getElement().isChecked());
        conf.addProperty(CREW_CONFIG_NAME, "" + this.includeCrewClasses.getElement().isChecked());
        conf.addProperty(SUMMARIZE_CREW_NAME, "" + this.summarizeCrew.getElement().isChecked());
        if (this.hideNSDSFlights != null) {
            conf.addProperty(HIDE_NS_DS_FLIGHTS, "" + this.hideNSDSFlights.getElement().isChecked());
        }
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.STOWING_LIST_REPORT;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[2];
        if (this.dateChooser != null) {
            o[0] = this.dateChooser.getElement().getSelectedDate();
        }
        o[1] = this.getCurrentNode();
        return o;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = super.getFocusComponents();
        if (this.finalizeFlight != null) {
            CheckedListAdder.addToList(a, this.finalizeFlight);
        }
        CheckedListAdder.addToList(a, this.includeGalleyMap);
        CheckedListAdder.addToList(a, this.includeCrewClasses);
        CheckedListAdder.addToList(a, this.summarizeCrew);
        CheckedListAdder.addToList(a, this.hideNSDSFlights);
        CheckedListAdder.addToList(a, this.department);
        CheckedListAdder.addToList(a, this.colors);
        if (this.dateChooser != null) {
            CheckedListAdder.addToList(a, this.dateChooser);
        }
        if (this.paxCount != null) {
            CheckedListAdder.addToList(a, this.paxCount);
        }
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean b = super.isInnerComponent(c);
        if (b) {
            return b;
        }
        if (this.department != null && this.department.isInnerComponent(c)) {
            return true;
        }
        return this.colors != null && this.colors.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.finalizeFlight != null) {
            this.finalizeFlight.kill();
        }
        if (this.department != null) {
            this.department.kill();
        }
        if (this.colors != null) {
            this.colors.kill();
        }
        if (this.summarizeCrew != null) {
            this.summarizeCrew.kill();
        }
        if (this.dateChooser != null) {
            this.dateChooser.kill();
        }
        if (this.paxCount != null) {
            this.paxCount.kill();
        }
        if (this.includeGalleyMap != null) {
            this.includeGalleyMap.kill();
        }
        if (this.includeCrewClasses != null) {
            this.includeCrewClasses.kill();
        }
        if (this.hideNSDSFlights != null) {
            this.hideNSDSFlights.kill();
        }
        this.finalizeFlight = null;
        this.paxCount = null;
        this.department = null;
        this.colors = null;
        this.printOptionTitle = null;
        this.dateChooser = null;
        this.includeGalleyMap = null;
        this.summarizeCrew = null;
        this.includeCrewClasses = null;
        this.hideNSDSFlights = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.finalizeFlight != null) {
            this.finalizeFlight.setVisible(true);
        }
        if (this.department != null) {
            this.department.setVisible(true);
        }
        if (this.colors != null) {
            this.colors.setVisible(true);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(true);
        }
        if (this.paxCount != null) {
            this.paxCount.setVisible(true);
        }
        if (this.summarizeCrew != null) {
            this.summarizeCrew.setVisible(true);
        }
        if (this.hideNSDSFlights != null) {
            this.hideNSDSFlights.setVisible(true);
        }
        if (this.includeGalleyMap != null) {
            this.includeGalleyMap.setVisible(true);
        }
        if (this.includeCrewClasses != null) {
            this.includeCrewClasses.setVisible(true);
        }
        if (this.popup != null) {
            this.popup.createFocusCycle();
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.finalizeFlight != null) {
            this.finalizeFlight.setVisible(false);
        }
        if (this.department != null) {
            this.department.setVisible(false);
        }
        if (this.colors != null) {
            this.colors.setVisible(false);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
        if (this.paxCount != null) {
            this.paxCount.setVisible(false);
        }
        if (this.summarizeCrew != null) {
            this.summarizeCrew.setVisible(false);
        }
        if (this.hideNSDSFlights != null) {
            this.hideNSDSFlights.setVisible(false);
        }
        if (this.includeGalleyMap != null) {
            this.includeGalleyMap.setVisible(false);
        }
        if (this.includeCrewClasses != null) {
            this.includeCrewClasses.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a;
        List<ScreenValidationObject> b;
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        if (this.paxCount != null && (b = this.paxCount.getElement().validatePaxTable()) != null) {
            l.addAll(b);
        }
        if ((a = super.validateBeforePrint()) != null) {
            l.addAll(a);
        }
        return l;
    }

    public void getConfig(StowingListReportConfiguration config) {
        if (this.department.getElement().getSelectedItem() instanceof Node) {
            Node d = (Node)this.department.getElement().getSelectedItem();
            config.setDepartment((CostCenterComplete)d.getValue());
        } else {
            config.setDepartment(null);
        }
        if (this.colors.getElement().getSelectedItem() instanceof Node) {
            Node c = (Node)this.colors.getElement().getSelectedItem();
            config.setLabelColor((ColorComplete)c.getValue());
        } else {
            config.setLabelColor(null);
        }
        if (this.hideNSDSFlights != null) {
            config.setHideNSDSFlights(Boolean.valueOf(this.hideNSDSFlights.getElement().isChecked()));
        }
        config.setIncludeGalleyMap(Boolean.valueOf(this.includeGalleyMap.getElement().isChecked()));
        config.setIncludeCrewPaxes(Boolean.valueOf(this.includeCrewClasses.getElement().isChecked()));
        if (this.includeCrewClasses.getElement().isChecked()) {
            config.setSummarizeCrew(Boolean.valueOf(this.summarizeCrew.getElement().isChecked()));
        } else {
            config.setSummarizeCrew(Boolean.valueOf(false));
        }
        Map<? extends ALegComplete, Map<CabinClassComplete, Integer>> map = null;
        if (this.paxCount != null) {
            map = this.paxCount.getElement().getMap();
        }
        if (this.finalizeFlight != null) {
            config.setFinalizeFlight(Boolean.valueOf(this.finalizeFlight.getElement().isChecked()));
        }
        config.setPax(map);
    }

    @Override
    public BatchJob<T> createBatchJob(Node<T> value, ThreadSafeExecutable job) {
        return new FlightPrintBatch<T>(job, value, this.getPrintProcessor(), false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintStowingListComponent.this.layoutInheritedComponents(parent);
            if (PrintStowingListComponent.this.printOptionTitle != null) {
                PrintStowingListComponent.this.printOptionTitle.setLocation(PrintStowingListComponent.this.border, y + PrintStowingListComponent.this.border);
                PrintStowingListComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintStowingListComponent.this.border, (int)PrintStowingListComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = PrintStowingListComponent.this.printOptionTitle.getY() + PrintStowingListComponent.this.printOptionTitle.getHeight() + PrintStowingListComponent.this.border / 2;
            }
            if (PrintStowingListComponent.this.includeGalleyMap != null) {
                if (PrintStowingListComponent.this.finalizeFlight != null) {
                    PrintStowingListComponent.this.finalizeFlight.setLocation(PrintStowingListComponent.this.border, y);
                    PrintStowingListComponent.this.finalizeFlight.setSize(parent.getWidth() - 2 * PrintStowingListComponent.this.border, (int)PrintStowingListComponent.this.finalizeFlight.getPreferredSize().getHeight());
                    y = PrintStowingListComponent.this.finalizeFlight.getY() + PrintStowingListComponent.this.finalizeFlight.getHeight() + PrintStowingListComponent.this.border;
                }
                PrintStowingListComponent.this.includeGalleyMap.setLocation(PrintStowingListComponent.this.border, y);
                PrintStowingListComponent.this.includeGalleyMap.setSize(parent.getWidth() - 2 * PrintStowingListComponent.this.border, (int)PrintStowingListComponent.this.includeGalleyMap.getPreferredSize().getHeight());
                PrintStowingListComponent.this.includeCrewClasses.setLocation(PrintStowingListComponent.this.border, PrintStowingListComponent.this.includeGalleyMap.getY() + PrintStowingListComponent.this.includeGalleyMap.getHeight() + PrintStowingListComponent.this.border / 4);
                PrintStowingListComponent.this.includeCrewClasses.setSize(parent.getWidth() - 2 * PrintStowingListComponent.this.border, (int)PrintStowingListComponent.this.includeCrewClasses.getPreferredSize().getHeight());
                PrintStowingListComponent.this.summarizeCrew.setLocation(PrintStowingListComponent.this.border + ((CheckBox)PrintStowingListComponent.this.includeCrewClasses.getElement()).getWidth() + PrintStowingListComponent.this.includeCrewClasses.getInnerGap(), PrintStowingListComponent.this.includeCrewClasses.getY() + PrintStowingListComponent.this.includeCrewClasses.getHeight() + PrintStowingListComponent.this.border / 4);
                PrintStowingListComponent.this.summarizeCrew.setSize(parent.getWidth() - (PrintStowingListComponent.this.summarizeCrew.getX() + PrintStowingListComponent.this.border), (int)PrintStowingListComponent.this.summarizeCrew.getPreferredSize().getHeight());
                y = PrintStowingListComponent.this.summarizeCrew.getY() + PrintStowingListComponent.this.summarizeCrew.getHeight();
                if (PrintStowingListComponent.this.hideNSDSFlights != null) {
                    PrintStowingListComponent.this.hideNSDSFlights.setLocation(PrintStowingListComponent.this.border, y + PrintStowingListComponent.this.border);
                    PrintStowingListComponent.this.hideNSDSFlights.setSize(parent.getWidth() - 2 * PrintStowingListComponent.this.border, (int)PrintStowingListComponent.this.hideNSDSFlights.getPreferredSize().getHeight());
                    y = PrintStowingListComponent.this.hideNSDSFlights.getY() + PrintStowingListComponent.this.hideNSDSFlights.getHeight();
                }
                PrintStowingListComponent.this.department.setLocation(PrintStowingListComponent.this.border, y + PrintStowingListComponent.this.border);
                PrintStowingListComponent.this.department.setSize(parent.getWidth() - 2 * PrintStowingListComponent.this.border, (int)PrintStowingListComponent.this.department.getPreferredSize().getHeight());
                PrintStowingListComponent.this.colors.setLocation(PrintStowingListComponent.this.border, PrintStowingListComponent.this.department.getY() + PrintStowingListComponent.this.department.getHeight() + PrintStowingListComponent.this.border / 2);
                PrintStowingListComponent.this.colors.setSize(parent.getWidth() - 2 * PrintStowingListComponent.this.border, (int)PrintStowingListComponent.this.colors.getPreferredSize().getHeight());
                if (PrintStowingListComponent.this.dateChooser != null) {
                    PrintStowingListComponent.this.dateChooser.setLocation(PrintStowingListComponent.this.border, PrintStowingListComponent.this.colors.getY() + PrintStowingListComponent.this.colors.getHeight() + PrintStowingListComponent.this.border);
                    PrintStowingListComponent.this.dateChooser.setSize(PrintStowingListComponent.this.dateChooser.getPreferredSize());
                    y = PrintStowingListComponent.this.dateChooser.getY() + PrintStowingListComponent.this.dateChooser.getHeight();
                }
                if (PrintStowingListComponent.this.paxCount != null) {
                    PrintStowingListComponent.this.paxCount.setLocation(PrintStowingListComponent.this.border, y + PrintStowingListComponent.this.border);
                    PrintStowingListComponent.this.paxCount.setSize(parent.getWidth() - 2 * PrintStowingListComponent.this.border, (int)PrintStowingListComponent.this.paxCount.getPreferredSize().getHeight());
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintStowingListComponent.this.getInheritedComponentsHeight();
            h += PrintStowingListComponent.this.border;
            if (PrintStowingListComponent.this.printOptionTitle != null) {
                h = (int)((double)h + PrintStowingListComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border / 2;
            }
            if (PrintStowingListComponent.this.finalizeFlight != null) {
                h = (int)((double)h + PrintStowingListComponent.this.finalizeFlight.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border;
            }
            if (PrintStowingListComponent.this.includeGalleyMap != null) {
                h = (int)((double)h + PrintStowingListComponent.this.includeGalleyMap.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border / 4;
            }
            if (PrintStowingListComponent.this.includeCrewClasses != null) {
                h = (int)((double)h + PrintStowingListComponent.this.includeCrewClasses.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border / 4;
            }
            if (PrintStowingListComponent.this.summarizeCrew != null) {
                h = (int)((double)h + PrintStowingListComponent.this.summarizeCrew.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border;
            }
            if (PrintStowingListComponent.this.hideNSDSFlights != null) {
                h = (int)((double)h + PrintStowingListComponent.this.hideNSDSFlights.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border;
            }
            if (PrintStowingListComponent.this.department != null) {
                h = (int)((double)h + PrintStowingListComponent.this.department.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border / 2;
            }
            if (PrintStowingListComponent.this.colors != null) {
                h = (int)((double)h + PrintStowingListComponent.this.colors.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border;
            }
            if (PrintStowingListComponent.this.dateChooser != null) {
                h = (int)((double)h + PrintStowingListComponent.this.dateChooser.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border;
            }
            if (PrintStowingListComponent.this.paxCount != null) {
                h = (int)((double)h + PrintStowingListComponent.this.paxCount.getPreferredSize().getHeight());
                h += PrintStowingListComponent.this.border;
            }
            h += PrintStowingListComponent.this.border;
            int w = 2 * PrintStowingListComponent.this.border;
            if (PrintStowingListComponent.this.dateChooser != null) {
                w = (int)((double)w + PrintStowingListComponent.this.dateChooser.getPreferredSize().getWidth());
            }
            return new Dimension(w, h);
        }
    }
}

